/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.engine.NodeThread;
import com.edb.gridsql.engine.ObjectPool;
import com.edb.gridsql.exception.XDBServerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeThreadPool
extends ObjectPool<NodeThread> {
    private int nodeID;

    public NodeThreadPool(int n, int n2, int n3) {
        super(n2, n3);
        this.nodeID = n;
    }

    @Override
    protected NodeThread createEntry() throws XDBServerException {
        NodeThread nodeThread = new NodeThread(this.nodeID);
        new Thread(nodeThread).start();
        return nodeThread;
    }

    @Override
    protected void destroyEntry(NodeThread nodeThread) {
        nodeThread.processMessage(NodeMessage.getNodeMessage(1001));
    }

    public NodeThread getNodeThread() throws XDBServerException {
        return (NodeThread)this.getObject();
    }

    public void releaseNodeThread(NodeThread nodeThread) {
        if (nodeThread.isAlive()) {
            this.releaseObject(nodeThread);
        } else {
            this.destroyObject(nodeThread, false);
        }
    }
}

