/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLevel;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.IMessageListener;
import com.edb.gridsql.communication.NodeAgent;
import com.edb.gridsql.communication.SendMessageHelper;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.engine.JDBCPool;
import com.edb.gridsql.engine.NodeProducerThread;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBBaseException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.exception.XDBUnexpectedMessageException;
import com.edb.gridsql.exception.XDBUnexpectedStateException;
import com.edb.gridsql.exception.XDBWrappedException;
import com.edb.gridsql.exception.XDBWrappedSQLException;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.planner.StepDetail;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class NodeThread
implements Runnable,
IMessageListener {
    private static final XLogger logger = XLogger.getLogger(NodeThread.class);
    private static final boolean USEBATCHES = true;
    private static final boolean AUTOCOMMIT = false;
    private static final int BATCHSIZE = 1000;
    private static final int STATEDONE = -3;
    private static final int STATEDISCONNECTED = -1;
    private static final int STATEWAIT = 0;
    private static final int STATECOMMAND = 1;
    private static final int STATEBEGINTRAN = 2;
    private static final int STATECOMMIT = 3;
    private static final int STATEROLLBACK = 4;
    private static final int STATEENDTRAN = 5;
    private static final int STATESTEP = 8;
    private static final int STATEDATADOWN = 9;
    private static final int STATESTEPEND = 10;
    private static final int freeInterval = Property.getInt("xdb.memory.freeinterval", 0);
    private static final boolean JUST_DATA_VALUES = Property.getBoolean("xdb.message.data.justvalues", false);
    private int currentState;
    private int nodeId;
    private volatile int requestIDtoAbort = -1;
    private StepDetail aStepDetail;
    private Connection oConn;
    private LinkedBlockingQueue<NodeMessage> msgQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<NodeMessage> producerQueue = new LinkedBlockingQueue();
    private Statement batchStatement = null;
    private int iCount;
    private String downTableName;
    private String baseInsert;
    private JDBCPool currentPool;
    private SendMessageHelper sendHelper;
    private HashMap<String, Savepoint> savepointTable;
    HashSet<String> tempTableNames = new HashSet();
    private volatile Statement aStatement = null;
    private boolean isTaking;
    private int lastMessageType = -1;
    private NodeProducerThread aNodeProducerThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeThread(int n) {
        this.savepointTable = new HashMap();
        this.nodeId = n;
        this.currentState = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset(Integer n, JDBCPool jDBCPool) throws XDBBaseException {
        try {
            Serializable serializable;
            int n2;
            for (n2 = 0; this.currentState != -1 && this.currentState != 0 && this.currentState != -3 && n2 <= 10; ++n2) {
                try {
                    this.wait(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    logger.catching(interruptedException);
                }
            }
            n2 = 0;
            while (this.currentState != -1 && this.currentState != 0 && this.currentState != -3) {
                XLogger.getLogger("Server").warn(" NodeThread in inconsistent state during reset.  State = " + this.currentState);
                this.kill();
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    logger.catching(interruptedException);
                }
                if (n2 >= 6) {
                    serializable = new XDBUnexpectedStateException(this.nodeId, this.currentState, new int[]{0, -1});
                    logger.throwing((Throwable)serializable);
                    throw serializable;
                }
                ++n2;
            }
            if (this.currentState == -3) {
                XDBUnexpectedStateException xDBUnexpectedStateException = new XDBUnexpectedStateException(this.nodeId, -3, new int[]{0, -1});
                logger.throwing(xDBUnexpectedStateException);
                throw xDBUnexpectedStateException;
            }
            if (n != null) {
                this.sendHelper = new SendMessageHelper(this.nodeId, n, NodeAgent.getNodeAgent(this.nodeId));
            }
            n2 = 0;
            if (this.oConn != null) {
                try {
                    this.oConn.rollback();
                }
                catch (SQLException sQLException) {
                    n2 = 1;
                    logger.catching(sQLException);
                }
                serializable = this.tempTableNames;
                synchronized (serializable) {
                    for (String string : this.tempTableNames) {
                        try {
                            this.doProcessSqlCommand("DROP TABLE " + IdentifierHandler.quote(string), true);
                        }
                        catch (Throwable throwable) {}
                    }
                    this.tempTableNames.clear();
                }
            }
            this.savepointTable.clear();
            if (this.oConn != null) {
                if (n2 != 0) {
                    this.currentPool.destroyConnection(this.oConn);
                } else {
                    this.currentPool.releaseConnection(this.oConn);
                }
                this.oConn = null;
            }
            this.currentPool = jDBCPool;
            if (this.currentPool != null) {
                this.oConn = this.currentPool.getConnection();
                this.setState(0);
            } else {
                this.setState(-1);
            }
            if (this.aNodeProducerThread != null) {
                this.aNodeProducerThread.reset();
            }
            this.requestIDtoAbort = -1;
        }
        catch (Exception exception) {
            logger.catching(exception);
            if (this.currentPool != null && this.oConn != null) {
                this.currentPool.destroyConnection(this.oConn);
            }
            XDBBaseException xDBBaseException = exception instanceof XDBBaseException ? (XDBBaseException)exception : (exception instanceof SQLException ? new XDBWrappedSQLException(this.nodeId, (SQLException)exception) : new XDBWrappedException(this.nodeId, (Throwable)exception));
            logger.throwing(xDBBaseException);
            throw xDBBaseException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initNodeProducerThread(Connection connection, SendMessageHelper sendMessageHelper) throws XDBBaseException {
        if (this.aNodeProducerThread == null) {
            this.producerQueue = new LinkedBlockingQueue();
            this.aNodeProducerThread = new NodeProducerThread(this, this.producerQueue);
            new Thread(this.aNodeProducerThread).start();
        }
        this.aNodeProducerThread.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBeginSavepoint(String string) throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            if (Props.XDB_SAVEPOINTTYPE.equals("S")) {
                Savepoint savepoint = this.oConn.setSavepoint(string);
                this.savepointTable.put(string, savepoint);
            } else {
                this.aStatement = this.oConn.createStatement();
                try {
                    this.aStatement.executeUpdate("SUBTRANS BEGIN");
                }
                finally {
                    this.aStatement.close();
                    this.aStatement = null;
                }
            }
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginSavepoint(String string) throws XDBBaseException {
        block6: {
            try {
                this.doBeginSavepoint(string);
            }
            catch (SQLException sQLException) {
                if (!this.handleSqlException(sQLException, null)) break block6;
                try {
                    this.doBeginSavepoint(string);
                }
                catch (SQLException sQLException2) {
                    logger.catching(sQLException2);
                    XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                    logger.throwing(xDBWrappedSQLException);
                    throw xDBWrappedSQLException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRollbackSavepoint(String string) throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            if (Props.XDB_SAVEPOINTTYPE.equals("S")) {
                Savepoint savepoint = this.savepointTable.get(string);
                if (savepoint == null) {
                    throw new XDBServerException(ErrorMessageRepository.SQL_ROLLBACK_SAVEPOINT_ERROR + " nodeId = " + this.nodeId, 8, ErrorMessageRepository.SQL_ROLLBACK_SAVEPOINT_ERROR_CODE);
                }
                this.oConn.rollback(savepoint);
            } else {
                this.aStatement = this.oConn.createStatement();
                try {
                    this.aStatement.executeUpdate("SUBTRANS ROLLBACK");
                }
                finally {
                    this.aStatement.close();
                    this.aStatement = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackSavepoint(String string) throws XDBBaseException {
        block7: {
            try {
                this.doRollbackSavepoint(string);
            }
            catch (SQLException sQLException) {
                if (!this.handleSqlException(sQLException, null)) break block7;
                try {
                    this.doRollbackSavepoint(string);
                }
                catch (SQLException sQLException2) {
                    logger.catching(sQLException2);
                    XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                    logger.throwing(xDBWrappedSQLException);
                    throw xDBWrappedSQLException;
                }
            }
            finally {
                this.savepointTable.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEndSavepoint(String string) throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            if (Props.XDB_SAVEPOINTTYPE.equals("S")) {
                Savepoint savepoint = this.savepointTable.get(string);
                this.oConn.releaseSavepoint(savepoint);
            } else {
                this.aStatement = this.oConn.createStatement();
                try {
                    this.aStatement.executeUpdate("SUBTRANS END");
                }
                finally {
                    this.aStatement.close();
                    this.aStatement = null;
                }
            }
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endSavepoint(String string) throws XDBBaseException {
        block7: {
            try {
                this.doEndSavepoint(string);
            }
            catch (SQLException sQLException) {
                if (!this.handleSqlException(sQLException, null)) break block7;
                try {
                    this.doEndSavepoint(string);
                }
                catch (SQLException sQLException2) {
                    logger.catching(sQLException2);
                    XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                    logger.throwing(xDBWrappedSQLException);
                    throw xDBWrappedSQLException;
                }
            }
            finally {
                this.savepointTable.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doProcessSqlCommand(String string, boolean bl) throws SQLException {
        int n = 0;
        Connection connection = this.oConn;
        synchronized (connection) {
            this.aStatement = this.oConn.createStatement();
            if (bl) {
                this.oConn.setAutoCommit(true);
            }
            try {
                try {
                    n = this.aStatement.executeUpdate(string);
                }
                finally {
                    this.aStatement.close();
                    this.aStatement = null;
                }
            }
            finally {
                if (bl) {
                    this.oConn.setAutoCommit(false);
                }
            }
            this.oConn.notify();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processSqlCommand(String string, boolean bl) throws XDBBaseException {
        try {
            return this.doProcessSqlCommand(string, bl);
        }
        catch (SQLException sQLException) {
            if (!this.handleSqlException(sQLException, string)) return 0;
            try {
                return this.doProcessSqlCommand(string, bl);
            }
            catch (SQLException sQLException2) {
                logger.catching(sQLException2);
                XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                logger.throwing(xDBWrappedSQLException);
                throw xDBWrappedSQLException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStep() throws XDBBaseException {
        if (this.aStepDetail.isConsumer) {
            boolean bl = !Props.XDB_COMMIT_AFTER_CREATE_TEMP_TABLE && !Props.XDB_USE_LOAD_FOR_STEP;
            try {
                if (bl) {
                    this.beginSavepoint("stepSavepoint");
                }
                this.processSqlCommand(this.aStepDetail.targetSchema, !bl);
            }
            finally {
                if (bl) {
                    this.endSavepoint("stepSavepoint");
                }
            }
            if (this.aStepDetail.targetTable != null) {
                HashSet<String> hashSet = this.tempTableNames;
                synchronized (hashSet) {
                    this.tempTableNames.add(this.aStepDetail.targetTable);
                }
            }
            if (!Props.XDB_USE_LOAD_FOR_STEP) {
                this.initDataDown(this.aStepDetail.targetTable);
            }
        }
        if (this.aStepDetail.isProducer) {
            this.initNodeProducerThread(this.oConn, this.sendHelper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStep(NodeMessage nodeMessage) throws XDBBaseException {
        if (this.aStepDetail.isProducer) {
            this.initNodeProducerThread(this.oConn, this.sendHelper);
            nodeMessage.setStepDetail(this.aStepDetail);
            if (this.producerQueue != null) {
                this.producerQueuePut(nodeMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQuery(NodeMessage nodeMessage) throws XDBBaseException {
        this.initNodeProducerThread(this.oConn, this.sendHelper);
        if (this.producerQueue != null) {
            this.producerQueuePut(nodeMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitDataDown(String string) throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            this.aStatement = this.batchStatement = this.oConn.createStatement();
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDataDown(String string) throws XDBBaseException {
        block6: {
            this.downTableName = string;
            this.baseInsert = "INSERT INTO " + IdentifierHandler.quote(string) + " VALUES ";
            try {
                this.downTableName = string;
                this.baseInsert = "INSERT INTO " + IdentifierHandler.quote(string) + " VALUES ";
                this.doInitDataDown(string);
            }
            catch (SQLException sQLException) {
                if (!this.handleSqlException(sQLException, null)) break block6;
                try {
                    this.doInitDataDown(string);
                }
                catch (SQLException sQLException2) {
                    logger.catching(sQLException2);
                    XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                    logger.throwing(xDBWrappedSQLException);
                    throw xDBWrappedSQLException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPopulateDownData(String string) throws SQLException {
        if (string == null) {
            return;
        }
        String string2 = JUST_DATA_VALUES ? this.baseInsert + string : string;
        Connection connection = this.oConn;
        synchronized (connection) {
            this.batchStatement.addBatch(string2);
            logger.log(XLevel.TRACE, "From connection: %0% added batch command to Statement: ", new Object[]{this.oConn, this.batchStatement});
            if (++this.iCount % 1000 == 0) {
                logger.log(XLevel.TRACE, "From connection: %0% executing batch Statement: %1%", new Object[]{this.oConn, this.batchStatement});
                this.batchStatement.executeBatch();
                logger.log(XLevel.TRACE, "From connection: %0% executed batch Statement: %1%", new Object[]{this.oConn, this.batchStatement});
                this.batchStatement.clearBatch();
                logger.log(XLevel.TRACE, "From connection: %0% cleared batch Statement: %1%", new Object[]{this.oConn, this.batchStatement});
            }
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDownData(String string) throws XDBBaseException {
        block6: {
            try {
                this.doPopulateDownData(string);
            }
            catch (SQLException sQLException) {
                if (!this.handleSqlException(sQLException, null)) break block6;
                try {
                    this.doPopulateDownData(string);
                }
                catch (SQLException sQLException2) {
                    logger.catching(sQLException2);
                    XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                    logger.throwing(xDBWrappedSQLException);
                    throw xDBWrappedSQLException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFinishInserts() throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            this.batchStatement.executeBatch();
            this.batchStatement.close();
            this.aStatement = null;
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishInserts() throws XDBBaseException {
        try {
            this.doFinishInserts();
        }
        catch (SQLException sQLException) {
            if (this.handleSqlException(sQLException, null)) {
                try {
                    this.doFinishInserts();
                }
                catch (SQLException sQLException2) {
                    logger.catching(sQLException2);
                    XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                    logger.throwing(xDBWrappedSQLException);
                    throw xDBWrappedSQLException;
                }
            }
            this.iCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFinalizeStep() throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            Object object;
            Object object2;
            if (Props.XDB_STEP_INDEX_CORRELATED && (object2 = this.aStepDetail.getCorrelatedIndex()) != null) {
                object = this.oConn.createStatement();
                object.execute((String)object2);
                object.close();
            }
            if (Props.XDB_STEP_RUNANALYZE) {
                object2 = new HashMap();
                ((HashMap)object2).put("table", IdentifierHandler.quote(this.aStepDetail.targetTable));
                object = Props.XDB_SQLCOMMAND_ANALYZE_TEMPLATE_TABLE.trim();
                String string = ParseCmdLine.substitute((String)object, (Map<String, String>)object2);
                Statement statement = this.oConn.createStatement();
                statement.execute(string);
                statement.close();
            }
            this.oConn.commit();
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeStep() throws XDBBaseException {
        try {
            this.doFinalizeStep();
        }
        catch (SQLException sQLException) {
            if (this.handleSqlException(sQLException, null)) {
                try {
                    this.doFinalizeStep();
                }
                catch (SQLException sQLException2) {
                    logger.catching(sQLException2);
                    XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                    logger.throwing(xDBWrappedSQLException);
                    throw xDBWrappedSQLException;
                }
            }
            this.iCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] processExecuteBatch(NodeMessage nodeMessage) throws XDBBaseException {
        String[] stringArray;
        this.initBatch();
        for (String string : stringArray = nodeMessage.getRowData()) {
            this.addBatch(string);
        }
        int[] nArray = this.executeBatch();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitBatch() throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            this.aStatement = this.batchStatement = this.oConn.createStatement();
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBatch() throws XDBBaseException {
        block6: {
            try {
                this.doInitBatch();
            }
            catch (SQLException sQLException) {
                if (!this.handleSqlException(sQLException, null)) break block6;
                try {
                    this.doInitBatch();
                }
                catch (SQLException sQLException2) {
                    logger.catching(sQLException2);
                    XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                    logger.throwing(xDBWrappedSQLException);
                    throw xDBWrappedSQLException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddBatch(String string) throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            this.batchStatement.addBatch(string);
            logger.log(XLevel.TRACE, "From connection: %0% added batch command to Statement: %1%", new Object[]{this.oConn, this.batchStatement});
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBatch(String string) throws XDBBaseException {
        block6: {
            try {
                this.doAddBatch(string);
            }
            catch (SQLException sQLException) {
                if (!this.handleSqlException(sQLException, null)) break block6;
                try {
                    this.doAddBatch(string);
                }
                catch (SQLException sQLException2) {
                    logger.catching(sQLException2);
                    XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                    logger.throwing(xDBWrappedSQLException);
                    throw xDBWrappedSQLException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] doExecuteBatch() throws SQLException {
        int[] nArray = null;
        try {
            Connection connection = this.oConn;
            synchronized (connection) {
                nArray = this.batchStatement.executeBatch();
                this.oConn.notify();
            }
        }
        catch (BatchUpdateException batchUpdateException) {
            logger.catching(batchUpdateException);
            nArray = batchUpdateException.getUpdateCounts();
        }
        this.iCount = 0;
        return nArray;
    }

    private int[] executeBatch() throws XDBBaseException {
        try {
            int[] nArray = this.doExecuteBatch();
            return nArray;
        }
        catch (SQLException sQLException) {
            this.handleSqlException(sQLException, null);
            try {
                int[] nArray = this.doExecuteBatch();
                return nArray;
            }
            catch (SQLException sQLException2) {
                logger.catching(sQLException2);
                XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                logger.throwing(xDBWrappedSQLException);
                throw xDBWrappedSQLException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setState(int n) {
        this.currentState = n;
        this.notify();
    }

    private synchronized int checkCurrentState(int[] nArray, int n) throws XDBUnexpectedStateException {
        for (int n2 : nArray) {
            if (this.currentState != n2) continue;
            this.setState(n);
            return n2;
        }
        XDBUnexpectedStateException xDBUnexpectedStateException = new XDBUnexpectedStateException(this.nodeId, this.currentState, nArray);
        logger.throwing(xDBUnexpectedStateException);
        throw xDBUnexpectedStateException;
    }

    public synchronized boolean isAlive() {
        return this.currentState != -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = null;
        block65: while (true) lbl-1000:
        // 5 sources

        {
            try {
                block66: while (true) {
                    this.isTaking = true;
                    var1_1 = this.msgQueue.poll(5L, TimeUnit.SECONDS);
                    if (var1_1 == null) continue;
                    this.isTaking = false;
                    this.lastMessageType = var1_1.getMessageType();
                    if (var1_1.getMessageType() != 1 && var1_1.getRequestId() == this.requestIDtoAbort) continue;
                    this.requestIDtoAbort = -1;
                    switch (var1_1.getMessageType()) {
                        case 22: {
                            this.tranCommit(var1_1);
                            break;
                        }
                        case 24: {
                            this.tranRollback(var1_1);
                            break;
                        }
                        case 28: {
                            this.checkCurrentState(new int[]{0}, 2);
                            try {
                                this.beginSavepoint(var1_1.getSavepoint());
                                this.sendHelper.sendReplyMessage(var1_1, 29);
                                continue block66;
                            }
                            finally {
                                this.setState(0);
                                continue block66;
                            }
                        }
                        case 30: {
                            this.checkCurrentState(new int[]{0}, 4);
                            try {
                                this.rollbackSavepoint(var1_1.getSavepoint());
                                this.sendHelper.sendReplyMessage(var1_1, 31);
                                continue block66;
                            }
                            finally {
                                this.setState(0);
                                continue block66;
                            }
                        }
                        case 32: {
                            this.checkCurrentState(new int[]{0}, 5);
                            try {
                                this.endSavepoint(var1_1.getSavepoint());
                                this.sendHelper.sendReplyMessage(var1_1, 33);
                                continue block66;
                            }
                            finally {
                                this.setState(0);
                                continue block66;
                            }
                        }
                        case 7: 
                        case 107: {
                            this.checkCurrentState(new int[]{0}, 1);
                            try {
                                this.processQuery(var1_1);
                                continue block66;
                            }
                            finally {
                                this.setState(0);
                                continue block66;
                            }
                        }
                        case 9: {
                            this.checkCurrentState(new int[]{0}, 8);
                            try {
                                this.aStepDetail = var1_1.getStepDetail();
                                this.initStep();
                                this.sendHelper.sendReplyMessage(var1_1, 109);
                                this.setState(this.aStepDetail.isConsumer != false ? 9 : 0);
                                break;
                            }
                            catch (Throwable var6_16) {
                                this.setState(this.aStepDetail.isConsumer != false ? 9 : 0);
                                throw var6_16;
                            }
                        }
                        case 209: {
                            var2_3 = this.checkCurrentState(new int[]{0, 9}, 8);
                            this.aStepDetail = var1_1.getStepDetail();
                            try {
                                this.processStep(var1_1);
                                continue block66;
                            }
                            finally {
                                this.setState(var2_3);
                                continue block66;
                            }
                        }
                        case 10: {
                            this.checkCurrentState(new int[]{0, 9}, 10);
                            try {
                                if (!Props.XDB_USE_LOAD_FOR_STEP) {
                                    this.finishInserts();
                                }
                                this.finalizeStep();
                                if (Props.XDB_DUMPSTEPPATH != null) {
                                    NodeThread.dumpStepResults(this.oConn, this.aStepDetail.targetTable, this.nodeId);
                                }
                                this.sendHelper.sendReplyMessage(var1_1, 110);
                                continue block66;
                            }
                            finally {
                                this.setState(0);
                                continue block66;
                            }
                        }
                        case 19: {
                            this.checkCurrentState(new int[]{0}, 9);
                            this.initDataDown(var1_1.getTargetTable());
                            break;
                        }
                        case 16: {
                            if (this.aStepDetail != null && !this.aStepDetail.consumerNodeList.contains(new Integer(this.nodeId))) continue block65;
                            this.checkCurrentState(new int[]{9}, 9);
                            for (String var7_17 : var3_7 = var1_1.getRowData()) {
                                this.populateDownData(var7_17);
                            }
                            var4_10 /* !! */  = NodeMessage.getNodeMessage(17);
                            var4_10 /* !! */ .setDataSeqNo(var1_1.getDataSeqNo());
                            this.sendHelper.sendReplyMessage(var1_1, (NodeMessage)var4_10 /* !! */ );
                            var3_7 = null;
                            var4_10 /* !! */  = null;
                            if (NodeThread.freeInterval <= 0 || var1_1.getDataSeqNo() % (long)NodeThread.freeInterval != 0L) continue block65;
                            var1_1 = null;
                            System.gc();
                            break;
                        }
                        case 17: {
                            this.producerQueuePut(var1_1);
                            break;
                        }
                        case 40: {
                            this.checkCurrentState(new int[]{0}, 1);
                            try {
                                var3_7 = NodeMessage.getNodeMessage(41);
                                var3_7.setRequestId(var1_1.getRequestId());
                                var5_14 = this.processExecuteBatch(var1_1);
                                if (var5_14.length < var1_1.getRowCount()) {
                                    var4_10 /* !! */  = (String[])new int[var1_1.getRowCount()];
                                    System.arraycopy(var5_14, 0, var4_10 /* !! */ , 0, var5_14.length);
                                    Arrays.fill((int[])var4_10 /* !! */ , var5_14.length, var4_10 /* !! */ .length, -3);
                                } else {
                                    var4_10 /* !! */  = (String[])var5_14;
                                }
                                var3_7.setBatchResult((int[])var4_10 /* !! */ );
                                this.sendHelper.sendReplyMessage(var1_1, (NodeMessage)var3_7);
                                continue block66;
                            }
                            finally {
                                this.setState(0);
                                continue block66;
                            }
                        }
                        case 26: {
                            this.producerQueuePut(var1_1);
                            break;
                        }
                        case 1001: {
                            this.setState(-3);
                            try {
                                if (this.producerQueue != null) {
                                    this.producerQueuePut(var1_1);
                                }
                                this.producerQueue = null;
                            }
                            catch (Exception var3_9) {
                                NodeThread.logger.catching(var3_9);
                            }
                            return;
                        }
                        case 1: {
                            try {
                                if (this.producerQueue == null) continue block66;
                                this.producerQueuePut(var1_1);
                                continue block66;
                            }
                            finally {
                                this.requestIDtoAbort = var1_1.getRequestId();
                                this.setState(0);
                                continue block66;
                            }
                        }
                        case 14: {
                            this.checkCurrentState(new int[]{0}, 1);
                            try {
                                this.checkConnection();
                            }
                            finally {
                                this.setState(0);
                            }
                            this.sendHelper.sendReplyMessage(var1_1, 15);
                            break;
                        }
                        case 42: {
                            this.producerQueuePut(var1_1);
                            break;
                        }
                        case 142: {
                            this.producerQueuePut(var1_1);
                            break;
                        }
                        case 15: {
                            break;
                        }
                        case 71: 
                        case 72: 
                        case 73: {
                            this.producerQueuePut(var1_1);
                            break;
                        }
                        default: {
                            var3_7 = new XDBUnexpectedMessageException(this.nodeId, "NodeThread can not handle message", var1_1);
                            NodeThread.logger.throwing((Throwable)var3_7);
                            throw var3_7;
                        }
                    }
                }
            }
            catch (XDBBaseException var2_4) {
                var3_7 = this;
                synchronized (var3_7) {
                    NodeThread.logger.catching(var2_4);
                    if (this.sendHelper != null) {
                        this.requestIDtoAbort = var1_1.getRequestId();
                        var4_10 /* !! */  = NodeMessage.getNodeMessage(1);
                        var4_10 /* !! */ .setCause(var2_4);
                        this.sendHelper.sendReplyMessage(var1_1, (NodeMessage)var4_10 /* !! */ );
                    }
                    continue;
                }
            }
            catch (Throwable var2_5) {
                var3_7 = this;
                synchronized (var3_7) {
                    NodeThread.logger.catching(var2_5);
                    if (this.sendHelper != null) {
                        this.requestIDtoAbort = var1_1.getRequestId();
                        var4_10 /* !! */  = NodeMessage.getNodeMessage(1);
                        var4_10 /* !! */ .setCause(new XDBWrappedException(this.nodeId, var2_5));
                        this.sendHelper.sendReplyMessage(var1_1, (NodeMessage)var4_10 /* !! */ );
                    }
                    continue;
                }
            }
            break;
        }
        {
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection() throws XDBBaseException {
        if ("".equals(Props.XDB_BACKEND_PING_STATEMENT)) {
            return;
        }
        Savepoint savepoint = null;
        Connection connection = this.oConn;
        synchronized (connection) {
            block17: {
                try {
                    this.aStatement = this.oConn.createStatement();
                    try {
                        boolean bl;
                        logger.debug("SQL: " + Props.XDB_BACKEND_PING_STATEMENT);
                        boolean bl2 = bl = Props.XDB_BACKEND_PING_SETUP != null && Props.XDB_SAVEPOINTTYPE.equals("S");
                        if (bl) {
                            savepoint = this.oConn.setSavepoint("checkConn");
                        }
                        try {
                            this.aStatement.execute(Props.XDB_BACKEND_PING_STATEMENT);
                            logger.log(XLevel.TRACE, "From connection: %0% executed Statement: %1%", new Object[]{this.oConn, this.aStatement});
                            if (bl) {
                                this.oConn.releaseSavepoint(savepoint);
                            }
                        }
                        catch (SQLException sQLException) {
                            if (bl) {
                                this.oConn.rollback(savepoint);
                            }
                            if (Props.XDB_BACKEND_PING_SETUP != null) {
                                this.aStatement.execute(Props.XDB_BACKEND_PING_SETUP);
                                logger.log(XLevel.TRACE, "From connection: %0% executed Statement: %1%", new Object[]{this.oConn, this.aStatement});
                                break block17;
                            }
                            throw sQLException;
                        }
                    }
                    finally {
                        this.aStatement.close();
                        this.aStatement = null;
                    }
                }
                catch (SQLException sQLException) {
                    throw new XDBBaseException(this.getNodeId(), "Ping failed: " + sQLException.getMessage());
                }
            }
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTranRollback(NodeMessage nodeMessage) throws XDBBaseException, SQLException {
        this.checkCurrentState(new int[]{0}, 4);
        try {
            Connection connection = this.oConn;
            synchronized (connection) {
                this.oConn.rollback();
                this.oConn.notify();
            }
        }
        finally {
            this.setState(0);
        }
        this.sendHelper.sendReplyMessage(nodeMessage, 25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tranRollback(NodeMessage nodeMessage) throws XDBBaseException {
        block7: {
            try {
                this.doTranRollback(nodeMessage);
            }
            catch (SQLException sQLException) {
                if (!this.handleSqlException(sQLException, null)) break block7;
                try {
                    this.doTranRollback(nodeMessage);
                }
                catch (SQLException sQLException2) {
                    logger.catching(sQLException2);
                    XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                    logger.throwing(xDBWrappedSQLException);
                    throw xDBWrappedSQLException;
                }
            }
            finally {
                this.savepointTable.clear();
                this.setState(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTranCommit(NodeMessage nodeMessage) throws XDBBaseException, SQLException {
        this.checkCurrentState(new int[]{0}, 3);
        Connection connection = this.oConn;
        synchronized (connection) {
            this.oConn.commit();
            this.oConn.notify();
        }
        if (nodeMessage != null) {
            this.sendHelper.sendReplyMessage(nodeMessage, 23);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tranCommit(NodeMessage nodeMessage) throws XDBBaseException {
        block16: {
            try {
                this.doTranCommit(nodeMessage);
            }
            catch (SQLException sQLException) {
                if (!this.handleSqlException(sQLException, null)) break block16;
                try {
                    this.doTranCommit(nodeMessage);
                }
                catch (SQLException sQLException2) {
                    logger.catching(sQLException2);
                    XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                    logger.throwing(xDBWrappedSQLException);
                    throw xDBWrappedSQLException;
                }
            }
            finally {
                NodeThread nodeThread = this;
                synchronized (nodeThread) {
                    this.savepointTable.clear();
                    this.setState(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processMessage(NodeMessage nodeMessage) {
        switch (nodeMessage.getMessageType()) {
            case 0: {
                NodeThread nodeThread = this;
                synchronized (nodeThread) {
                    if (this.oConn != null) {
                        this.kill();
                    }
                    break;
                }
            }
            case 1: {
                NodeThread nodeThread = this;
                synchronized (nodeThread) {
                    if (this.oConn != null) {
                        this.kill();
                    }
                }
            }
            default: {
                this.msgQueue.offer(nodeMessage);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kill() {
        try {
            if (this.aNodeProducerThread != null) {
                this.aNodeProducerThread.kill();
            }
            if (this.aStatement != null) {
                this.aStatement.cancel();
            }
        }
        catch (SQLException sQLException) {
            logger.catching(sQLException);
        }
        catch (Throwable throwable) {
            logger.catching(throwable);
        }
    }

    private void producerQueuePut(NodeMessage nodeMessage) throws XDBBaseException {
        if (this.aNodeProducerThread == null || this.aNodeProducerThread.getState() == -1) {
            this.initNodeProducerThread(this.oConn, this.sendHelper);
        }
        this.producerQueue.offer(nodeMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleSqlException(SQLException sQLException, Object object) throws XDBBaseException {
        Object object2;
        String string;
        String string2;
        logger.catching(sQLException);
        switch (sQLException.getErrorCode()) {
            case -708: {
                int n;
                NodeThread nodeThread = this;
                synchronized (nodeThread) {
                    n = this.currentState;
                    this.setState(0);
                }
                this.reset(null, this.currentPool);
                this.checkCurrentState(new int[]{0}, n);
                return true;
            }
            case -4004: {
                String string3;
                if (!(object instanceof String) || (string2 = ((String)object).trim()).length() <= 5 || !(string = string2.substring(0, 4).toUpperCase()).equals("DROP") || (string2 = string2.substring(5).trim()).length() <= 6 || !(string3 = string2.substring(0, 5).toUpperCase()).equals("TABLE")) break;
                return false;
            }
        }
        if ("57P01".equals(sQLException.getSQLState()) || "08006".equals(sQLException.getSQLState())) {
            try {
                Connection connection = this.currentPool.getConnection();
                this.currentPool.destroyConnection(this.oConn);
                this.oConn = connection;
                if (this.aNodeProducerThread != null) {
                    try {
                        this.aNodeProducerThread.reset();
                    }
                    catch (Throwable throwable) {
                        this.producerQueue.offer(NodeMessage.getNodeMessage(1001));
                        this.aNodeProducerThread = null;
                    }
                }
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ("42P01".equals(sQLException.getSQLState()) && object instanceof String && ((String)(object2 = ((String)object).trim())).length() > 5 && (string2 = ((String)object2).substring(0, 4).toUpperCase()).equals("DROP") && ((String)(object2 = ((String)object2).substring(5).trim())).length() > 6 && (string = ((String)object2).substring(0, 5).toUpperCase()).equals("TABLE")) {
            try {
                this.oConn.rollback();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return false;
        }
        if ("08003".equals(sQLException.getSQLState())) {
            try {
                object2 = this.currentPool.getConnection();
                this.currentPool.destroyConnection(this.oConn);
                this.oConn = object2;
                if (this.aNodeProducerThread != null) {
                    try {
                        this.aNodeProducerThread.reset();
                    }
                    catch (Throwable throwable) {
                        this.producerQueue.offer(NodeMessage.getNodeMessage(1001));
                        this.aNodeProducerThread = null;
                    }
                }
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        object2 = new XDBWrappedSQLException(this.nodeId, sQLException);
        logger.throwing((Throwable)object2);
        throw object2;
    }

    int getNodeId() {
        return this.nodeId;
    }

    Connection getConnection() {
        return this.oConn;
    }

    SendMessageHelper getSendHelper() {
        return this.sendHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpStepResults(Connection connection, String string, int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("path", Props.XDB_DUMPSTEPPATH);
        hashMap.put("table", string);
        hashMap.put("node", "" + n);
        String string2 = ParseCmdLine.substitute(Props.XDB_DUMPCOMMAND, hashMap);
        Connection connection2 = connection;
        synchronized (connection2) {
            try {
                Statement statement = connection.createStatement();
                statement.execute(string2);
            }
            catch (Exception exception) {
                logger.catching(exception);
            }
        }
    }
}

