/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.ResultSetImpl;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.AbstractAgent;
import com.edb.gridsql.communication.CoordinatorAgent;
import com.edb.gridsql.communication.IMessageListener;
import com.edb.gridsql.communication.NodeAgent;
import com.edb.gridsql.communication.SendMessageHelper;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.engine.io.ResultSetResponse;
import com.edb.gridsql.exception.XDBBaseException;
import com.edb.gridsql.exception.XDBServerException;
import java.sql.SQLException;

public class NodeResultSetImpl
extends ResultSetImpl
implements IMessageListener {
    private static final XLogger logger = XLogger.getLogger(NodeResultSetImpl.class);
    private AbstractAgent agent = null;
    private SendMessageHelper sendHelper = null;
    private NodeMessage nodeMessage = null;
    private Integer sessionID = null;
    private NodeMessage nextMessage = null;

    public NodeResultSetImpl(NodeMessage nodeMessage) throws SQLException {
        this.nodeMessage = nodeMessage;
        int n = nodeMessage.getTargetNodeID();
        this.sessionID = nodeMessage.getSessionID();
        this.agent = n == 0 ? CoordinatorAgent.getInstance() : NodeAgent.getNodeAgent(n);
        this.sendHelper = new SendMessageHelper(n, this.sessionID, this.agent);
        this.responseMessage = this.getNextResponse(nodeMessage, null);
        this.resetRawRows();
        this.columnMeta = this.responseMessage.getColumnMetaData();
    }

    public synchronized boolean processMessage(NodeMessage nodeMessage) {
        if (this.nextMessage != null) {
            XDBServerException xDBServerException = new XDBServerException("Previous message has not been consumed");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        if ((nodeMessage.getMessageType() == 43 || nodeMessage.getMessageType() == 1) && this.nodeMessage.getSourceNodeID() == nodeMessage.getSourceNodeID() && this.nodeMessage.getRequestId() == nodeMessage.getRequestId()) {
            this.nextMessage = nodeMessage;
            this.notify();
            return true;
        }
        return false;
    }

    protected synchronized void setNextResultSet() throws SQLException {
        NodeMessage nodeMessage = NodeMessage.getNodeMessage(42);
        nodeMessage.setResultSetID(this.nodeMessage.getResultSetID());
        this.sendHelper.sendReplyMessage(this.nodeMessage, nodeMessage);
        while (this.nextMessage == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new SQLException("Result set is closed");
            }
        }
        if (this.nextMessage.getMessageType() == 1) {
            XDBBaseException xDBBaseException = this.nextMessage.getCause();
            if (xDBBaseException != null) {
                logger.catching(xDBBaseException);
            }
            SQLException sQLException = new SQLException("Can not fetch more rows: " + xDBBaseException == null ? "reason unknown" : xDBBaseException.getMessage());
            logger.throwing(sQLException);
            throw sQLException;
        }
        this.responseMessage = this.getNextResponse(this.nextMessage, this.responseMessage);
        this.nextMessage = null;
    }

    private ResultSetResponse getNextResponse(NodeMessage nodeMessage, ResultSetResponse resultSetResponse) {
        if (resultSetResponse == null) {
            resultSetResponse = new ResultSetResponse();
        }
        byte[] byArray = nodeMessage.getResultSetData();
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        resultSetResponse.setHeaderBytes(byArray2);
        int n = resultSetResponse.getPacketLength() - 8;
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 8, byArray3, 0, n);
        resultSetResponse.setMessage(byArray3);
        return resultSetResponse;
    }

    public void close() throws SQLException {
        NodeMessage nodeMessage;
        if (!this.responseMessage.isLastPacket()) {
            nodeMessage = NodeMessage.getNodeMessage(142);
            nodeMessage.setResultSetID(this.nodeMessage.getResultSetID());
            this.sendHelper.sendReplyMessage(this.nodeMessage, nodeMessage);
        }
        nodeMessage = NodeMessage.getNodeMessage(142);
        nodeMessage.setResultSetID(this.nodeMessage.getResultSetID());
        nodeMessage.setSessionID(this.nodeMessage.getSessionID());
        nodeMessage.setRequestId(this.nodeMessage.getRequestId());
        nodeMessage.setSourceNodeID(this.nodeMessage.getTargetNodeID());
        this.sendHelper.sendMessage(this.nodeMessage.getTargetNodeID(), nodeMessage);
    }
}

