/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.ObjectPool;
import com.edb.gridsql.exception.XDBServerException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCPool
extends ObjectPool<Connection> {
    private static final XLogger logger = XLogger.getLogger(JDBCPool.class);
    private String url;
    private String user;
    private String passwd;

    public JDBCPool(String string, String string2, String string3, String string4, int n, int n2) {
        super(n, n2);
        this.url = string2;
        this.user = string3;
        this.passwd = string4;
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.catching(classNotFoundException);
        }
    }

    @Override
    protected Connection createEntry() throws XDBServerException {
        Connection connection = null;
        try {
            connection = !(this.user != null && this.user.length() != 0 || this.passwd != null && this.passwd.length() != 0) ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.user, this.passwd);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
            Connection connection2 = connection;
            return connection2;
        }
        catch (SQLException sQLException) {
            throw new XDBServerException("Can not establish connection", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyEntry(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            logger.catching(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws XDBServerException {
        Connection connection = null;
        Connection connection2 = connection = (Connection)this.getObject();
        return connection2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(Connection connection) throws XDBServerException {
        this.releaseObject(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConnection(Connection connection) {
        try {
            this.destroyObject(connection, false);
        }
        catch (Exception exception) {
            logger.catching(exception);
        }
    }
}

