/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.constraintchecker;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.constraintchecker.AbstractConstraintChecker;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysForeignKey;
import com.edb.gridsql.metadata.SysReference;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.Parser;
import com.edb.gridsql.parser.SqlSelect;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateForeignKeyChecker
extends AbstractConstraintChecker {
    private static final XLogger logger = XLogger.getLogger(UpdateForeignKeyChecker.class);

    public UpdateForeignKeyChecker(SysTable sysTable, XDBSessionContext xDBSessionContext) {
        super(sysTable, xDBSessionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<SysColumn> scanConstraints(Collection<SysColumn> collection, Collection collection2) {
        HashSet hashSet = new HashSet();
        Vector<SysReference> vector = this.targetTable.getSysFkReferenceList();
        for (SysReference sysReference : vector) {
            if (!sysReference.getDistributedCheck()) continue;
            boolean bl = false;
            HashSet<SysColumn> hashSet2 = new HashSet<SysColumn>();
            Vector vector2 = sysReference.getForeignKeys();
            for (SysForeignKey sysForeignKey : vector2) {
                SysColumn sysColumn = this.targetTable.getSysColumn(sysForeignKey.getColid());
                if (collection.contains(sysColumn)) {
                    bl = true;
                    continue;
                }
                hashSet2.add(sysColumn);
            }
            if (!bl) continue;
            collection2.add(sysReference);
            hashSet.addAll(hashSet2);
        }
        HashSet hashSet3 = hashSet;
        return hashSet3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<IExecutable, AbstractConstraintChecker.ViolationCriteria> prepareConstraint(Object object) throws Exception {
        Object object2;
        AbstractConstraintChecker.ViolationCriteria violationCriteria = new AbstractConstraintChecker.ViolationCriteria();
        violationCriteria.violationType = 2;
        violationCriteria.message = ((SysReference)object).getConstraint().toString();
        SysTable sysTable = this.targetTable.getSysDatabase().getSysTable(((SysReference)object).getRefTableID());
        StringBuffer stringBuffer = new StringBuffer("SELECT 1 FROM ");
        stringBuffer.append(this.tempTable.getTableName()).append(" LEFT JOIN ");
        stringBuffer.append(sysTable.getTableName()).append(" ON ");
        Vector vector = ((SysReference)object).getForeignKeys();
        for (SysForeignKey object32 : vector) {
            object2 = this.targetTable.getSysColumn(object32.getColid());
            SysColumn sysColumn = sysTable.getSysColumn(object32.getRefcolid());
            stringBuffer.append(this.tempTable.getTableName()).append(".");
            stringBuffer.append(((SysColumn)object2).getColName()).append("_new=");
            stringBuffer.append(sysTable.getTableName()).append(".");
            stringBuffer.append(sysColumn.getColName()).append(" AND ");
        }
        stringBuffer.setLength(stringBuffer.length() - 5);
        stringBuffer.append(" WHERE ");
        for (SysColumn sysColumn : sysTable.getRowID()) {
            stringBuffer.append(sysTable.getTableName()).append(".").append(sysColumn.getColName()).append(" IS NULL AND ");
        }
        stringBuffer.setLength(stringBuffer.length() - 5);
        Parser parser = new Parser(this.client);
        parser.parseStatement(stringBuffer.toString());
        SqlSelect sqlSelect = (SqlSelect)parser.getSqlObject();
        sqlSelect.addSkipPermissionCheck(this.targetTable.getTableName());
        sqlSelect.addSkipPermissionCheck(sysTable.getTableName());
        sqlSelect.prepare();
        object2 = Collections.singletonMap(sqlSelect, violationCriteria);
        return object2;
    }
}

