/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.communication.message;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.message.AbortMessage;
import com.edb.gridsql.communication.message.BatchResultMessage;
import com.edb.gridsql.communication.message.CommandExtMessage;
import com.edb.gridsql.communication.message.CommandMessage;
import com.edb.gridsql.communication.message.ConnectMessage;
import com.edb.gridsql.communication.message.DataRowsMessage;
import com.edb.gridsql.communication.message.ResultSetMessage;
import com.edb.gridsql.communication.message.SendRowsMessage;
import com.edb.gridsql.communication.message.StepDetailMessage;
import com.edb.gridsql.communication.message.UpdateResultMessage;
import com.edb.gridsql.engine.NodeResultSetImpl;
import com.edb.gridsql.exception.XDBBaseException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.planner.StepDetail;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMessage
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -651288860476875902L;
    public static final XLogger CATEGORY_MESSAGE = XLogger.getLogger("MessageFlow");
    private static final XLogger logger = XLogger.getLogger(NodeMessage.class);
    public static final int MSG_KILL = 0;
    public static final int MSG_ABORT = 1;
    public static final int MSG_ABORT_ACK = 101;
    public static final int MSG_CONNECTION_BEGIN = 2;
    public static final int MSG_CONNECTION_BEGIN_ACK = 3;
    public static final int MSG_CONNECTION_END = 4;
    public static final int MSG_CONNECTION_END_ACK = 5;
    public static final int MSG_ERROR = 6;
    public static final int MSG_EXEC_COMMAND = 7;
    public static final int MSG_EXEC_COMMAND_RESULT = 8;
    public static final int MSG_EXEC_QUERY = 107;
    public static final int MSG_EXEC_QUERY_RESULT = 108;
    public static final int MSG_PREPARE_COMMAND = 71;
    public static final int MSG_PREPARE_COMMAND_ACK = 81;
    public static final int MSG_PREPARE_COMMAND_EXEC = 72;
    public static final int MSG_PREPARE_COMMAND_CLOSE = 73;
    public static final int MSG_PREPARE_COMMAND_CLOSE_ACK = 83;
    public static final int MSG_EXECUTE_STEP_INIT = 9;
    public static final int MSG_EXECUTE_STEP_INIT_ACK = 109;
    public static final int MSG_EXECUTE_STEP_RUN = 209;
    public static final int MSG_EXECUTE_STEP_END = 10;
    public static final int MSG_EXECUTE_STEP_END_ACK = 110;
    public static final int MSG_EXECUTE_STEP_SENT = 11;
    public static final int MSG_INIT_FROM_SYS = 12;
    public static final int MSG_INIT_FROM_SYS_ACK = 13;
    public static final int MSG_SHUTDOWN_FROM_SYS = 62;
    public static final int MSG_SHUTDOWN_FROM_SYS_ACK = 63;
    public static final int MSG_NODE_UP = 112;
    public static final int MSG_NODE_UP_ACK = 113;
    public static final int MSG_PING = 14;
    public static final int MSG_PING_ACK = 15;
    public static final int MSG_SEND_DATA = 16;
    public static final int MSG_SEND_DATA_ACK = 17;
    public static final int MSG_SEND_DATA_INIT = 19;
    public static final int MSG_TRAN_COMMIT = 22;
    public static final int MSG_TRAN_COMMIT_ACK = 23;
    public static final int MSG_TRAN_ROLLBACK = 24;
    public static final int MSG_TRAN_ROLLBACK_ACK = 25;
    public static final int MSG_DROP_TEMP_TABLES = 26;
    public static final int MSG_DROP_TEMP_TABLES_ACK = 27;
    public static final int MSG_TRAN_BEGIN_SAVEPOINT = 28;
    public static final int MSG_TRAN_BEGIN_SAVEPOINT_ACK = 29;
    public static final int MSG_TRAN_ROLLBACK_SAVEPOINT = 30;
    public static final int MSG_TRAN_ROLLBACK_SAVEPOINT_ACK = 31;
    public static final int MSG_TRAN_END_SAVEPOINT = 32;
    public static final int MSG_TRAN_END_SAVEPOINT_ACK = 33;
    public static final int MSG_EXECUTE_BATCH = 40;
    public static final int MSG_EXECUTE_BATCH_ACK = 41;
    public static final int MSG_RESULT_CLOSE = 142;
    public static final int MSG_RESULT_ROWS_REQUEST = 42;
    public static final int MSG_RESULT_ROWS = 43;
    public static final int MSG_INIT_PROPERTIES = 44;
    public static final int MSG_START_LOADERS = 45;
    public static final int MSG_START_LOADERS_ACK = 145;
    public static final int MSG_BEGIN_SEND_ROWS = 46;
    public static final int MSG_END_SEND_ROWS = 47;
    public static final int MSG_STOP_THREAD = 1001;
    public static final int MAX_DATA_ROWS = 1000;
    public static final int MAX_DATA_SIZE = 35000;
    private int msgType;
    protected Integer[] targetNodeIDs;
    private int sourceNodeID;
    private int requestId;
    private Integer sessionID;
    private transient int sendAttempt = 0;

    public NodeMessage() {
    }

    protected NodeMessage(int n) {
        this.msgType = n;
    }

    public static final NodeMessage getNodeMessage(int n) {
        switch (n) {
            case 11: 
            case 42: 
            case 43: 
            case 108: 
            case 142: {
                return new ResultSetMessage(n);
            }
            case 9: 
            case 209: {
                return new StepDetailMessage(n);
            }
            case 16: 
            case 17: 
            case 26: 
            case 40: 
            case 44: 
            case 71: 
            case 72: {
                return new DataRowsMessage(n);
            }
            case 41: {
                return new BatchResultMessage(n);
            }
            case 19: 
            case 28: 
            case 30: 
            case 32: 
            case 73: 
            case 107: {
                return new CommandMessage(n);
            }
            case 7: {
                return new CommandExtMessage(n);
            }
            case 8: {
                return new UpdateResultMessage(n);
            }
            case 1: {
                return new AbortMessage(n);
            }
            case 2: 
            case 12: 
            case 13: 
            case 45: 
            case 62: 
            case 63: {
                return new ConnectMessage(n);
            }
            case 46: 
            case 47: {
                return new SendRowsMessage(n);
            }
        }
        return new NodeMessage(n);
    }

    public static final byte[] getBytes(NodeMessage nodeMessage) throws IOException {
        return NodeMessage.getBytes(nodeMessage, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getBytes(NodeMessage nodeMessage, int n) throws IOException {
        OutputStream outputStream;
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(0);
            outputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                try {
                    ((ObjectOutputStream)outputStream).writeObject(nodeMessage);
                }
                catch (NotSerializableException notSerializableException) {
                    logger.catching(notSerializableException);
                    throw new IOException("Can not serialize message " + nodeMessage);
                }
                ((ObjectOutputStream)outputStream).flush();
                byArray = byteArrayOutputStream.toByteArray();
                logger.debug("Encode message, size: " + byArray.length);
            }
            finally {
                ((ObjectOutputStream)outputStream).close();
            }
        }
        finally {
            byteArrayOutputStream.close();
        }
        if (byArray.length > n) {
            return byArray;
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray2;
            byteArrayOutputStream.write(1);
            outputStream = new ZipOutputStream(byteArrayOutputStream);
            try {
                ((ZipOutputStream)outputStream).putNextEntry(new ZipEntry("x"));
                ((ZipOutputStream)outputStream).write(byArray, 1, byArray.length - 1);
                ((ZipOutputStream)outputStream).closeEntry();
                ((DeflaterOutputStream)outputStream).flush();
                logger.debug("Compress message, size: " + byteArrayOutputStream.size());
                byArray2 = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                ((ZipOutputStream)outputStream).close();
                throw throwable;
            }
            ((ZipOutputStream)outputStream).close();
            return byArray2;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    /*
     * Exception decompiling
     */
    public static final NodeMessage decodeBytes(byte[] var0) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getMessageTypeString(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "MSG_KILL";
                break;
            }
            case 1: {
                string = "MSG_ABORT";
                break;
            }
            case 101: {
                string = "MSG_ABORT_ACK";
                break;
            }
            case 2: {
                string = "MSG_CONNECTION_BEGIN";
                break;
            }
            case 3: {
                string = "MSG_CONNECTION_BEGIN_ACK";
                break;
            }
            case 4: {
                string = "MSG_CONNECTION_END";
                break;
            }
            case 5: {
                string = "MSG_CONNECTION_END_ACK";
                break;
            }
            case 6: {
                string = "MSG_ERROR";
                break;
            }
            case 7: {
                string = "MSG_EXEC_COMMAND";
                break;
            }
            case 8: {
                string = "MSG_EXEC_COMMAND_RESULT";
                break;
            }
            case 107: {
                string = "MSG_EXEC_QUERY";
                break;
            }
            case 108: {
                string = "MSG_EXEC_QUERY_RESULT";
                break;
            }
            case 71: {
                string = "MSG_PREPARE_COMMAND";
                break;
            }
            case 81: {
                string = "MSG_PREPARE_COMMAND_ACK";
                break;
            }
            case 72: {
                string = "MSG_PREPARE_COMMAND_EXEC";
                break;
            }
            case 73: {
                string = "MSG_PREPARE_COMMAND_CLOSE";
                break;
            }
            case 83: {
                string = "MSG_PREPARE_COMMAND_CLOSE_ACK";
                break;
            }
            case 9: {
                string = "MSG_EXECUTE_STEP_INIT";
                break;
            }
            case 109: {
                string = "MSG_EXECUTE_STEP_INIT_ACK";
                break;
            }
            case 209: {
                string = "MSG_EXECUTE_STEP_RUN";
                break;
            }
            case 10: {
                string = "MSG_EXECUTE_STEP_END";
                break;
            }
            case 110: {
                string = "MSG_EXECUTE_STEP_END_ACK";
                break;
            }
            case 11: {
                string = "MSG_EXECUTE_STEP_SENT";
                break;
            }
            case 12: {
                string = "MSG_INIT_FROM_SYS";
                break;
            }
            case 13: {
                string = "MSG_INIT_FROM_SYS_ACK";
                break;
            }
            case 62: {
                string = "MSG_SHUTDOWN_FROM_SYS";
                break;
            }
            case 63: {
                string = "MSG_SHUTDOWN_FROM_SYS_ACK";
                break;
            }
            case 112: {
                string = "MSG_NODE_UP";
                break;
            }
            case 14: {
                string = "MSG_PING";
                break;
            }
            case 15: {
                string = "MSG_PING_ACK";
                break;
            }
            case 16: {
                string = "MSG_SEND_DATA";
                break;
            }
            case 17: {
                string = "MSG_SEND_DATA_ACK";
                break;
            }
            case 19: {
                string = "MSG_SEND_DATA_INIT";
                break;
            }
            case 22: {
                string = "MSG_TRAN_COMMIT";
                break;
            }
            case 23: {
                string = "MSG_TRAN_COMMIT_ACK";
                break;
            }
            case 24: {
                string = "MSG_TRAN_ROLLBACK";
                break;
            }
            case 25: {
                string = "MSG_TRAN_ROLLBACK_ACK";
                break;
            }
            case 26: {
                string = "MSG_DROP_TEMP_TABLES";
                break;
            }
            case 27: {
                string = "MSG_DROP_TEMP_TABLES_ACK";
                break;
            }
            case 28: {
                string = "MSG_TRAN_BEGIN_SAVEPOINT";
                break;
            }
            case 29: {
                string = "MSG_TRAN_BEGIN_SAVEPOINT_ACK";
                break;
            }
            case 30: {
                string = "MSG_TRAN_ROLLBACK_SAVEPOINT";
                break;
            }
            case 31: {
                string = "MSG_TRAN_ROLLBACK_SAVEPOINT_ACK";
                break;
            }
            case 32: {
                string = "MSG_TRAN_END_SAVEPOINT";
                break;
            }
            case 33: {
                string = "MSG_TRAN_END_SAVEPOINT_ACK";
                break;
            }
            case 40: {
                string = "MSG_EXECUTE_BATCH";
                break;
            }
            case 41: {
                string = "MSG_EXECUTE_BATCH_ACK";
                break;
            }
            case 42: {
                string = "MSG_RESULT_ROWS_REQUEST";
                break;
            }
            case 142: {
                string = "MSG_RESULT_CLOSE";
                break;
            }
            case 43: {
                string = "MSG_RESULT_ROWS";
                break;
            }
            case 1001: {
                string = "MSG_STOP_THREAD";
                break;
            }
            case 113: {
                string = "MSG_NODE_UP_ACK";
                break;
            }
            case 44: {
                string = "MSG_INIT_PROPERTIES";
                break;
            }
            case 45: {
                string = "MSG_START_LOADERS";
                break;
            }
            case 145: {
                string = "MSG_START_LOADERS_ACK";
                break;
            }
            default: {
                string = new Integer(n).toString();
            }
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NodeMessage[Type:").append(this.getMessageTypeString()).append(", From:").append(this.sourceNodeID).append(", To: [");
        if (this.targetNodeIDs != null) {
            for (int i = 0; i < this.targetNodeIDs.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.targetNodeIDs[i]);
            }
        }
        stringBuffer.append("], Session: ").append(this.sessionID).append(", Request: ").append(this.requestId).append(this.getDescription()).append("]");
        return stringBuffer.toString();
    }

    protected String getDescription() {
        return "";
    }

    public int getMessageType() {
        return this.msgType;
    }

    public String getMessageTypeString() {
        return NodeMessage.getMessageTypeString(this.msgType);
    }

    public Integer getTargetNodeID() {
        return this.targetNodeIDs == null || this.targetNodeIDs.length != 1 ? null : this.targetNodeIDs[0];
    }

    public void setTargetNodeID(Integer n) {
        Integer[] integerArray;
        if (n == null) {
            integerArray = null;
        } else {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = n;
        }
        this.targetNodeIDs = integerArray;
    }

    public void setTargetNodeIDs(Integer[] integerArray) {
        this.targetNodeIDs = integerArray;
    }

    public Collection<Integer> getNodeList() {
        if (this.targetNodeIDs == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.targetNodeIDs);
    }

    public int getSourceNodeID() {
        return this.sourceNodeID;
    }

    public void setSourceNodeID(int n) {
        this.sourceNodeID = n;
    }

    public Integer getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(Integer n) {
        this.sessionID = n;
    }

    public void setRequestId(int n) {
        this.requestId = n;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public int sendFailed() {
        return ++this.sendAttempt;
    }

    public NodeResultSetImpl getResultSet() {
        throw new XDBServerException("Method is not implemented: getResultSet()");
    }

    public String getResultSetID() {
        throw new XDBServerException("Method is not implemented: getResultSetID()");
    }

    public void setResultSetID(String string) {
        throw new XDBServerException("Method is not implemented: setResultSetID(String)");
    }

    public byte[] getResultSetData() {
        throw new XDBServerException("Method is not implemented: getResultSetData()");
    }

    public void setResultSetData(byte[] byArray) {
        throw new XDBServerException("Method is not implemented: setResultSetData(byte[])");
    }

    public boolean isResultSetHasMoreRows() {
        throw new XDBServerException("Method is not implemented: isResultSetHasMoreRows()");
    }

    public void setResultSetHasMoreRows(boolean bl) {
        throw new XDBServerException("Method is not implemented: setResultSetHasMoreRows(boolean)");
    }

    public void setStepDetail(StepDetail stepDetail) {
        throw new XDBServerException("Method is not implemented: setStepDetail(StepDetail)");
    }

    public StepDetail getStepDetail() {
        throw new XDBServerException("Method is not implemented: getStepDetail()");
    }

    public int addRowData(String string) {
        throw new XDBServerException("Method is not implemented: setRowData(String)");
    }

    public String[] getRowData() {
        throw new XDBServerException("Method is not implemented: getRowData()");
    }

    public int getRowCount() {
        throw new XDBServerException("Method is not implemented: getRowCount()");
    }

    public boolean canAddRows() {
        throw new XDBServerException("Method is not implemented: canAddRows()");
    }

    public void setDataSeqNo(long l) {
        throw new XDBServerException("Method is not implemented: setDataSeqNo(long)");
    }

    public long getDataSeqNo() {
        throw new XDBServerException("Method is not implemented: getDataSeqNo()");
    }

    public void setBatchResult(int[] nArray) {
        throw new XDBServerException("Method is not implemented: setBatchResult(int[])");
    }

    public int[] getBatchResult() {
        throw new XDBServerException("Method is not implemented: getBatchResult()");
    }

    public void setSqlCommand(String string) {
        throw new XDBServerException("Method is not implemented: setSqlCommand(String)");
    }

    public String getSqlCommand() {
        throw new XDBServerException("Method is not implemented: getSqlCommand()");
    }

    public boolean getAutocommit() {
        throw new XDBServerException("Method is not implemented: getAutoCommit()");
    }

    public void setAutocommit(boolean bl) {
        throw new XDBServerException("Method is not implemented: setAutoCommit(boolean)");
    }

    public void setTempTables(Collection<String> collection) {
        throw new XDBServerException("Method is not implemented: setTempTables(String)");
    }

    public Collection<String> getTempTables() {
        throw new XDBServerException("Method is not implemented: getTempTables()");
    }

    public void setSavepoint(String string) {
        throw new XDBServerException("Method is not implemented: setSavepoint(String)");
    }

    public String getSavepoint() {
        throw new XDBServerException("Method is not implemented: getSavepoint()");
    }

    public void setTargetTable(String string) {
        throw new XDBServerException("Method is not implemented: setTargetTable(String)");
    }

    public String getTargetTable() {
        throw new XDBServerException("Method is not implemented: getTargetTable()");
    }

    public void setNumRowsResult(int n) {
        throw new XDBServerException("Method is not implemented: setNumRowsResult(int)");
    }

    public int getNumRowsResult() {
        throw new XDBServerException("Method is not implemented: getNumRowsResult()");
    }

    public XDBBaseException getCause() {
        throw new XDBServerException("Method is not implemented: getCause()");
    }

    public void setCause(XDBBaseException xDBBaseException) {
        throw new XDBServerException("Method is not implemented: setCause(XDBBaseException)");
    }

    public String getDatabase() {
        throw new XDBServerException("Method is not implemented: getDatabase()");
    }

    public void setDatabase(String string) {
        throw new XDBServerException("Method is not implemented: setDatabase(String)");
    }

    public String getJdbcDriver() {
        throw new XDBServerException("Method is not implemented: getJdbcDriver()");
    }

    public String getJdbcString() {
        throw new XDBServerException("Method is not implemented: getJdbcString()");
    }

    public String getJdbcUser() {
        throw new XDBServerException("Method is not implemented: getJdbcUser()");
    }

    public String getJdbcPassword() {
        throw new XDBServerException("Method is not implemented: getJdbcPassword()");
    }

    public int getMaxConns() {
        throw new XDBServerException("Method is not implemented: getMaxConns()");
    }

    public int getMinConns() {
        throw new XDBServerException("Method is not implemented: getMinConns()");
    }

    public long getTimeOut() {
        throw new XDBServerException("Method is not implemented: getTimeOut()");
    }

    public void setJdbcDriver(String string) {
        throw new XDBServerException("Method is not implemented: setJdbcDriver(String)");
    }

    public void setJdbcString(String string) {
        throw new XDBServerException("Method is not implemented: setJdbcString(String)");
    }

    public void setJdbcUser(String string) {
        throw new XDBServerException("Method is not implemented: setJdbcUser(String)");
    }

    public void setJdbcPassword(String string) {
        throw new XDBServerException("Method is not implemented: setJdbcPassword(String)");
    }

    public void setMaxConns(int n) {
        throw new XDBServerException("Method is not implemented: setMaxConns(int)");
    }

    public void setMessageType(int n) {
        this.msgType = n;
    }

    public void setMinConns(int n) {
        throw new XDBServerException("Method is not implemented: setMinConns(int)");
    }

    public void setTimeOut(long l) {
        throw new XDBServerException("Method is not implemented: setTimeOut(long)");
    }

    public Object clone() {
        NodeMessage nodeMessage = null;
        try {
            nodeMessage = (NodeMessage)super.clone();
            if (this.targetNodeIDs != null) {
                nodeMessage.targetNodeIDs = new Integer[this.targetNodeIDs.length];
                System.arraycopy(this.targetNodeIDs, 0, nodeMessage.targetNodeIDs, 0, this.targetNodeIDs.length);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return nodeMessage;
    }
}

