/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.communication;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.AbstractAgent;
import com.edb.gridsql.communication.AbstractConnector;
import com.edb.gridsql.communication.ConnectorFactory;
import com.edb.gridsql.communication.IMessageListener;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.engine.JDBCPool;
import com.edb.gridsql.engine.NodeThread;
import com.edb.gridsql.engine.NodeThreadPool;
import com.edb.gridsql.exception.XDBBaseException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.exception.XDBUnexpectedMessageException;
import com.edb.gridsql.exception.XDBWrappedException;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;

public class NodeAgent
extends AbstractAgent {
    private static final XLogger logger = XLogger.getLogger(NodeAgent.class);
    private static final XLogger serverLogger = XLogger.getLogger("Server");
    private static final HashMap<Integer, NodeAgent> localNodeAgents = new HashMap();
    private int nodeID;
    private HashMap<String, JDBCPool> connectionPools = new HashMap();
    private AtomicReference<NodeThreadPool> threadPool = new AtomicReference<Object>(null);
    private AbstractConnector[] connectors;
    private AbstractConnector broadcastConnector;
    private AbstractAgent.ProcessAnalizer analizer = new AbstractAgent.ProcessAnalizer();
    private Executor executor;

    private NodeAgent(int n) {
        this.nodeID = n;
        this.executor = Executors.newCachedThreadPool();
    }

    public int getNodeID() {
        return this.nodeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        try {
            this.connectors = new AbstractConnector[1];
            this.connectors[0] = ConnectorFactory.getConnector(this.nodeID, 0);
            this.connectors[0].addMessageListener(this);
            this.connectors[0].start();
            NodeMessage nodeMessage = NodeMessage.getNodeMessage(112);
            nodeMessage.setSourceNodeID(this.nodeID);
            nodeMessage.setTargetNodeID(new Integer(0));
            this.sendMessage(nodeMessage);
        }
        catch (XDBServerException xDBServerException) {
            logger.catching(xDBServerException);
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishInit() {
        try {
            AbstractConnector abstractConnector = this.connectors[0];
            this.connectors = new AbstractConnector[Props.XDB_NODECOUNT + 1];
            this.connectors[0] = abstractConnector;
            this.broadcastConnector = ConnectorFactory.getBroadcastConnector(this.getNodeID());
            if (this.broadcastConnector != null) {
                this.broadcastConnector.addMessageListener(this);
                this.broadcastConnector.start();
            }
            NodeThreadPool nodeThreadPool = new NodeThreadPool(this.nodeID, Property.getInt("xdb.node." + this.nodeID + ".threads.pool.initsize", Props.XDB_DEFAULT_THREADS_POOL_INITSIZE), Property.getInt("xdb.node." + this.nodeID + ".threads.pool.maxsize", Props.XDB_DEFAULT_THREADS_POOL_MAXSIZE));
            nodeThreadPool.setGetTimeout(Property.getInt("xdb.node." + this.nodeID + ".threads.pool.timeout", Props.XDB_DEFAULT_THREADS_POOL_TIMEOUT));
            nodeThreadPool.setReleaseTimeout(Property.getInt("xdb.node." + this.nodeID + ".threads.pool.idle", Props.XDB_DEFAULT_THREADS_POOL_IDLE));
            nodeThreadPool.initBuffer();
            nodeThreadPool.setCleanupAgent(this.analizer);
            serverLogger.log(Level.INFO, "Node %0%: thread pool is ready", new Object[]{new Integer(this.nodeID)});
            nodeThreadPool = this.threadPool.getAndSet(nodeThreadPool);
            if (nodeThreadPool != null) {
                logger.warn("Node Thread Pool was initialized twice on node " + this.nodeID);
                nodeThreadPool.destroy();
            }
        }
        catch (XDBServerException xDBServerException) {
            logger.catching(xDBServerException);
            serverLogger.fatal("Can not initialize Agent properly, perhaps invalid config or duplicate instance");
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        NodeThreadPool nodeThreadPool = this.threadPool.getAndSet(null);
        if (nodeThreadPool != null) {
            nodeThreadPool.destroy();
        }
        HashMap<String, JDBCPool> hashMap = this.connectionPools;
        synchronized (hashMap) {
            for (JDBCPool jDBCPool : this.connectionPools.values()) {
                if (jDBCPool == null) continue;
                jDBCPool.destroy();
            }
            this.connectionPools.clear();
        }
        if (this.connectors != null) {
            for (int i = 0; i < this.connectors.length; ++i) {
                if (this.connectors[i] == null) continue;
                this.connectors[i].destroy();
                this.connectors[i].removeMessageListener(this);
                this.connectors[i] = null;
            }
            this.connectors = null;
        }
        if (this.broadcastConnector != null) {
            this.broadcastConnector.destroy();
            this.broadcastConnector.removeMessageListener(this);
            this.broadcastConnector = null;
        }
        serverLogger.log(Level.INFO, "*** Node agent %0% is stopped", new Object[]{new Integer(this.nodeID)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractConnector getConnector(Integer n) {
        AbstractConnector abstractConnector = null;
        if (n == null) {
            abstractConnector = this.broadcastConnector;
        } else {
            if (this.connectors == null) {
                throw new XDBServerException("Node Agent " + this.nodeID + " is not initialized");
            }
            if (n >= this.connectors.length) {
                throw new XDBServerException("Invalid Node Number: " + n);
            }
            abstractConnector = this.connectors[n];
            if (abstractConnector == null) {
                abstractConnector = ConnectorFactory.getConnector(this.nodeID, n);
                if (abstractConnector != null) {
                    abstractConnector.addMessageListener(this);
                    abstractConnector.start();
                }
                this.connectors[n.intValue()] = abstractConnector;
            }
        }
        AbstractConnector abstractConnector2 = abstractConnector;
        return abstractConnector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean beforeProcessMessage(NodeMessage nodeMessage) {
        switch (nodeMessage.getMessageType()) {
            case 44: {
                Property.addLines(nodeMessage.getRowData());
                return true;
            }
            case 113: {
                this.finishInit();
                serverLogger.log(Level.INFO, "Node %0%: Connection to Coordinator is completed", new Object[]{new Integer(this.nodeID)});
                return true;
            }
            case 12: {
                this.executor.execute(new PoolInitializer(nodeMessage));
                return true;
            }
            case 62: {
                try {
                    if (nodeMessage.getDatabase() == null) {
                        HashMap<String, JDBCPool> hashMap = this.connectionPools;
                        // MONITORENTER : hashMap
                        for (JDBCPool jDBCPool : this.connectionPools.values()) {
                            if (jDBCPool == null) continue;
                            jDBCPool.destroy();
                        }
                        this.connectionPools.clear();
                        // MONITOREXIT : hashMap
                        if ("RESTART".equals(nodeMessage.getSqlCommand())) {
                            this.sendMessage(this.reply(nodeMessage, 112));
                            return true;
                        } else {
                            this.sendMessage(this.reply(nodeMessage, 63));
                            NodeAgent.releaseNodeAgent(this.nodeID);
                        }
                        return true;
                    }
                    HashMap<String, JDBCPool> hashMap = this.connectionPools;
                    // MONITORENTER : hashMap
                    JDBCPool jDBCPool = this.connectionPools.remove(nodeMessage.getDatabase());
                    if (jDBCPool != null) {
                        jDBCPool.destroy();
                    }
                    // MONITOREXIT : hashMap
                    NodeMessage nodeMessage2 = this.reply(nodeMessage, 63);
                    nodeMessage2.setDatabase(nodeMessage.getDatabase());
                    this.sendMessage(nodeMessage2);
                    return true;
                }
                catch (Exception exception) {
                    this.sendMessage(this.reply(nodeMessage, 1));
                }
                return true;
            }
            case 2: {
                this.executor.execute(new ThreadInitializer(nodeMessage));
                return true;
            }
            case 4: {
                this.executor.execute(new ThreadFinalizer(nodeMessage));
                return true;
            }
            case 45: {
                String string = nodeMessage.getJdbcString();
                String string2 = nodeMessage.getDatabase();
                String string3 = nodeMessage.getJdbcUser();
                String string4 = nodeMessage.getJdbcPassword();
                String string5 = nodeMessage.getTargetTable();
                String string6 = nodeMessage.getSqlCommand();
                try {
                    Class<?> clazz = Class.forName("com.edb.gridsql.Util.loader.SocketWriter");
                    Constructor<?> constructor = clazz.getConstructor(Integer.TYPE, String.class, String.class, String.class, String.class, String.class, String.class);
                    constructor.newInstance(new Integer(this.nodeID), string, string2, string3, string4, string5, string6);
                }
                catch (Throwable throwable) {
                    logger.catching(throwable);
                }
                this.sendMessage(this.reply(nodeMessage, 145));
                return true;
            }
        }
        return super.beforeProcessMessage(nodeMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeAgent getNodeAgent(int n) {
        Integer n2 = new Integer(n);
        NodeAgent nodeAgent = null;
        HashMap<Integer, NodeAgent> hashMap = localNodeAgents;
        synchronized (hashMap) {
            nodeAgent = localNodeAgents.get(n2);
            if (nodeAgent == null) {
                nodeAgent = new NodeAgent(n);
                localNodeAgents.put(n2, nodeAgent);
                nodeAgent.init();
            }
        }
        return nodeAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseNodeAgent(int n) {
        Integer n2 = new Integer(n);
        HashMap<Integer, NodeAgent> hashMap = localNodeAgents;
        synchronized (hashMap) {
            NodeAgent nodeAgent = localNodeAgents.remove(n2);
            if (nodeAgent != null) {
                nodeAgent.close();
            }
            if (localNodeAgents.isEmpty()) {
                System.exit(0);
            }
        }
    }

    private class ThreadFinalizer
    implements Runnable {
        private NodeMessage message;
        private NodeThread nt;

        public ThreadFinalizer(NodeMessage nodeMessage) {
            this.message = nodeMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            IMessageListener iMessageListener = NodeAgent.this.removeProcess(this.message.getSessionID());
            NodeAgent.this.sendMessage(NodeAgent.this.reply(this.message, 5));
            if (!(iMessageListener instanceof NodeThread)) {
                logger.warn("A listener is not NodeThread but " + iMessageListener);
                return;
            }
            this.nt = (NodeThread)iMessageListener;
            NodeThreadPool nodeThreadPool = (NodeThreadPool)NodeAgent.this.threadPool.get();
            try {
                NodeThread nodeThread = this.nt;
                synchronized (nodeThread) {
                    if (nodeThreadPool != null && nodeThreadPool.isOut(this.nt)) {
                        this.nt.reset(null, null);
                        nodeThreadPool.releaseObject(this.nt);
                    }
                    this.nt.notifyAll();
                }
            }
            catch (Exception exception) {
                if (nodeThreadPool != null) {
                    nodeThreadPool.destroyObject(this.nt, true);
                }
            }
        }
    }

    private class ThreadInitializer
    implements Runnable {
        private NodeMessage initMessage;

        public ThreadInitializer(NodeMessage nodeMessage) {
            this.initMessage = nodeMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addProcess(NodeThread nodeThread, NodeThreadPool nodeThreadPool) {
            block7: {
                IMessageListener iMessageListener = NodeAgent.this.addProcess(this.initMessage.getSessionID(), nodeThread);
                if (iMessageListener instanceof NodeThread) {
                    NodeThread nodeThread2 = (NodeThread)iMessageListener;
                    try {
                        NodeThread nodeThread3 = nodeThread2;
                        synchronized (nodeThread3) {
                            if (nodeThreadPool != null && nodeThreadPool.isOut(nodeThread2)) {
                                nodeThread2.reset(null, null);
                                nodeThreadPool.releaseNodeThread(nodeThread2);
                            }
                            nodeThread2.notifyAll();
                        }
                    }
                    catch (Throwable throwable) {
                        logger.catching(throwable);
                        if (nodeThreadPool == null) break block7;
                        nodeThreadPool.destroyObject(nodeThread2, true);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block13: {
                NodeThread nodeThread = null;
                NodeThreadPool nodeThreadPool = (NodeThreadPool)NodeAgent.this.threadPool.get();
                if (nodeThreadPool == null) {
                    NodeMessage nodeMessage = NodeAgent.this.reply(this.initMessage, 1);
                    nodeMessage.setCause(new XDBUnexpectedMessageException(NodeAgent.this.getNodeID(), "Node Agent is not initialized", this.initMessage));
                    NodeAgent.this.sendMessage(nodeMessage);
                    return;
                }
                try {
                    JDBCPool jDBCPool = null;
                    Serializable serializable = NodeAgent.this.connectionPools;
                    synchronized (serializable) {
                        jDBCPool = (JDBCPool)NodeAgent.this.connectionPools.get(this.initMessage.getDatabase());
                    }
                    if (jDBCPool == null) {
                        serializable = new XDBUnexpectedMessageException(NodeAgent.this.getNodeID(), "Not connected to database: " + this.initMessage.getDatabase(), this.initMessage);
                        logger.throwing((Throwable)serializable);
                        throw serializable;
                    }
                    nodeThread = nodeThreadPool.getNodeThread();
                    nodeThread.reset(this.initMessage.getSessionID(), jDBCPool);
                    this.addProcess(nodeThread, nodeThreadPool);
                    NodeAgent.this.sendMessage(NodeAgent.this.reply(this.initMessage, 3));
                }
                catch (Throwable throwable) {
                    logger.catching(throwable);
                    NodeMessage nodeMessage = NodeAgent.this.reply(this.initMessage, 1);
                    if (throwable instanceof XDBBaseException) {
                        nodeMessage.setCause((XDBBaseException)throwable);
                    } else {
                        nodeMessage.setCause(new XDBWrappedException(NodeAgent.this.nodeID, throwable));
                    }
                    NodeAgent.this.sendMessage(nodeMessage);
                    if (nodeThread == null) break block13;
                    try {
                        nodeThread.reset(null, null);
                        nodeThreadPool.releaseObject(nodeThread);
                    }
                    catch (Exception exception) {
                        nodeThreadPool.destroyObject(nodeThread, true);
                    }
                }
            }
        }
    }

    private class PoolInitializer
    implements Runnable {
        private NodeMessage initMessage;

        public PoolInitializer(NodeMessage nodeMessage) {
            this.initMessage = nodeMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = Property.getInt("xdb.jdbc.pool.retry", -1);
            if (n < 0) {
                n = 0;
            }
            boolean bl = true;
            String string = this.initMessage.getDatabase();
            while (n-- >= 0) {
                try {
                    JDBCPool jDBCPool = null;
                    Object object = NodeAgent.this.connectionPools;
                    synchronized (object) {
                        jDBCPool = (JDBCPool)NodeAgent.this.connectionPools.get(string);
                        if (jDBCPool == null) {
                            jDBCPool = new JDBCPool(this.initMessage.getJdbcDriver(), this.initMessage.getJdbcString(), this.initMessage.getJdbcUser(), this.initMessage.getJdbcPassword(), Property.getInt("xdb.jdbc.pool.initsize", Props.XDB_DEFAULT_THREADS_POOL_INITSIZE), Property.getInt("xdb.jdbc.pool.maxsize", Props.XDB_DEFAULT_THREADS_POOL_MAXSIZE));
                            jDBCPool.setGetTimeout(Property.getInt("xdb.jdbc.pool.timeout", Props.XDB_DEFAULT_THREADS_POOL_TIMEOUT));
                            jDBCPool.setReleaseTimeout(Property.getInt("xdb.jdbc.pool.idle", Props.XDB_DEFAULT_THREADS_POOL_IDLE));
                            jDBCPool.setCleanupAgent(NodeAgent.this.analizer);
                            NodeAgent.this.connectionPools.put(this.initMessage.getDatabase(), jDBCPool);
                        }
                        jDBCPool.initBuffer();
                    }
                    object = jDBCPool.getConnection();
                    try {
                        Statement statement;
                        ResultSet resultSet;
                        if (Props.XDB_TEMP_TABLE_SELECT == null || Props.XDB_TEMP_TABLE_SELECT.trim().length() == 0) {
                            resultSet = object.getMetaData().getTables(null, null, Props.XDB_TEMPTABLEPREFIX + "%", null);
                        } else {
                            statement = object.createStatement();
                            resultSet = statement.executeQuery(Props.XDB_TEMP_TABLE_SELECT);
                        }
                        statement = object.createStatement();
                        try {
                            while (resultSet.next()) {
                                try {
                                    String string2 = "DROP TABLE " + IdentifierHandler.quote(resultSet.getString("TABLE_NAME"));
                                    statement.executeUpdate(string2);
                                    object.commit();
                                }
                                catch (SQLException sQLException) {
                                    logger.catching(sQLException);
                                    object.rollback();
                                }
                            }
                        }
                        finally {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        logger.catching(sQLException);
                    }
                    finally {
                        jDBCPool.releaseConnection((Connection)object);
                    }
                    serverLogger.log(Level.INFO, "Node %0%: connection pool for database %1% is ready", new Object[]{new Integer(NodeAgent.this.nodeID), string});
                    for (int i = 0; i < 5 && NodeAgent.this.threadPool.get() == null; ++i) {
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (NodeAgent.this.threadPool.get() != null) {
                        NodeMessage nodeMessage = NodeAgent.this.reply(this.initMessage, 13);
                        nodeMessage.setDatabase(string);
                        NodeAgent.this.sendMessage(nodeMessage);
                        return;
                    }
                    serverLogger.error("Failed to initialize thread pool on node " + NodeAgent.this.nodeID);
                    break;
                }
                catch (XDBServerException xDBServerException) {
                    if (bl) {
                        bl = false;
                        serverLogger.log(Level.INFO, "Node %0%: failed to create connection pool for database %1% (%2%)", new Object[]{new Integer(NodeAgent.this.nodeID), string, xDBServerException.getMessage()});
                    }
                    if (n >= 0) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    serverLogger.error("Failed to initialize connection pool for " + string + " on node " + NodeAgent.this.nodeID);
                }
            }
        }
    }
}

