/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.communication;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.AbstractConnector;
import com.edb.gridsql.communication.message.NodeMessage;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalConnector
extends AbstractConnector {
    private static final XLogger logger = XLogger.getLogger(LocalConnector.class);
    private ConcurrentHashMap<Integer, BlockingQueue<NodeMessage>> msgQTable;
    private boolean started = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalConnector(int n, ConcurrentHashMap<Integer, BlockingQueue<NodeMessage>> concurrentHashMap) {
        this.msgQTable = concurrentHashMap;
        concurrentHashMap.put(n, this.inQueue);
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.addWorkerThread(new SendingThread());
        this.addWorkerThread(this);
    }

    protected class SendingThread
    extends AbstractConnector.AbstractSendingThread {
        protected SendingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void send(NodeMessage nodeMessage) throws Exception {
            BlockingQueue blockingQueue = (BlockingQueue)LocalConnector.this.msgQTable.get(nodeMessage.getTargetNodeID());
            blockingQueue.offer(nodeMessage);
        }
    }
}

