/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.communication;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.AbstractConnector;
import com.edb.gridsql.communication.LocalConnector;
import com.edb.gridsql.communication.NodeAgent;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.exception.XDBServerException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectorFactory {
    private static final XLogger logger = XLogger.getLogger(ConnectorFactory.class);
    public static final int CONNECTOR_TYPE_UNKNOWN = -1;
    public static final int CONNECTOR_TYPE_LOCAL = 0;
    public static final int CONNECTOR_TYPE_SOCKET = 1;
    public static final int CONNECTOR_TYPE_CHANNEL = 2;
    public static final int CONNECTOR_TYPE_BROADCAST = 3;
    private static final ConcurrentHashMap<Integer, BlockingQueue<NodeMessage>> msgQTable = new ConcurrentHashMap();
    private static HashMap<Integer, AbstractConnector> localConnectors = new HashMap();
    private static HashMap<Integer, AbstractConnector> socketConnectors = new HashMap();
    private static HashMap<Integer, AbstractConnector> broadcastConnectors = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AbstractConnector getConnector(int n, int n2) throws XDBServerException {
        Serializable serializable;
        Object object;
        String string = "xdb.connector." + n + "." + n2;
        int n3 = Property.getInt(string, -1);
        if (n3 == -1) {
            try {
                object = InetAddress.getByName(Property.get("xdb." + (n == 0 ? "coordinator" : "node." + n) + ".host", "localhost"));
                serializable = InetAddress.getByName(Property.get("xdb." + (n2 == 0 ? "coordinator" : "node." + n2) + ".host", "localhost"));
                n3 = ((InetAddress)object).equals(serializable) ? 0 : 2;
            }
            catch (UnknownHostException unknownHostException) {
                n3 = 3;
            }
        }
        switch (n3) {
            case 0: {
                object = ConnectorFactory.getLocalConnector(n);
                if (msgQTable.get(n2) == null) {
                    if (n2 == 0) {
                        serializable = new XDBServerException("Could not found Coordinator's LocalConnector - configuration inconsistent");
                        logger.throwing((Throwable)serializable);
                        throw serializable;
                    }
                    NodeAgent.getNodeAgent(n2);
                }
                return object;
            }
            case 1: 
            case 2: {
                serializable = socketConnectors;
                synchronized (serializable) {
                    Integer n4 = new Integer(n);
                    AbstractConnector abstractConnector = socketConnectors.get(n4);
                    if (abstractConnector == null) {
                        try {
                            Class<?> clazz = Class.forName("com.edb.gridsql.communication.SocketConnector");
                            abstractConnector = (AbstractConnector)clazz.getConstructor(Integer.TYPE).newInstance(n4);
                            socketConnectors.put(n4, abstractConnector);
                        }
                        catch (Throwable throwable) {
                            return ConnectorFactory.getLocalConnector(n);
                        }
                    }
                    return abstractConnector;
                }
            }
            case 3: {
                return ConnectorFactory.getBroadcastConnector(n);
            }
        }
        serializable = new XDBServerException("Requested connector type does not supported");
        logger.throwing((Throwable)serializable);
        throw serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractConnector getLocalConnector(int n) {
        HashMap<Integer, AbstractConnector> hashMap = localConnectors;
        synchronized (hashMap) {
            AbstractConnector abstractConnector = localConnectors.get(n);
            if (abstractConnector == null) {
                abstractConnector = new LocalConnector(n, msgQTable);
                localConnectors.put(n, abstractConnector);
            }
            return abstractConnector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractConnector getBroadcastConnector(int n) {
        HashMap<Integer, AbstractConnector> hashMap = broadcastConnectors;
        synchronized (hashMap) {
            AbstractConnector abstractConnector = broadcastConnectors.get(n);
            if (abstractConnector == null) {
                String string = Property.get("xdb.broadcast.connector");
                if (string == null) {
                    return null;
                }
                try {
                    Class<?> clazz = Class.forName(string);
                    abstractConnector = (AbstractConnector)clazz.getConstructor(Integer.TYPE).newInstance(new Integer(n));
                    broadcastConnectors.put(new Integer(n), abstractConnector);
                }
                catch (Throwable throwable) {
                    logger.catching(throwable);
                    return null;
                }
            }
            return abstractConnector;
        }
    }
}

