/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.communication;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLevel;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.AbstractConnector;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.engine.AckTracker;
import com.edb.gridsql.exception.XDBServerException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Level;

public class BroadcastConnector
extends AbstractConnector {
    private static final XLogger logger = XLogger.getLogger(BroadcastConnector.class);
    private static final XLogger chunkLog = XLogger.getLogger("Chunks");
    private static final InetSocketAddress[][] ACK_TARGET_TABLE;
    private int nodeID;
    private int domain;
    private static final int UDP_PACKET_SIZE;
    private static final int ACK_UDP_PACKET_SIZE = 10;
    private MulticastSocket channel = null;
    private InetAddress group = null;
    private int port = 0;
    private DatagramSocket ackChannel = null;
    private AckTracker tracker;
    private LinkedHashSet<Integer> recentSenders;
    private LinkedBlockingQueue<byte[]> incomingPackets = new LinkedBlockingQueue();
    private long msgSent = 0L;
    private long msgReceived = 0L;
    private long msgFailed = 0L;
    private long chunkCreated = 0L;
    private long chunkSent = 0L;
    private long chunkReceived = 0L;
    private long sendTime = 0L;
    private long lastDumped = System.currentTimeMillis();
    private static final int MAX_SENDERS_HISTORY = 1024;

    static final int domainCount() {
        return ACK_TARGET_TABLE[0].length;
    }

    private void dumpStats() {
        if (this.lastDumped + 60000L > System.currentTimeMillis()) {
            return;
        }
        String string = "Node: " + this.nodeID + " Domain: " + this.domain + " Messages (Sent, Received, Failed): " + this.msgSent + ", " + this.msgReceived + ", " + this.msgFailed + " Chunks (Created, Sent, Received): " + this.chunkCreated + ", " + this.chunkSent + ", " + this.chunkReceived + " Average send time, ms: " + this.sendTime / this.msgSent;
        this.lastDumped = System.currentTimeMillis();
    }

    public BroadcastConnector(int n) {
        this(n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BroadcastConnector(int n, int n2) {
        this.nodeID = n;
        this.domain = n2;
        this.tracker = new AckTracker();
    }

    private void listen() throws UnknownHostException, IOException {
        String string = Property.get("xdb.multicastgroup.domain" + this.domain + ".address", "228.5.6.7");
        this.group = InetAddress.getByName(string);
        this.port = Property.getInt("xdb.multicastgroup.domain" + this.domain + ".port", 6987 + (ACK_TARGET_TABLE.length + 1) * this.domain);
        this.ackChannel = new DatagramSocket(ACK_TARGET_TABLE[this.nodeID][this.domain]);
        this.channel = new MulticastSocket(this.port);
        this.channel.joinGroup(this.group);
    }

    public void start() {
        if (this.channel != null) {
            return;
        }
        this.recentSenders = new LinkedHashSet();
        try {
            this.listen();
        }
        catch (IOException iOException) {
            logger.catching(iOException);
            System.exit(1);
        }
        this.addWorkerThread(new ReceiveChunksThread(this.channel));
        this.addWorkerThread(new ReceiveAcksThread(this.ackChannel));
        this.addWorkerThread(new ReceivingThread());
        this.addWorkerThread(new SendingThread());
        this.addWorkerThread(this);
    }

    public void destroy() {
        super.destroy();
        this.channel.close();
        this.ackChannel.close();
    }

    private Object getKey(int n, int n2) {
        long l = ((long)n << 32) + (long)n2;
        return new Long(l);
    }

    private void packInt(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    private int unpackInt(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    static {
        int n = 1;
        while (Property.get("xdb.multicastgroup.domain" + n + ".address") != null) {
            ++n;
        }
        ACK_TARGET_TABLE = new InetSocketAddress[Props.XDB_NODECOUNT + 1][n];
        try {
            for (int i = 0; i < ACK_TARGET_TABLE.length; ++i) {
                InetAddress inetAddress = InetAddress.getByName(Property.get("xdb." + (i == 0 ? "coordinator" : "node." + i) + ".host"));
                for (n = 0; n < ACK_TARGET_TABLE[i].length; ++n) {
                    String string = Property.get("xdb.broadcast.domain" + n + ".ack.node" + i + ".address");
                    InetAddress inetAddress2 = string == null ? inetAddress : InetAddress.getByName(string);
                    int n2 = Property.getInt("xdb.broadcast.domain" + n + ".ack.node" + i + ".port", -1);
                    if (n2 < 0) {
                        n2 = Property.getInt("xdb.multicastgroup.domain" + n + ".port", 6987 + 2 * n) + 1;
                    }
                    BroadcastConnector.ACK_TARGET_TABLE[i][n] = new InetSocketAddress(inetAddress2, n2);
                }
            }
        }
        catch (Throwable throwable) {
            logger.catching(throwable);
            System.exit(1);
        }
        UDP_PACKET_SIZE = Property.getInt("xdb.broadcast.packetsize", 1024);
    }

    protected class SendingThread
    extends AbstractConnector.AbstractSendingThread {
        private int senderID;

        protected SendingThread() {
            this.senderID = BroadcastConnector.this.nodeID << 16;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void send(NodeMessage nodeMessage) throws Exception {
            long l = System.currentTimeMillis();
            try {
                Object object;
                byte[] byArray = NodeMessage.getBytes(nodeMessage);
                HashMap<Object, byte[]> hashMap = new HashMap<Object, byte[]>();
                int n = (byArray.length - 1) / (UDP_PACKET_SIZE - 12) + 1;
                BroadcastConnector.this.chunkCreated += n;
                for (int i = 0; i < n - 1; ++i) {
                    object = new byte[UDP_PACKET_SIZE];
                    BroadcastConnector.this.packInt(this.senderID, (byte[])object, 0);
                    BroadcastConnector.this.packInt(i, (byte[])object, 4);
                    BroadcastConnector.this.packInt(n, (byte[])object, 8);
                    System.arraycopy(byArray, i * (UDP_PACKET_SIZE - 12), object, 12, UDP_PACKET_SIZE - 12);
                    hashMap.put(BroadcastConnector.this.getKey(this.senderID, i), (byte[])object);
                }
                byte[] byArray2 = new byte[(byArray.length - 1) % (UDP_PACKET_SIZE - 12) + 13];
                BroadcastConnector.this.packInt(this.senderID, byArray2, 0);
                BroadcastConnector.this.packInt(n - 1, byArray2, 4);
                BroadcastConnector.this.packInt(n, byArray2, 8);
                System.arraycopy(byArray, (n - 1) * (UDP_PACKET_SIZE - 12), byArray2, 12, byArray2.length - 12);
                hashMap.put(BroadcastConnector.this.getKey(this.senderID, n - 1), byArray2);
                BroadcastConnector.this.tracker.init(hashMap, nodeMessage.getNodeList());
                chunkLog.log(XLevel.TRACE, "Node %0% Domain %1% Chunks created: %2%", new Object[]{new Integer(BroadcastConnector.this.nodeID), new Integer(BroadcastConnector.this.domain), hashMap});
                object = BroadcastConnector.this.tracker.getPackets();
                while (!object.isEmpty()) {
                    chunkLog.log(Level.DEBUG, "Node %0% Domain %1% Chunks sending: %2%", new Object[]{new Integer(BroadcastConnector.this.nodeID), new Integer(BroadcastConnector.this.domain), object});
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        byte[] byArray3 = (byte[])iterator.next();
                        DatagramPacket datagramPacket = new DatagramPacket(byArray3, byArray3.length, BroadcastConnector.this.group, BroadcastConnector.this.port);
                        BroadcastConnector.this.channel.send(datagramPacket);
                    }
                    BroadcastConnector.this.chunkSent += object.size();
                    try {
                        BroadcastConnector.this.tracker.waitAcks(1000L);
                    }
                    catch (XDBServerException xDBServerException) {
                        logger.catching(xDBServerException);
                        BroadcastConnector.this.tracker.reset();
                        logger.throwing(xDBServerException);
                        throw xDBServerException;
                    }
                    object = BroadcastConnector.this.tracker.getPackets();
                }
                BroadcastConnector.this.msgSent++;
                BroadcastConnector.this.dumpStats();
            }
            finally {
                if (++this.senderID >> 16 != BroadcastConnector.this.nodeID) {
                    this.senderID = BroadcastConnector.this.nodeID << 16;
                }
                BroadcastConnector.this.sendTime += System.currentTimeMillis() - l;
            }
        }

        protected void sendFailed(NodeMessage nodeMessage, Exception exception) {
            BroadcastConnector.this.msgFailed++;
            super.sendFailed(nodeMessage, exception);
        }
    }

    protected class ReceiveChunksThread
    extends ReceivePacketsThread {
        public ReceiveChunksThread(DatagramSocket datagramSocket) {
            super(datagramSocket);
        }

        protected void receive() throws Exception {
            DatagramPacket datagramPacket = new DatagramPacket(new byte[UDP_PACKET_SIZE], UDP_PACKET_SIZE);
            this.theChannel.receive(datagramPacket);
            BroadcastConnector.this.incomingPackets.offer(datagramPacket.getData());
        }
    }

    protected class ReceiveAcksThread
    extends ReceivePacketsThread {
        public ReceiveAcksThread(DatagramSocket datagramSocket) {
            super(datagramSocket);
        }

        protected void receive() throws Exception {
            DatagramPacket datagramPacket = new DatagramPacket(new byte[10], 10);
            this.theChannel.receive(datagramPacket);
            byte[] byArray = datagramPacket.getData();
            int n = BroadcastConnector.this.unpackInt(byArray, 0);
            int n2 = BroadcastConnector.this.unpackInt(byArray, 4);
            int n3 = (byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF;
            chunkLog.log(XLevel.TRACE, "Node %0% Domain %1% Chunk %2% acked from node %3%", new Object[]{new Integer(BroadcastConnector.this.nodeID), new Integer(BroadcastConnector.this.domain), BroadcastConnector.this.getKey(n, n2), new Integer(n3)});
            BroadcastConnector.this.tracker.register(BroadcastConnector.this.getKey(n, n2), n3);
        }
    }

    protected abstract class ReceivePacketsThread
    implements Runnable {
        protected DatagramSocket theChannel;

        public ReceivePacketsThread(DatagramSocket datagramSocket) {
            this.theChannel = datagramSocket;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.receive();
                    }
                }
                catch (IOException iOException) {
                    if (this.theChannel.isClosed()) break;
                    logger.catching(iOException);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.catching(throwable);
                    continue;
                }
                break;
            }
        }

        protected abstract void receive() throws Exception;
    }

    protected class ReceivingThread
    extends AbstractConnector.AbstractReceivingThread {
        private Map<Integer, byte[][]> incomingChunks = new HashMap<Integer, byte[][]>();

        protected ReceivingThread() {
        }

        protected NodeMessage[] receive() throws Exception {
            int n;
            byte[] byArray = (byte[])BroadcastConnector.this.incomingPackets.take();
            BroadcastConnector.this.chunkReceived++;
            int n2 = BroadcastConnector.this.unpackInt(byArray, 0);
            int n3 = BroadcastConnector.this.unpackInt(byArray, 4);
            chunkLog.log(XLevel.TRACE, "Node %0% Domain %1% Chunk received: %2%", new Object[]{new Integer(BroadcastConnector.this.nodeID), new Integer(BroadcastConnector.this.domain), BroadcastConnector.this.getKey(n2, n3)});
            logger.log(XLevel.TRACE, "Sending acknowlegement from %0% to %1%, domain %2% using %3%", new Object[]{new Integer(BroadcastConnector.this.nodeID), new Integer(n2 >> 16), new Integer(BroadcastConnector.this.domain), ACK_TARGET_TABLE[n2 >> 16][BroadcastConnector.this.domain]});
            byte[] byArray2 = new byte[10];
            System.arraycopy(byArray, 0, byArray2, 0, 8);
            byArray2[8] = (byte)(BroadcastConnector.this.nodeID >> 8);
            byArray2[9] = (byte)BroadcastConnector.this.nodeID;
            DatagramPacket datagramPacket = new DatagramPacket(byArray2, 10, ACK_TARGET_TABLE[n2 >> 16][BroadcastConnector.this.domain]);
            BroadcastConnector.this.ackChannel.send(datagramPacket);
            if (BroadcastConnector.this.recentSenders.contains(new Integer(n2))) {
                return null;
            }
            Object object = this.incomingChunks.get(n2);
            if (object == null) {
                n = BroadcastConnector.this.unpackInt(byArray, 8);
                object = new byte[n][];
                this.incomingChunks.put(new Integer(n2), (byte[][])object);
            }
            if (object[n3] == null) {
                object[n3] = new byte[byArray.length - 12];
                System.arraycopy(byArray, 12, object[n3], 0, object[n3].length);
                n = 1;
                for (int i = ((byte[][])object).length - 1; i >= 0; --i) {
                    if (object[i] != null) continue;
                    n = 0;
                    break;
                }
                if (n != 0) {
                    byte[] byArray3 = new byte[(UDP_PACKET_SIZE - 12) * (((byte[][])object).length - 1) + object[((byte[][])object).length - 1].length];
                    for (int i = 0; i < ((byte[][])object).length; ++i) {
                        System.arraycopy(object[i], 0, byArray3, (UDP_PACKET_SIZE - 12) * i, object[i].length);
                    }
                    while (BroadcastConnector.this.recentSenders.size() >= 1024) {
                        Iterator iterator = BroadcastConnector.this.recentSenders.iterator();
                        iterator.next();
                        iterator.remove();
                    }
                    BroadcastConnector.this.recentSenders.add(n2);
                    this.incomingChunks.remove(n2);
                    NodeMessage nodeMessage = NodeMessage.decodeBytes(byArray3);
                    if (nodeMessage.getNodeList().contains(new Integer(BroadcastConnector.this.nodeID))) {
                        BroadcastConnector.this.msgReceived++;
                        return new NodeMessage[]{nodeMessage};
                    }
                }
            }
            return null;
        }
    }
}

