/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.common.util;

import com.edb.gridsql.common.util.XLevel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class XLogger
implements Serializable {
    private static final long serialVersionUID = -217487181061734376L;
    private String name = null;
    private transient Logger log;
    private static final Object ENTERING = "Entering method: ";
    private static final Object EXITING = "Exiting method: ";
    private static final Object RETURNING = "Returning value from method: ";
    private static final Object CATCHING = "Catching throwable: ";
    private static final Object THROWING = "Throwing throwable: ";

    private XLogger() {
    }

    private XLogger(String string) {
        this.name = string;
        this.log = Logger.getLogger((String)string);
    }

    public static XLogger getLogger(String string) {
        return new XLogger(string);
    }

    public static XLogger getLogger(Class clazz) {
        return XLogger.getLogger(clazz.getName());
    }

    public void supertrace(Object object) {
        this.log.log((Priority)XLevel.SUPERTRACE, object);
    }

    public void supertrace(Object object, Throwable throwable) {
        this.log.log((Priority)XLevel.SUPERTRACE, object, throwable);
    }

    public void trace(Object object) {
        this.log.log((Priority)XLevel.TRACE, object);
    }

    public void trace(Object object, Throwable throwable) {
        this.log.log((Priority)XLevel.TRACE, object, throwable);
    }

    public void debug(Object object) {
        this.log.log((Priority)Level.DEBUG, object);
    }

    public void debug(Object object, Throwable throwable) {
        this.log.log((Priority)Level.DEBUG, object, throwable);
    }

    public void info(Object object) {
        this.log.log((Priority)Level.INFO, object);
    }

    public void info(Object object, Throwable throwable) {
        this.log.log((Priority)Level.INFO, object, throwable);
    }

    public void warn(Object object) {
        this.log.log((Priority)Level.WARN, object);
    }

    public void warn(Object object, Throwable throwable) {
        this.log.log((Priority)Level.WARN, object, throwable);
    }

    public void error(Object object) {
        this.log.log((Priority)Level.ERROR, object);
    }

    public void error(Object object, Throwable throwable) {
        this.log.log((Priority)Level.ERROR, object, throwable);
    }

    public void fatal(Object object) {
        this.log.log((Priority)Level.FATAL, object);
    }

    public void fatal(Object object, Throwable throwable) {
        this.log.log((Priority)Level.FATAL, object, throwable);
    }

    public boolean isEnabledFor(Level level) {
        return this.log.isEnabledFor((Priority)level);
    }

    public boolean isSuperTraceEnabled() {
        return this.log.isEnabledFor((Priority)XLevel.SUPERTRACE);
    }

    public boolean isTraceEnabled() {
        return this.log.isEnabledFor((Priority)XLevel.TRACE);
    }

    public boolean isDebugEnabled() {
        return this.log.isEnabledFor((Priority)Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.log.isEnabledFor((Priority)Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.log.isEnabledFor((Priority)Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.log.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.log.isEnabledFor((Priority)Level.FATAL);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.log = Logger.getLogger((String)this.name);
    }

    public void entering(String string, Object[] objectArray) {
        if (this.isSuperTraceEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ENTERING).append(string).append("(");
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(objectArray[i]);
                }
            }
            stringBuffer.append(")");
            this.supertrace(stringBuffer);
        }
    }

    public void entering(String string) {
        this.entering(string, null);
    }

    public void exiting(String string, Object object) {
        if (this.isSuperTraceEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(RETURNING).append(object).append(";").append(string).append("()");
            this.supertrace(stringBuffer);
        }
    }

    public void exiting(String string) {
        if (this.isSuperTraceEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(EXITING).append(string).append("()");
            this.supertrace(stringBuffer);
        }
    }

    public void catching(Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.error(CATCHING, throwable);
        }
    }

    public void throwing(Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.error(THROWING, throwable);
        }
    }

    private String format(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "%");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken();
            if ("".equals(string2)) {
                stringBuffer.append("%");
            }
            try {
                int n = Integer.parseInt(string2);
                stringBuffer.append(objectArray[n]);
            }
            catch (Exception exception) {
                stringBuffer.append("%").append(string2).append("%");
            }
        }
        return stringBuffer.toString();
    }

    public void log(Level level, String string, Object[] objectArray) {
        if (this.log.isEnabledFor((Priority)level)) {
            if (objectArray == null) {
                this.log.log((Priority)level, (Object)string);
            } else {
                this.log.log((Priority)level, (Object)this.format(string, objectArray));
            }
        }
    }
}

