/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.common.util;

import com.edb.gridsql.engine.datatypes.XBlob;
import com.edb.gridsql.engine.datatypes.XClob;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;

public class SQLTypeConverter {
    public static Array getArray(Object object) throws SQLException {
        throw new SQLException("Data type is not supported");
    }

    public static InputStream getAsciiStream(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Clob) {
            return ((Clob)object).getAsciiStream();
        }
        return new XClob(object.toString()).getAsciiStream();
    }

    public static InputStream getBinaryStream(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Blob) {
            return ((Blob)object).getBinaryStream();
        }
        return new XBlob(SQLTypeConverter.getBytes(object)).getBinaryStream();
    }

    public static BigDecimal getBigDecimal(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Number) {
            return new BigDecimal(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? new BigDecimal(1) : new BigDecimal(0);
        }
        return new BigDecimal(object.toString().trim());
    }

    public static Blob getBlob(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Blob) {
            return (Blob)object;
        }
        return new XBlob(SQLTypeConverter.getBytes(object));
    }

    public static boolean getBoolean(Object object) throws SQLException {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue() != 0;
        }
        return Boolean.valueOf(object.toString().trim());
    }

    public static byte getByte(Object object) throws SQLException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? (byte)1 : 0;
        }
        return Byte.parseByte(object.toString().trim());
    }

    public static byte[] getBytes(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        String string = object.toString().trim();
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        byte[] byArray = new byte[string.length() / 2];
        try {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)Integer.parseInt(string.substring(2 * i, 2 * i + 2), 16);
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            return object.toString().trim().getBytes();
        }
    }

    public static Reader getCharacterStream(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        return new XClob(object.toString()).getCharacterStream();
    }

    public static Clob getClob(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Clob) {
            return (Clob)object;
        }
        return new XClob(object.toString());
    }

    public static Date getDate(Object object, Calendar calendar) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            return new Date(((java.util.Date)object).getTime());
        }
        if (object instanceof Number) {
            return new Date(((Number)object).longValue());
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return new Date(simpleDateFormat.parse(object.toString().trim()).getTime());
        }
        catch (Throwable throwable) {
            return new Date(Long.parseLong(object.toString().trim()));
        }
    }

    public static double getDouble(Object object) throws SQLException {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        return Double.parseDouble(object.toString().trim());
    }

    public static int getInt(Object object) throws SQLException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        return Integer.parseInt(object.toString().trim());
    }

    public static float getFloat(Object object) throws SQLException {
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0f : 0.0f;
        }
        return Float.parseFloat(object.toString().trim());
    }

    public static long getLong(Object object) throws SQLException {
        if (object == null) {
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        return Long.parseLong(object.toString().trim());
    }

    public static Object getObject(Object object, Map map) throws SQLException {
        return object;
    }

    public static Ref getRef(Object object) throws SQLException {
        throw new SQLException("Data type is not supported");
    }

    public static short getShort(Object object) throws SQLException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? (short)1 : 0;
        }
        return Short.parseShort(object.toString().trim());
    }

    public static String getString(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return SQLTypeConverter.getHexString((byte[])object);
        }
        return object.toString();
    }

    public static Time getTime(Object object, Calendar calendar) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            return new Time(((java.util.Date)object).getTime());
        }
        if (object instanceof Number) {
            return new Time(((Number)object).longValue());
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            return new Time(simpleDateFormat.parse(object.toString().trim()).getTime());
        }
        catch (Throwable throwable) {
            return new Time(Long.parseLong(object.toString().trim()));
        }
    }

    public static Timestamp getTimestamp(Object object, Calendar calendar) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        if (object instanceof Number) {
            return new Timestamp(((Number)object).longValue());
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return new Timestamp(simpleDateFormat.parse(object.toString().trim()).getTime());
        }
        catch (Throwable throwable) {
            return new Timestamp(Long.parseLong(object.toString().trim()));
        }
    }

    public static URL getURL(Object object) throws SQLException {
        throw new SQLException("Data type is not supported");
    }

    public static String getHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 4);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] >= 32 && byArray[i] < 128) {
                stringBuffer.append((char)byArray[i]);
                continue;
            }
            if (byArray[i] == 10) {
                stringBuffer.append("\\n");
                continue;
            }
            if (byArray[i] == 13) {
                stringBuffer.append("\\r");
                continue;
            }
            if (byArray[i] == 9) {
                stringBuffer.append("\\t");
                continue;
            }
            if (byArray[i] == 8) {
                stringBuffer.append("\\b");
                continue;
            }
            if (byArray[i] == 12) {
                stringBuffer.append("\\f");
                continue;
            }
            stringBuffer.append("\\x");
            int n = byArray[i] >> 4 & 0xF;
            stringBuffer.append(n < 10 ? (char)(48 + n) : (char)(97 + n - 10));
            int n2 = byArray[i] & 0xF;
            stringBuffer.append(n2 < 10 ? (char)(48 + n2) : (char)(97 + n2 - 10));
        }
        return stringBuffer.toString();
    }
}

