/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.common;

import com.edb.gridsql.common.ColumnMetaData;
import com.edb.gridsql.common.XDBResultSetMetaData;
import com.edb.gridsql.common.util.SQLErrorHandler;
import com.edb.gridsql.common.util.SQLTypeConverter;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.datatypes.XData;
import com.edb.gridsql.engine.io.ResultSetResponse;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetImpl
implements ResultSet {
    private static final XLogger logger = XLogger.getLogger(ResultSetImpl.class);
    protected ResultSetResponse responseMessage = null;
    protected ColumnMetaData[] columnMeta = null;
    private String[] columns;
    private List<XData[]> rows = null;
    private int totalRows = 0;
    private XData[] currentRow = new XData[0];
    private int currentRowIndex = -1;
    private boolean hasMoreRowsToFetch = false;
    private SQLWarning sqlWarning = null;
    private int concurrency = 1007;
    private int scrollType = 1003;
    private int fetchSize = 200;
    private int fetchDirection = 1000;
    private boolean wasLastValueNull = true;

    protected ResultSetImpl() {
        this.scrollType = 1003;
        this.fetchDirection = 1000;
    }

    public ResultSetImpl(ColumnMetaData[] columnMetaDataArray, List<XData[]> list) {
        this.setColumnMetaData(columnMetaDataArray);
        this.rows = list;
        this.totalRows = list != null ? list.size() : 0;
        this.hasMoreRowsToFetch = false;
    }

    public void setColumnMetaData(ColumnMetaData[] columnMetaDataArray) {
        this.columnMeta = columnMetaDataArray;
        this.columns = new String[columnMetaDataArray.length];
        for (int i = 0; i < columnMetaDataArray.length; ++i) {
            this.columns[i] = columnMetaDataArray[i].alias;
        }
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (this.scrollType == 1003) {
            throw SQLErrorHandler.getError(5004, "operation absolute() cannot be done with scroll type FORWARD ONLY");
        }
        if (n == 0) {
            throw SQLErrorHandler.getError(5004, "invalid index to move: " + n);
        }
        if (this.rows == null || this.rows.size() == 0) {
            return false;
        }
        if (Math.abs(n) > this.totalRows) {
            this.getAllPackets();
        }
        if (Math.abs(n) > this.totalRows) {
            throw SQLErrorHandler.getError(5004, "invalid index to move: " + n);
        }
        if (n < 0) {
            this.resetCurrentRow(this.totalRows + n - 1);
        } else {
            this.resetCurrentRow(n - 1);
        }
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.scrollType == 1003) {
            throw SQLErrorHandler.getError(5004, "operation afterLast() cannot be done with scroll type FORWARD ONLY");
        }
        if (this.rows == null || this.totalRows == 0) {
            return;
        }
        this.currentRowIndex = this.totalRows;
        this.currentRow = null;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.scrollType == 1003) {
            throw SQLErrorHandler.getError(5004, "operation beforeFirst() cannot be done with scroll type FORWARD ONLY");
        }
        if (this.rows == null || this.totalRows == 0) {
            return;
        }
        this.currentRowIndex = -1;
        this.currentRow = null;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public int findColumn(String string) throws SQLException {
        int n = -1;
        int n2 = this.columns.length;
        for (int i = 0; i < n2; ++i) {
            if (!string.equalsIgnoreCase(this.columns[i])) continue;
            n = i + 1;
        }
        if (n < 1) {
            throw SQLErrorHandler.getError(6000, "column name " + string + " not found in resultset");
        }
        return n;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.scrollType == 1003) {
            throw SQLErrorHandler.getError(5004, "operation not permitted with FORWARD_ONLY scroll type");
        }
        if (this.totalRows == 0) {
            return false;
        }
        this.resetCurrentRow(0);
        return true;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getArray(xData.getObject());
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw new SQLException("not supported yet");
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getAsciiStream(xData.getObject());
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getBigDecimal(xData.getObject());
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getBinaryStream(xData.getObject());
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getBlob(xData.getObject());
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? false : SQLTypeConverter.getBoolean(xData.getObject());
    }

    @Override
    public byte getByte(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? (byte)0 : SQLTypeConverter.getByte(xData.getObject());
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getBytes(xData.getObject());
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getCharacterStream(xData.getObject());
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getClob(xData.getObject());
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.getDate(n, Calendar.getInstance());
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string), Calendar.getInstance());
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getDate(xData.getObject(), calendar);
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public double getDouble(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? 0.0 : SQLTypeConverter.getDouble(xData.getObject());
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? 0.0f : SQLTypeConverter.getFloat(xData.getObject());
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public int getInt(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? 0 : SQLTypeConverter.getInt(xData.getObject());
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? 0L : SQLTypeConverter.getLong(xData.getObject());
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        XDBResultSetMetaData xDBResultSetMetaData = new XDBResultSetMetaData(this.columnMeta);
        return xDBResultSetMetaData;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public Object getObject(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : xData.getObject();
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("Method is not implemented");
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getRef(xData.getObject());
    }

    @Override
    public int getRow() throws SQLException {
        return this.currentRowIndex + 1;
    }

    @Override
    public short getShort(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? (short)0 : SQLTypeConverter.getShort(xData.getObject());
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public String getString(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getString(xData.getObject());
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.getTime(n, Calendar.getInstance());
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string), Calendar.getInstance());
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getTime(xData.getObject(), calendar);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string), Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getTimestamp(xData.getObject(), calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public int getType() throws SQLException {
        return this.scrollType;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new SQLException("getURL is not supported");
    }

    @Override
    public URL getURL(int n) throws SQLException {
        XData xData = this.currentRow[n - 1];
        this.wasLastValueNull = xData == null || xData.isValueNull();
        return this.wasLastValueNull ? null : SQLTypeConverter.getURL(xData.getObject());
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.getAsciiStream(n);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("todo - support?");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.currentRowIndex >= this.totalRows;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.currentRowIndex < 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.currentRowIndex == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.currentRowIndex + 1 == this.totalRows;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.scrollType == 1003) {
            throw new SQLException("operation not permitted with scroll type FORWARD ONLY");
        }
        this.getAllPackets();
        this.currentRowIndex = this.totalRows - 1;
        this.resetCurrentRow();
        return true;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("resultset is not updatable");
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rows == null || this.totalRows == 0) {
            return false;
        }
        if (this.currentRowIndex + 1 >= this.totalRows) {
            if (!this.hasMoreRowsToFetch) {
                return false;
            }
            int n = this.totalRows;
            this.setNextResultSet();
            this.resetRawRows();
            if (this.scrollType == 1003 && this.totalRows <= 0 || this.scrollType != 1003 && this.totalRows == n) {
                return false;
            }
        }
        ++this.currentRowIndex;
        this.resetCurrentRow();
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.scrollType == 1003) {
            throw new SQLException("operation not permitted with scroll type FORWARD ONLY", null, 5004);
        }
        if (this.currentRowIndex < 1) {
            throw new SQLException("already at the first row - cannot move cursor to previous row", null, 5004);
        }
        --this.currentRowIndex;
        this.resetCurrentRow();
        return true;
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (this.scrollType == 1003) {
            throw new SQLException("relative() not supported with scroll type FORWARD ONLY");
        }
        if (n == 0) {
            return true;
        }
        this.currentRowIndex += n;
        this.currentRowIndex = n > 0 ? (this.currentRowIndex >= this.totalRows ? this.totalRows - 1 : this.currentRowIndex) : (this.currentRowIndex < 0 ? 0 : this.currentRowIndex);
        this.resetCurrentRow();
        return true;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw new SQLException("fetch direction not supported", null, 5000);
        }
        this.fetchDirection = n;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n <= 0) {
            throw new SQLException("Fetch size must not be negative", null, 5004);
        }
        this.fetchSize = n;
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasLastValueNull;
    }

    private void resetCurrentRow(int n) throws SQLException {
        this.currentRowIndex = n;
        this.resetCurrentRow();
    }

    private void resetCurrentRow() throws SQLException {
        if (this.rows == null) {
            throw new SQLException("There are no rows to reset");
        }
        this.currentRow = this.rows.get(this.currentRowIndex);
        this.clearWarnings();
    }

    protected void resetRawRows() throws SQLException {
        try {
            this.responseMessage.resetRows();
            boolean bl = this.hasMoreRowsToFetch = !this.responseMessage.isLastPacket();
            if (this.scrollType == 1003) {
                this.rows = null;
                this.totalRows = 0;
                this.currentRowIndex = -1;
                this.rows = this.responseMessage.getRows();
                if (this.rows != null) {
                    this.totalRows = this.rows.size();
                }
            } else if (this.responseMessage.getRows() != null) {
                if (this.rows == null) {
                    this.rows = new ArrayList<XData[]>();
                }
                this.rows.addAll(this.responseMessage.getRows());
                this.totalRows = this.rows.size();
            }
        }
        catch (Throwable throwable) {
            throw new SQLException("Error reading next rows - " + throwable.getMessage());
        }
    }

    private void getAllPackets() throws SQLException {
        int n = 0;
        while (this.hasMoreRowsToFetch) {
            n = this.totalRows;
            this.resetRawRows();
            if (this.totalRows != n) continue;
            this.setNextResultSet();
        }
    }

    protected void setNextResultSet() throws SQLException {
        this.hasMoreRowsToFetch = false;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int n) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String string) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }
}

