
DROP TABLE IF EXISTS __prefix__hits;
CREATE TABLE __prefix__hits (
  hit_id int(11) unsigned NOT NULL auto_increment,
  ipaddr int(11) unsigned NOT NULL default '0',
  visitor_id int(11) unsigned NOT NULL default '0',
  page_id int(11) unsigned NOT NULL default '0',
  hitdate datetime NOT NULL default '0000-00-00 00:00:00',
  page_gen int(11) unsigned NOT NULL default '0',
  page_loaded tinyint(1) unsigned default '0',
  PRIMARY KEY  (hit_id),
  KEY visitor_id (visitor_id,page_id,hitdate,page_gen)
) TYPE=MyISAM;


DROP TABLE IF EXISTS __prefix__pages;
CREATE TABLE __prefix__pages (
  page_id int(11) unsigned NOT NULL auto_increment,
  ch_summ varchar(64) NOT NULL default '0',
  url varchar(255) NOT NULL default '',
  PRIMARY KEY  (page_id),
  KEY ch_summ (ch_summ)
) TYPE=MyISAM;

DROP TABLE IF EXISTS __prefix__searches;
CREATE TABLE __prefix__searches (
  hit_id int(11) unsigned NOT NULL default '0',
  searcher int(11) unsigned NOT NULL default '0',
  query varchar(255) NOT NULL default '0',
  PRIMARY KEY  (hit_id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS __prefix__visitors;
CREATE TABLE __prefix__visitors (
  visitor_id int(11) unsigned NOT NULL auto_increment,
  ch_summ varchar(64) NOT NULL default '0',
  PRIMARY KEY  (visitor_id),
  UNIQUE KEY ch_summ (ch_summ),
  KEY ch_summ_2 (ch_summ)
) TYPE=MyISAM;

DROP TABLE IF EXISTS __prefix__settings;
CREATE TABLE __prefix__settings (
  name varchar(32) NOT NULL default '',
  value varchar(255) default NULL,
  PRIMARY KEY  (name)
) TYPE=MyISAM;

