<?php

require_once('loader.php');

// Functions

function log_msg($msg)
{
	$f = fopen("log.txt", "a");
	fwrite($f, "[" . date("Y-m-d h:i:s") . "] " . $msg . "\n");
	fclose($f);
}

function ipaddr_long($ipaddr)
{
	return sprintf("%u", ip2long($ipaddr));
}

function query_insert($sql)
{
	global $db;
	if (!$db->query($sql)) 
	{
		die($db->getMessage() . " - $sql");
	}
	return mysql_insert_id();
}

function query_exist($id_field, $table_name, $where)
{
	global $db, $conf_db_pref;
	
	$sql = "SELECT $id_field FROM {$conf_db_pref}{$table_name} WHERE $where LIMIT 1";
	if (!$db->query($sql)) 
	{
		die($db->getMessage() . " - $sql");
	}
	
	return $db->queryResultRowField($id_field);
}

function insert_visitor($visitor_ch_summ)
{
	global $conf_db_pref;
	
	$visitor_id = query_exist('visitor_id', 'visitors', "ch_summ = '$visitor_ch_summ'");
	if ($visitor_id != null) return $visitor_id;
	
	$sql = "INSERT INTO {$conf_db_pref}visitors (visitor_id, ch_summ) VALUES (NULL, '$visitor_ch_summ')";
	return query_insert($sql);
}

function insert_page($page)
{
	global $conf_db_pref;
	
	$page_ch_summ = md5($page);//TODO: maybe crc32 ?
	
	$page_id = query_exist('page_id', 'pages', "ch_summ = '$page_ch_summ'");
	if ($page_id != null) return $page_id;
	
	$page = addslashes($page);
	$sql = "INSERT INTO {$conf_db_pref}pages (page_id, ch_summ, url) VALUES (NULL, '$page_ch_summ', '$page')";
	return query_insert($sql);
}

function insert_hit($ipaddr_long, $visitor_id, $page_id, $page_gen, $loaded = 0)
{
	global $conf_db_pref;
	
	$date = date("Y-m-d H:i:s");
	$sql = "INSERT INTO {$conf_db_pref}hits (hit_id, ipaddr, visitor_id, page_id, hitdate, page_gen, page_loaded) 
			VALUES (NULL, $ipaddr_long, $visitor_id, $page_id, '$date', $page_gen, $loaded)";
	return query_insert($sql);
}

function update_hit($page_gen)
{
	global $conf_db_pref, $db;
	$sql = "UPDATE {$conf_db_pref}hits SET page_loaded=1 WHERE page_gen=$page_gen";
	$db->query($sql);
}




// Main stuff ! //////////////////////////////////////////////////////////////////////

if (isset($_GET['sih'])) //Small Image Hit
{
	include_once('searches.php');

	$page 		= $_GET['p'];
	$referrer 	= $_GET['r'];
	$monitor 	= $_GET['m'];
	$page_gen 	= intval($_GET['g']);
	
	$user_agent = $_SERVER['HTTP_USER_AGENT'];
	$ipaddr 	= $_SERVER['REMOTE_ADDR'];
	$ipaddr_long= ipaddr_long($ipaddr);
	
	
	
	$visitor_ch_summ = md5($ipaddr . $user_agent . $monitor);
	
	$visitor_id = insert_visitor($visitor_ch_summ);//TODO: if failed - write error
	
	$page_id = insert_page($page);
	
	$hit_id = insert_hit($ipaddr_long, $visitor_id, $page_id, $page_gen);
	//log_msg("hit inserted " . $page_gen);
	
	process_referrer($referrer, $hit_id);
	
	//TODO: echo white image 1x1
}

elseif (isset($_GET['bih'])) //Big Image Hit
{
	include('stats.php');
	
	$page_gen 	= isset($_GET['g']) ? intval($_GET['g']) : 0;
	$page		= $_GET['p'];
	$date = date("Y-m-d");
	
	$common = get_common_stats($date);
	
	$I_ALL_HITS = $common['hits'];
	$I_ALL_HOSTS = $common['hosts'];
	$I_PAGE_HITS = get_page_hits($page, $date);
	$I_SKIN = isset($_GET['skin']) ? $_GET['skin'] : 1;
	
	sleep(1);//Garanty that small counter is loaded
	
	update_hit($page_gen);
	//log_msg("hit updated " . $page_gen);
	
	include('bigimage.php');
}





?>