#include <stdio.h>
#include "cngeoip.h"


#define DBFILE "../cngeoip.dat"

int main(int argc, char** argv) {
    int i, j;
    unsigned long ip;
    struct cngeoip4result res;
    struct cngeoip_result oldres;
    char info[CNGEOIP_MAX_INFO_LEN];

    if ( argc == 1 ) {
	printf("Usage: %s [ip] ...\n", argv[0]);
	return -1;
    }

    for ( i=1; i<argc; i++ ) {
	printf("Processing ip: %s...\n", argv[i]);
	if ( cngeoip_str2ip(argv[i], &res.ip) ) {
	    printf("Ip address format error!\n");
	    continue;
	}
        cngeoip4array(DBFILE, &res);
        if ( res.error ) {
            // Error, there is no infomation about IP
            printf("Error %i\n", res.error);
        }
        else if ( res.cnt ) {
            // It's an ordinary range
            printf("Result has %i parts:\n", res.cnt);
            for (j=0; j<res.cnt; j++) {
                printf("\t%c/%s/%s/%s/%f/%f/%s;\n",
                    res.places[j].type,
                    res.places[j].name_nat,
                    res.places[j].name_eng,
                    res.places[j].name_rus,
                    res.places[j].geo_lon,
                    res.places[j].geo_lat,
                    res.places[j].name_code);
            }
        }
        else {
            // It's a special range
            printf("Special range: (%s)\n", res.special);
        }
	
	oldres.ip = res.ip;
	cngeoip_lookup(DBFILE, &oldres);
	printf("Old style result: (%s/%s/%s/%1.4f/%1.4f/%s/%s/%s/%s)\n",
	   oldres.city_eng,
	   oldres.city_rus,
	   oldres.country_code,
	   oldres.geo_lon,
	   oldres.geo_lat,
	   oldres.country_eng,
	   oldres.country_rus,
	   oldres.region_eng,
	   oldres.region_rus);
	
	puts("");
    }
    
    return 0;
}
