;******************************************************************************
TITLE CONTROL - ControlDispatch for ALG VxD in C
;******************************************************************************
;

    .386p

;******************************************************************************
;                I N C L U D E S
;******************************************************************************

    .xlist
    include vmm.inc
    include debug.inc
    include configmg.inc
DOS_VXD equ 1       ; temporary until fixed in ifs.inc
MASM    equ 1       ; temporary until fixed in ifs.inc
    include ifs.inc
    include ifsmgr.inc
    include vpicd.inc
    include vsd.inc
    include vtd.inc
    include ios.inc
    include .\bin.w95\bc_name_.inc

    .list


;============================================================================
;        V I R T U A L   D E V I C E   D E C L A R A T I O N
;============================================================================


DECLARE_VIRTUAL_DEVICE %BC_NAME, 4, 0, BCALG_Control, UNDEFINED_DEVICE_ID, UNDEFINED_INIT_ORDER,,,


VXD_IDATA_SEG

VXD_IDATA_ENDS


VxD_LOCKED_DATA_SEG

VxD_LOCKED_DATA_ENDS

VxD_LOCKED_CODE_SEG


;===========================================================================
;
;   PROCEDURE: ALG_Control
;
;   DESCRIPTION:
;    Device control procedure for the ALG VxD
;
;   ENTRY:
;    EAX = Control call ID
;
;   EXIT:
;    If carry clear then
;        Successful
;    else
;        Control call failed
;
;   USES:
;    EAX, EBX, ECX, EDX, ESI, EDI, Flags
;
;============================================================================

BeginProc BCALG_Control
    Control_Dispatch SYS_DYNAMIC_DEVICE_INIT, BCALG_Dynamic_Init, sCall
    Control_Dispatch SYS_DYNAMIC_DEVICE_EXIT, BCALG_Dynamic_Exit, sCall
    Control_Dispatch W32_DEVICEIOCONTROL,     BCALG_W32_DeviceIOControl, sCall, <ecx, ebx, edx, esi>
    clc
    ret
EndProc BCALG_Control




VxD_LOCKED_CODE_ENDS


    END

