/*++

Copyright (c) 1998 Jetico, Inc.

 Module Name: BCalg.c

 Abstract:    This is the BC Alg driver for Windows 9x

 Author:      Igor M. Arsenin

 Environment: VxD

 Notes: --  Transfer to Win95 NT Model of BestCrypt Working


 Errors:

 Revision History:



 --*/









#define WANTVXDWRAPS

#include <basedef.h>
#include <vmm.h>
#include <debug.h>
#include <vxdwraps.h>
#include <vwin32.h>
#include <winerror.h>

#include "bcalg.h"
#include ".\bin.w95\bc_alg_.h"


#pragma VxD_LOCKED_DATA_SEG


typedef struct _KEY_ELEMENT
{
    UCHAR*        keyExtended;
    UCHAR*        pool;
    PAlgInstance  pAlgInstance;
} KEY_ELEMENT, *PKEY_ELEMENT;



#define TABLE_LENGTH 32

KEY_ELEMENT KeyTable[ TABLE_LENGTH ];


#pragma VxD_LOCKED_CODE_SEG

/****************************************************************************
                    Wrapers
****************************************************************************/


VOID BCALGStrcpyn(PCHAR pszDest,const char *pszSrc,DWORD cb)
{
    _lstrcpyn(pszDest,pszSrc,cb);
}



ULONG BCALGStrlen(const char *psz)
{
    return _lstrlen(psz);
}




void BCALGCopyMemory(PVOID pDst, const void *pSrc, DWORD cb)
{
    _lmemcpy(pDst, pSrc, cb);
}

void BCALGFillMemory(PVOID pDst, BYTE v,DWORD cb)
{
    _asm
    {
        cld
        mov     ecx,cb
        mov     edi,pDst
        mov     al,v
        rep stosb
    }
}


// Different Memory Pools used for Key and Handle Instances

void FreeBuff_I(PVOID buff)
{
    if (buff != NULL) {
        _HeapFree(buff,0);
    }
}



PVOID AllocBuff_I(ULONG Size)
{
    return (PVOID)_HeapAllocate(Size, HEAPZEROINIT);
}



void FreeBuff_K(PVOID buff)
{
    if (buff != NULL) {
        _PageFree(buff,0);
    }
}



PVOID AllocBuff_K(ULONG Size)
{
    ULONG BSize = (Size + P_SIZE - 1) & ~(P_SIZE - 1);
    return _PageAllocate(BSize / P_SIZE, PG_SYS , 0, 0, 0, 0, NULL, PAGEFIXED);
}







/****************************************************************************
                    User Call Procedures
****************************************************************************/



// Helper Procedures




BOOL BC_ExtendKey( PUCHAR KeyFrom, PUCHAR KeyTo )
{
  if ((!KeyFrom) || (!KeyTo)) return FALSE;

  return KeyExtend( KeyFrom, (PDWORD) KeyTo );
}


/***************************************************************************/

BOOL BC_TestKey( KEY_HANDLE KeyHandle )
{
    ULONG entry;
    for (entry = 0; entry < TABLE_LENGTH; entry++)
    {
        if ((KeyTable[entry].keyExtended  != NULL     )   &&
            (KeyTable[entry].pAlgInstance == KeyHandle)   &&
            (KeyHandle->entry             == entry    ))
        {
            return TRUE;
        }
    }
    return FALSE;
}


/***************************************************************************/

VOID
Transform_IV( DWORD *IVector, DWORD *Pool)
{
	DWORD i;
	i = (IVector[0] & 0x3f) << 1;
	IVector[0] ^= Pool[i];
	IVector[1] ^= Pool[i+1];
}



VOID Increment_IV( PUCHAR Syncro )
{
  PWORD   pdwSyncro;
  UINT    i;
  __int64 *pi64Syncro;

  pdwSyncro = (PWORD)Syncro;

  if ( (pdwSyncro[0] == pdwSyncro[1]) && // for compatibility with older versions of BestCrypt
       (pdwSyncro[1] == pdwSyncro[2]) && 
       (pdwSyncro[2] == pdwSyncro[3]) )
  {
     
     for( i=0; i<4; i++) (pdwSyncro[i])++;
  }
  else
  {
     pi64Syncro = (__int64 *)Syncro;
     (*pi64Syncro)++;
  }
}



VOID
Transform_Buf(	DWORD *Pool, 
                DWORD *InBuffer, 
                DWORD *OutBuffer, 
                DWORD Length )    // Length in DWORDs
{
	DWORD i;
	for ( i=0; i<Length; i++ ) OutBuffer[i] = InBuffer[i] ^ Pool[i];
}



/***************************************************************************/

BOOL __cdecl BC_Encrypt( KEY_HANDLE KeyHandle,
            PUCHAR     IVector,
            PUCHAR     InBuffer,
            PUCHAR     OutBuffer,
            DWORD      Length )       // in bytes
{
    UCHAR *keyExtended,*pool;
    DWORD length = Length;
    PWORD s;
    WORD  ivector[4], ivectorS[4];
    UINT  i, offset;

    if (Length == 0)
    {
        return TRUE;
    }

    if (!BC_TestKey( KeyHandle ))
    {
        return FALSE;
    }


    keyExtended = KeyTable[KeyHandle->entry].keyExtended;
    pool = KeyTable[KeyHandle->entry].pool;
    s = (PWORD)IVector;
    for( i=0; i<4; i++)
    {
        ivector[i] = ivectorS[i] = s[i];
    }

    for( offset = 0; ; offset += 512)
    {
        Transform_IV( (PDWORD)ivector, (PDWORD)pool );
        if (length > 512)
        {
            length = length - 512;
            Transform_Buf( (PDWORD)pool,
                           (PDWORD)(&(InBuffer[offset] )),
                           (PDWORD)(&(OutBuffer[offset])), 128  );
            Encrypt( (PDWORD)ivector, (PDWORD)keyExtended,
                                      (PDWORD)(&(OutBuffer[offset] )),
                                      (PDWORD)(&(OutBuffer[offset])), 512 );
        }
        else
        {   Transform_Buf( (PDWORD)pool,
                           (PDWORD)(&(InBuffer[offset] )),
                           (PDWORD)(&(OutBuffer[offset])), length >> 2 );
            Encrypt( (PDWORD)ivector, (PDWORD)keyExtended,
                                      (PDWORD)(&(OutBuffer[offset] )),
                                      (PDWORD)(&(OutBuffer[offset])), length );
            break;
        }
        // We need to update Initial Vector every 512 bytes
        Increment_IV( (PUCHAR)ivectorS );
        for( i=0; i<4; i++) ivector[i] = ivectorS[i]; 
    }
    return TRUE;
}


/***************************************************************************/

BOOL __cdecl BC_Decrypt( KEY_HANDLE KeyHandle,
            PUCHAR     IVector,
            PUCHAR     InBuffer,
            PUCHAR     OutBuffer,
            DWORD      Length )       // in bytes
{
    UCHAR *keyExtended, *pool;
    DWORD length = Length;
    PWORD s;
    WORD  ivector[4], ivectorS[4];
    UINT  i, offset;

    if (Length == 0)
    {
        return TRUE;
    }

    if (!BC_TestKey( KeyHandle ))
    {
        return FALSE;
    }

    keyExtended = KeyTable[KeyHandle->entry].keyExtended;
    pool        = KeyTable[KeyHandle->entry].pool;
    s = (PWORD)IVector;
    for( i=0; i<4; i++)
    {
        ivector[i] = ivectorS[i] = s[i];
    }

    for( offset = 0; ; offset += 512)
    {
	Transform_IV( (PDWORD)ivector, (PDWORD)pool );
        if (length > 512)
        {
            length = length - 512;
            Decrypt( (PDWORD)ivector, (PDWORD)keyExtended,
                                      (PDWORD)(&(InBuffer[offset] )),
                                      (PDWORD)(&(OutBuffer[offset])), 512 );
            Transform_Buf( (PDWORD)pool,
                           (PDWORD)(&(OutBuffer[offset] )),
                           (PDWORD)(&(OutBuffer[offset])), 128 );
        }
        else
        {
            Decrypt( (PDWORD)ivector, (PDWORD)keyExtended,
                                      (PDWORD)(&(InBuffer[offset] )),
                                      (PDWORD)(&(OutBuffer[offset])), length );
            Transform_Buf( (PDWORD)pool,
                           (PDWORD)(&(OutBuffer[offset] )),
                           (PDWORD)(&(OutBuffer[offset])), length >> 2 );
            break;
        }
        // We need to update Initial Vector every 512 bytes
        Increment_IV( (PUCHAR)ivectorS );
        for( i=0; i<4; i++) ivector[i] = ivectorS[i]; 
    }
    return TRUE;
}



/***************************************************************************/

BOOL __cdecl BC_FreeKey( KEY_HANDLE KeyHandle )
{
    ULONG entry;
    if (!BC_TestKey( KeyHandle ))
    {
        return FALSE;
    }
    entry = KeyHandle->entry;
    BCALGFillMemory(KeyTable[entry].pAlgInstance, 0, sizeof(AlgInstance));
    FreeBuff_I(KeyTable[entry].pAlgInstance);
    BCALGFillMemory(KeyTable[entry].keyExtended,  0, KEY_LENGTH_EXTENDED / 8);
    FreeBuff_K(KeyTable[entry].keyExtended);
    KeyTable[entry].keyExtended = NULL;
    BCALGFillMemory(KeyTable[entry].pool,         0, POOL_SIZE_BYTES);
    FreeBuff_K(KeyTable[entry].pool);
    KeyTable[entry].pool        = NULL;

    return TRUE;
}


/***************************************************************************/




// Private APIs




// IOCTL_PRIVATE_GET_VERSION_INFO:
void private_get_version_info(PVERSION_BUFFER pbuff)
{
    pbuff->Major_version = DRIVER_MAJOR_VERSION;
    pbuff->Minor_version = DRIVER_MINOR_VERSION;
}


// IOCTL_PRIVATE_GET_INFO:
void private_get_info(PINFO_BUFFER pbuff)
{
    BCALGStrcpyn(pbuff->DisplayName, DISPLAY_NAME, sizeof(pbuff->DisplayName));
    pbuff->AlgorithmID = ALGORITHM_ID;
    pbuff->KeyLength   = KEY_LENGTH;
}



// IOCTL_PRIVATE_CREATE_KEY_HANDLE:
void  private_create_key_handle(PCREATEKEY_BUFFER pbuff)
{
    ULONG        entry;
    PAlgInstance pAlgInstance = NULL;
    UCHAR        *keyExtended = NULL;
    UCHAR        *pool        = NULL;

    if ((pbuff->KeyLength) != KEY_LENGTH)
    {
        pbuff->Status = BCSTATUS_ERR_INVALID_KEY_LENGTH;
        goto errorExit;
    }

    // Allocate memory space for Key structure -- May Swap Pages and Shedule!
    keyExtended = (UCHAR *)AllocBuff_K(KEY_LENGTH_EXTENDED / 8);
    pool        = (UCHAR *)AllocBuff_K(POOL_SIZE_BYTES);
    pAlgInstance= (PAlgInstance)AllocBuff_I(sizeof(AlgInstance));

    if ((keyExtended == NULL) || (pool == NULL) || (pAlgInstance == NULL))
    {
        pbuff->Status = BCSTATUS_ERR_NOSYSTEM_RESOURCES;
        goto errorExit;
    }

    BCALGCopyMemory(pool, pbuff->Pool, POOL_SIZE_BYTES);

    // Define an empty element in Key Table
    for(entry = 0; entry < TABLE_LENGTH ; entry++)
    {
        if (KeyTable[entry].keyExtended == NULL) break;
    }

    if (entry == TABLE_LENGTH)
    {
        pbuff->Status = BCSTATUS_ERR_NOSYSTEM_RESOURCES;
        goto errorExit;
    }

     // Initialize Key structure
    KeyTable[entry].keyExtended = keyExtended;
    KeyTable[entry].pool        = pool;
    KeyTable[entry].pAlgInstance= pAlgInstance;

    pAlgInstance->fFreeKey  = BC_FreeKey;
    pAlgInstance->fEncrypt  = BC_Encrypt;
    pAlgInstance->fDecrypt  = BC_Decrypt;
    pAlgInstance->entry     = entry;

    BC_ExtendKey( pbuff->Key, keyExtended );
    pbuff->KeyHandle  = (PVOID)pAlgInstance;
    pbuff->Status     = BCSTATUS_SUCCESS;
    return;

errorExit:
    if (keyExtended != NULL)
    {
        FreeBuff_K(keyExtended);
    }
    if (pool != NULL)
    {
        FreeBuff_K(pool);
    }
    if (pAlgInstance != NULL)
    {
        FreeBuff_I(pAlgInstance);
    }
    pbuff->KeyHandle = NULL;
    return;
}



// IOCTL_PRIVATE_TEST_KEY_HANDLE:
void  private_test_key_handle(PTESTKEY_BUFFER pbuff)
{
    if (!BC_TestKey( pbuff->KeyHandle ))
    {
        pbuff->Status = BCSTATUS_ERR_NOSYSTEM_RESOURCES;
    }
}



// IOCTL_PRIVATE_FREE_KEY_HANDLE:
void  private_free_key_handle(PTESTKEY_BUFFER pbuff)
{
    if (!BC_FreeKey( pbuff->KeyHandle ))
    {
        pbuff->Status = BCSTATUS_ERR_NOSYSTEM_RESOURCES;
    }
}




// IOCTL_PRIVATE_ENCRYPT:
void  private_encrypt(PENCRYPT_BUFFER pbuff, PBYTE outputBuffer)
{
    if (!BC_Encrypt(pbuff->KeyHandle,
               pbuff->IVector,
               outputBuffer,
               outputBuffer,
               pbuff->Length ))
    {
        pbuff->Status = BCSTATUS_ERR_NOSYSTEM_RESOURCES;
    }
}



// IOCTL_PRIVATE_DECRYPT:
void  private_decrypt(PENCRYPT_BUFFER pbuff, PBYTE outputBuffer)
{
    if (!BC_Decrypt(pbuff->KeyHandle,
               pbuff->IVector,
               outputBuffer,
               outputBuffer,
               pbuff->Length ))
    {
        pbuff->Status = BCSTATUS_ERR_NOSYSTEM_RESOURCES;
    }
}

// IOCTL_PRIVATE_SUPPORTS_SYNCRO_64BITS
void private_support64bitIV( PSYNCRO64BITS_BUFFER pbuff )
{
    pbuff->SupportStatus = TRUE;
}



__int64 c64(PCHAR s)
{
    __int64 t64[2];
    BCALGStrcpyn((PCHAR)&t64,s,sizeof(t64));
    return t64[0];
}


BOOL ProcessPrivateCommands(ULONG dwService, PBUFFER_HEADER pbuff, ULONG buffsize,
                            PBYTE poutbuff)
{
    switch (dwService)
    {
        case IOCTL_PRIVATE_GET_VERSION_INFO:
        case IOCTL_PRIVATE_CREATE_KEY_HANDLE:
        case IOCTL_PRIVATE_TEST_KEY_HANDLE:
        case IOCTL_PRIVATE_FREE_KEY_HANDLE:
        case IOCTL_PRIVATE_ENCRYPT:
        case IOCTL_PRIVATE_DECRYPT:
        case IOCTL_PRIVATE_GET_INFO:
        case IOCTL_PRIVATE_SUPPORTS_SYNCRO_64BITS:
                  if (buffsize >= sizeof(BUFFER_HEADER))
                  {
                      if (pbuff->Signature ==  c64("LOCOS97 ")) // input: "LOCOS97",00
                      {
                          pbuff->Signature = c64("LS06CXX ");   // output: "LS06CXX",00
                          pbuff->Status    = BCSTATUS_SUCCESS;
                          break;
                      }
                  }
        default:  return FALSE;
    }

    switch (dwService)
    {
        case IOCTL_PRIVATE_GET_VERSION_INFO:
                  if (buffsize < sizeof(VERSION_BUFFER)) return FALSE;
                  private_get_version_info((PVERSION_BUFFER)pbuff);
                  break;
        case IOCTL_PRIVATE_GET_INFO:
                  if (buffsize < sizeof(INFO_BUFFER)) return FALSE;
                  private_get_info((PINFO_BUFFER)pbuff);
                  break;
        case IOCTL_PRIVATE_CREATE_KEY_HANDLE:
                  if (buffsize < sizeof(CREATEKEY_BUFFER)) return FALSE;
                  private_create_key_handle((PCREATEKEY_BUFFER)pbuff);
                  break;
        case IOCTL_PRIVATE_TEST_KEY_HANDLE:
                  if (buffsize < sizeof(TESTKEY_BUFFER)) return FALSE;
                  private_test_key_handle((PTESTKEY_BUFFER)pbuff);
                  break;
        case IOCTL_PRIVATE_FREE_KEY_HANDLE:
                  if (buffsize < sizeof(TESTKEY_BUFFER)) return FALSE;
                  private_free_key_handle((PTESTKEY_BUFFER)pbuff);
                  break;
        case IOCTL_PRIVATE_ENCRYPT:
                  if (buffsize < sizeof(ENCRYPT_BUFFER)) return FALSE;
                  private_encrypt((PENCRYPT_BUFFER)pbuff,poutbuff);
                  break;
        case IOCTL_PRIVATE_DECRYPT:
                  if (buffsize < sizeof(ENCRYPT_BUFFER)) return FALSE;
                  private_decrypt((PENCRYPT_BUFFER)pbuff,poutbuff);
                  break;
        case IOCTL_PRIVATE_SUPPORTS_SYNCRO_64BITS:
                  if (buffsize < sizeof(SYNCRO64BITS_BUFFER)) return FALSE;
                  private_support64bitIV((PSYNCRO64BITS_BUFFER)pbuff);
                  break;
    }
    return TRUE;
}



/****************************************************************************
                  BCALG_W32_DeviceIOControl
****************************************************************************/



typedef DIOCPARAMETERS  *LPDIOC;


ULONG _stdcall BCALG_W32_DeviceIOControl(ULONG  dwService,
                                        ULONG  dwDDB,
                                        ULONG  hDevice,
                                        LPDIOC lpDIOCParms)
{
    ULONG dwRetVal = 0;

    // DIOC_OPEN is sent when VxD is loaded w/ CreateFile
    //  (this happens just after SYS_DYNAMIC_INIT)

    if ( dwService == DIOC_OPEN )
    {
        // Must return 0 to tell WIN32 that this VxD supports DEVIOCTL
        dwRetVal = 0;
    }
    // DIOC_CLOSEHANDLE is sent when VxD is unloaded w/ CloseHandle
    //  (this happens just before SYS_DYNAMIC_EXIT)
    else if ( dwService == DIOC_CLOSEHANDLE )
    {
        // Nobody cares
        dwRetVal = 0;
    }
    else if (!ProcessPrivateCommands(dwService,
                          (PBUFFER_HEADER)(lpDIOCParms->lpvInBuffer),
                          lpDIOCParms->cbInBuffer,
                          (PBYTE)(lpDIOCParms->lpvOutBuffer)))
    {
        dwRetVal = ERROR_NOT_SUPPORTED;
    }
    return(dwRetVal);
}



ULONG _stdcall BCALG_Dynamic_Exit(void)
{
    return(VXD_SUCCESS);
}



/****************************************************************************
                  BCALG Init Code & Data
****************************************************************************/



#pragma VxD_IDATA_SEG

#define DISPLAY_NAME_LENGTH 32
#define SERVICE_NAME_LENGTH 32
#define EYE_CATCH_STRING    "__BCALGDRV__"
#define EYE_CATCH_STRING_1  "__BCB_SIZE__"

typedef struct _BC_ALGID_BLOCK
  { char  eyeCatchString[16];
    DWORD algorithmID;
    DWORD keyLength;
    char  displayName[ DISPLAY_NAME_LENGTH ];
    char  serviceName[ SERVICE_NAME_LENGTH ];
    char  eyeCatchString_1[16];
    DWORD structSize;
    DWORD blockSize;
  } BC_ALGID_BLOCK, *PBC_ALGID_BLOCK;



BC_ALGID_BLOCK sig = { EYE_CATCH_STRING, ALGORITHM_ID, KEY_LENGTH, DISPLAY_NAME, SERVICE_NAME, EYE_CATCH_STRING_1, sizeof(BC_ALGID_BLOCK), ALGORITHM_BLOCK_SIZE_BYTES };

#pragma VxD_ICODE_SEG


ULONG _stdcall BCALG_Dynamic_Init(void)
{
    _asm clc;
    return(VXD_SUCCESS);
}

