//
//  bc_ioctl.h - Control Codes for interface between 
//  the BestCrypt Control Panel and low-level drivers
//

#ifndef __BCIOCTL
#define __BCIOCTL

#include <windef.h> 

#define UNUSED_ALGORITHM_ID 0xff

/* MAX_KEY_LENGTH value in bites */
#define MAX_KEY_LENGTH      512

/* Pool of random bytes */
#define POOL_SIZE_BYTES		512

/* Must be uncommented if the bc_ioctl.h is included in Windows application

#define FILE_DEVICE_DISK   0x00000007
#define IOCTL_DISK_BASE    FILE_DEVICE_DISK
#define METHOD_BUFFERED    0
#define METHOD_IN_DIRECT   1
#define FILE_ANY_ACCESS    0

#define CTL_CODE( DeviceType, Function, Method, Access ) (                 \
    ((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) \
)
*/

//#define STATUS_SUCCESS    0

typedef DWORD KEY_HANDLE;
 
typedef struct _BUFFER_HEADER { char   Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                UCHAR   Status;
                              } BUFFER_HEADER, *PBUFFER_HEADER;

/*******************************************************************************
***************** IOCTLs for BestCrypt Disk Driver Service *********************
********************************************************************************/

// Get version command & structure definition

#define IOCTL_PRIVATE_GET_VERSION_INFO \
              CTL_CODE(IOCTL_DISK_BASE, 0x800, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


typedef struct  _VERSION_BUFFER { char   Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                  UCHAR   Status;
                                  UCHAR   Major_version;
                                  UCHAR   Minor_version;
                                  } VERSION_BUFFER, *PVERSION_BUFFER;

//
//  Control codes for the "program -> driver" interface
//
//  This control codes are private for this driver, hence, 
//  functions number must be >= 0x800
//
//  Functions numbers for Disk Driver      are 0x800 - 0x80F
//  


// Get Logical Disk Mask command & structure definition

#define IOCTL_PRIVATE_GET_BCDISK_MASK \
              CTL_CODE(IOCTL_DISK_BASE, 0x801, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


typedef struct  _GETMASK_BUFFER { char   Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                  UCHAR  Status;
                                  DWORD  Mask;
                                } GETMASK_BUFFER, *PGETMASK_BUFFER;


// Get Logical Disk Mask command & structure definition

#define IOCTL_PRIVATE_GET_BCDISK_INFO \
              CTL_CODE(IOCTL_DISK_BASE, 0x802, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


typedef struct  _DISKINFO_BUFFER { char   Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                   UCHAR  Status;
                                   char   filename[256];
                                   DWORD  diskNumber;
                                   DWORD  diskSizeLow;
                                   DWORD  diskSizeHigh;
                                   DWORD  keyHandle;
                                   char   algDevice[128];
                                   DWORD  algorithmID;
                                   DWORD  readOnly;
                                   HANDLE process;
                                   HANDLE thread;
                                   DWORD  sectorSize;
                                   BOOL   fullDismounted;
                                   DWORD  dataOffset;     //in bytes
                                 } DISKINFO_BUFFER, *PDISKINFO_BUFFER;


// Map Logical Disk command definition

#define IOCTL_PRIVATE_MAP_BCDISK \
              CTL_CODE(IOCTL_DISK_BASE, 0x803, METHOD_IN_DIRECT, FILE_ANY_ACCESS)

// Disconnect BestCrypt Disk command & structure definition

#define IOCTL_PRIVATE_DISCONNECT_BCDISK \
              CTL_CODE(IOCTL_DISK_BASE, 0x804, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


typedef struct  _DISCONNECT_BUFFER { char   Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                     UCHAR  Status;
                                     DWORD  DiskNumber;
                                     BOOL   FullDismounted;
                                     } DISCONNECT_BUFFER, *PDISCONNECT_BUFFER;


// Get Logical Disk Mask command & structure definition

#define IOCTL_PRIVATE_DISCONNECT_ALL \
              CTL_CODE(IOCTL_DISK_BASE, 0x805, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


// Create or delete Symbolic Link for initialized Device Object

#define IOCTL_PRIVATE_CHANGE_SYMBOLIC_LINK \
              CTL_CODE(IOCTL_DISK_BASE, 0x807, METHOD_IN_DIRECT, FILE_ANY_ACCESS)

typedef struct  _CHANGELINK_BUFFER { char   Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                     UCHAR  Status;
                                     DWORD  DiskNumber;
                                     BOOL   DeleteLink;
                                     } CHANGELINK_BUFFER, *PCHANGELINK_BUFFER;

// Remove or restore NT security descriptor for the BestCrypt virtual 
// disk to allow the BestCrypt Control Panel flush system cache if 
// user has no an administrator priveleges

#define IOCTL_PRIVATE_CHANGE_NT_SECURITY \
              CTL_CODE(IOCTL_DISK_BASE, 0x808, METHOD_IN_DIRECT, FILE_ANY_ACCESS)

typedef struct  _CHANGESEC_BUFFER { char   Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                    UCHAR  Status;
                                    DWORD  DiskNumber;
                                    BOOL   RemoveSecurity;
                                    } CHANGESEC_BUFFER, *PCHANGESEC_BUFFER;



//
//  Control codes for the "program -> algorithm driver" interface
//
//  This control codes are private for this driver, hence, 
//  functions number must be >= 0x800
//
//  Functions numbers for Algorithm Driver are 0x810 - 0x8FF
//  

// Expand key, save it, and return a handle for the given key

#define IOCTL_PRIVATE_CREATE_KEY_HANDLE \
              CTL_CODE(IOCTL_DISK_BASE, 0x810, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


typedef struct  _CREATEKEY_BUFFER { char        Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                    UCHAR       Status;
                                    DWORD       KeyLength;
                                    KEY_HANDLE  KeyHandle;
                                    UCHAR       Key[MAX_KEY_LENGTH / 8];
                                    UCHAR       Pool[POOL_SIZE_BYTES];
                                  } CREATEKEY_BUFFER, *PCREATEKEY_BUFFER;


// Test if the key for the given key handle exists

#define IOCTL_PRIVATE_TEST_KEY_HANDLE \
              CTL_CODE(IOCTL_DISK_BASE, 0x811, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


typedef struct  _TESTKEY_BUFFER { char        Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                  UCHAR       Status;
                                  UCHAR       IsValid;
                                  KEY_HANDLE  KeyHandle;
                                  } TESTKEY_BUFFER, *PTESTKEY_BUFFER;


// Free Key Handle command: uses a TESTKEY_BUFFER structure definition

#define IOCTL_PRIVATE_FREE_KEY_HANDLE \
              CTL_CODE(IOCTL_DISK_BASE, 0x812, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


// Encrypt command & structure definition

#define IOCTL_PRIVATE_ENCRYPT \
              CTL_CODE(IOCTL_DISK_BASE, 0x814, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


// Buffer for data is in the Output buffer of DeviceIoControl request

typedef struct  _ENCRYPT_BUFFER { char        Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                  UCHAR       Status;
                                  KEY_HANDLE  KeyHandle;
                                  UCHAR       IVector[8];
                                  DWORD       Length;       // in bytes
                                  } ENCRYPT_BUFFER, *PENCRYPT_BUFFER;

// Decrypt command definition

#define IOCTL_PRIVATE_DECRYPT \
              CTL_CODE(IOCTL_DISK_BASE, 0x815, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


// Get function address from Algorithm Driver
#define IOCTL_PRIVATE_GETFUNCTIONS \
              CTL_CODE(IOCTL_DISK_BASE, 0x816, METHOD_IN_DIRECT, FILE_ANY_ACCESS)

typedef struct  _GETFUNC_BUFFER { char        Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                  UCHAR       Status;
                                  PVOID       FuncTestKey;
                                  PVOID       FuncFreeKey;
                                  PVOID       FuncEncrypt;
                                  PVOID       FuncDecrypt;
                                  } GETFUNC_BUFFER, *PGETFUNC_BUFFER;


// Get version command & structure definition

#define IOCTL_PRIVATE_GET_INFO \
              CTL_CODE(IOCTL_DISK_BASE, 0x817, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


typedef struct  _INFO_BUFFER { char   Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                               UCHAR  Status;
                               UCHAR  DisplayName[32];
                               DWORD  AlgorithmID;
                               DWORD  KeyLength;
} INFO_BUFFER, *PINFO_BUFFER;



// Get information about keyboard + mouse + disk activity
#define IOCTL_PRIVATE_GET_AND_RESET_FLAG \
              CTL_CODE(IOCTL_DISK_BASE, 0x855, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


typedef struct  _FLAG_BUFFER { char  Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                               UCHAR Status;
                               DWORD Flag;
                             } FLAG_BUFFER, *PFLAG_BUFFER;


// Set or Reset Container's Guard utility hooks

#define IOCTL_FSH_REFRESH_HOOK \
              CTL_CODE(IOCTL_DISK_BASE, 0x820, METHOD_IN_DIRECT, FILE_ANY_ACCESS)

typedef struct { char    Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                 UCHAR   Status;
                 ULONG   HookMask;
               } REFRESH_BUFFER, *PREFRESH_BUFFER;



#endif

