/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdesktop.swingx.Searchable;

public abstract class AbstractSearchable
implements Searchable {
    public static final SearchResult NO_MATCH = new SearchResult();
    protected SearchResult lastSearchResult = new SearchResult();
    public static final String MATCH_HIGHLIGHTER = "match.highlighter";

    public int search(String searchString) {
        return this.search(searchString, -1);
    }

    public int search(String searchString, int startIndex) {
        return this.search(searchString, startIndex, false);
    }

    public int search(String searchString, int startIndex, boolean backward) {
        Pattern pattern = null;
        if (!this.isEmpty(searchString)) {
            pattern = Pattern.compile(searchString, 0);
        }
        return this.search(pattern, startIndex, backward);
    }

    public int search(Pattern pattern) {
        return this.search(pattern, -1);
    }

    public int search(Pattern pattern, int startIndex) {
        return this.search(pattern, startIndex, false);
    }

    public int search(Pattern pattern, int startIndex, boolean backwards) {
        int matchingRow = this.doSearch(pattern, startIndex, backwards);
        this.moveMatchMarker();
        return matchingRow;
    }

    protected int doSearch(Pattern pattern, int startIndex, boolean backwards) {
        int startRow;
        if (this.isTrivialNoMatch(pattern, startIndex)) {
            this.updateState(null);
            return this.lastSearchResult.foundRow;
        }
        if (this.isEqualStartIndex(startIndex)) {
            SearchResult searchResult;
            if (!this.isEqualPattern(pattern) && (searchResult = this.findExtendedMatch(pattern, startIndex)) != null) {
                this.updateState(searchResult);
                return this.lastSearchResult.foundRow;
            }
            startRow = this.moveStartPosition(startIndex, backwards);
        } else {
            startRow = this.adjustStartPosition(startIndex, backwards);
        }
        this.findMatchAndUpdateState(pattern, startRow, backwards);
        return this.lastSearchResult.foundRow;
    }

    protected abstract void findMatchAndUpdateState(Pattern var1, int var2, boolean var3);

    protected boolean isTrivialNoMatch(Pattern pattern, int startIndex) {
        return pattern == null || startIndex >= this.getSize();
    }

    protected int adjustStartPosition(int startIndex, boolean backwards) {
        if (startIndex < 0) {
            if (backwards) {
                return this.getSize() - 1;
            }
            return 0;
        }
        return startIndex;
    }

    protected int moveStartPosition(int startIndex, boolean backwards) {
        startIndex = backwards ? --startIndex : ++startIndex;
        return startIndex;
    }

    protected boolean isEqualPattern(Pattern pattern) {
        return pattern.pattern().equals(this.lastSearchResult.getRegEx());
    }

    protected boolean isEqualStartIndex(int startIndex) {
        return this.isValidIndex(startIndex) && startIndex == this.lastSearchResult.foundRow;
    }

    protected boolean isEmpty(String searchString) {
        return searchString == null || searchString.length() == 0;
    }

    protected abstract SearchResult findExtendedMatch(Pattern var1, int var2);

    protected SearchResult createSearchResult(Matcher matcher, int row, int column) {
        return new SearchResult(matcher.pattern(), matcher.toMatchResult(), row, column);
    }

    protected boolean isValidIndex(int index) {
        return index >= 0 && index < this.getSize();
    }

    protected abstract int getSize();

    protected void updateState(SearchResult searchResult) {
        this.lastSearchResult.updateFrom(searchResult);
    }

    protected abstract void moveMatchMarker();

    public static class SearchResult {
        int foundRow;
        int foundColumn;
        MatchResult matchResult;
        Pattern pattern;

        public SearchResult() {
            this.reset();
        }

        public SearchResult(Pattern ex, MatchResult result, int row, int column) {
            this.pattern = ex;
            this.matchResult = result;
            this.foundRow = row;
            this.foundColumn = column;
        }

        public void updateFrom(SearchResult searchResult) {
            if (searchResult == null) {
                this.reset();
                return;
            }
            this.foundRow = searchResult.foundRow;
            this.foundColumn = searchResult.foundColumn;
            this.matchResult = searchResult.matchResult;
            this.pattern = searchResult.pattern;
        }

        public String getRegEx() {
            return this.pattern != null ? this.pattern.pattern() : null;
        }

        public void reset() {
            this.foundRow = -1;
            this.foundColumn = -1;
            this.matchResult = null;
            this.pattern = null;
        }

        public int getFoundColumn() {
            return this.foundColumn;
        }

        public int getFoundRow() {
            return this.foundRow;
        }

        public MatchResult getMatchResult() {
            return this.matchResult;
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

