/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mspdi.MSPDIReader;

public class MpxjQuery {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("Usage: MpxQuery <input file name>");
            } else {
                MpxjQuery.query(args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private static void query(String filename) throws Exception {
        ProjectFile mpx = null;
        try {
            mpx = new MPXReader().read(filename);
        }
        catch (Exception ex) {
            mpx = null;
        }
        if (mpx == null) {
            try {
                mpx = new MPPReader().read(filename);
            }
            catch (Exception ex) {
                mpx = null;
            }
        }
        if (mpx == null) {
            try {
                mpx = new MSPDIReader().read(filename);
            }
            catch (Exception ex) {
                mpx = null;
            }
        }
        if (mpx == null) {
            throw new Exception("Failed to read file");
        }
        MpxjQuery.listProjectHeader(mpx);
        MpxjQuery.listResources(mpx);
        MpxjQuery.listTasks(mpx);
        MpxjQuery.listAssignments(mpx);
        MpxjQuery.listAssignmentsByTask(mpx);
        MpxjQuery.listAssignmentsByResource(mpx);
        MpxjQuery.listHierarchy(mpx);
        MpxjQuery.listTaskNotes(mpx);
        MpxjQuery.listResourceNotes(mpx);
        MpxjQuery.listPredecessors(mpx);
        MpxjQuery.listSlack(mpx);
        MpxjQuery.listCalendars(mpx);
    }

    private static void listProjectHeader(ProjectFile file) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm z");
        ProjectHeader header = file.getProjectHeader();
        Date startDate = header.getStartDate();
        Date finishDate = header.getFinishDate();
        String formattedStartDate = startDate == null ? "(none)" : df.format(startDate);
        String formattedFinishDate = finishDate == null ? "(none)" : df.format(finishDate);
        System.out.println("Project Header: StartDate=" + formattedStartDate + " FinishDate=" + formattedFinishDate);
        System.out.println();
    }

    private static void listResources(ProjectFile file) {
        for (Resource resource : file.getAllResources()) {
            System.out.println("Resource: " + resource.getName() + " (Unique ID=" + resource.getUniqueID() + ") Start=" + resource.getStart() + " Finish=" + resource.getFinish());
        }
        System.out.println();
    }

    private static void listTasks(ProjectFile file) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm z");
        for (Task task : file.getAllTasks()) {
            Date date = task.getStart();
            String startDate = date != null ? df.format(date) : "(no date supplied)";
            date = task.getFinish();
            String finishDate = date != null ? df.format(date) : "(no date supplied)";
            Duration dur = task.getDuration();
            String duration = dur != null ? dur.toString() : "(no duration supplied)";
            System.out.println("Task: " + task.getName() + " ID=" + task.getID() + " Unique ID=" + task.getUniqueID() + " (Start Date=" + startDate + " Finish Date=" + finishDate + " Duration=" + duration + " Outline Level=" + task.getOutlineLevel() + " Outline Number=" + task.getOutlineNumber() + ")");
        }
        System.out.println();
    }

    private static void listHierarchy(ProjectFile file) {
        for (Task task : file.getChildTasks()) {
            System.out.println("Task: " + task.getName());
            MpxjQuery.listHierarchy(task, " ");
        }
        System.out.println();
    }

    private static void listHierarchy(Task task, String indent) {
        for (Task child : task.getChildTasks()) {
            System.out.println(indent + "Task: " + child.getName());
            MpxjQuery.listHierarchy(child, indent + " ");
        }
    }

    private static void listAssignments(ProjectFile file) {
        for (ResourceAssignment assignment : file.getAllResourceAssignments()) {
            Task task = assignment.getTask();
            String taskName = task == null ? "(null task)" : task.getName();
            Resource resource = assignment.getResource();
            String resourceName = resource == null ? "(null resource)" : resource.getName();
            System.out.println("Assignment: Task=" + taskName + " Resource=" + resourceName);
        }
        System.out.println();
    }

    private static void listAssignmentsByTask(ProjectFile file) {
        for (Task task : file.getAllTasks()) {
            System.out.println("Assignments for task " + task.getName() + ":");
            for (ResourceAssignment assignment : task.getResourceAssignments()) {
                Resource resource = assignment.getResource();
                String resourceName = resource == null ? "(null resource)" : resource.getName();
                System.out.println("   " + resourceName);
            }
        }
        System.out.println();
    }

    private static void listAssignmentsByResource(ProjectFile file) {
        for (Resource resource : file.getAllResources()) {
            System.out.println("Assignments for resource " + resource.getName() + ":");
            for (ResourceAssignment assignment : resource.getTaskAssignments()) {
                Task task = assignment.getTask();
                System.out.println("   " + task.getName());
            }
        }
        System.out.println();
    }

    private static void listTaskNotes(ProjectFile file) {
        for (Task task : file.getAllTasks()) {
            String notes = task.getNotes();
            if (notes == null || notes.length() == 0) continue;
            System.out.println("Notes for " + task.getName() + ": " + notes);
        }
        System.out.println();
    }

    private static void listResourceNotes(ProjectFile file) {
        for (Resource resource : file.getAllResources()) {
            String notes = resource.getNotes();
            if (notes == null || notes.length() == 0) continue;
            System.out.println("Notes for " + resource.getName() + ": " + notes);
        }
        System.out.println();
    }

    private static void listPredecessors(ProjectFile file) {
        for (Task task : file.getAllTasks()) {
            List<Relation> predecessors = task.getPredecessors();
            if (predecessors == null || predecessors.isEmpty()) continue;
            System.out.println(task.getName() + " predecessors:");
            for (Relation relation : predecessors) {
                System.out.println("   Task: " + file.getTaskByUniqueID(relation.getTaskUniqueID()).getName());
                System.out.println("   Type: " + relation.getType());
                System.out.println("   Lag: " + relation.getDuration());
            }
        }
    }

    private static void listSlack(ProjectFile file) {
        for (Task task : file.getAllTasks()) {
            System.out.println(task.getName() + " Total Slack=" + task.getTotalSlack() + " Start Slack=" + task.getStartSlack() + " Finish Slack=" + task.getFinishSlack());
        }
    }

    private static void listCalendars(ProjectFile file) {
        for (ProjectCalendar cal : file.getBaseCalendars()) {
            System.out.println(cal.toString());
        }
        for (ProjectCalendar cal : file.getResourceCalendars()) {
            System.out.println(cal.toString());
        }
    }
}

