/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.EnumSet;
import java.util.Iterator;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TimeUnit implements MpxjEnum
{
    MINUTES(0, "m"),
    HOURS(1, "h"),
    DAYS(2, "d"),
    WEEKS(3, "w"),
    MONTHS(4, "mo"),
    YEARS(5, "y"),
    PERCENT(6, "%"),
    ELAPSED_MINUTES(7, "em"),
    ELAPSED_HOURS(8, "eh"),
    ELAPSED_DAYS(9, "ed"),
    ELAPSED_WEEKS(10, "ew"),
    ELAPSED_MONTHS(11, "emo"),
    ELAPSED_YEARS(12, "ey"),
    ELAPSED_PERCENT(13, "e%");

    private static final TimeUnit[] TYPE_VALUES;
    private int m_value;
    private String m_name;

    private TimeUnit(int type, String name) {
        this.m_value = type;
        this.m_name = name;
    }

    public static TimeUnit getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = DAYS.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static TimeUnit getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return TimeUnit.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    static {
        TYPE_VALUES = new TimeUnit[14];
        Iterator i$ = EnumSet.range(MINUTES, ELAPSED_PERCENT).iterator();
        while (i$.hasNext()) {
            TimeUnit e;
            TimeUnit.TYPE_VALUES[e.getValue()] = e = (TimeUnit)i$.next();
        }
    }
}

