/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.EnumSet;
import java.util.Iterator;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TestOperator implements MpxjEnum
{
    IS_ANY_VALUE(0){

        public boolean evaluate(Object lhs, Object rhs) {
            return true;
        }
    }
    ,
    IS_WITHIN(1){

        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateWithin(lhs, rhs);
        }
    }
    ,
    IS_GREATER_THAN(2){

        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateCompareTo(lhs, rhs) > 0;
        }
    }
    ,
    IS_LESS_THAN(3){

        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateCompareTo(lhs, rhs) < 0;
        }
    }
    ,
    IS_GREATER_THAN_OR_EQUAL_TO(4){

        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateCompareTo(lhs, rhs) >= 0;
        }
    }
    ,
    IS_LESS_THAN_OR_EQUAL_TO(5){

        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateCompareTo(lhs, rhs) <= 0;
        }
    }
    ,
    EQUALS(6){

        public boolean evaluate(Object lhs, Object rhs) {
            boolean result = lhs == null ? lhs == this.getSingleOperand(rhs) : lhs.equals(this.getSingleOperand(rhs));
            return result;
        }
    }
    ,
    DOES_NOT_EQUAL(7){

        public boolean evaluate(Object lhs, Object rhs) {
            boolean result = lhs == null ? lhs != this.getSingleOperand(rhs) : !lhs.equals(this.getSingleOperand(rhs));
            return result;
        }
    }
    ,
    CONTAINS(8){

        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateContains(lhs, rhs);
        }
    }
    ,
    IS_NOT_WITHIN(9){

        public boolean evaluate(Object lhs, Object rhs) {
            return !this.evaluateWithin(lhs, rhs);
        }
    }
    ,
    DOES_NOT_CONTAIN(10){

        public boolean evaluate(Object lhs, Object rhs) {
            return !this.evaluateContains(lhs, rhs);
        }
    }
    ,
    CONTAINS_EXACTLY(11){

        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateContainsExactly(lhs, rhs);
        }
    };

    private static final TestOperator[] TYPE_VALUES;
    private int m_value;

    private TestOperator(int type) {
        this.m_value = type;
    }

    public static TestOperator getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = IS_ANY_VALUE.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static TestOperator getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return TestOperator.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public abstract boolean evaluate(Object var1, Object var2);

    protected Object getSingleOperand(Object operand) {
        if (operand instanceof Object[]) {
            Object[] list = (Object[])operand;
            operand = list[0];
        }
        return operand;
    }

    protected boolean evaluateWithin(Object lhs, Object rhs) {
        boolean result = false;
        if (lhs != null && rhs instanceof Object[]) {
            Comparable lhsComparable = (Comparable)lhs;
            Object[] rhsList = (Object[])rhs;
            if (rhsList[0] != null && rhsList[1] != null) {
                result = lhsComparable.compareTo(rhsList[0]) >= 0 && lhsComparable.compareTo(rhsList[1]) <= 0;
            }
        }
        return result;
    }

    protected int evaluateCompareTo(Object lhs, Object rhs) {
        rhs = this.getSingleOperand(rhs);
        int result = lhs == null || rhs == null ? (lhs == rhs ? 0 : (lhs == null ? 1 : -1)) : ((Comparable)lhs).compareTo(rhs);
        return result;
    }

    protected boolean evaluateContains(Object lhs, Object rhs) {
        boolean result = false;
        rhs = this.getSingleOperand(rhs);
        if (lhs instanceof String && rhs instanceof String) {
            result = ((String)lhs).toUpperCase().indexOf(((String)rhs).toUpperCase()) != -1;
        }
        return result;
    }

    protected boolean evaluateContainsExactly(Object lhs, Object rhs) {
        boolean result = false;
        rhs = this.getSingleOperand(rhs);
        if (lhs instanceof String && rhs instanceof String) {
            result = ((String)lhs).indexOf((String)rhs) != -1;
        }
        return result;
    }

    static {
        TYPE_VALUES = new TestOperator[12];
        Iterator i$ = EnumSet.range(IS_ANY_VALUE, CONTAINS_EXACTLY).iterator();
        while (i$.hasNext()) {
            TestOperator e;
            TestOperator.TYPE_VALUES[e.getValue()] = e = (TestOperator)i$.next();
        }
    }
}

