/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.EnumSet;
import java.util.Iterator;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProjectTimeFormat implements MpxjEnum
{
    TWELVE_HOUR(0),
    TWENTY_FOUR_HOUR(1);

    private static final ProjectTimeFormat[] TYPE_VALUES;
    private int m_value;

    private ProjectTimeFormat(int type) {
        this.m_value = type;
    }

    public static ProjectTimeFormat getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = TWELVE_HOUR.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static ProjectTimeFormat getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return ProjectTimeFormat.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String toString() {
        return Integer.toString(this.m_value);
    }

    static {
        TYPE_VALUES = new ProjectTimeFormat[2];
        Iterator i$ = EnumSet.range(TWELVE_HOUR, TWENTY_FOUR_HOUR).iterator();
        while (i$.hasNext()) {
            ProjectTimeFormat e;
            ProjectTimeFormat.TYPE_VALUES[e.getValue()] = e = (ProjectTimeFormat)i$.next();
        }
    }
}

