/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Iterator;
import java.util.LinkedList;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.ProjectCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectCalendarHours
implements Iterable<DateRange> {
    private ProjectCalendar m_parentCalendar;
    private Day m_day;
    private LinkedList<DateRange> m_dateRanges = new LinkedList();

    ProjectCalendarHours(ProjectCalendar parentCalendar) {
        this.m_parentCalendar = parentCalendar;
    }

    public ProjectCalendar getParentCalendar() {
        return this.m_parentCalendar;
    }

    public Day getDay() {
        return this.m_day;
    }

    public void setDay(Day d) {
        if (this.m_day != null) {
            this.m_parentCalendar.removeHoursFromDay(this);
        }
        this.m_day = d;
        this.m_parentCalendar.attachHoursToDay(this);
    }

    public void addDateRange(DateRange range) {
        this.m_dateRanges.add(range);
    }

    public DateRange getDateRange(int index) {
        DateRange result = null;
        if (index >= 0 && index < this.m_dateRanges.size()) {
            result = this.m_dateRanges.get(index);
        }
        return result;
    }

    @Override
    public Iterator<DateRange> iterator() {
        return this.m_dateRanges.iterator();
    }

    public int getDateRangeCount() {
        return this.m_dateRanges.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ProjectCalendarHours ");
        for (DateRange range : this.m_dateRanges) {
            sb.append(range.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

