/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.EnumSet;
import java.util.Iterator;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConstraintType implements MpxjEnum
{
    AS_SOON_AS_POSSIBLE(0),
    AS_LATE_AS_POSSIBLE(1),
    MUST_START_ON(2),
    MUST_FINISH_ON(3),
    START_NO_EARLIER_THAN(4),
    START_NO_LATER_THAN(5),
    FINISH_NO_EARLIER_THAN(6),
    FINISH_NO_LATER_THAN(7);

    private static final ConstraintType[] TYPE_VALUES;
    private int m_value;

    private ConstraintType(int type) {
        this.m_value = type;
    }

    public static ConstraintType getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = AS_SOON_AS_POSSIBLE.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static ConstraintType getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return ConstraintType.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    static {
        TYPE_VALUES = new ConstraintType[8];
        Iterator i$ = EnumSet.range(AS_SOON_AS_POSSIBLE, FINISH_NO_LATER_THAN).iterator();
        while (i$.hasNext()) {
            ConstraintType e;
            ConstraintType.TYPE_VALUES[e.getValue()] = e = (ConstraintType)i$.next();
        }
    }
}

