/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaDragRecognitionSupport;
import ch.randelshofer.quaqua.QuaquaDropTargetListener;
import ch.randelshofer.quaqua.QuaquaLazyActionMap;
import ch.randelshofer.quaqua.QuaquaUIAction;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.color.InactivatableColorUIResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class QuaquaTreeUI
extends BasicTreeUI {
    private static final Actions SHARED_ACTION = new Actions();
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private int lastWidth;
    private long timeFactor = 1000L;
    private Handler handler;
    private MouseEvent releaseEvent;
    private boolean ignoreLAChange;
    private int leadRow;
    private static DropTargetListener defaultDropTargetListener = null;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaTreeUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.tree.setInvokesStopCellEditing(true);
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tree, 1, km);
        km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tree, 0, km);
        QuaquaLazyActionMap.installLazyActionMap(this.tree, QuaquaTreeUI.class, "Tree.actionMap");
    }

    static void loadActionMap(QuaquaLazyActionMap map) {
        map.put(new Actions("selectPrevious"));
        map.put(new Actions("selectPreviousChangeLead"));
        map.put(new Actions("selectPreviousExtendSelection"));
        map.put(new Actions("selectNext"));
        map.put(new Actions("selectNextChangeLead"));
        map.put(new Actions("selectNextExtendSelection"));
        map.put(new Actions("selectChild"));
        map.put(new Actions("selectChildChangeLead"));
        map.put(new Actions("selectParent"));
        map.put(new Actions("selectParentChangeLead"));
        map.put(new Actions("scrollUpChangeSelection"));
        map.put(new Actions("scrollUpChangeLead"));
        map.put(new Actions("scrollUpExtendSelection"));
        map.put(new Actions("scrollDownChangeSelection"));
        map.put(new Actions("scrollDownExtendSelection"));
        map.put(new Actions("scrollDownChangeLead"));
        map.put(new Actions("selectFirst"));
        map.put(new Actions("selectFirstChangeLead"));
        map.put(new Actions("selectFirstExtendSelection"));
        map.put(new Actions("selectLast"));
        map.put(new Actions("selectLastChangeLead"));
        map.put(new Actions("selectLastExtendSelection"));
        map.put(new Actions("toggle"));
        map.put(new Actions("cancel"));
        map.put(new Actions("startEditing"));
        map.put(new Actions("selectAll"));
        map.put(new Actions("clearSelection"));
        map.put(new Actions("scrollLeft"));
        map.put(new Actions("scrollRight"));
        map.put(new Actions("scrollLeftExtendSelection"));
        map.put(new Actions("scrollRightExtendSelection"));
        map.put(new Actions("scrollRightChangeLead"));
        map.put(new Actions("scrollLeftChangeLead"));
        map.put(new Actions("expand"));
        map.put(new Actions("collapse"));
        map.put(new Actions("moveSelectionToParent"));
        map.put(new Actions("addToSelection"));
        map.put(new Actions("toggleAndAnchor"));
        map.put(new Actions("extendTo"));
        map.put(new Actions("moveSelectionTo"));
        map.put(TransferHandler.getCutAction());
        map.put(TransferHandler.getCopyAction());
        map.put(TransferHandler.getPasteAction());
    }

    protected void prepareForUIInstall() {
        super.prepareForUIInstall();
        this.leadRow = -1;
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.handler = null;
    }

    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null && this.currentCellRenderer instanceof DefaultTreeCellRenderer) {
            QuaquaTreeCellEditor editor = new QuaquaTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer);
            return editor;
        }
        return new DefaultTreeCellEditor(this.tree, null);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new QuaquaTreeCellRenderer();
    }

    protected KeyListener createKeyListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return this.getHandler();
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return this.getHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return this.getHandler();
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected boolean isToggleSelectionEvent(MouseEvent event) {
        return event.getID() == 501 && SwingUtilities.isLeftMouseButton(event) && event.isMetaDown();
    }

    protected boolean isToggleEvent(MouseEvent event) {
        if (event.getID() != 501 || !SwingUtilities.isLeftMouseButton(event)) {
            return false;
        }
        int clickCount = this.tree.getToggleClickCount();
        if (clickCount <= 0) {
            return false;
        }
        return event.getClickCount() % clickCount == 0;
    }

    protected boolean isMultiSelectEvent(MouseEvent event) {
        return SwingUtilities.isLeftMouseButton(event) && event.isShiftDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAnchorSelectionPath(TreePath newPath) {
        this.ignoreLAChange = true;
        try {
            this.tree.setAnchorSelectionPath(newPath);
        }
        finally {
            this.ignoreLAChange = false;
        }
    }

    private TreePath getAnchorSelectionPath() {
        return this.tree.getAnchorSelectionPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLeadSelectionPath(TreePath newPath, boolean repaint) {
        Rectangle bounds = repaint ? this.getPathBounds(this.tree, this.getLeadSelectionPath()) : null;
        this.ignoreLAChange = true;
        try {
            this.tree.setLeadSelectionPath(newPath);
        }
        finally {
            this.ignoreLAChange = false;
        }
        this.leadRow = this.getRowForPath(this.tree, newPath);
        if (repaint) {
            if (bounds != null) {
                this.tree.repaint(bounds);
            }
            if ((bounds = this.getPathBounds(this.tree, newPath)) != null) {
                this.tree.repaint(bounds);
            }
        }
    }

    private TreePath getLeadSelectionPath() {
        return this.tree.getLeadSelectionPath();
    }

    private void setLeadSelectionPath(TreePath newPath) {
        this.setLeadSelectionPath(newPath, false);
    }

    private void updateLeadRow() {
        this.leadRow = this.getRowForPath(this.tree, this.getLeadSelectionPath());
    }

    private int getLeadSelectionRow() {
        return this.tree.getLeadSelectionRow();
    }

    private void repaintPath(TreePath path) {
        Rectangle bounds;
        if (path != null && (bounds = this.getPathBounds(this.tree, path)) != null) {
            this.tree.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        Object value = path.getLastPathComponent();
        if (!(isLeaf || hasBeenExpanded && this.treeModel.getChildCount(value) <= 0)) {
            int middleXOfKnob = QuaquaUtilities.isLeftToRight(this.tree) ? bounds.x - (this.getRightChildIndent() - 1) : bounds.x + bounds.width + this.getRightChildIndent();
            int middleYOfKnob = bounds.y + bounds.height / 2;
            Icon treeIcon = this.getTreeIcon(isExpanded, this.tree.isRowSelected(row));
            if (treeIcon != null) {
                this.drawCentered(this.tree, g, treeIcon, middleXOfKnob, middleYOfKnob);
            }
        }
    }

    private Icon getTreeIcon(boolean isExpanded, boolean isSelected) {
        int index;
        Icon[] icons = (Icon[])UIManager.get("Tree.icons");
        if (icons == null) {
            return UIManager.getIcon(isExpanded ? "Tree.expandedIcon" : "Tree.collapsedIcon");
        }
        Object property = this.tree.getClientProperty("Quaqua.Tree.style");
        boolean isSideBar = property != null && property.equals("sideBar");
        int n = index = isExpanded ? 3 : 0;
        if (!isSideBar && !QuaquaUtilities.isOnActiveWindow(this.tree)) {
            index += 2;
        } else if (isSelected && QuaquaUtilities.isFocused(this.tree)) {
            ++index;
        } else if (!this.tree.isEnabled()) {
            index += 2;
        }
        return icons[index];
    }

    protected int getRowX(int row, int depth) {
        boolean isSideBar;
        Object property = this.tree.getClientProperty("Quaqua.Tree.style");
        boolean bl = isSideBar = property != null && property.equals("sideBar");
        if (isSideBar) {
            return this.totalChildIndent * (Math.max(1, depth - 2) + this.depthOffset);
        }
        return this.totalChildIndent * (depth + this.depthOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startEditingOnRelease(TreePath path, MouseEvent event, MouseEvent releaseEvent) {
        this.releaseEvent = releaseEvent;
        try {
            boolean bl = this.startEditing(path, event);
            return bl;
        }
        finally {
            this.releaseEvent = null;
        }
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("Tree.ancestorInputMap");
        }
        if (condition == 0) {
            InputMap rtlKeyMap;
            InputMap keyMap = (InputMap)UIManager.get("Tree.focusInputMap");
            if (this.tree.getComponentOrientation().isLeftToRight() || (rtlKeyMap = (InputMap)UIManager.get("Tree.focusInputMap.RightToLeft")) == null) {
                return keyMap;
            }
            rtlKeyMap.setParent(keyMap);
            return rtlKeyMap;
        }
        return null;
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseListener createMouseListener() {
        if (System.getProperty("java.version").startsWith("1.4") || System.getProperty("java.version").startsWith("1.5")) {
            return this.getHandler();
        }
        return super.createMouseListener();
    }

    public void paint(Graphics gr, JComponent c) {
        Border selectionBorder;
        Color background;
        if (this.tree != c) {
            throw new InternalError("incorrect component");
        }
        Graphics2D g = (Graphics2D)gr;
        Object property = this.tree.getClientProperty("Quaqua.Tree.style");
        boolean isStriped = property != null && property.equals("striped");
        boolean isSideBar = property != null && property.equals("sideBar");
        Color[] stripes = new Color[]{UIManager.getColor("Tree.alternateBackground.0"), UIManager.getColor("Tree.alternateBackground.1")};
        boolean isEnabled = c.isEnabled();
        boolean isFocused = QuaquaUtilities.isFocused(c);
        boolean isActive = QuaquaUtilities.isOnActiveWindow(c);
        Color selectionBackground = UIManager.getColor("Tree.selectionBackground");
        Color selectionForeground = UIManager.getColor("Tree.selectionForeground");
        if (selectionBackground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionBackground).setActive(isFocused && isEnabled);
        }
        if (selectionForeground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionForeground).setActive(isFocused && isEnabled);
        }
        if (this.treeState == null) {
            return;
        }
        boolean leftToRight = QuaquaUtilities.isLeftToRight(this.tree);
        int width = this.tree.getWidth();
        int height = this.tree.getHeight();
        if (width != this.lastWidth) {
            this.lastWidth = width;
            if (!leftToRight) {
                this.redoTheLayout();
                this.updateSize();
            }
        }
        Rectangle paintBounds = g.getClipBounds();
        Insets insets = this.tree.getInsets();
        if (insets == null) {
            insets = EMPTY_INSETS;
        }
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int row = this.treeState.getRowForPath(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        this.drawingCache.clear();
        if (isSideBar) {
            background = UIManager.getColor("Tree.background.sideBar");
            selectionBorder = UIManager.getBorder("Tree.selectionBorder.sideBar");
            if (selectionBackground instanceof InactivatableColorUIResource) {
                ((InactivatableColorUIResource)selectionBackground).setTransparent(true);
            }
        } else {
            background = this.tree.getBackground();
            selectionBorder = null;
        }
        if (this.tree.isOpaque()) {
            if (background instanceof InactivatableColorUIResource) {
                ((InactivatableColorUIResource)background).setActive(isActive);
            }
            g.setColor(background);
            g.fillRect(0, 0, width, height);
        }
        if (initialPath != null && paintingEnumerator != null) {
            boolean isExpanded;
            boolean hasBeenExpanded;
            boolean isLeaf;
            TreePath path;
            TreePath parentPath = initialPath;
            boolean done = false;
            Rectangle bounds = null;
            Rectangle boundsBuffer = new Rectangle();
            boolean rootVisible = this.isRootVisible();
            int rwidth = width - insets.right - insets.left;
            if (isStriped) {
                int startY;
                while (!done && paintingEnumerator.hasMoreElements()) {
                    path = paintingEnumerator.nextElement();
                    if (path != null) {
                        isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                        if (isLeaf) {
                            hasBeenExpanded = false;
                            isExpanded = false;
                        } else {
                            isExpanded = this.treeState.getExpandedState(path);
                            hasBeenExpanded = this.tree.hasBeenExpanded(path);
                        }
                        bounds = this.treeState.getBounds(path, boundsBuffer);
                        if (bounds == null) {
                            return;
                        }
                        bounds.x += insets.left;
                        bounds.y += insets.top;
                        if (this.tree.isRowSelected(row)) {
                            if (selectionBorder == null) {
                                g.setColor(selectionBackground);
                                g.fillRect(insets.left, bounds.y, rwidth, bounds.height);
                            } else {
                                selectionBorder.paintBorder(this.tree, g, insets.left, bounds.y, rwidth, bounds.height);
                            }
                        } else {
                            g.setColor(stripes[row % 2]);
                            g.fillRect(insets.left, bounds.y, rwidth, bounds.height);
                        }
                        if (bounds.y + bounds.height >= endY) {
                            done = true;
                        }
                    } else {
                        done = true;
                    }
                    ++row;
                }
                int rheight = this.tree.getRowHeight();
                if (rheight <= 0) {
                    rheight = this.tree.getFont().getSize() + 4;
                }
                for (int y = startY = bounds != null ? bounds.y + bounds.height : 0; y < height; y += rheight) {
                    g.setColor(stripes[row % 2]);
                    g.fillRect(insets.left, y, rwidth, rheight);
                    ++row;
                }
            } else {
                g.setColor(selectionBackground);
                while (!done && paintingEnumerator.hasMoreElements()) {
                    path = paintingEnumerator.nextElement();
                    if (path != null) {
                        isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                        if (isLeaf) {
                            hasBeenExpanded = false;
                            isExpanded = false;
                        } else {
                            isExpanded = this.treeState.getExpandedState(path);
                            hasBeenExpanded = this.tree.hasBeenExpanded(path);
                        }
                        bounds = this.treeState.getBounds(path, boundsBuffer);
                        if (bounds == null) {
                            return;
                        }
                        bounds.x += insets.left;
                        bounds.y += insets.top;
                        if (this.tree.isRowSelected(row)) {
                            if (selectionBorder == null) {
                                g.fillRect(insets.left, bounds.y, rwidth, bounds.height);
                            } else {
                                selectionBorder.paintBorder(this.tree, g, insets.left, bounds.y, rwidth, bounds.height);
                            }
                        }
                        if (bounds.y + bounds.height >= endY) {
                            done = true;
                        }
                    } else {
                        done = true;
                    }
                    ++row;
                }
            }
            paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
            row = this.treeState.getRowForPath(initialPath);
            for (parentPath = parentPath.getParentPath(); parentPath != null; parentPath = parentPath.getParentPath()) {
                this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                this.drawingCache.put(parentPath, Boolean.TRUE);
            }
            done = false;
            while (!done && paintingEnumerator.hasMoreElements()) {
                path = paintingEnumerator.nextElement();
                if (path != null) {
                    isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                    if (isLeaf) {
                        hasBeenExpanded = false;
                        isExpanded = false;
                    } else {
                        isExpanded = this.treeState.getExpandedState(path);
                        hasBeenExpanded = this.tree.hasBeenExpanded(path);
                    }
                    bounds = this.treeState.getBounds(path, boundsBuffer);
                    if (bounds == null) {
                        return;
                    }
                    bounds.x += insets.left;
                    bounds.y += insets.top;
                    parentPath = path.getParentPath();
                    if (parentPath != null) {
                        if (this.drawingCache.get(parentPath) == null) {
                            this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                            this.drawingCache.put(parentPath, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    } else if (rootVisible && row == 0) {
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                        this.paintExpandControl(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (!leftToRight) {
                        bounds.x += 4;
                    }
                    this.paintRow(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf, isEnabled, isFocused);
                    if (bounds.y + bounds.height >= endY) {
                        done = true;
                    }
                } else {
                    done = true;
                }
                ++row;
            }
        } else if (isStriped) {
            int rwidth = width - insets.left - insets.left;
            int rheight = this.tree.getRowHeight();
            if (rheight <= 0) {
                rheight = this.tree.getFont().getSize() + 4;
            }
            row = 0;
            for (int y = 0; y < height; y += rheight) {
                g.setColor(stripes[row % 2]);
                g.fillRect(insets.left, y, rwidth, rheight);
                ++row;
            }
        }
        this.rendererPane.removeAll();
        if (selectionBackground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionBackground).setActive(true);
            ((InactivatableColorUIResource)selectionBackground).setTransparent(false);
        }
        if (selectionForeground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionForeground).setActive(true);
        }
    }

    private void redoTheLayout() {
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
    }

    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
    }

    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
    }

    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf, boolean isEnabled, boolean isFocused) {
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        int leadIndex = this.tree.hasFocus() ? this.getLeadSelectionRow() : -1;
        boolean isRowSelected = this.tree.isRowSelected(row);
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), isRowSelected, isExpanded, isLeaf, row, leadIndex == row);
        this.rendererPane.paintComponent(g, component, this.tree, bounds.x, bounds.y, bounds.width, bounds.height, true);
    }

    private void extendSelection(TreePath newLead) {
        TreePath aPath = this.getAnchorSelectionPath();
        int aRow = aPath == null ? -1 : this.getRowForPath(this.tree, aPath);
        int newIndex = this.getRowForPath(this.tree, newLead);
        if (aRow == -1) {
            this.tree.setSelectionRow(newIndex);
        } else {
            if (aRow < newIndex) {
                this.tree.setSelectionInterval(aRow, newIndex);
            } else {
                this.tree.setSelectionInterval(newIndex, aRow);
            }
            this.setAnchorSelectionPath(aPath);
            this.setLeadSelectionPath(newLead);
        }
    }

    public class TreeCancelEditingAction
    extends AbstractAction {
        public TreeCancelEditingAction(String name) {
        }

        public void actionPerformed(ActionEvent e) {
            if (QuaquaTreeUI.this.tree != null) {
                SHARED_ACTION.cancelEditing(QuaquaTreeUI.this.tree, QuaquaTreeUI.this);
            }
        }

        public boolean isEnabled() {
            return QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.isEnabled() && QuaquaTreeUI.this.isEditing(QuaquaTreeUI.this.tree);
        }
    }

    public class TreeToggleAction
    extends AbstractAction {
        public TreeToggleAction(String name) {
        }

        public void actionPerformed(ActionEvent e) {
            if (QuaquaTreeUI.this.tree != null) {
                SHARED_ACTION.toggle(QuaquaTreeUI.this.tree, QuaquaTreeUI.this);
            }
        }

        public boolean isEnabled() {
            return QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeHomeAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeHomeAction(int direction, String name) {
            this(direction, name, false, true);
        }

        private TreeHomeAction(int direction, String name, boolean addToSelection, boolean changeSelection) {
            this.direction = direction;
            this.changeSelection = changeSelection;
            this.addToSelection = addToSelection;
        }

        public void actionPerformed(ActionEvent e) {
            if (QuaquaTreeUI.this.tree != null) {
                SHARED_ACTION.home(QuaquaTreeUI.this.tree, QuaquaTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        public boolean isEnabled() {
            return QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeIncrementAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeIncrementAction(int direction, String name) {
            this(direction, name, false, true);
        }

        private TreeIncrementAction(int direction, String name, boolean addToSelection, boolean changeSelection) {
            this.direction = direction;
            this.addToSelection = addToSelection;
            this.changeSelection = changeSelection;
        }

        public void actionPerformed(ActionEvent e) {
            if (QuaquaTreeUI.this.tree != null) {
                SHARED_ACTION.increment(QuaquaTreeUI.this.tree, QuaquaTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        public boolean isEnabled() {
            return QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.isEnabled();
        }
    }

    public class TreePageAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreePageAction(int direction, String name) {
            this(direction, name, false, true);
        }

        private TreePageAction(int direction, String name, boolean addToSelection, boolean changeSelection) {
            this.direction = direction;
            this.addToSelection = addToSelection;
            this.changeSelection = changeSelection;
        }

        public void actionPerformed(ActionEvent e) {
            if (QuaquaTreeUI.this.tree != null) {
                SHARED_ACTION.page(QuaquaTreeUI.this.tree, QuaquaTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        public boolean isEnabled() {
            return QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeTraverseAction
    extends AbstractAction {
        protected int direction;
        private boolean changeSelection;

        public TreeTraverseAction(int direction, String name) {
            this(direction, name, true);
        }

        private TreeTraverseAction(int direction, String name, boolean changeSelection) {
            this.direction = direction;
            this.changeSelection = changeSelection;
        }

        public void actionPerformed(ActionEvent e) {
            if (QuaquaTreeUI.this.tree != null) {
                SHARED_ACTION.traverse(QuaquaTreeUI.this.tree, QuaquaTreeUI.this, this.direction, this.changeSelection);
            }
        }

        public boolean isEnabled() {
            return QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.isEnabled();
        }
    }

    private static class Actions
    extends QuaquaUIAction {
        private static final String SELECT_PREVIOUS = "selectPrevious";
        private static final String SELECT_PREVIOUS_CHANGE_LEAD = "selectPreviousChangeLead";
        private static final String SELECT_PREVIOUS_EXTEND_SELECTION = "selectPreviousExtendSelection";
        private static final String SELECT_NEXT = "selectNext";
        private static final String SELECT_NEXT_CHANGE_LEAD = "selectNextChangeLead";
        private static final String SELECT_NEXT_EXTEND_SELECTION = "selectNextExtendSelection";
        private static final String SELECT_CHILD = "selectChild";
        private static final String SELECT_CHILD_CHANGE_LEAD = "selectChildChangeLead";
        private static final String SELECT_PARENT = "selectParent";
        private static final String SELECT_PARENT_CHANGE_LEAD = "selectParentChangeLead";
        private static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        private static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        private static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        private static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        private static final String SELECT_FIRST = "selectFirst";
        private static final String SELECT_FIRST_CHANGE_LEAD = "selectFirstChangeLead";
        private static final String SELECT_FIRST_EXTEND_SELECTION = "selectFirstExtendSelection";
        private static final String SELECT_LAST = "selectLast";
        private static final String SELECT_LAST_CHANGE_LEAD = "selectLastChangeLead";
        private static final String SELECT_LAST_EXTEND_SELECTION = "selectLastExtendSelection";
        private static final String TOGGLE = "toggle";
        private static final String CANCEL_EDITING = "cancel";
        private static final String START_EDITING = "startEditing";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String SCROLL_LEFT = "scrollLeft";
        private static final String SCROLL_RIGHT = "scrollRight";
        private static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        private static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        private static final String SCROLL_RIGHT_CHANGE_LEAD = "scrollRightChangeLead";
        private static final String SCROLL_LEFT_CHANGE_LEAD = "scrollLeftChangeLead";
        private static final String EXPAND = "expand";
        private static final String COLLAPSE = "collapse";
        private static final String MOVE_SELECTION_TO_PARENT = "moveSelectionToParent";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";

        Actions() {
            super(null);
        }

        Actions(String key) {
            super(key);
        }

        public boolean isEnabled(Object o) {
            if (o instanceof JTree && this.getName() == CANCEL_EDITING) {
                return ((JTree)o).isEditing();
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            JTree tree = (JTree)e.getSource();
            QuaquaTreeUI ui = (QuaquaTreeUI)QuaquaUtilities.getUIOfType(tree.getUI(), class$ch$randelshofer$quaqua$QuaquaTreeUI == null ? (class$ch$randelshofer$quaqua$QuaquaTreeUI = QuaquaTreeUI.class$("ch.randelshofer.quaqua.QuaquaTreeUI")) : class$ch$randelshofer$quaqua$QuaquaTreeUI);
            if (ui == null) {
                return;
            }
            String key = this.getName();
            if (key == SELECT_PREVIOUS) {
                this.increment(tree, ui, -1, false, true);
            } else if (key == SELECT_PREVIOUS_CHANGE_LEAD) {
                this.increment(tree, ui, -1, false, false);
            } else if (key == SELECT_PREVIOUS_EXTEND_SELECTION) {
                this.increment(tree, ui, -1, true, true);
            } else if (key == SELECT_NEXT) {
                this.increment(tree, ui, 1, false, true);
            } else if (key == SELECT_NEXT_CHANGE_LEAD) {
                this.increment(tree, ui, 1, false, false);
            } else if (key == SELECT_NEXT_EXTEND_SELECTION) {
                this.increment(tree, ui, 1, true, true);
            } else if (key == SELECT_CHILD) {
                this.traverse(tree, ui, 1, true);
            } else if (key == SELECT_CHILD_CHANGE_LEAD) {
                this.traverse(tree, ui, 1, false);
            } else if (key == SELECT_PARENT) {
                this.traverse(tree, ui, -1, true);
            } else if (key == SELECT_PARENT_CHANGE_LEAD) {
                this.traverse(tree, ui, -1, false);
            } else if (key == SCROLL_UP_CHANGE_SELECTION) {
                this.page(tree, ui, -1, false, true);
            } else if (key == SCROLL_UP_CHANGE_LEAD) {
                this.page(tree, ui, -1, false, false);
            } else if (key == SCROLL_UP_EXTEND_SELECTION) {
                this.page(tree, ui, -1, true, true);
            } else if (key == SCROLL_DOWN_CHANGE_SELECTION) {
                this.page(tree, ui, 1, false, true);
            } else if (key == SCROLL_DOWN_EXTEND_SELECTION) {
                this.page(tree, ui, 1, true, true);
            } else if (key == SCROLL_DOWN_CHANGE_LEAD) {
                this.page(tree, ui, 1, false, false);
            } else if (key == SELECT_FIRST) {
                this.home(tree, ui, -1, false, true);
            } else if (key == SELECT_FIRST_CHANGE_LEAD) {
                this.home(tree, ui, -1, false, false);
            } else if (key == SELECT_FIRST_EXTEND_SELECTION) {
                this.home(tree, ui, -1, true, true);
            } else if (key == SELECT_LAST) {
                this.home(tree, ui, 1, false, true);
            } else if (key == SELECT_LAST_CHANGE_LEAD) {
                this.home(tree, ui, 1, false, false);
            } else if (key == SELECT_LAST_EXTEND_SELECTION) {
                this.home(tree, ui, 1, true, true);
            } else if (key == TOGGLE) {
                this.toggle(tree, ui);
            } else if (key == CANCEL_EDITING) {
                this.cancelEditing(tree, ui);
            } else if (key == START_EDITING) {
                this.startEditing(tree, ui);
            } else if (key == SELECT_ALL) {
                this.selectAll(tree, ui, true);
            } else if (key == CLEAR_SELECTION) {
                this.selectAll(tree, ui, false);
            } else if (key == ADD_TO_SELECTION) {
                int lead;
                if (ui.getRowCount(tree) > 0 && !tree.isRowSelected(lead = ui.getLeadSelectionRow())) {
                    TreePath aPath = ui.getAnchorSelectionPath();
                    tree.addSelectionRow(lead);
                    ui.setAnchorSelectionPath(aPath);
                }
            } else if (key == TOGGLE_AND_ANCHOR) {
                if (ui.getRowCount(tree) > 0) {
                    int lead = ui.getLeadSelectionRow();
                    TreePath lPath = ui.getLeadSelectionPath();
                    if (!tree.isRowSelected(lead)) {
                        tree.addSelectionRow(lead);
                    } else {
                        tree.removeSelectionRow(lead);
                        ui.setLeadSelectionPath(lPath);
                    }
                    ui.setAnchorSelectionPath(lPath);
                }
            } else if (key == EXTEND_TO) {
                this.extendSelection(tree, ui);
            } else if (key == MOVE_SELECTION_TO) {
                if (ui.getRowCount(tree) > 0) {
                    int lead = ui.getLeadSelectionRow();
                    tree.setSelectionInterval(lead, lead);
                }
            } else if (key == SCROLL_LEFT) {
                this.scroll(tree, ui, 0, -10);
            } else if (key == SCROLL_RIGHT) {
                this.scroll(tree, ui, 0, 10);
            } else if (key == SCROLL_LEFT_EXTEND_SELECTION) {
                this.scrollChangeSelection(tree, ui, -1, true, true);
            } else if (key == SCROLL_RIGHT_EXTEND_SELECTION) {
                this.scrollChangeSelection(tree, ui, 1, true, true);
            } else if (key == SCROLL_RIGHT_CHANGE_LEAD) {
                this.scrollChangeSelection(tree, ui, 1, false, false);
            } else if (key == SCROLL_LEFT_CHANGE_LEAD) {
                this.scrollChangeSelection(tree, ui, -1, false, false);
            } else if (key == EXPAND) {
                this.expand(tree, ui);
            } else if (key == COLLAPSE) {
                this.collapse(tree, ui);
            } else if (key == MOVE_SELECTION_TO_PARENT) {
                this.moveSelectionToParent(tree, ui);
            }
        }

        private void scrollChangeSelection(JTree tree, QuaquaTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount = ui.getRowCount(tree);
            if (rowCount > 0 && ui.treeSelectionModel != null) {
                TreePath newPath;
                Rectangle visRect = tree.getVisibleRect();
                if (direction == -1) {
                    newPath = ui.getClosestPathForLocation(tree, visRect.x, visRect.y);
                    visRect.x = Math.max(0, visRect.x - visRect.width);
                } else {
                    visRect.x = Math.min(Math.max(0, tree.getWidth() - visRect.width), visRect.x + visRect.width);
                    newPath = ui.getClosestPathForLocation(tree, visRect.x, visRect.y + visRect.height);
                }
                tree.scrollRectToVisible(visRect);
                if (addToSelection) {
                    ui.extendSelection(newPath);
                } else if (changeSelection) {
                    tree.setSelectionPath(newPath);
                } else {
                    ui.setLeadSelectionPath(newPath, true);
                }
            }
        }

        private void scroll(JTree component, QuaquaTreeUI ui, int direction, int amount) {
            Rectangle visRect = component.getVisibleRect();
            Dimension size = component.getSize();
            if (direction == 0) {
                visRect.x += amount;
                visRect.x = Math.max(0, visRect.x);
                visRect.x = Math.min(Math.max(0, size.width - visRect.width), visRect.x);
            } else {
                visRect.y += amount;
                visRect.y = Math.max(0, visRect.y);
                visRect.y = Math.min(Math.max(0, size.width - visRect.height), visRect.y);
            }
            component.scrollRectToVisible(visRect);
        }

        private void extendSelection(JTree tree, QuaquaTreeUI ui) {
            int lead;
            if (ui.getRowCount(tree) > 0 && (lead = ui.getLeadSelectionRow()) != -1) {
                TreePath leadP = ui.getLeadSelectionPath();
                TreePath aPath = ui.getAnchorSelectionPath();
                int aRow = ui.getRowForPath(tree, aPath);
                if (aRow == -1) {
                    aRow = 0;
                }
                tree.setSelectionInterval(aRow, lead);
                ui.setLeadSelectionPath(leadP);
                ui.setAnchorSelectionPath(aPath);
            }
        }

        private void selectAll(JTree tree, QuaquaTreeUI ui, boolean selectAll) {
            int rowCount = ui.getRowCount(tree);
            if (rowCount > 0) {
                if (selectAll) {
                    if (tree.getSelectionModel().getSelectionMode() == 1) {
                        int lead = ui.getLeadSelectionRow();
                        if (lead != -1) {
                            tree.setSelectionRow(lead);
                        } else if (tree.getMinSelectionRow() == -1) {
                            tree.setSelectionRow(0);
                            ui.ensureRowsAreVisible(0, 0);
                        }
                        return;
                    }
                    TreePath lastPath = ui.getLeadSelectionPath();
                    TreePath aPath = ui.getAnchorSelectionPath();
                    if (lastPath != null && !tree.isVisible(lastPath)) {
                        lastPath = null;
                    }
                    tree.setSelectionInterval(0, rowCount - 1);
                    if (lastPath != null) {
                        ui.setLeadSelectionPath(lastPath);
                    }
                    if (aPath != null && tree.isVisible(aPath)) {
                        ui.setAnchorSelectionPath(aPath);
                    }
                } else {
                    TreePath lastPath = ui.getLeadSelectionPath();
                    TreePath aPath = ui.getAnchorSelectionPath();
                    tree.clearSelection();
                    ui.setAnchorSelectionPath(aPath);
                    ui.setLeadSelectionPath(lastPath);
                }
            }
        }

        private void startEditing(JTree tree, QuaquaTreeUI ui) {
            int editRow;
            TreePath lead = ui.getLeadSelectionPath();
            int n = editRow = lead != null ? ui.getRowForPath(tree, lead) : -1;
            if (editRow != -1) {
                tree.startEditingAtPath(lead);
            }
        }

        private void cancelEditing(JTree tree, QuaquaTreeUI ui) {
            tree.cancelEditing();
        }

        private void toggle(JTree tree, QuaquaTreeUI ui) {
            int selRow = ui.getLeadSelectionRow();
            if (selRow != -1 && !ui.isLeaf(selRow)) {
                TreePath aPath = ui.getAnchorSelectionPath();
                TreePath lPath = ui.getLeadSelectionPath();
                ui.toggleExpandState(ui.getPathForRow(tree, selRow));
                ui.setAnchorSelectionPath(aPath);
                ui.setLeadSelectionPath(lPath);
            }
        }

        private void expand(JTree tree, QuaquaTreeUI ui) {
            int selRow = ui.getLeadSelectionRow();
            tree.expandRow(selRow);
        }

        private void collapse(JTree tree, QuaquaTreeUI ui) {
            int selRow = ui.getLeadSelectionRow();
            tree.collapseRow(selRow);
        }

        private void increment(JTree tree, QuaquaTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount;
            if (!addToSelection && !changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if (ui.treeSelectionModel != null && (rowCount = tree.getRowCount()) > 0) {
                int selIndex = ui.getLeadSelectionRow();
                int newIndex = selIndex == -1 ? (direction == 1 ? 0 : rowCount - 1) : Math.min(rowCount - 1, Math.max(0, selIndex + direction));
                if (addToSelection && ui.treeSelectionModel.getSelectionMode() != 1) {
                    ui.extendSelection(tree.getPathForRow(newIndex));
                } else if (changeSelection) {
                    tree.setSelectionInterval(newIndex, newIndex);
                } else {
                    ui.setLeadSelectionPath(tree.getPathForRow(newIndex), true);
                }
                ui.ensureRowsAreVisible(newIndex, newIndex);
                ui.lastSelectedRow = newIndex;
            }
        }

        private void traverse(JTree tree, QuaquaTreeUI ui, int direction, boolean changeSelection) {
            int rowCount;
            if (!changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if ((rowCount = tree.getRowCount()) > 0) {
                int newIndex;
                int minSelIndex = ui.getLeadSelectionRow();
                if (minSelIndex == -1) {
                    newIndex = 0;
                } else if (direction == 1) {
                    if (!ui.isLeaf(minSelIndex) && !tree.isExpanded(minSelIndex)) {
                        ui.toggleExpandState(ui.getPathForRow(tree, minSelIndex));
                        newIndex = -1;
                    } else {
                        newIndex = Math.min(minSelIndex + 1, rowCount - 1);
                    }
                } else if (!ui.isLeaf(minSelIndex) && tree.isExpanded(minSelIndex)) {
                    ui.toggleExpandState(ui.getPathForRow(tree, minSelIndex));
                    newIndex = -1;
                } else {
                    TreePath path = ui.getPathForRow(tree, minSelIndex);
                    newIndex = path != null && path.getPathCount() > 1 ? ui.getRowForPath(tree, path.getParentPath()) : -1;
                }
                if (newIndex != -1) {
                    if (changeSelection) {
                        tree.setSelectionInterval(newIndex, newIndex);
                    } else {
                        ui.setLeadSelectionPath(ui.getPathForRow(tree, newIndex), true);
                    }
                    ui.ensureRowsAreVisible(newIndex, newIndex);
                }
            }
        }

        private void moveSelectionToParent(JTree tree, QuaquaTreeUI ui) {
            int newIndex;
            int selRow = ui.getLeadSelectionRow();
            TreePath path = ui.getPathForRow(tree, selRow);
            if (path != null && path.getPathCount() > 1 && (newIndex = ui.getRowForPath(tree, path.getParentPath())) != -1) {
                tree.setSelectionInterval(newIndex, newIndex);
                ui.ensureRowsAreVisible(newIndex, newIndex);
            }
        }

        private void page(JTree tree, QuaquaTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount;
            if (!addToSelection && !changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if ((rowCount = ui.getRowCount(tree)) > 0 && ui.treeSelectionModel != null) {
                TreePath newPath;
                Dimension maxSize = tree.getSize();
                TreePath lead = ui.getLeadSelectionPath();
                Rectangle visRect = tree.getVisibleRect();
                if (direction == -1) {
                    newPath = ui.getClosestPathForLocation(tree, visRect.x, visRect.y);
                    if (newPath.equals(lead)) {
                        visRect.y = Math.max(0, visRect.y - visRect.height);
                        newPath = tree.getClosestPathForLocation(visRect.x, visRect.y);
                    }
                } else {
                    visRect.y = Math.min(maxSize.height, visRect.y + visRect.height - 1);
                    newPath = tree.getClosestPathForLocation(visRect.x, visRect.y);
                    if (newPath.equals(lead)) {
                        visRect.y = Math.min(maxSize.height, visRect.y + visRect.height - 1);
                        newPath = tree.getClosestPathForLocation(visRect.x, visRect.y);
                    }
                }
                Rectangle newRect = ui.getPathBounds(tree, newPath);
                newRect.x = visRect.x;
                newRect.width = visRect.width;
                if (direction == -1) {
                    newRect.height = visRect.height;
                } else {
                    newRect.y -= visRect.height - newRect.height;
                    newRect.height = visRect.height;
                }
                if (addToSelection) {
                    ui.extendSelection(newPath);
                } else if (changeSelection) {
                    tree.setSelectionPath(newPath);
                } else {
                    ui.setLeadSelectionPath(newPath, true);
                }
                tree.scrollRectToVisible(newRect);
            }
        }

        private void home(JTree tree, QuaquaTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount;
            if (!addToSelection && !changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if ((rowCount = ui.getRowCount(tree)) > 0) {
                if (direction == -1) {
                    ui.ensureRowsAreVisible(0, 0);
                    if (addToSelection) {
                        int aRow;
                        TreePath aPath = ui.getAnchorSelectionPath();
                        int n = aRow = aPath == null ? -1 : ui.getRowForPath(tree, aPath);
                        if (aRow == -1) {
                            tree.setSelectionInterval(0, 0);
                        } else {
                            tree.setSelectionInterval(0, aRow);
                            ui.setAnchorSelectionPath(aPath);
                            ui.setLeadSelectionPath(ui.getPathForRow(tree, 0));
                        }
                    } else if (changeSelection) {
                        tree.setSelectionInterval(0, 0);
                    } else {
                        ui.setLeadSelectionPath(ui.getPathForRow(tree, 0), true);
                    }
                } else {
                    ui.ensureRowsAreVisible(rowCount - 1, rowCount - 1);
                    if (addToSelection) {
                        int aRow;
                        TreePath aPath = ui.getAnchorSelectionPath();
                        int n = aRow = aPath == null ? -1 : ui.getRowForPath(tree, aPath);
                        if (aRow == -1) {
                            tree.setSelectionInterval(rowCount - 1, rowCount - 1);
                        } else {
                            tree.setSelectionInterval(aRow, rowCount - 1);
                            ui.setAnchorSelectionPath(aPath);
                            ui.setLeadSelectionPath(ui.getPathForRow(tree, rowCount - 1));
                        }
                    } else if (changeSelection) {
                        tree.setSelectionInterval(rowCount - 1, rowCount - 1);
                    } else {
                        ui.setLeadSelectionPath(ui.getPathForRow(tree, rowCount - 1), true);
                    }
                }
            }
        }
    }

    static class TreeDropTargetListener
    extends QuaquaDropTargetListener {
        private int[] selectedIndices;

        TreeDropTargetListener() {
        }

        protected void saveComponentState(JComponent comp) {
            JTree tree = (JTree)comp;
            this.selectedIndices = tree.getSelectionRows();
        }

        protected void restoreComponentState(JComponent comp) {
            JTree tree = (JTree)comp;
            tree.setSelectionRows(this.selectedIndices);
        }

        protected void updateInsertionLocation(JComponent comp, Point p) {
            JTree tree = (JTree)comp;
            BasicTreeUI ui = (BasicTreeUI)tree.getUI();
            TreePath path = ui.getClosestPathForLocation(tree, p.x, p.y);
            if (path != null) {
                tree.setSelectionPath(path);
            }
        }
    }

    private class Handler
    implements CellEditorListener,
    FocusListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    TreeExpansionListener,
    TreeModelListener,
    TreeSelectionListener,
    QuaquaDragRecognitionSupport.BeforeDrag {
        private String prefix = "";
        private String typedString = "";
        private long lastTime = 0L;
        private boolean mouseReleaseDeselects;
        private boolean mouseDragSelects;

        private Handler() {
        }

        public void keyTyped(KeyEvent e) {
            if (QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.getRowCount() > 0 && QuaquaTreeUI.this.tree.hasFocus() && QuaquaTreeUI.this.tree.isEnabled()) {
                TreePath path;
                if (e.isAltDown() || e.isControlDown() || e.isMetaDown() || this.isNavigationKey(e)) {
                    return;
                }
                boolean startingFromSelection = true;
                char c = e.getKeyChar();
                long time = e.getWhen();
                int startingRow = QuaquaTreeUI.this.getLeadSelectionRow();
                if (time - this.lastTime < QuaquaTreeUI.this.timeFactor) {
                    this.typedString = this.typedString + c;
                    if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                        ++startingRow;
                    } else {
                        this.prefix = this.typedString;
                    }
                } else {
                    ++startingRow;
                    this.prefix = this.typedString = "" + c;
                }
                this.lastTime = time;
                if (startingRow < 0 || startingRow >= QuaquaTreeUI.this.tree.getRowCount()) {
                    startingFromSelection = false;
                    startingRow = 0;
                }
                if ((path = QuaquaTreeUI.this.tree.getNextMatch(this.prefix, startingRow, Position.Bias.Forward)) != null) {
                    QuaquaTreeUI.this.tree.setSelectionPath(path);
                    int row = QuaquaTreeUI.this.getRowForPath(QuaquaTreeUI.this.tree, path);
                    QuaquaTreeUI.this.ensureRowsAreVisible(row, row);
                } else if (startingFromSelection && (path = QuaquaTreeUI.this.tree.getNextMatch(this.prefix, 0, Position.Bias.Forward)) != null) {
                    QuaquaTreeUI.this.tree.setSelectionPath(path);
                    int row = QuaquaTreeUI.this.getRowForPath(QuaquaTreeUI.this.tree, path);
                    QuaquaTreeUI.this.ensureRowsAreVisible(row, row);
                }
            }
        }

        public void keyPressed(KeyEvent e) {
            if (this.isNavigationKey(e)) {
                this.prefix = "";
                this.typedString = "";
                this.lastTime = 0L;
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        private boolean isNavigationKey(KeyEvent event) {
            InputMap inputMap = QuaquaTreeUI.this.tree.getInputMap(1);
            KeyStroke key = KeyStroke.getKeyStrokeForEvent(event);
            return inputMap != null && inputMap.get(key) != null;
        }

        public void propertyChange(PropertyChangeEvent event) {
            String name = event.getPropertyName();
            if (event.getSource() == QuaquaTreeUI.this.treeSelectionModel) {
                QuaquaTreeUI.this.treeSelectionModel.resetRowSelection();
            } else if (event.getSource() == QuaquaTreeUI.this.tree) {
                if (name == "Frame.active") {
                    if (QuaquaTreeUI.this.tree.getClientProperty("Quaqua.Tree.style") != null && QuaquaTreeUI.this.tree.getClientProperty("Quaqua.Tree.style").equals("sideBar")) {
                        QuaquaTreeUI.this.tree.repaint();
                    }
                } else if (name == "leadSelectionPath") {
                    if (!QuaquaTreeUI.this.ignoreLAChange) {
                        QuaquaTreeUI.this.updateLeadRow();
                        QuaquaTreeUI.this.repaintPath((TreePath)event.getOldValue());
                        QuaquaTreeUI.this.repaintPath((TreePath)event.getNewValue());
                    }
                } else if (name == "anchorSelectionPath" && !QuaquaTreeUI.this.ignoreLAChange) {
                    QuaquaTreeUI.this.repaintPath((TreePath)event.getOldValue());
                    QuaquaTreeUI.this.repaintPath((TreePath)event.getNewValue());
                }
                if (name == "cellRenderer") {
                    QuaquaTreeUI.this.setCellRenderer((TreeCellRenderer)event.getNewValue());
                    QuaquaTreeUI.this.redoTheLayout();
                } else if (name == "model") {
                    QuaquaTreeUI.this.setModel((TreeModel)event.getNewValue());
                } else if (name == "rootVisible") {
                    QuaquaTreeUI.this.setRootVisible((Boolean)event.getNewValue());
                } else if (name == "showsRootHandles") {
                    QuaquaTreeUI.this.setShowsRootHandles((Boolean)event.getNewValue());
                } else if (name == "rowHeight") {
                    QuaquaTreeUI.this.setRowHeight((Integer)event.getNewValue());
                } else if (name == "cellEditor") {
                    QuaquaTreeUI.this.setCellEditor((TreeCellEditor)event.getNewValue());
                } else if (name == "editable") {
                    QuaquaTreeUI.this.setEditable((Boolean)event.getNewValue());
                } else if (name == "largeModel") {
                    QuaquaTreeUI.this.setLargeModel(QuaquaTreeUI.this.tree.isLargeModel());
                } else if (name == "selectionModel") {
                    QuaquaTreeUI.this.setSelectionModel(QuaquaTreeUI.this.tree.getSelectionModel());
                } else if (name == "font") {
                    QuaquaTreeUI.this.completeEditing();
                    if (QuaquaTreeUI.this.treeState != null) {
                        QuaquaTreeUI.this.treeState.invalidateSizes();
                    }
                    QuaquaTreeUI.this.updateSize();
                } else if (name == "componentOrientation") {
                    if (QuaquaTreeUI.this.tree != null) {
                        QuaquaTreeUI.this.redoTheLayout();
                        QuaquaTreeUI.this.tree.treeDidChange();
                        InputMap km = QuaquaTreeUI.this.getInputMap(0);
                        SwingUtilities.replaceUIInputMap(QuaquaTreeUI.this.tree, 0, km);
                    }
                } else if ("transferHandler" == name) {
                    DropTarget dropTarget = QuaquaTreeUI.this.tree.getDropTarget();
                    if (dropTarget instanceof UIResource) {
                        if (defaultDropTargetListener == null) {
                            defaultDropTargetListener = new TreeDropTargetListener();
                        }
                        try {
                            dropTarget.addDropTargetListener(defaultDropTargetListener);
                        }
                        catch (TooManyListenersException tmle) {}
                    }
                } else if (name.equals("JComponent.sizeVariant")) {
                    QuaquaUtilities.applySizeVariant(QuaquaTreeUI.this.tree);
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void dragStarting(MouseEvent me) {
        }

        public void mousePressed(MouseEvent e) {
            if (QuaquaTreeUI.this.tree.isEnabled()) {
                if (QuaquaTreeUI.this.isEditing(QuaquaTreeUI.this.tree) && QuaquaTreeUI.this.tree.getInvokesStopCellEditing() && !QuaquaTreeUI.this.stopEditing(QuaquaTreeUI.this.tree)) {
                    return;
                }
                QuaquaTreeUI.this.completeEditing();
                QuaquaTreeUI.this.tree.requestFocusInWindow();
                TreePath path = QuaquaTreeUI.this.getClosestPathForLocation(QuaquaTreeUI.this.tree, e.getX(), e.getY());
                if (QuaquaTreeUI.this.startEditing(path, e)) {
                    return;
                }
                if (QuaquaTreeUI.this.isLocationInExpandControl(path, e.getX(), e.getY())) {
                    QuaquaTreeUI.this.checkForClickInExpandControl(path, e.getX(), e.getY());
                    return;
                }
                int index = QuaquaTreeUI.this.tree.getRowForPath(path);
                this.mouseDragSelects = false;
                this.mouseReleaseDeselects = false;
                if (!(index == -1 || QuaquaTreeUI.this.tree.isRowSelected(index) && e.isPopupTrigger())) {
                    int anchorIndex = QuaquaTreeUI.this.tree.getRowForPath(QuaquaTreeUI.this.tree.getAnchorSelectionPath());
                    if ((e.getModifiersEx() & 0x1900) == 256) {
                        if (QuaquaTreeUI.this.tree.isRowSelected(index)) {
                            QuaquaTreeUI.this.tree.removeSelectionInterval(index, index);
                        } else {
                            QuaquaTreeUI.this.tree.addSelectionInterval(index, index);
                            this.mouseDragSelects = true;
                        }
                    } else if ((e.getModifiersEx() & 0x1840) == 64 && anchorIndex != -1) {
                        QuaquaTreeUI.this.tree.setSelectionInterval(anchorIndex, index);
                        QuaquaTreeUI.this.setLeadSelectionPath(path);
                        this.mouseDragSelects = true;
                    } else if ((e.getModifiersEx() & 0x140) == 0) {
                        if (QuaquaTreeUI.this.tree.isRowSelected(index)) {
                            this.mouseReleaseDeselects = QuaquaTreeUI.this.tree.isFocusOwner();
                        } else {
                            QuaquaTreeUI.this.tree.setSelectionInterval(index, index);
                            this.mouseDragSelects = true;
                        }
                        QuaquaTreeUI.this.setAnchorSelectionPath(path);
                        QuaquaTreeUI.this.setLeadSelectionPath(path);
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (QuaquaTreeUI.this.tree.getDragEnabled()) {
                QuaquaDragRecognitionSupport.mouseDragged(e, this);
            }
            if (QuaquaTreeUI.this.tree.isEnabled()) {
                int index;
                if (QuaquaTreeUI.this.isEditing(QuaquaTreeUI.this.tree) && QuaquaTreeUI.this.tree.getInvokesStopCellEditing() && !QuaquaTreeUI.this.stopEditing(QuaquaTreeUI.this.tree)) {
                    return;
                }
                TreePath leadPath = QuaquaTreeUI.this.getClosestPathForLocation(QuaquaTreeUI.this.tree, e.getX(), e.getY());
                if (QuaquaTreeUI.this.tree.getCellEditor() != null) {
                    QuaquaTreeUI.this.tree.getCellEditor().isCellEditable(new EventObject(this){});
                }
                this.mouseReleaseDeselects = false;
                if (this.mouseDragSelects && (index = QuaquaTreeUI.this.tree.getRowForPath(leadPath)) != -1) {
                    Rectangle cellBounds = QuaquaTreeUI.this.tree.getRowBounds(index);
                    QuaquaTreeUI.this.tree.scrollRectToVisible(cellBounds);
                    TreePath anchorPath = QuaquaTreeUI.this.tree.getAnchorSelectionPath();
                    int anchorIndex = QuaquaTreeUI.this.tree.getRowForPath(anchorPath);
                    if (QuaquaTreeUI.this.tree.getSelectionModel().getSelectionMode() == 1) {
                        QuaquaTreeUI.this.tree.setSelectionInterval(index, index);
                    } else {
                        if (anchorIndex < index) {
                            QuaquaTreeUI.this.tree.setSelectionInterval(anchorIndex, index);
                        } else {
                            QuaquaTreeUI.this.tree.setSelectionInterval(index, anchorIndex);
                        }
                        QuaquaTreeUI.this.setAnchorSelectionPath(anchorPath);
                        QuaquaTreeUI.this.setLeadSelectionPath(leadPath);
                    }
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (QuaquaTreeUI.this.tree.isEnabled()) {
                if (QuaquaTreeUI.this.isEditing(QuaquaTreeUI.this.tree) && QuaquaTreeUI.this.tree.getInvokesStopCellEditing() && !QuaquaTreeUI.this.stopEditing(QuaquaTreeUI.this.tree)) {
                    return;
                }
                TreePath path = QuaquaTreeUI.this.getClosestPathForLocation(QuaquaTreeUI.this.tree, e.getX(), e.getY());
                if (!this.mouseDragSelects && QuaquaTreeUI.this.startEditingOnRelease(path, e, e)) {
                    return;
                }
                this.mouseDragSelects = false;
                if (this.mouseReleaseDeselects) {
                    int index = QuaquaTreeUI.this.tree.getRowForPath(path);
                    QuaquaTreeUI.this.tree.setSelectionInterval(index, index);
                }
            }
            if (QuaquaTreeUI.this.tree.isRequestFocusEnabled()) {
                QuaquaTreeUI.this.tree.requestFocus();
            }
        }

        public void focusGained(FocusEvent e) {
            if (QuaquaTreeUI.this.tree != null) {
                Rectangle pBounds = QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, QuaquaTreeUI.this.tree.getLeadSelectionPath());
                if (pBounds != null) {
                    QuaquaTreeUI.this.tree.repaint(pBounds);
                }
                if ((pBounds = QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, QuaquaTreeUI.this.getLeadSelectionPath())) != null) {
                    QuaquaTreeUI.this.tree.repaint(pBounds);
                }
            }
        }

        public void focusLost(FocusEvent e) {
            this.focusGained(e);
        }

        public void editingStopped(ChangeEvent e) {
            QuaquaTreeUI.this.completeEditing(false, false, true);
        }

        public void editingCanceled(ChangeEvent e) {
            QuaquaTreeUI.this.completeEditing(false, false, false);
        }

        public void valueChanged(TreeSelectionEvent event) {
            TreePath[] paths;
            QuaquaTreeUI.this.completeEditing();
            if (QuaquaTreeUI.this.tree.getExpandsSelectedPaths() && QuaquaTreeUI.this.treeSelectionModel != null && (paths = QuaquaTreeUI.this.treeSelectionModel.getSelectionPaths()) != null) {
                for (int counter = paths.length - 1; counter >= 0; --counter) {
                    TreePath path = paths[counter].getParentPath();
                    boolean expand = true;
                    while (path != null) {
                        if (QuaquaTreeUI.this.treeModel.isLeaf(path.getLastPathComponent())) {
                            expand = false;
                            path = null;
                            continue;
                        }
                        path = path.getParentPath();
                    }
                    if (!expand) continue;
                    QuaquaTreeUI.this.tree.makeVisible(paths[counter]);
                }
            }
            TreePath oldLead = QuaquaTreeUI.this.getLeadSelectionPath();
            QuaquaTreeUI.this.lastSelectedRow = QuaquaTreeUI.this.tree.getMinSelectionRow();
            TreePath lead = QuaquaTreeUI.this.tree.getSelectionModel().getLeadSelectionPath();
            QuaquaTreeUI.this.setAnchorSelectionPath(lead);
            QuaquaTreeUI.this.setLeadSelectionPath(lead);
            TreePath[] changedPaths = event.getPaths();
            Rectangle visRect = QuaquaTreeUI.this.tree.getVisibleRect();
            boolean paintPaths = true;
            int nWidth = QuaquaTreeUI.this.tree.getWidth();
            if (changedPaths != null) {
                int maxCounter = changedPaths.length;
                if (maxCounter > 4) {
                    QuaquaTreeUI.this.tree.repaint();
                    paintPaths = false;
                } else {
                    for (int counter = 0; counter < maxCounter; ++counter) {
                        Rectangle nodeBounds = QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, changedPaths[counter]);
                        if (nodeBounds == null || !visRect.intersects(nodeBounds)) continue;
                        QuaquaTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                    }
                }
            }
            if (paintPaths) {
                oldLead = event.getOldLeadSelectionPath();
                Rectangle nodeBounds = QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, oldLead);
                if (nodeBounds != null && visRect.intersects(nodeBounds)) {
                    QuaquaTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                }
                if ((nodeBounds = QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, lead)) != null && visRect.intersects(nodeBounds)) {
                    QuaquaTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                }
            }
        }

        public void treeExpanded(TreeExpansionEvent event) {
            if (event != null && QuaquaTreeUI.this.tree != null) {
                TreePath path = event.getPath();
                QuaquaTreeUI.this.updateExpandedDescendants(path);
            }
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            if (event != null && QuaquaTreeUI.this.tree != null) {
                TreePath path = event.getPath();
                QuaquaTreeUI.this.completeEditing();
                if (path != null && QuaquaTreeUI.this.tree.isVisible(path)) {
                    QuaquaTreeUI.this.treeState.setExpandedState(path, false);
                    QuaquaTreeUI.this.updateLeadRow();
                    QuaquaTreeUI.this.updateSize();
                }
            }
        }

        public void treeNodesChanged(TreeModelEvent e) {
            if (QuaquaTreeUI.this.treeState != null && e != null) {
                QuaquaTreeUI.this.treeState.treeNodesChanged(e);
                TreePath pPath = e.getTreePath().getParentPath();
                if (pPath == null || QuaquaTreeUI.this.treeState.isExpanded(pPath)) {
                    QuaquaTreeUI.this.updateSize();
                }
            }
        }

        public void treeNodesInserted(TreeModelEvent e) {
            if (QuaquaTreeUI.this.treeState != null && e != null) {
                QuaquaTreeUI.this.treeState.treeNodesInserted(e);
                QuaquaTreeUI.this.updateLeadRow();
                TreePath path = e.getTreePath();
                if (QuaquaTreeUI.this.treeState.isExpanded(path)) {
                    QuaquaTreeUI.this.updateSize();
                } else {
                    int[] indices = e.getChildIndices();
                    int childCount = QuaquaTreeUI.this.treeModel.getChildCount(path.getLastPathComponent());
                    if (indices != null && childCount - indices.length == 0) {
                        QuaquaTreeUI.this.updateSize();
                    }
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            if (QuaquaTreeUI.this.treeState != null && e != null) {
                QuaquaTreeUI.this.treeState.treeNodesRemoved(e);
                QuaquaTreeUI.this.updateLeadRow();
                TreePath path = e.getTreePath();
                if (QuaquaTreeUI.this.treeState.isExpanded(path) || QuaquaTreeUI.this.treeModel.getChildCount(path.getLastPathComponent()) == 0) {
                    QuaquaTreeUI.this.updateSize();
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent e) {
            if (QuaquaTreeUI.this.treeState != null && e != null) {
                QuaquaTreeUI.this.treeState.treeStructureChanged(e);
                QuaquaTreeUI.this.updateLeadRow();
                TreePath pPath = e.getTreePath();
                if (pPath != null) {
                    pPath = pPath.getParentPath();
                }
                if (pPath == null || QuaquaTreeUI.this.treeState.isExpanded(pPath)) {
                    QuaquaTreeUI.this.updateSize();
                }
            }
        }
    }

    public class FocusHandler
    extends BasicTreeUI.FocusHandler {
        public FocusHandler() {
            super(QuaquaTreeUI.this);
        }

        public void focusGained(FocusEvent event) {
            if (QuaquaTreeUI.this.tree != null) {
                Rectangle pBounds = null;
                TreePath[] selectionPaths = QuaquaTreeUI.this.tree.getSelectionPaths();
                if (selectionPaths != null) {
                    for (int i = 0; i < selectionPaths.length; ++i) {
                        if (i == 0) {
                            pBounds = QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, selectionPaths[i]);
                            continue;
                        }
                        pBounds.add(QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, selectionPaths[i]));
                    }
                    if (pBounds != null) {
                        QuaquaTreeUI.this.tree.repaint(0, pBounds.y, QuaquaTreeUI.this.tree.getWidth(), pBounds.height);
                    }
                }
            }
        }

        public void focusLost(FocusEvent event) {
            this.focusGained(event);
        }
    }

    private static class QuaquaTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements UIResource {
        public QuaquaTreeCellRenderer() {
            this.setBorder(null);
        }
    }

    private static class QuaquaTreeCellEditor
    extends DefaultTreeCellEditor
    implements UIResource {
        public QuaquaTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
        }

        protected Container createContainer() {
            return new DefaultTreeCellEditor.EditorContainer(){

                public void paint(Graphics gr) {
                    Graphics2D g = (Graphics2D)gr;
                    g.setColor(UIManager.getColor("TextField.background"));
                    Component[] c = this.getComponents();
                    for (int i = 0; i < c.length; ++i) {
                        g.fill(c[i].getBounds());
                    }
                    super.paint(g);
                }
            };
        }
    }
}

