/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaButtonUI;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonListener;

public class QuaquaButtonListener
extends BasicButtonListener {
    transient long lastPressedTimestamp = -1L;
    transient boolean shouldDiscardRelease = false;

    public QuaquaButtonListener(AbstractButton button) {
        super(button);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("Frame.active")) {
            ((AbstractButton)e.getSource()).repaint();
        }
        super.propertyChange(e);
    }

    public void mousePressed(MouseEvent e) {
        AbstractButton b;
        if (SwingUtilities.isLeftMouseButton(e) && (b = (AbstractButton)e.getSource()).contains(e.getX(), e.getY())) {
            long multiClickThreshhold = Methods.invokeGetter((Object)b, "getMultiClickThreshhold", 0L);
            long lastTime = this.lastPressedTimestamp;
            long currentTime = this.lastPressedTimestamp = e.getWhen();
            if (lastTime != -1L && currentTime - lastTime < multiClickThreshhold) {
                this.shouldDiscardRelease = true;
                return;
            }
            ButtonModel model = b.getModel();
            if (!model.isEnabled()) {
                return;
            }
            if (!model.isArmed()) {
                model.setArmed(true);
            }
            model.setPressed(true);
            if (!b.hasFocus() && b.isRequestFocusEnabled()) {
                b.requestFocus();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.shouldDiscardRelease) {
                this.shouldDiscardRelease = false;
                return;
            }
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            model.setPressed(false);
            model.setArmed(false);
        }
    }

    public void mouseEntered(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        ButtonModel model = b.getModel();
        if (b.isRolloverEnabled()) {
            model.setRollover(true);
        }
        if (model.isPressed()) {
            model.setArmed(true);
        }
    }

    public void mouseExited(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        ButtonModel model = b.getModel();
        if (b.isRolloverEnabled()) {
            model.setRollover(false);
        }
        model.setArmed(false);
    }

    public void focusGained(FocusEvent e) {
        QuaquaButtonUI ui;
        JRootPane root;
        AbstractButton b = (AbstractButton)e.getSource();
        if (b instanceof JButton && ((JButton)b).isDefaultCapable() && (root = b.getRootPane()) != null && (ui = (QuaquaButtonUI)QuaquaUtilities.getUIOfType(b.getUI(), QuaquaButtonUI.class)) != null && UIManager.get(ui.getPropertyPrefix() + "defaultButtonFollowsFocus") != Boolean.FALSE) {
            root.putClientProperty("temporaryDefaultButton", b);
            root.setDefaultButton((JButton)b);
            root.putClientProperty("temporaryDefaultButton", null);
        }
        b.repaint();
    }

    public void focusLost(FocusEvent e) {
        QuaquaButtonUI ui;
        JButton initialDefault;
        AbstractButton b = (AbstractButton)e.getSource();
        JRootPane root = b.getRootPane();
        if (root != null && b != (initialDefault = (JButton)root.getClientProperty("initialDefaultButton")) && (ui = (QuaquaButtonUI)QuaquaUtilities.getUIOfType(b.getUI(), QuaquaButtonUI.class)) != null && UIManager.get(ui.getPropertyPrefix() + "defaultButtonFollowsFocus") != Boolean.FALSE) {
            root.setDefaultButton(initialDefault);
        }
        b.getModel().setArmed(false);
        b.repaint();
    }
}

