/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.Quaqua14TextFieldFocusHandler;
import ch.randelshofer.quaqua.QuaquaCaret;
import ch.randelshofer.quaqua.QuaquaHighlighter;
import ch.randelshofer.quaqua.QuaquaTextFieldUI;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.border.BackgroundBorder;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.Fonts;
import ch.randelshofer.quaqua.util.InsetsUtil;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicFormattedTextFieldUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.View;

public class Quaqua14FormattedTextFieldUI
extends BasicFormattedTextFieldUI
implements VisuallyLayoutable {
    boolean oldDragState = false;
    private FocusListener focusListener;
    private MouseListener popupListener;

    public static ComponentUI createUI(JComponent c) {
        return new Quaqua14FormattedTextFieldUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        QuaquaUtilities.installProperty(c, "opaque", UIManager.get(this.getPropertyPrefix() + ".opaque"));
    }

    protected void installDefaults() {
        if (!QuaquaUtilities.isHeadless()) {
            this.oldDragState = Methods.invokeGetter((Object)this.getComponent(), "getDragEnabled", true);
            Methods.invokeIfExists((Object)this.getComponent(), "setDragEnabled", true);
        }
        super.installDefaults();
    }

    protected void uninstallDefaults() {
        if (QuaquaUtilities.isHeadless()) {
            Methods.invokeIfExists((Object)this.getComponent(), "setDragEnabled", this.oldDragState);
        }
        super.uninstallDefaults();
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        if (this.focusListener != null) {
            this.getComponent().addFocusListener(this.focusListener);
        }
        this.popupListener = this.createPopupListener();
        if (this.popupListener != null) {
            this.getComponent().addMouseListener(this.popupListener);
        }
        super.installListeners();
    }

    protected void uninstallListeners() {
        if (this.focusListener != null) {
            this.getComponent().removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.popupListener != null) {
            this.getComponent().removeMouseListener(this.popupListener);
            this.popupListener = null;
        }
        super.uninstallListeners();
    }

    protected FocusListener createFocusListener() {
        return Quaqua14TextFieldFocusHandler.getInstance();
    }

    protected MouseListener createPopupListener() {
        return (MouseListener)UIManager.get(this.getPropertyPrefix() + ".popupHandler");
    }

    public EditorKit getEditorKit(JTextComponent tc) {
        return QuaquaTextFieldUI.defaultKit;
    }

    public Insets getVisualMargin(JTextComponent tc) {
        Insets margin = (Insets)tc.getClientProperty("Quaqua.Component.visualMargin");
        if (margin == null) {
            margin = UIManager.getInsets("Component.visualMargin");
        }
        return margin == null ? new Insets(0, 0, 0, 0) : (Insets)margin.clone();
    }

    protected void paintSafely(Graphics g) {
        Object oldHints = QuaquaUtilities.beginGraphics((Graphics2D)g);
        JTextComponent editor = this.getComponent();
        Border border = editor.getBorder();
        if (border != null && border instanceof BackgroundBorder) {
            Border bb = ((BackgroundBorder)border).getBackgroundBorder();
            bb.paintBorder(editor, g, 0, 0, editor.getWidth(), editor.getHeight());
        }
        super.paintSafely(g);
        QuaquaUtilities.endGraphics((Graphics2D)g, oldHints);
        Debug.paint(g, editor, this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if (name.equals("Frame.active")) {
            QuaquaUtilities.repaintBorder(this.getComponent());
        } else if (name.equals("JComponent.sizeVariant")) {
            QuaquaUtilities.applySizeVariant(this.getComponent());
        } else {
            super.propertyChange(event);
        }
    }

    protected Caret createCaret() {
        Window window = SwingUtilities.getWindowAncestor(this.getComponent());
        QuaquaCaret caret = new QuaquaCaret(window, this.getComponent());
        return caret;
    }

    protected Highlighter createHighlighter() {
        return new QuaquaHighlighter();
    }

    protected Keymap createKeymap() {
        String nm = this.getKeymapName();
        Keymap map = JTextComponent.getKeymap(nm);
        if (map == null) {
            Keymap parent = JTextComponent.getKeymap("default");
            map = JTextComponent.addKeymap(nm, parent);
            String prefix = this.getPropertyPrefix();
            Object o = UIManager.get(prefix + ".keyBindings");
            if (o != null && o instanceof JTextComponent.KeyBinding[]) {
                JTextComponent.KeyBinding[] bindings = (JTextComponent.KeyBinding[])o;
                JTextComponent.loadKeymap(map, bindings, this.getComponent().getActions());
            }
        }
        return map;
    }

    public int getBaseline(JComponent c, int width, int height) {
        JTextComponent textComponent = (JTextComponent)c;
        View rootView = textComponent.getUI().getRootView(textComponent);
        if (rootView.getViewCount() > 0) {
            Insets insets = textComponent.getInsets();
            int h = height - insets.top - insets.bottom;
            int y = insets.top;
            View fieldView = rootView.getView(0);
            int vspan = (int)fieldView.getPreferredSpan(1);
            if (height != vspan) {
                int slop = h - vspan;
                y += slop / 2;
            }
            FontMetrics fm = textComponent.getFontMetrics(textComponent.getFont());
            return y += fm.getAscent();
        }
        return -1;
    }

    public Rectangle getVisualBounds(JComponent c, int type, int width, int height) {
        Rectangle bounds = new Rectangle(0, 0, width, height);
        if (type == 0) {
            return bounds;
        }
        JTextComponent b = (JTextComponent)c;
        if (type == 1 && b.getBorder() != null) {
            Border border = b.getBorder();
            if (border instanceof UIResource) {
                InsetsUtil.subtractInto(this.getVisualMargin(b), bounds);
                --bounds.height;
            }
        } else {
            bounds = this.getVisibleEditorRect();
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int baseline = this.getBaseline(b, width, height);
            Rectangle textBounds = Fonts.getPerceivedBounds(b.getText(), b.getFont(), c);
            if (bounds == null) {
                bounds = textBounds;
                bounds.y += baseline;
            } else {
                bounds.y = baseline + textBounds.y;
                bounds.height = textBounds.height;
            }
        }
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize(JComponent c) {
        Document doc = ((JTextComponent)c).getDocument();
        Insets i = c.getInsets();
        Dimension d = c.getSize();
        View rootView = this.getRootView((JTextComponent)c);
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            if (d.width > i.left + i.right && d.height > i.top + i.bottom) {
                rootView.setSize(d.width - i.left - i.right, d.height - i.top - i.bottom);
            } else if (d.width == 0 && d.height == 0) {
                rootView.setSize(2.1474836E9f, 2.1474836E9f);
            }
            d.width = (int)Math.min((long)rootView.getPreferredSpan(0) + (long)i.left + (long)i.right, Integer.MAX_VALUE);
            d.height = (int)Math.min((long)rootView.getPreferredSpan(1) + (long)i.top + (long)i.bottom, Integer.MAX_VALUE);
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        d.width += 2;
        return d;
    }
}

