/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.JBrowser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.CellRendererPane;
import javax.swing.JScrollBar;
import javax.swing.JViewport;

public class JBrowserViewport
extends JViewport {
    private static JScrollBar scrollBarRenderer = new JScrollBar(1, 0, 1, 0, 1){

        public boolean isShowing() {
            return true;
        }

        protected void paintChildren(Graphics g) {
            Component[] c = this.getComponents();
            for (int i = 0; i < c.length; ++i) {
                Graphics cg = g.create(c[i].getX(), c[i].getY(), c[i].getWidth(), c[i].getHeight());
                c[i].paint(cg);
                cg.dispose();
            }
        }
    };
    private static CellRendererPane cellRendererPane = new CellRendererPane();

    public void paintComponent(Graphics g) {
        JBrowser browser;
        if (this.getView() instanceof JBrowser && (browser = (JBrowser)this.getView()) != null) {
            Dimension vs = this.getSize();
            Dimension bs = browser.getSize();
            Point p = browser.getLocation();
            Dimension ss = scrollBarRenderer.getPreferredSize();
            if (bs.width < vs.width) {
                int fixedCellWidth = browser.getFixedCellWidth();
                g.setColor(browser.getBackground());
                g.fillRect(bs.width, 0, vs.width - bs.width, vs.height);
                scrollBarRenderer.setSize(ss.width, vs.height);
                scrollBarRenderer.doLayout();
                for (int x = browser.getWidth() + fixedCellWidth; x < vs.width; x += fixedCellWidth + ss.width) {
                    cellRendererPane.paintComponent(g, scrollBarRenderer, this, x, 0, ss.width, vs.height, false);
                }
            }
        }
    }
}

