/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.BrowserCellRenderer;
import ch.randelshofer.quaqua.JBrowser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class DefaultBrowserCellRenderer
extends JLabel
implements BrowserCellRenderer {
    private JBrowser browser;
    protected boolean selected;
    protected boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    private boolean drawDashedFocusIndicator;
    private Color treeBGColor;
    private Color focusBGColor;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    public DefaultBrowserCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        Object value = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = value != null && (Boolean)value != false;
        value = UIManager.get("Tree.drawDashedFocusIndicator");
        this.drawDashedFocusIndicator = value != null && (Boolean)value != false;
        this.setBorder(null);
    }

    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    public void setOpenIcon(Icon newIcon) {
        this.openIcon = newIcon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon newIcon) {
        this.closedIcon = newIcon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon newIcon) {
        this.leafIcon = newIcon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color newColor) {
        this.textSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.textNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.backgroundNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.browser != null) {
            font = this.browser.getFont();
        }
        return font;
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public Component getBrowserCellRendererComponent(JBrowser browser, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = browser.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.browser = browser;
        this.hasFocus = hasFocus;
        this.setText(stringValue);
        if (sel) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (!browser.isEnabled()) {
            this.setEnabled(false);
            if (leaf) {
                this.setDisabledIcon(this.getLeafIcon());
            } else if (expanded) {
                this.setDisabledIcon(this.getOpenIcon());
            } else {
                this.setDisabledIcon(this.getClosedIcon());
            }
        } else {
            this.setEnabled(true);
            if (leaf) {
                this.setIcon(this.getLeafIcon());
            } else if (expanded) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
        }
        this.setComponentOrientation(browser.getComponentOrientation());
        this.selected = sel;
        return this;
    }

    public void paint(Graphics g) {
        Color bColor;
        if (this.selected) {
            bColor = this.getBackgroundSelectionColor();
        } else {
            bColor = this.getBackgroundNonSelectionColor();
            if (bColor == null) {
                bColor = this.getBackground();
            }
        }
        int imageOffset = -1;
        if (bColor != null) {
            Icon currentI = this.getIcon();
            imageOffset = this.getLabelStart();
            g.setColor(bColor);
            if (this.getComponentOrientation().isLeftToRight()) {
                g.fillRect(imageOffset, 0, this.getWidth() - imageOffset, this.getHeight());
            } else {
                g.fillRect(0, 0, this.getWidth() - imageOffset, this.getHeight());
            }
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                imageOffset = 0;
            } else if (imageOffset == -1) {
                imageOffset = this.getLabelStart();
            }
            if (this.getComponentOrientation().isLeftToRight()) {
                this.paintFocus(g, imageOffset, 0, this.getWidth() - imageOffset, this.getHeight());
            } else {
                this.paintFocus(g, 0, 0, this.getWidth() - imageOffset, this.getHeight());
            }
        }
        super.paint(g);
    }

    private void paintFocus(Graphics g, int x, int y, int w, int h) {
        Color bsColor = this.getBorderSelectionColor();
        if (bsColor != null && (this.selected || !this.drawDashedFocusIndicator)) {
            g.setColor(bsColor);
            g.drawRect(x, y, w - 1, h - 1);
        }
        if (this.drawDashedFocusIndicator) {
            Color color;
            if (this.selected) {
                color = this.getBackgroundSelectionColor();
            } else {
                color = this.getBackgroundNonSelectionColor();
                if (color == null) {
                    color = this.getBackground();
                }
            }
            if (this.treeBGColor != color) {
                this.treeBGColor = color;
                this.focusBGColor = new Color(~color.getRGB());
            }
            g.setColor(this.focusBGColor);
            BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
        }
    }

    private int getLabelStart() {
        Icon currentI = this.getIcon();
        if (currentI != null && this.getText() != null) {
            return currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height);
        }
        return retDimension;
    }

    public void validate() {
    }

    public void invalidate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    public void repaint() {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

