/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <dpmi.h>
#include <llp.h>

extern int _stacktop;

static unsigned oldcr0;
unsigned hasfloat;

#pragma startup llfpini 149
		
static void raise16(void)
{
	__clearxcept();
		asm mov esp,[_stacktop]
  asm sti
		fprintf(stderr,"\nFloating point exception");
		exit(EXIT_FAILURE);
}
static void raise7(void)
{
	__clearxcept();
		asm mov esp,[_stacktop]
  	asm sti
		fprintf(stderr,"\nFloating point emulation not supported under DOS");
		exit(EXIT_FAILURE);
}
static void llfpini(void)
{
	short work;

	work = 0x4567;

  asm fninit
  asm fnstsw [work]	
	if (work == 0) {
		/* have fpu coprocessor */
		asm fninit
    asm fwait
		asm fstcw [work]
		work &= 0xffbb;
		asm fldcw [work]
		hasfloat++;
		__setxcept(16,raise16);
	}
	else {
		/* need emulator */
		__setxcept(7,raise7);
	}
}