; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
; opcodes.asm
;
; Locate the opcode table entry for a given opcode byte
; ALSO, locate the opcode table entries for a given mnemonic
;
	.386p
	;MASM MODE
	.model small
include  opcodes.asi
include  opcom.ase

	PUBLIC	FindOpcode
	PUBLIC	mnemonicMatchCount
	PUBLIC	mnemonicMatchAddrTable
	PUBLIC	LookupOpName
	public  x86pfx

	.data

x86pfx	db	0
;
; Following is a table of opcodes.  Each entry consists of a mask value,
; a comparison value, a pointer to the name, the addressing mode to be
; used in dissassembly, and the base length of the instruction (possibly
; modified by the exact addressing mode encountered)
;
; added two new bytes: first is evalutation flags, second is unused
;
;  The groups are selected based on the high order 3 bits of the first
;  byte of the opcode, which are translated into a table offset. These
;  bits probably encode something that all opcodes have in common if the
;  high order 3 bits are the same, but I don't know what it might be.
;	In any case, from the lookup logic, it appears that these structures
;  are broken into groups only for performance, which is hardly necessary
;  since this program won't run on anything less than a P24T - it has a
;  CPUID instruction in it.
	align

group000xxxxx	label	byte
	OPCODE	<0FCh,0,opn_add,OP_REGRMREG,2,0,0>	;ADD RM
	OPCODE	<0e7h,06h,opn_push,OP_SEG35,1,0,0>	;PUSH
	OPCODE	<0feh,04h,opn_add,OP_ACCIMM,1,0,0>	;ADD immediate
	OPCODE	<0e7h,07h,opn_pop,OP_SEG35,1,0,0>	;POP
	OPCODE	<0fch,08h,opn_or,OP_REGRMREG,2,0,0>	;OR RM
	OPCODE	<0feh,0ch,opn_or,OP_ACCIMM,1,0,0>	;OR immediate
	OPCODE	<0fch,010h,opn_adc,OP_REGRMREG,2,0,0>	;ADC RM
	OPCODE	<0feh,014h,opn_adc,OP_ACCIMM,1,0,0>	;ADC immediate
	OPCODE	<0fch,018h,opn_sbb,OP_REGRMREG,2,0,0>	;SBB RM
	OPCODE	<0feh,01ch,opn_sbb,OP_ACCIMM,1,0,0>	;SBB immediate
	OPCODE	<0,0,0,0,0,0,0>				;group terminator

group001xxxxx	label	byte
	OPCODE	<0fch,020h,opn_and,OP_REGRMREG,2,0,0>	;AND RM
	OPCODE	<0feh,024h,opn_and,OP_ACCIMM,1,0,0>	;AND immediate
	OPCODE	<0ffh,027h,opn_daa,OP_CODEONLY,1,0,0>	;DAA
	OPCODE	<0fch,028h,opn_sub,OP_REGRMREG,2,0,0>	;SUB RM
	OPCODE	<0feh,02ch,opn_sub,OP_ACCIMM,1,0,0>	;SUB immediate
	OPCODE	<0ffh,02fh,opn_das,OP_CODEONLY,1,0,0>	;DAS
	OPCODE	<0fch,030h,opn_xor,OP_REGRMREG,2,0,0>	;XOR RM
	OPCODE	<0feh,034h,opn_xor,OP_ACCIMM,1,0,0>	;XOR immediate
	OPCODE	<0ffh,037h,opn_aaa,OP_CODEONLY,1,0,0>	;AAA
	OPCODE	<0fch,038h,opn_cmp,OP_REGRMREG,2,0,0>	;CMP RM
	OPCODE	<0feh,03ch,opn_cmp,OP_ACCIMM,1,0,0>	;CMP immediate
	OPCODE	<0ffh,03fh,opn_aas,OP_CODEONLY,1,0,0>	;AAS
	OPCODE	<0,0,0,0,0,0,0>				;group terminator

group010xxxxx	label	byte
	OPCODE	<0f8h,040h,opn_inc,OP_WREG02,1,0,0>	;INC
	OPCODE	<0f8h,048h,opn_dec,OP_WREG02,1,0,0>	;DEC
	OPCODE	<0f8h,050h,opn_push,OP_WREG02,1,0,0>	;PUSH
	OPCODE	<0f8h,058h,opn_pop,OP_WREG02,1,0,0>	;POP
	OPCODE	<0,0,0,0,0,0,0>				;group terminator

group011xxxxx	label	byte
	OPCODE	<0ffh,060h,opn_pushad,OP_INSWORDSIZE,1,1,0>	;PUSHA
	OPCODE	<0ffh,061h,opn_popad,OP_INSWORDSIZE,1,1,0>	;POPA
	OPCODE	<0ffh,062h,opn_bound,OP_WORDREGRM,2,1,0>	;BOUND
	OPCODE	<0ffh,063h,opn_arpl,OP_WORDRMREG,2,1,0>		;ARPL
	OPCODE	<0fdh,068h,opn_push,OP_IMM,1,1,0>		;PUSH imm
	OPCODE	<0fdh,069h,opn_imul,OP_IMUL,2,0,0>		;IMUL
	OPCODE	<0ffh,06ch,opn_insb,OP_CODEONLY,1,1,0>		;INSB
	OPCODE	<0ffh,06dh,opn_ins,OP_INSWORDSIZE,1,1,0>	;INS
	OPCODE	<0ffh,06eh,opn_outsb,OP_CODEONLY,1,1,0>		;OUTSB
	OPCODE	<0ffh,06fh,opn_outs,OP_INSWORDSIZE,1,1,0>	;OUTS
	OPCODE	<0ffh,070h,opn_jo,OP_SHORTBRANCH,2,0,0>		;JO
	OPCODE	<0ffh,071h,opn_jno,OP_SHORTBRANCH,2,0,0>	;JNO
	OPCODE	<0ffh,072h,opn_jb,OP_SHORTBRANCH,2,0,0>		;JB
	OPCODE	<0ffh,073h,opn_jnb,OP_SHORTBRANCH,2,0,0>	;JNB
	OPCODE	<0ffh,074h,opn_jz,OP_SHORTBRANCH,2,0,0>		;JZ
	OPCODE	<0ffh,075h,opn_jnz,OP_SHORTBRANCH,2,0,0>	;JNZ
	OPCODE	<0ffh,076h,opn_jbe,OP_SHORTBRANCH,2,0,0>	;JBE
	OPCODE	<0ffh,077h,opn_ja,OP_SHORTBRANCH,2,0,0>		;JA
	OPCODE	<0ffh,078h,opn_js,OP_SHORTBRANCH,2,0,0>		;JS
	OPCODE	<0ffh,079h,opn_jns,OP_SHORTBRANCH,2,0,0>	;JNS
	OPCODE	<0ffh,07ah,opn_jp,OP_SHORTBRANCH,2,0,0>		;JP
	OPCODE	<0ffh,07bh,opn_jnp,OP_SHORTBRANCH,2,0,0>	;JNP
	OPCODE	<0ffh,07ch,opn_jl,OP_SHORTBRANCH,2,0,0>		;JL
	OPCODE	<0ffh,07dh,opn_jge,OP_SHORTBRANCH,2,0,0>	;JGE
	OPCODE	<0ffh,07eh,opn_jle,OP_SHORTBRANCH,2,0,0>	;JLE
	OPCODE	<0ffh,07fh,opn_jg,OP_SHORTBRANCH,2,0,0>		;JG
	OPCODE	<0,0,0,0,0,0,0>					;terminator

group100xxxxx	label	byte
	OPCODE	<038fch,080h,opn_add,OP_RMIMMSIGNED,2,0,0>	;ADD
	OPCODE	<038feh,0880h,opn_or,OP_RMIMMSIGNED,2,0,0>	;OR
	OPCODE	<038fch,0880h,opn_or,OP_RMIMMSIGNED,2,0,0>	;OR
	OPCODE	<038fch,01080h,opn_adc,OP_RMIMMSIGNED,2,0,0>	;ADC
	OPCODE	<038fch,01880h,opn_sbb,OP_RMIMMSIGNED,2,0,0>	;SBB
	OPCODE	<038feh,02080h,opn_and,OP_RMIMMSIGNED,2,0,0>	;AND
	OPCODE	<038fch,02080h,opn_and,OP_RMIMMSIGNED,2,0,0>	;AND
	OPCODE	<038fch,02880h,opn_sub,OP_RMIMMSIGNED,2,0,0>	;SUB
	OPCODE	<038feh,03080h,opn_xor,OP_RMIMMSIGNED,2,0,0>	;XOR
	OPCODE	<038fch,03080h,opn_xor,OP_RMIMMSIGNED,2,0,0>	;XOR
	OPCODE	<038fch,03880h,opn_cmp,OP_RMIMMSIGNED,2,0,0>	;CMP
	OPCODE	<0feh,084h,opn_test,OP_REGMOD,2,0,0>		;TEST
	OPCODE	<0feh,086h,opn_xchg,OP_REGRM,2,0,0>		;XCHG
	OPCODE	<0fch,088h,opn_mov,OP_REGRMREG,2,0,0>		;MOV
	OPCODE	<020fdh,08ch,opn_mov,OP_SEGRMSEG,2,0,0>		;MOV
	OPCODE	<0fdh,08ch,opn_mov,OP_SEGRMSEG,2,0,0>		;MOV
	OPCODE	<0ffh,08dh,opn_lea,OP_WORDREGRM,2,0,0>		;LEA
	OPCODE	<038ffh,08fh,opn_pop,OP_PUSHW,2,0,0>		;POP
	OPCODE	<0ffh,090h,opn_nop,OP_CODEONLY,1,0,0>		;NOP
	OPCODE	<0f8h,090h,opn_xchg,OP_ACCREG02,1,0,0>		;XCHG
	OPCODE	<0ffh,098h,opn_cbw,OP_CBW,1,0,0>		;CBW
	OPCODE	<0ffh,099h,opn_cwd,OP_CODEONLY,1,0,0>		;CWD
	OPCODE	<0ffh,09ah,opn_call,OP_SEGBRANCH,5,0,0>		;CALL
	OPCODE	<0ffh,09bh,opn_wait,OP_CODEONLY,1,0,0>		;WAIT
	OPCODE	<0ffh,09ch,opn_pushfd,OP_INSWORDSIZE,1,0,0>	;PUSHF
	OPCODE	<0ffh,09dh,opn_popfd,OP_INSWORDSIZE,1,0,0>	;POPF
	OPCODE	<0ffh,09eh,opn_sahf,OP_CODEONLY,1,0,0>		;SAHF
	OPCODE	<0ffh,09fh,opn_lahf,OP_CODEONLY,1,0,0>		;LAHF
	OPCODE	<0,0,0,0,0,0,0>					;terminator

group101xxxxx	label	byte
	OPCODE	<0feh,0a0h,opn_mov,OP_ACCABS,3,0,0>		;MOV
	OPCODE	<0feh,0a2h,opn_mov,OP_ABSACC,3,0,0>		;MOV
	OPCODE	<0ffh,0a5h,opn_movs,OP_INSWORDSIZE,1,0,0>	;MOVS
	OPCODE	<0ffh,0a7h,opn_cmps,OP_INSWORDSIZE,1,0,0>	;CMPS
	OPCODE	<0feh,0a8h,opn_test,OP_ACCIMM,1,0,0>		;TEST
	OPCODE	<0ffh,0abh,opn_stos,OP_INSWORDSIZE,1,0,0>	;STOS
	OPCODE	<0ffh,0adh,opn_lods,OP_INSWORDSIZE,1,0,0>	;LODS
	OPCODE	<0ffh,0afh,opn_scas,OP_INSWORDSIZE,1,0,0>	;SCAS
	OPCODE	<0ffh,0a4h,opn_movsb,OP_CODEONLY,1,0,0>		;MOVSB
	OPCODE	<0ffh,0a6h,opn_cmpsb,OP_CODEONLY,1,0,0>		;CMPSB
	OPCODE	<0ffh,0aah,opn_stosb,OP_CODEONLY,1,0,0>		;STOSB
	OPCODE	<0ffh,0ach,opn_lodsb,OP_CODEONLY,1,0,0>		;LODSB
	OPCODE	<0ffh,0aeh,opn_scasb,OP_CODEONLY,1,0,0>		;SCASB
	OPCODE	<0f0h,0b0h,opn_mov,OP_ACCIMMB3,1,0,0>		;MOV
	OPCODE	<0,0,0,0,0,0,0>					;terminator

group110xxxxx	label	byte
	OPCODE	<038feh,0c0h,opn_rol,OP_RMSHIFT,2,1,0>		;ROL
	OPCODE	<038feh,08c0h,opn_ror,OP_RMSHIFT,2,1,0>		;ROR
	OPCODE	<038feh,010c0h,opn_rcl,OP_RMSHIFT,2,1,0>	;RCL
	OPCODE	<038feh,018c0h,opn_rcr,OP_RMSHIFT,2,1,0>	;RCR
	OPCODE	<038feh,020c0h,opn_shl,OP_RMSHIFT,2,1,0>	;SHL
	OPCODE	<038feh,028c0h,opn_shr,OP_RMSHIFT,2,1,0>	;SHR
	OPCODE	<038feh,038c0h,opn_sar,OP_RMSHIFT,2,1,0>	;SAR
	OPCODE	<0ffh,0c2h,opn_ret,OP_RET,3,0,0>		;RET
	OPCODE	<0ffh,0c3h,opn_ret,OP_CODEONLY,1,0,0>		;RET
	OPCODE	<0ffh,0c4h,opn_les,OP_WORDREGRM,2,0,0>		;LES
	OPCODE	<0ffh,0c5h,opn_lds,OP_WORDREGRM,2,0,0>		;LDS
	OPCODE	<038feh,0c6h,opn_mov,OP_RMIMM,2,0,0>		;MOV
	OPCODE	<0ffh,0c8h,opn_enter,OP_ENTER,4,1,0>		;ENTER
	OPCODE	<0ffh,0cah,opn_retf,OP_RET,3,0,0>		;RETF
	OPCODE	<0ffh,0cbh,opn_retf,OP_CODEONLY,1,0,0>		;RETF
	OPCODE	<0ffh,0cch,opn_int,OP_INTR,1,0,0>		;INT
	OPCODE	<0ffh,0cdh,opn_int,OP_INTR,2,0,0>		;INT
	OPCODE	<0ffh,0ceh,opn_into,OP_CODEONLY,1,0,0>		;INTO
	OPCODE	<0ffh,0cfh,opn_iret,OP_CODEONLY,1,0,0>		;IRET
	OPCODE	<0ffh,0c9h,opn_leave,OP_CODEONLY,1,1,0>		;LEAVE
	OPCODE	<038fch,0d0h,opn_rol,OP_RMSHIFT,2,0,0>		;ROL
	OPCODE	<038fch,08d0h,opn_ror,OP_RMSHIFT,2,0,0>		;ROR
	OPCODE	<038fch,010d0h,opn_rcl,OP_RMSHIFT,2,0,0>	;RCL
	OPCODE	<038fch,018d0h,opn_rcr,OP_RMSHIFT,2,0,0>	;RCR
	OPCODE	<038fch,020d0h,opn_shl,OP_RMSHIFT,2,0,0>	;SHL
	OPCODE	<038fch,028d0h,opn_shr,OP_RMSHIFT,2,0,0>	;SHR
	OPCODE	<038fch,038d0h,opn_sar,OP_RMSHIFT,2,0,0>	;SAR
	OPCODE	<0ffffh,0ad4h,opn_aam,OP_CODEONLY,2,0,0>	;AAM
	OPCODE	<0ffffh,0ad5h,opn_aad,OP_CODEONLY,2,0,0>	;AAD
	OPCODE	<0ffh,0d7h,opn_xlat,OP_CODEONLY,1,0,0>		;XLAT
	OPCODE	<0,0,0,0,0,0,0>

group111xxxxx	label	byte
	OPCODE	<0ffh,0e0h,opn_loopnz,OP_SHORTBRANCH,2,0,0>	;LOOPNZ
	OPCODE	<0ffh,0e1h,opn_loopz,OP_SHORTBRANCH,2,0,0>	;LOOPZ
	OPCODE	<0ffh,0e2h,opn_loop,OP_SHORTBRANCH,2,0,0>	;LOOP
	OPCODE	<0ffh,0e3h,opn_jcxz,OP_SHORTBRANCH,2,0,0>	;JCXZ
	OPCODE	<0feh,0e4h,opn_in,OP_PORTACCPORT,2,0,0>		;IN
	OPCODE	<0feh,0e6h,opn_out,OP_PORTACCPORT,2,0,0>	;OUT
	OPCODE	<0ffh,0e8h,opn_call,OP_BRANCH,3,0,0>		;CALL
	OPCODE	<0ffh,0e9h,opn_jmp,OP_BRANCH,3,0,0>		;JMP
	OPCODE	<0ffh,0eah,opn_jmp,OP_SEGBRANCH,5,0,0>		;JMP
	OPCODE	<0ffh,0ebh,opn_jmp,OP_SHORTBRANCH,2,0,0>	;JMP
	OPCODE	<0feh,0ech,opn_in,OP_ACCDX,1,0,0>		;IN
	OPCODE	<0feh,0eeh,opn_out,OP_DXACC,1,0,0>		;OUT
	OPCODE	<0ffh,0f0h,opn_lock,OP_CODEONLY,1,0,0>		;LOCK
	OPCODE	<0ffh,0f2h,opn_repnz,OP_CODEONLY,1,0,0>		;REPNZ
	OPCODE	<0ffh,0f3h,opn_repz,OP_CODEONLY,1,0,0>		;REPZ
	OPCODE	<0ffh,0f4h,opn_hlt,OP_CODEONLY,1,0,0>		;HLT
	OPCODE	<0ffh,0f5h,opn_cmc,OP_CODEONLY,1,0,0>		;CMC
	OPCODE	<038feh,0f6h,opn_test,OP_RMIMM,2,0,0>		;TEST
	OPCODE	<038feh,010f6h,opn_not,OP_RM ,2,0,0>		;NOT
	OPCODE	<038feh,018f6h,opn_neg,OP_RM ,2,0,0>		;NEG
	OPCODE	<038feh,020f6h,opn_mul,OP_RM ,2,0,0>		;MUL
	OPCODE	<038feh,028f6h,opn_imul,OP_RM ,2,0,0>		;IMUL
	OPCODE	<038feh,030f6h,opn_div,OP_RM ,2,0,0>		;DIV
	OPCODE	<038feh,038f6h,opn_idiv,OP_RM ,2,0,0>		;IDIV
	OPCODE	<0ffh,0f8h,opn_clc,OP_CODEONLY,1,0,0>		;CLC
	OPCODE	<0ffh,0f9h,opn_stc,OP_CODEONLY,1,0,0>		;STC
	OPCODE	<0ffh,0fah,opn_cli,OP_CODEONLY,1,0,0>		;CLI
	OPCODE	<0ffh,0fbh,opn_sti,OP_CODEONLY,1,0,0>		;STI
	OPCODE	<0ffh,0fch,opn_cld,OP_CODEONLY,1,0,0>		;CLD
	OPCODE	<0ffh,0fdh,opn_std,OP_CODEONLY,1,0,0>		;STD
	OPCODE	<038feh,0feh,opn_inc,OP_RM ,2,0,0>		;INC
	OPCODE	<038feh,08feh,opn_dec,OP_RM ,2,0,0>		;DEC
	OPCODE	<038ffh,010ffh,opn_call,OP_RM ,2,0,0>		;CALL
	OPCODE	<038ffh,018ffh,opn_call,OP_FARRM ,2,0,0>	;CALL
	OPCODE	<038ffh,020ffh,opn_jmp,OP_RM ,2,0,0>		;JMP
	OPCODE	<038ffh,028ffh,opn_jmp,OP_FARRM ,2,0,0>		;JMP
	OPCODE	<038ffh,030ffh,opn_push,OP_PUSHW,2,0,0>		;PUSH
	OPCODE	<0,0,0,0,0,0,0>

groupx386	label	byte
	OPCODE	<0feh,0beh,opn_movsx,OP_MIXEDREGRM,2,3,0>	;MOVSX
	OPCODE	<0feh,0b6h,opn_movzx,OP_MIXEDREGRM,2,3,0>	;MOVZX
	OPCODE	<0f8h,0c8h,opn_bswap,OP_BSWAP,1,3,0>		;BSWAP
	OPCODE	<0f7h,0a0h,opn_push,OP_SEG35,1,3,0>		;PUSH
	OPCODE	<0f7h,0a1h,opn_pop,OP_SEG35,1,3,0>		;POP
	OPCODE	<0ffh,0b4h,opn_lfs,OP_WORDREGRM,2,3,0>		;LFS
	OPCODE	<0ffh,0b5h,opn_lgs,OP_WORDREGRM,2,3,0>		;LGS
	OPCODE	<0ffh,0b2h,opn_lss,OP_WORDREGRM,2,3,0>		;LSS
	OPCODE	<0ffh,06h,opn_clts,OP_CODEONLY,1,3,0>		;CLTS
	OPCODE	<0ffh,08h,opn_invd,OP_CODEONLY,1,3,0>		;INVD
	OPCODE	<0ffh,09h,opn_wbinvd,OP_CODEONLY,1,3,0>		;WBINVD
	OPCODE	<0ffh,0afh,opn_imul,OP_WORDREGRM,2,3,0>		;IMUL
	OPCODE	<0ffh,0a4h,opn_shld,OP_REGRMSHIFT,3,3,0>	;SHLD
	OPCODE	<0ffh,0a5h,opn_shld,OP_REGRMSHIFT,2,3,0>	;SHLD
	OPCODE	<0ffh,0ach,opn_shrd,OP_REGRMSHIFT,3,3,0>	;SHRD
	OPCODE	<0ffh,0adh,opn_shrd,OP_REGRMSHIFT,2,3,0>	;SHRD
	OPCODE	<0ffh,0bch,opn_bsf,OP_WORDREGRM,2,3,0>		;BSF
	OPCODE	<0ffh,0bdh,opn_bsr,OP_WORDREGRM,2,3,0>		;BSR
	OPCODE	<0ffh,0a3h,opn_bt,OP_WORDRMREG,2,3,0>		;BT
	OPCODE	<0ffh,0abh,opn_bts,OP_WORDRMREG,2,3,0>		;BTS
	OPCODE	<0ffh,0b3h,opn_btr,OP_WORDRMREG,2,3,0>		;BTR
	OPCODE	<0ffh,0bbh,opn_btc,OP_WORDRMREG,2,3,0>		;BTC
	OPCODE	<0ffh,040h,opn_cmovo,OP_WORDREGRM,2,3,0>	;CMOVO
	OPCODE	<0ffh,041h,opn_cmovno,OP_WORDREGRM,2,3,0>	;CMOVNO
	OPCODE	<0ffh,042h,opn_cmovb,OP_WORDREGRM,2,3,0>	;CMOVB
	OPCODE	<0ffh,043h,opn_cmovnb,OP_WORDREGRM,2,3,0>	;CMOVNB
	OPCODE	<0ffh,044h,opn_cmovz,OP_WORDREGRM,2,3,0>	;CMOVZ
	OPCODE	<0ffh,045h,opn_cmovnz,OP_WORDREGRM,2,3,0>	;CMOVNZ
	OPCODE	<0ffh,046h,opn_cmovbe,OP_WORDREGRM,2,3,0>	;CMOVBE
	OPCODE	<0ffh,047h,opn_cmova,OP_WORDREGRM,2,3,0>	;CMOVA
	OPCODE	<0ffh,048h,opn_cmovs,OP_WORDREGRM,2,3,0>	;CMOVS
	OPCODE	<0ffh,049h,opn_cmovns,OP_WORDREGRM,2,3,0>	;CMOVNS
	OPCODE	<0ffh,04ah,opn_cmovp,OP_WORDREGRM,2,3,0>	;CMOVP
	OPCODE	<0ffh,04bh,opn_cmovnp,OP_WORDREGRM,2,3,0>	;CMOVNP
	OPCODE	<0ffh,04ch,opn_cmovl,OP_WORDREGRM,2,3,0>	;CMOVL
	OPCODE	<0ffh,04dh,opn_cmovge,OP_WORDREGRM,2,3,0>	;CMOVGE
	OPCODE	<0ffh,04eh,opn_cmovle,OP_WORDREGRM,2,3,0>	;CMOVLE
	OPCODE	<0ffh,04fh,opn_cmovg,OP_WORDREGRM,2,3,0>	;CMOVG
	OPCODE	<038ffh,020bah,opn_bt,OP_BITNUM,3,3,0>		;BT
	OPCODE	<038ffh,028bah,opn_bts,OP_BITNUM,3,3,0>		;BTS
	OPCODE	<038ffh,030bah,opn_btr,OP_BITNUM,3,3,0>		;BTR
	OPCODE	<038ffh,038bah,opn_btc,OP_BITNUM,3,3,0>		;BTC
	OPCODE	<0ffh,0a7h,opn_ibts,OP_CODEONLY,1,3,0>		;IBTS
	OPCODE	<0ffh,0aah,opn_rsm,OP_CODEONLY,1,3,0>		;RSM
	OPCODE	<0ffh,0a6h,opn_xbts,OP_CODEONLY,1,3,0>		;XBTS
	OPCODE	<0ffh,0a2h,opn_cpuid,OP_CODEONLY,1,3,0>		;CPUID
	OPCODE	<0ffh,080h,opn_jo,OP_BRANCH,3,3,0>		;JO
	OPCODE	<0ffh,081h,opn_jno,OP_BRANCH,3,3,0>		;JNO
	OPCODE	<0ffh,082h,opn_jb,OP_BRANCH,3,3,0>		;JB
	OPCODE	<0ffh,083h,opn_jnb,OP_BRANCH,3,3,0>		;JNB
	OPCODE	<0ffh,084h,opn_jz,OP_BRANCH,3,3,0>		;JZ
	OPCODE	<0ffh,085h,opn_jnz,OP_BRANCH,3,3,0>		;JNZ
	OPCODE	<0ffh,086h,opn_jbe,OP_BRANCH,3,3,0>		;JBE
	OPCODE	<0ffh,087h,opn_ja,OP_BRANCH,3,3,0>		;JA
	OPCODE	<0ffh,088h,opn_js,OP_BRANCH,3,3,0>		;JS
	OPCODE	<0ffh,089h,opn_jns,OP_BRANCH,3,3,0>		;JNS
	OPCODE	<0ffh,08ah,opn_jp,OP_BRANCH,3,3,0>		;JP
	OPCODE	<0ffh,08bh,opn_jnp,OP_BRANCH,3,3,0>		;JNP
	OPCODE	<0ffh,08ch,opn_jl,OP_BRANCH,3,3,0>		;JL
	OPCODE	<0ffh,08dh,opn_jge,OP_BRANCH,3,3,0>		;JGE
	OPCODE	<0ffh,08eh,opn_jle,OP_BRANCH,3,3,0>		;JLE
	OPCODE	<0ffh,08fh,opn_jg,OP_BRANCH,3,3,0>		;JG
	OPCODE	<0ffh,033h,opn_rdtsc,OP_CODEONLY,1,3,0>		;RDTSC
	OPCODE	<0ffh,031h,opn_rdpmc,OP_CODEONLY,1,3,0>		;RDPMC
	OPCODE	<0ffh,032h,opn_rdmsr,OP_CODEONLY,1,3,0>		;RDMSR
	OPCODE	<0ffh,030h,opn_wrmsr,OP_CODEONLY,1,3,0>		;WRMSR
	OPCODE	<038ffh,090h,opn_seto,OP_NOSTRICTRM ,2,3,0>	;SETO
	OPCODE	<038ffh,091h,opn_setno,OP_NOSTRICTRM ,2,3,0>	;SETNO
	OPCODE	<038ffh,092h,opn_setb,OP_NOSTRICTRM ,2,3,0>	;SETB
	OPCODE	<038ffh,093h,opn_setnb,OP_NOSTRICTRM ,2,3,0>	;SETNB
	OPCODE	<038ffh,094h,opn_setz,OP_NOSTRICTRM ,2,3,0>	;SETZ
	OPCODE	<038ffh,095h,opn_setnz,OP_NOSTRICTRM ,2,3,0>	;SETNZ
	OPCODE	<038ffh,096h,opn_setbe,OP_NOSTRICTRM ,2,3,0>	;SETBE
	OPCODE	<038ffh,097h,opn_seta,OP_NOSTRICTRM ,2,3,0>	;SETA
	OPCODE	<038ffh,098h,opn_sets,OP_NOSTRICTRM ,2,3,0>	;SETS
	OPCODE	<038ffh,099h,opn_setns,OP_NOSTRICTRM ,2,3,0>	;SETNS
	OPCODE	<038ffh,09ah,opn_setp,OP_NOSTRICTRM ,2,3,0>	;SETP
	OPCODE	<038ffh,09bh,opn_setnp,OP_NOSTRICTRM ,2,3,0>	;SETNP
	OPCODE	<038ffh,09ch,opn_setl,OP_NOSTRICTRM ,2,3,0>	;SETL
	OPCODE	<038ffh,09dh,opn_setge,OP_NOSTRICTRM ,2,3,0>	;SETGE
	OPCODE	<038ffh,09eh,opn_setle,OP_NOSTRICTRM ,2,3,0>	;SETLE
	OPCODE	<038ffh,09fh,opn_setg,OP_NOSTRICTRM ,2,3,0>	;SETG
	OPCODE	<0feh,0c0h,opn_xadd,OP_BYTERMREG,2,3,0>		;XADD
	OPCODE	<0feh,0b0h,opn_cmpxchg,OP_BYTERMREG,2,3,0>	;CMPXCHG
	OPCODE	<0c0fdh,0c020h,opn_mov,OP_386REG,2,3,0>		;MOV
	OPCODE	<0c0fdh,0c021h,opn_mov,OP_386REG,2,3,0>		;MOV
	OPCODE	<0c0fdh,0c024h,opn_mov,OP_386REG,2,3,0>		;MOV
	OPCODE	<0ffh,00bh,opn_ud2,OP_CODEONLY,1,3,0>		;UD2
	OPCODE	<0ffh,02h,opn_lar,OP_WORDREGRM,2,3,0>		;LAR
	OPCODE	<0ffh,03h,opn_lsl,OP_WORDREGRM,2,3,0>		;LSL
	OPCODE	<038ffh,01001h,opn_lgdt,OP_NOSTRICTRM ,2,3,0>	;LGDT
	OPCODE	<038ffh,01801h,opn_lidt,OP_NOSTRICTRM ,2,3,0>	;LIDT
	OPCODE	<038ffh,008c7h,opn_cmpxchg8b,OP_NOSTRICTRM,2,3,0> ;CMPXCHG8B
	OPCODE	<038ffh,01000h,opn_lldt,OP_NOSTRICTRM ,2,3,0>	;LIDT
	OPCODE	<038ffh,03001h,opn_lmsw,OP_NOSTRICTRM ,2,3,0>	;LMSW
	OPCODE	<038ffh,01800h,opn_ltr,OP_NOSTRICTRM ,2,3,0>	;LTR
	OPCODE	<038ffh,01h,opn_sgdt,OP_NOSTRICTRM ,2,3,0>	;SGDT
	OPCODE	<038ffh,0801h,opn_sidt,OP_NOSTRICTRM ,2,3,0>	;SIDT
	OPCODE	<038ffh,00h,opn_sldt,OP_NOSTRICTRM ,2,3,0>	;SLDT
	OPCODE	<038ffh,02001h,opn_smsw,OP_NOSTRICTRM ,2,3,0>	;SMSW
	OPCODE	<038ffh,0800h,opn_str,OP_NOSTRICTRM ,2,3,0>	;STR
	OPCODE	<038ffh,02000h,opn_verr,OP_NOSTRICTRM ,2,3,0>	;VERR
	OPCODE	<038ffh,02800h,opn_verw,OP_NOSTRICTRM ,2,3,0>	;VERW
	OPCODE	<0,0,0,0,0,0,0>

;/* single byte commands */

floats	label	byte
	OPCODE	<0ffffh,0d0d9h,opn_fnop,OP_CODEONLY,2,0,0>	;FNOP
	OPCODE	<0ffffh,0e0d9h,opn_fchs,OP_CODEONLY,2,0,0>	;FCHS
	OPCODE	<0ffffh,0e1d9h,opn_fabs,OP_CODEONLY,2,0,0>	;FABS
	OPCODE	<0ffffh,0e4d9h,opn_ftst,OP_CODEONLY,2,0,0>	;FTST
	OPCODE	<0ffffh,0e5d9h,opn_fxam,OP_CODEONLY,2,0,0>	;FXAM
	OPCODE	<0ffffh,0e8d9h,opn_fld1,OP_CODEONLY,2,0,0>	;FLD1
	OPCODE	<0ffffh,0e9d9h,opn_fldl2t,OP_CODEONLY,2,0,0>	;FLDL2T
	OPCODE	<0ffffh,0ead9h,opn_fldl2e,OP_CODEONLY,2,0,0>	;FLDL2E
	OPCODE	<0ffffh,0ebd9h,opn_fldpi,OP_CODEONLY,2,0,0>	;FLDPI
	OPCODE	<0ffffh,0ecd9h,opn_fldlg2,OP_CODEONLY,2,0,0>	;FLDLG2
	OPCODE	<0ffffh,0edd9h,opn_fldln2,OP_CODEONLY,2,0,0>	;FLDLN2
	OPCODE	<0ffffh,0eed9h,opn_fldz,OP_CODEONLY,2,0,0>	;FLDZ
	OPCODE	<0ffffh,0f0d9h,opn_f2xm1,OP_CODEONLY,2,0,0>	;F2XM1
	OPCODE	<0ffffh,0f1d9h,opn_fyl2x,OP_CODEONLY,2,0,0>	;FYL2X
	OPCODE	<0ffffh,0f2d9h,opn_fptan,OP_CODEONLY,2,0,0>	;FPTAN
	OPCODE	<0ffffh,0f3d9h,opn_fpatan,OP_CODEONLY,2,0,0>	;FPATAN
	OPCODE	<0ffffh,0f5d9h,opn_fprem1,OP_CODEONLY,2,1,0>	;FPREM1
	OPCODE	<0ffffh,0f4d9h,opn_fxtract,OP_CODEONLY,2,0,0>	;FXTRACT
	OPCODE	<0ffffh,0f6d9h,opn_fdecstp,OP_CODEONLY,2,0,0>	;FDECSTP
	OPCODE	<0ffffh,0f7d9h,opn_fincstp,OP_CODEONLY,2,0,0>	;FINCSTP
	OPCODE	<0ffffh,0f8d9h,opn_fprem,OP_CODEONLY,2,0,0>	;FPREM
	OPCODE	<0ffffh,0f9d9h,opn_fyl2xp1,OP_CODEONLY,2,0,0>	;FYL2XP1
	OPCODE	<0ffffh,0fad9h,opn_fsqrt,OP_CODEONLY,2,0,0>	;FSQRT
	OPCODE	<0ffffh,0fbd9h,opn_fsincos,OP_CODEONLY,2,1,0>	;FSINCOS
	OPCODE	<0ffffh,0fcd9h,opn_frndint,OP_CODEONLY,2,0,0>	;FRNDINT
	OPCODE	<0ffffh,0fdd9h,opn_fscale,OP_CODEONLY,2,0,0>	;FSCALE
	OPCODE	<0ffffh,0fed9h,opn_fsin,OP_CODEONLY,2,1,0>	;FSIN
	OPCODE	<0ffffh,0ffd9h,opn_fcos,OP_CODEONLY,2,1,0>	;FCOS
	OPCODE	<0ffffh,0e9dah,opn_fucompp,OP_CODEONLY,2,1,0>	;FUCOMPP
	OPCODE	<0ffffh,0e0dbh,opn_feni,OP_CODEONLY,2,0,0>	;FENI
	OPCODE	<0ffffh,0e1dbh,opn_fdisi,OP_CODEONLY,2,0,0>	;FDISI
	OPCODE	<0ffffh,0e2dbh,opn_fclex,OP_CODEONLY,2,0,0>	;FCLEX
	OPCODE	<0ffffh,0e3dbh,opn_finit,OP_CODEONLY,2,0,0>	;FINIT
	OPCODE	<0ffffh,0e4dbh,opn_fsetpm,OP_CODEONLY,2,0,0>	;FSETPM
	OPCODE	<0ffffh,0d9deh,opn_fcompp,OP_CODEONLY,2,0,0>	;FCOMPP
	OPCODE	<0ffffh,0e0dfh,opn_fnstsw,OP_AX,2,0,0>		;FNSTSW


;  /* Group 1, RM 3 */

	OPCODE	<0f8ffh,0c0d9h,opn_fld,OP_FLD,2,0,0>		;FLD
	OPCODE	<0f8ffh,0c8d9h,opn_fxch,OP_FREGMAYBE,2,0,0>	;FXCH
	OPCODE	<0f8fbh,0d8d9h,opn_fstp,OP_FLD,2,0,0>		;FSTP
	OPCODE	<0c0ffh,0c0d9h,opn_esc,OP_ESC,2,0,0>		;ESC


;  /* Group 1, RM0-2 */

	OPCODE	<038ffh,020d9h,opn_fldenv,OP_FLOATNOPTR,2,0,0>	;FLDENV
	OPCODE	<038ffh,028d9h,opn_fldcw,OP_FLOATNOPTR,2,0,0>	;FLDCW
	OPCODE	<038ffh,030d9h,opn_fnstenv,OP_FLOATNOPTR,2,0,0>	;FNSTENV
	OPCODE	<038ffh,038d9h,opn_fnstcw,OP_FLOATNOPTR,2,0,0>	;FNSTCW
	

;  /* Group 5, RM3 */

	OPCODE	<0f8ffh,0c0ddh,opn_ffree,OP_FREG,2,0,0>		;FFREE
	OPCODE	<0f8ffh,0d0ddh,opn_fst,OP_FST,2,0,0>		;FST
	OPCODE	<0f8ffh,0e0ddh,opn_fucom,OP_FREGMAYBE,2,1,0>	;FUCOM
	OPCODE	<0f8ffh,0e8ddh,opn_fucomp,OP_FREGMAYBE,2,1,0>	;FUCOMP
	OPCODE	<0c0ffh,0c0ddh,opn_esc,OP_ESC,2,0,0>		;ESC


;  /* Group 5, RM0-2 */

	OPCODE	<038ffh,020ddh,opn_frstor,OP_FLOATNOPTR,2,0,0>	;FRSTOR
	OPCODE	<038ffh,030ddh,opn_fnsave,OP_FLOATNOPTR,2,0,0>	;FNSAVE
	OPCODE	<038ffh,038ddh,opn_fnstsw,OP_FLOATNOPTR,2,0,0>	;FNSTSW


;  /* Group 3 & 7*/

	OPCODE	<0c0fbh,0c0dbh,opn_esc,OP_ESC,2,0,0>		;ESC
	OPCODE	<038ffh,028dbh,opn_fld,OP_FLD,2,0,0>		;FLD
	OPCODE	<038ffh,038dbh,opn_fstp,OP_FLD,2,0,0>		;FSTP


;  /* Group 7 */

	OPCODE	<038ffh,020dfh,opn_fbld,OP_FBLD,2,0,0>		;FBLD
	OPCODE	<038ffh,028dfh,opn_fild,OP_FILD,2,0,0>		;FILD
	OPCODE	<038ffh,030dfh,opn_fbstp,OP_FBLD,2,0,0>		;FBSTP
	OPCODE	<038ffh,038dfh,opn_fistp,OP_FIST,2,0,0>		;FISTP


;  /* Math, group 0,2,4,6 special RM 3*/

	OPCODE	<0c0ffh,0c0dah,opn_esc,OP_ESC,2,0,0>		;ESC
	OPCODE	<0f8ffh,0c0deh,opn_faddp,OP_FLOATMATHP,2,0,0>	;FADDP
	OPCODE	<0f8ffh,0c8deh,opn_fmulp,OP_FLOATMATHP,2,0,0>	;FMULP
	OPCODE	<0f8ffh,0d0deh,opn_fcomp,OP_FREG,2,0,0>		;RCOMP
	OPCODE	<0f8ffh,0d8deh,opn_esc,OP_ESC,2,0,0>		;ESC
	OPCODE	<0f8ffh,0e8deh,opn_fsubp,OP_FLOATMATHP,2,0,0>	;FSUBP
	OPCODE	<0f8ffh,0f8deh,opn_fdivp,OP_FLOATMATHP,2,0,0>	;FDIVP
	OPCODE	<0f8ffh,0e0deh,opn_fsubrp,OP_FLOATMATHP,2,0,0>	;FSUBRP
	OPCODE	<0f8ffh,0f0deh,opn_fdivrp,OP_FLOATMATHP,2,0,0>	;FDIVRP


;  /* Math, other */

	OPCODE	<038fbh,0d8h,opn_fadd,OP_FLOATMATH,2,0,0>	;FADD
	OPCODE	<038fbh,08d8h,opn_fmul,OP_FLOATMATH,2,0,0>	;FMUL
	OPCODE	<038fbh,010d8h,opn_fcom,OP_FLOATRM,2,0,0>	;FCOM
	OPCODE	<038fbh,018d8h,opn_fcomp,OP_FLOATRM,2,0,0>	;FCOMP
	OPCODE	<038ffh,020d8h,opn_fsub,OP_FLOATMATH,2,0,0>	;FSUB
	OPCODE	<0f8ffh,0e8dch,opn_fsub,OP_FLOATMATH,2,0,0>	;FSUB
	OPCODE	<038ffh,028dch,opn_fsubr,OP_FLOATMATH,2,0,0>	;FSUBR
	OPCODE	<038ffh,028d8h,opn_fsubr,OP_FLOATMATH,2,0,0>	;FSUBR
	OPCODE	<0f8ffh,0e0dch,opn_fsubr,OP_FLOATMATH,2,0,0>	;FSUBR
	OPCODE	<038ffh,020dch,opn_fsub,OP_FLOATMATH,2,0,0>	;FSUB
	OPCODE	<038ffh,030d8h,opn_fdiv,OP_FLOATMATH,2,0,0>	;FDIV
	OPCODE	<0f8ffh,0f8dch,opn_fdiv,OP_FLOATMATH,2,0,0>	;FDIV
	OPCODE	<038ffh,038dch,opn_fdivr,OP_FLOATMATH,2,0,0>	;FDIVR
	OPCODE	<038ffh,038d8h,opn_fdivr,OP_FLOATMATH,2,0,0>	;FDIVR
	OPCODE	<0f8ffh,0f0dch,opn_fdivr,OP_FLOATMATH,2,0,0>	;FDIVR
	OPCODE	<038ffh,030dch,opn_fdiv,OP_FLOATMATH,2,0,0>	;FDIV
	OPCODE	<038fbh,0dah,opn_fiadd,OP_FLOATIMATH,2,0,0>	;FIADD
	OPCODE	<038fbh,08dah,opn_fimul,OP_FLOATIMATH,2,0,0>	;FIMUL
	OPCODE	<038fbh,010dah,opn_ficom,OP_FLOATIMATH,2,0,0>	;FICOM
	OPCODE	<038fbh,018dah,opn_ficomp,OP_FLOATIMATH,2,0,0>	;FICOMP
	OPCODE	<038fbh,020dah,opn_fisub,OP_FLOATIMATH,2,0,0>	;FISUB
	OPCODE	<038fbh,028dah,opn_fisubr,OP_FLOATIMATH,2,0,0>	;FISUBR
	OPCODE	<038fbh,030dah,opn_fidiv,OP_FLOATIMATH,2,0,0>	;FIDIV
	OPCODE	<038fbh,038dah,opn_fidivr,OP_FLOATIMATH,2,0,0>	;FIDIVR


;  /* groups 1, 3, 5, 7 */
;  /* keep the follwing from going into error, RM3 */

	OPCODE	<0e0f9h,0c0d9h,opn_esc,OP_ESC,2,0,0>		;ESC
	OPCODE	<038fbh,0d9h,opn_fld,OP_FLD,2,0,0>		;FLD
	OPCODE	<038fbh,010d9h,opn_fst,OP_FST,2,0,0>		;FST
	OPCODE	<038fbh,018d9h,opn_fstp,OP_FLD,2,0,0>		;FSTP
	OPCODE	<038fbh,0dbh,opn_fild,OP_FILD,2,0,0>		;FILD
	OPCODE	<038fbh,010dbh,opn_fist,OP_FIST,2,0,0>		;FIST
	OPCODE	<038fbh,018dbh,opn_fistp,OP_FILD,2,0,0>		;FISTP


;  /* Catch- all */

	OPCODE	<0f8h,0d8h,opn_esc,OP_ESC,2,0,0>		;ESC
	OPCODE	<0,0,0,0,0,0,0>
;
; now comes a table used only by the assembler for various aliased
; names
;
synonymTable	label	word

	OPCODE	<0ffh,0d7h,opn_xlatb,OP_CODEONLY,1,0,0>		;XLATB
	OPCODE	<0ffh,0e0h,opn_loopne,OP_SHORTBRANCH,2,0,0>	;LOOPNE
	OPCODE	<0ffh,0e1h,opn_loope,OP_SHORTBRANCH,2,0,0>	;LOOPE
	OPCODE	<0ffh,060h,opn_pusha,OP_OPSIZE1BYTE,1,1,0>	;PUSHAD
	OPCODE	<0ffh,061h,opn_popa,OP_OPSIZE1BYTE,1,1,0>	;POPAD
	OPCODE	<0ffh,09ch,opn_pushf,OP_OPSIZE1BYTE,1,0,0>	;PUSHFD
	OPCODE	<0ffh,09dh,opn_popf,OP_OPSIZE1BYTE,1,0,0>	;POPFD
	OPCODE	<0ffh,0a5h,opn_movsd,OP_CODEONLY,1,0,0>		;MOVSW
	OPCODE	<0ffh,0a7h,opn_cmpsd,OP_CODEONLY,1,0,0>		;CMPSW
	OPCODE	<0ffh,0abh,opn_stosd,OP_CODEONLY,1,0,0>		;STOSW
	OPCODE	<0ffh,0adh,opn_lodsd,OP_CODEONLY,1,0,0>		;LODSW
	OPCODE	<0ffh,0afh,opn_scasd,OP_CODEONLY,1,0,0>		;SCASW
	OPCODE	<0ffh,0a5h,opn_movsw,OP_OPSIZE1BYTE,1,0,0>	;MOVSD
	OPCODE	<0ffh,0a7h,opn_cmpsw,OP_OPSIZE1BYTE,1,0,0>	;CMPSD
	OPCODE	<0ffh,0abh,opn_stosw,OP_OPSIZE1BYTE,1,0,0>	;STOSD
	OPCODE	<0ffh,0adh,opn_lodsw,OP_OPSIZE1BYTE,1,0,0>	;LODSD
	OPCODE	<0ffh,0afh,opn_scasw,OP_OPSIZE1BYTE,1,0,0>	;SCASD
	OPCODE	<0ffh,06dh,opn_insd,OP_CODEONLY,1,1,0>		;INSW
	OPCODE	<0ffh,06dh,opn_insw,OP_OPSIZE1BYTE,1,1,0>	;INSD
	OPCODE	<0ffh,06fh,opn_outsd,OP_CODEONLY,1,1,0>		;OUTSW
	OPCODE	<0ffh,06fh,opn_outsw,OP_OPSIZE1BYTE,1,1,0>	;OUTSD
	OPCODE	<0ffh,072h,opn_jc,OP_SHORTBRANCH,2,0,0>		;JC
	OPCODE	<0ffh,082h,opn_jc,OP_BRANCH,2,3,0>		;JC
	OPCODE	<0ffh,072h,opn_jnae,OP_SHORTBRANCH,2,0,0>	;JNAE
	OPCODE	<0ffh,082h,opn_jnae,OP_BRANCH,2,3,0>		;JNAE
	OPCODE	<0ffh,073h,opn_jnc,OP_SHORTBRANCH,2,0,0>	;JNC
	OPCODE	<0ffh,083h,opn_jnc,OP_BRANCH,2,3,0>		;JNC
	OPCODE	<0ffh,073h,opn_jae,OP_SHORTBRANCH,2,0,0>	;JAE
	OPCODE	<0ffh,083h,opn_jae,OP_BRANCH,2,3,0>		;JAE
	OPCODE	<0ffh,074h,opn_je,OP_SHORTBRANCH,2,0,0>		;JE
	OPCODE	<0ffh,084h,opn_je,OP_BRANCH,2,3,0>		;JE
	OPCODE	<0ffh,075h,opn_jne,OP_SHORTBRANCH,2,0,0>	;JNE
	OPCODE	<0ffh,085h,opn_jne,OP_BRANCH,2,3,0>		;JNE
	OPCODE	<0ffh,076h,opn_jna,OP_SHORTBRANCH,2,0,0>	;JNA
	OPCODE	<0ffh,086h,opn_jna,OP_BRANCH,2,3,0>		;JNA
	OPCODE	<0ffh,077h,opn_jnbe,OP_SHORTBRANCH,2,0,0>	;JNBE
	OPCODE	<0ffh,087h,opn_jnbe,OP_BRANCH,2,3,0>		;JNBE
	OPCODE	<0ffh,07ah,opn_jpe,OP_SHORTBRANCH,2,0,0>	;JPE
	OPCODE	<0ffh,08ah,opn_jpe,OP_BRANCH,2,3,0>		;JPE
	OPCODE	<0ffh,07bh,opn_jpo,OP_SHORTBRANCH,2,0,0>	;JPO
	OPCODE	<0ffh,08bh,opn_jpo,OP_BRANCH,2,3,0>		;JPO
	OPCODE	<0ffh,07ch,opn_jnge,OP_SHORTBRANCH,2,0,0>	;JNGE
	OPCODE	<0ffh,08ch,opn_jnge,OP_BRANCH,2,3,0>		;JNGE
	OPCODE	<0ffh,07dh,opn_jnl,OP_SHORTBRANCH,2,0,0>	;JNL
	OPCODE	<0ffh,08dh,opn_jnl,OP_BRANCH,2,3,0>		;JNL
	OPCODE	<0ffh,07eh,opn_jng,OP_SHORTBRANCH,2,0,0>	;JNG
	OPCODE	<0ffh,08eh,opn_jng,OP_BRANCH,2,3,0>		;JNG
	OPCODE	<0ffh,07fh,opn_jnle,OP_SHORTBRANCH,2,0,0>	;JNLE
	OPCODE	<0ffh,08fh,opn_jnle,OP_BRANCH,2,3,0>		;JNLE
	OPCODE	<038ffh,092h,opn_setnae,OP_NOSTRICTRM ,2,3,0>	;SETNAE
	OPCODE	<038ffh,092h,opn_setc,OP_NOSTRICTRM ,2,3,0>	;SETC
	OPCODE	<038ffh,093h,opn_setnc,OP_NOSTRICTRM ,2,3,0>	;SETNC
	OPCODE	<038ffh,093h,opn_setae,OP_NOSTRICTRM ,2,3,0>	;SETAE
	OPCODE	<038ffh,094h,opn_sete,OP_NOSTRICTRM ,2,3,0>	;SETE
	OPCODE	<038ffh,095h,opn_setne,OP_NOSTRICTRM ,2,3,0>	;SETNE
	OPCODE	<038ffh,096h,opn_setna,OP_NOSTRICTRM ,2,3,0>	;SETNA
	OPCODE	<038ffh,097h,opn_setnbe,OP_NOSTRICTRM ,2,3,0>	;SETNBE
	OPCODE	<038ffh,09ah,opn_setpe,OP_NOSTRICTRM ,2,3,0>	;SETPE
	OPCODE	<038ffh,09bh,opn_setpo,OP_NOSTRICTRM ,2,3,0>	;SETPO
	OPCODE	<038ffh,09ch,opn_setnge,OP_NOSTRICTRM ,2,3,0>	;SETNGE
	OPCODE	<038ffh,09dh,opn_setnl,OP_NOSTRICTRM ,2,3,0>	;SETNL
	OPCODE	<038ffh,09eh,opn_setng,OP_NOSTRICTRM ,2,3,0>	;SETNG
	OPCODE	<038ffh,09fh,opn_setnle,OP_NOSTRICTRM ,2,3,0>	;SETNLE
	OPCODE	<0ffh,098h,opn_cwde,OP_CODEONLY,1,0,0>	;CWDE
	OPCODE	<0ffh,099h,opn_cdq,OP_CODEONLY,1,0,0>	;CDQ
	OPCODE	<0ffh,09bh,opn_fwait,OP_CODEONLY,1,0,0>		;FWAIT
	OPCODE	<0ffffh,00d1d8h,opn_fcom,OP_CODEONLY,2,0,0>	;FCOM
	OPCODE	<0ffffh,00d9d8h,opn_fcomp,OP_CODEONLY,2,0,0>	;FCOMP
	OPCODE	<0ffffh,00e1ddh,opn_fucom,OP_CODEONLY,2,0,0>	;FUCOM
	OPCODE	<0ffffh,00e9ddh,opn_fucomp,OP_CODEONLY,2,0,0>	;FUCOMP
	OPCODE	<0ffffh,00c9d9h,opn_fxch,OP_CODEONLY,2,0,0>	;FXCH
	OPCODE	<0,0,0,0,0,0,0>


indexes dd offset group000xxxxx, offset group001xxxxx, offset group010xxxxx, offset group011xxxxx
	dd offset group100xxxxx, offset group101xxxxx, offset group110xxxxx, offset group111xxxxx

mnemonicMatchCount	dw	0
mnemonicMatchAddrTable	dd	16 DUP (0)
;
	.CODE
;
; find an OPCODE. FS:SI points to the current byte of code, which is assumed 
; to be the first byte of this OPCODE.
;  Oops, actually SI points to the first byte of the OPCODE PAST any 
;  override bytes
;OUTPUT: AX contains the OPCODE, BX points to the OPCODE structure for it
;	Apparently there is an option, which can be disabled, to permit
;	disassembling instructions found on the 386 and above. So if we find
;	an instruction and THEN find that this option is disabled, we
;	decide that we didn't find the instruction after all.
;	CY if not found
;
FindOpcode	PROC	
	mov	[x86pfx],0
	mov	ebx,offset groupx386	; Assume it is an 0F OPCODE
	inc	esi			; Point to next byte
	cmp	BYTE PTR [esi-1],0fh	; Is it 0F?
	jnz	short not0ftable  	; No, try another table
	or	[x86pfx],1		; yes, flag as a prefix byte
	jmp	gotable
not0ftable:
	mov	[x86pfx],0		; not the 0f prefix table
	dec	esi			; Else point back to first byte
	mov	ebx,offset floats	; Assume floating
	movzx	eax,byte ptr [esi]	; Get the OPCODE
	and	al,0f8h			; Apply the FLOAT mask
	cmp	al,0d8h			; Apply FLOAT compare
	jz	short gotable		; Yes, go look for OPCODE
	shr	al,5			; get top 3 bits of OPCODE
	mov	ebx,indexes[EAX*4]	; use as WORD table index
gotable:
	test	WORD PTR [ebx],-1	; See if at end of table
	jz	short noentry		; Yes, not found
	mov	ax,[esi]		; Get the OPCODE
	and	ax,[ebx + OPCODE.MSK]	; Mask it
	cmp	ax,[ebx + OPCODE.COMPARE]; Compare with the compare value
	jz	short gotentry		; Quit if found
	add	ebx,OPCODESIZE		; Else go to next entry
	jmp	gotable			;
gotentry:
	clc				; Found, exit
	ret
noentry:
	stc
	ret
FindOpcode	ENDP	

;
; scan a table for matches with this OPCODE
; INPUT:Well, let's see...
;	SI appears to point to a mnemonic for an OPCODE, somewere in memory
;	DI appears to point to the beginning of a table of OPCODE structures
;	AX appears to contain the length of the mnemonic string at [si]
;	BX appears to contain some index, but the syntax confuses me.
;		for mnemonicMatchAddrTable, it is some even value which 
;			cannot exceed 1Eh or else mnemonicMatchAddrTable will 
;			overflow
;		for OPCODE.flags, it is apparently an offset from the top
;			of the data segment to the start of this OPCODE 
;			structure. It appears to hold BOTH OF THESE AT ONCE! 
;			HOW?
;		My best guess is that BX comes in as 0
;PROCESSING:
;	Compare the string pointed to by DS:SI with the mnemonic pointed
;	to by the current OPCODE structure pointed to in ES:DI. Each time
;	we get a string match, we store the address of the structure
;	containing the pointer to the matching string in a table.  No table
;	of OPCODE structures better have more than 10h matches, since there
;	is no check for this.
;
;OUTPUT: The mnemonicMatchAddrTable table contains some number of addresses 
;	of OPCODE structures, possibly 0.  My best guess is that the number 
;	of validentries in this table is found in (BX-2) SHR 1
;
;	
findMnemonicMatches	PROC
	test	dword ptr [edi],-1	; end of table?
	jz	nomorent
	mov	ecx,eax			; get len passed in AX
	push	edi			;save pointer to structure
	mov	edi,[edi+OPCODE.MNEMONIC]	; get mnemonic from structure
	push	esi			;save pointer to found mnemonic
	repe	cmpsb			; scan for match
	pop	esi			;restore pointers
	pop	edi
	jnz	nomatch			; no match?
	mov	[ebx+mnemonicMatchAddrTable],edi	; match, put it in match tab
	add	bx,4
nomatch:
	add	edi,OPCODESIZE		; next entry
	jmp	findMnemonicMatches
nomorent:
	ret
findMnemonicMatches	ENDP
;
; main OPCODE lookup outine
; INPUT: By implication at findMnemonicMatches, AX must contain the length of
;	the string being parsed, and SI points to a mnemonic string.
;	These registers must be preserved until at least after the last
;	call to findMnemonicMatches.
; OUTPUT: mnemonicMatCount contains the number of valid matches
;	mnemonicMatchAddrTable contains near pointers to the OPCODE
;	structures where we actually found the matches to the names
;
LookupOpName	PROC
	sub	ebx,ebx			;initial match count = 0
	mov	ecx,8			;look through 8 tables
	mov	edi,offset indexes	; match the main tabs
lp:
	push	edi			;save pointer to indexes
	push	ecx			;save table count
	mov	edi,[edi]			;find next table
	call	findMnemonicMatches 	;get match list
	pop	ecx			;restore loop count
	pop	edi			;and index pointer
	add	edi,4			;goto next table pointer
	loop	lp			;for all tables

	mov	edi,offset floats	; match the float tab
	call	findMnemonicMatches   	;and seach floats too
	mov	edi,offset groupx386	; match the x386 tab (0F prefix)
	call	findMnemonicMatches   	;search that for matches
	mov	edi,offset synonymTable	; match the assembly extras tab
	call	findMnemonicMatches   	;search synonyms

	shr	ebx,2			;restore count of finds
	mov	[mnemonicMatchCount],bx	; and save count
	jnz	lox			;we found at least one match
	stc				; no match, error
lox:
	ret				; back to caller
LookupOpName	ENDP
END