/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <dos.h>
#include <errno.h>
#include <dpmi.h>
#include <time.h>

void       _dos_getdate(struct dosdate_t *__datep)
{
	DPMI_REGS regs;
   __doscall(0x2a,&regs) ;
   __datep->day = regs.b.dl ;
   __datep->month = regs.b.dh ;
   __datep->year = regs.h.cx ;
   __datep->dayofweek = regs.b.al ;
}
void       _dos_gettime(struct dostime_t *__timep)
{
	DPMI_REGS regs;
   __doscall(0x2c,&regs) ;
   __timep->hour = regs.b.ch ;
   __timep->minute = regs.b.cl ;
   __timep->second = regs.b.dh ;
   __timep->hsecond = regs.b.dl ;
}
void       getdate(struct date *__datep)
{
	DPMI_REGS regs;
   __doscall(0x2a,&regs) ;
   __datep->da_day = regs.b.dl ;
   __datep->da_mon = regs.b.dh ;
   __datep->da_year = regs.h.cx ;
}
void       gettime(struct time *__timep)
{
	DPMI_REGS regs;
   __doscall(0x2c,&regs) ;
   __timep->ti_hour = regs.b.ch ;
   __timep->ti_min = regs.b.cl ;
   __timep->ti_sec = regs.b.dh ;
   __timep->ti_hund = regs.b.dl ;
}
unsigned   _dos_setdate(struct dosdate_t *__datep)
{
	DPMI_REGS regs;
   regs.h.cx = __datep->year;
   regs.b.dh = __datep->month ;
   regs.b.dl = __datep->day ;
   if (!__doscall(0x2b,&regs)) {
      errno = EINVAL ;
		return 2;
   }
	return 0;
}
unsigned   _dos_settime(struct dostime_t *__timep)
{
	DPMI_REGS regs;
   regs.b.ch = __timep->hour;
   regs.b.cl = __timep->minute;
   regs.b.dh = __timep->second ;
   regs.b.dl = __timep->hsecond ;
   if (!__doscall(0x2d,&regs)) {
      errno = EINVAL ;
		return 2;
   }
	return 0;
}
void       setdate(struct date *__datep)
{
	DPMI_REGS regs;
   regs.h.cx = __datep->da_year;
   regs.b.dh = __datep->da_mon ;
   regs.b.dl = __datep->da_day ;
   __doscall(0x2b,&regs) ;
}
void       settime( struct time *__timep)
{
	DPMI_REGS regs;
   regs.b.ch = __timep->ti_hour;
   regs.b.cl = __timep->ti_min;
   regs.b.dh = __timep->ti_sec ;
   regs.b.dl = __timep->ti_hund ;
   __doscall(0x2d,&regs) ;
}
long dostounix(struct date *__datep, struct time *__timep)
{
   struct tm tmx ;
   tmx.tm_mday = __datep->da_day ;
   tmx.tm_mon = __datep->da_mon-1 ;
   tmx.tm_year = __datep->da_year - 1900 ;      
   tmx.tm_hour = __timep->ti_hour ;
   tmx.tm_min = __timep->ti_min ;
   tmx.tm_sec = __timep->ti_sec ;
   return (long) mktime(&tmx) ;

}
void unixtodos(long __time, struct date *__datep, struct time *__timep)
{
   struct tm *tmx ;
   tmx = gmtime((time_t * )&__time) ;
   __datep->da_day = tmx->tm_mday ;
   __datep->da_mon = tmx->tm_mon+1 ;
   __datep->da_year = tmx->tm_year + 1900 ;
   __timep->ti_hour =tmx->tm_hour ;
   __timep->ti_min = tmx->tm_min ;
   __timep->ti_sec = tmx->tm_sec ;
   __timep->ti_hund = 0 ;

}