/*
 *   @(#) MPEG-I Video Decoder 1.0 Demicron (demicron@demicron.com)
 *
 *   bob61.java   2002-08-20
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

import java.awt.*;
import java.io.*;
import java.net.*;
import java.applet.Applet;
import java.awt.image.*;

public class bob61 extends bob implements Displayable, Runnable {
  private SystemDecoder systemDecoder;
  //private InputStream mpegIn = null;
  private Thread playerThread;
  private PixProducer pixProducer;
  private PixProducer soonToBePixProducer;
  private String filename;
  private boolean loop = false;
  private boolean supportSound;
  private boolean streamed;
  private int buffer;
  private int startupMode;
  private final static int LOOP = 2;

  private final static int PLAYING = 0;
  private final static int STOPPING = 1;
  private final static int STOPPED = 2;
  private int status = STOPPED;

  public void i() {
    if (streamed)
      m.rm.d.insertElementAt(filename, 0); // Add to the end of the stack, so that it loads when all resources in the loading manager has finished loading

    if (startupMode!=0) enableSysEv(START);
    enableSysEv(2);
    alwaysDirty = false;
  }


  public boolean isDirty() {
    return (super.isDirty() || (status==PLAYING) || (status==STOPPING)); // Behves dirty vid STOPPING?
  }

 /* public void initialize() {
    try {
        mpegIn = (get(filename).is());
        if (buffer>0)
          mpegIn = new BufferedInputStream(mpegIn, buffer*1024);
      systemDecoder = new SystemDecoder(mpegIn, this, supportSound);
    } catch (Exception e) {e.printStackTrace();}
  }*/


  public void handleSysEv(Event ev) {
    if (ev.id==2) {
      try {
        stop();
      } catch (Exception e) {e.printStackTrace();}
    } else {
      loop = (startupMode==LOOP);
      play();
    }
  }


  public void ap() {
    if (pixProducer!=null && (status == PLAYING)) {
      int height = pixProducer.pixels.length/pixProducer.scansize;
      Rectangle alphaRect = getGr(0);
      int alphaWidth = (pixels(0)==null) ? 0 : getGr(0).width;
      apply(pixProducer.pixels, pixProducer.scansize, new Rectangle(0,0,pixProducer.scansize, height), pixels(0), alphaWidth, alphaRect, false);
    }
  }


  public void rd(DataInputStream dis) {
    try {
      streamed = dis.readBoolean();
      buffer = dis.readShort();
      startupMode = dis.readShort();
      filename = dis.readUTF();
      supportSound = dis.readBoolean();
    } catch (Exception e) {e.printStackTrace();}
  }


  public void handleEv(bob arg, int inport) {
    try {
      if (inport==1 || inport==2) {
        loop = (inport==2);
        play();
      } else if (inport==3) {
        stop();
      }
    } catch (Exception e) {e.printStackTrace();}
    super.handleEv(arg, inport);
  }


  public void stop() throws IOException
  {
    if (status == PLAYING) {
      status = STOPPING;
      systemDecoder.stop();
    }
  }

  public void play()
  {
    if (status!=PLAYING) {
      Thread t = new Thread(this);
      t.start();
    }
  }


  public synchronized void run() { // synchronized...let possible stopping-processes finish before starting a new player
    do {
      status = PLAYING;
      playerThread = Thread.currentThread();
      try {
        InputStream mpegIn = (get(filename).is());
        if (buffer>0)
          mpegIn = new BufferedInputStream(mpegIn, buffer*1024);
        systemDecoder = new SystemDecoder(mpegIn, this, supportSound);
        systemDecoder.start();
        mpegIn.close(); // S att resourcen kan stts p lgprioritet om det inte r ngra fler streams som lser frn den
      } catch (Exception e) {e.printStackTrace();}
      if (status!=STOPPING) this.createEv(null, 1);
    } while (loop && (status!=STOPPING));
    playerThread = null; // A new player thread could have been started during the stopping process of this thread...
    systemDecoder = null;
    pixProducer = null;
    status = STOPPED;
  }


  public void setImageSource(PixProducer imagesource) {
    soonToBePixProducer = imagesource;
  }


  public void nextImage() {
    pixProducer = soonToBePixProducer;
  }
}
