#include <stdio.h>
#include <Windows.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <windowsx.h> 

//define for ApSetFunction
#define Ap_Set_MultiPage			101
#define Ap_Set_ImagePosAndSize		104
#define Ap_Set_Encrypt 				105
#define Ap_Set_Font					106
#define Ap_Set_NewOrClosePage		109
#define Ap_Set_BookMark				110
#define Ap_Set_ViewerPreferences	121
#define Ap_Set_Recompress			123
#define Ap_Set_Skewcorrect			126
#define Ap_Set_Clearspot			127


//define for ApGetFunction
#define Ap_Get_ImagePageCount		201
#define Ap_Get_ImageSizeW			202
#define Ap_Get_ImageSizeH			203
#define Ap_Get_ImageDpiX			204
#define Ap_Get_ImageDpiY			205
#define Ap_Get_PdfPageCount			206
#define Ap_Get_PdfCurrentPageSize	209
#define Ap_Get_StringWidth			250
#define Ap_Get_StringHeight			251
#define Ap_Get_Recomporess			210
#define Ap_Get_ImageBits			211

//define for ApAddText
#define Ap_DT_LEFT			0
#define Ap_DT_CENTER		1
#define Ap_DT_RIGHT			2
#define Ap_DT_WORDBREAK		0x10
#define Ap_DT_CALCRECT		0x400

//set password and permission
#define permission_Print	1
#define permission_Copy		2
#define permission_Modify	4


typedef long	(__stdcall *ApCreate)(char *);
typedef long	(__stdcall *ApOpen)(char *);
typedef void	(__stdcall *ApClose)(long);
typedef long	(__stdcall *ApAddInfo)(long,char*,char*,char*,char*,char*);
typedef long	(__stdcall *ApSetFunction)(long,long func_code,long para1,long para2,char *para3,char *para4);
typedef long	(__stdcall *ApGetFunction)(long,long func_code,long para1,long para2,char *para3,char *para4);

typedef long	(__stdcall *ApAddImage)(long,char *);
typedef long	(__stdcall *ApAddImageData)(long,char *,long ,long ,long );

typedef long	(__stdcall *ApAddTextEx)(long,long,long,char *,long );
typedef long	(__stdcall *ApAddText)(long,long,long,long,long,char *,long ,long,long);
typedef long	(__stdcall *ApAddTxt)(long id,char *szTxtName,long color,
						   long width,long height,long AutoNewLine,long AutoWidthAdjust,
						   long LeftMargin,long RightMargin,long TopMargin,long BottomMargin,
						   long TabSize);

typedef long	(__stdcall *ApAddLine)  (long ,long ,long ,long ,long ,long ,long );
typedef long	(__stdcall *ApAddRect  )(long ,long ,long ,long ,long ,long ,long ,long ,long );


HMODULE				g_hApW=NULL;

ApCreate			pApCreate;
ApOpen				pApOpen;
ApAddImage			pApAddImage;
ApAddImageData		pApAddImageData;
ApClose				pApClose	;	
ApAddInfo			pApAddInfo;	
ApSetFunction		pApSetFunction;
ApGetFunction		pApGetFunction;
ApAddTextEx			pApAddTextEx;
ApAddText			pApAddText;
ApAddTxt			pApAddTxt;
ApAddLine			pApAddLine;
ApAddRect			pApAddRect;

void	GetModulePath(char *out_path,char *in_name);
BOOL	LoadApWDll(void);
void	FreeApWDll();


void GetModulePath(char *out_path,char *in_name)
{
	char *p;
	GetModuleFileName(NULL,out_path,256);
	p =strrchr(out_path,'\\');
	p[1]=0;
	strcat(out_path,in_name);
}

BOOL LoadApWDll()
{
	char path[_MAX_PATH];
	GetModulePath(path,"tifftopdf.dll");
	g_hApW=LoadLibrary(path);
	if(g_hApW==NULL)
		goto Failer;

	pApCreate=(ApCreate)GetProcAddress(g_hApW,"ApCreate");
	if(pApCreate==NULL)
		goto Failer;
	pApOpen=(ApOpen)GetProcAddress(g_hApW,"ApOpen");
	if(pApOpen==NULL)
		goto Failer;
	pApAddImage=(ApAddImage)GetProcAddress(g_hApW,"ApAddImage");
	if(pApAddImage==NULL)
		goto Failer;
	pApAddImageData=(ApAddImageData)GetProcAddress(g_hApW,"ApAddImageData");
	if(pApAddImageData==NULL)
		goto Failer;
	pApClose=(ApClose)GetProcAddress(g_hApW,"ApClose");
	if(pApClose==NULL)
		goto Failer;
	pApAddInfo=(ApAddInfo)GetProcAddress(g_hApW,"ApAddInfo");
	if(pApAddInfo==NULL)
		goto Failer;
	pApSetFunction=(ApSetFunction)GetProcAddress(g_hApW,"ApSetFunction");
	if(pApSetFunction==NULL)
		goto Failer;
	pApGetFunction=(ApGetFunction)GetProcAddress(g_hApW,"ApGetFunction");
	if(pApGetFunction==NULL)
		goto Failer;
	pApAddTextEx=(ApAddTextEx)GetProcAddress(g_hApW,"ApAddTextEx");
	if(pApAddTextEx==NULL)
		goto Failer;
	pApAddText=(ApAddText)GetProcAddress(g_hApW,"ApAddText");
	if(pApAddText==NULL)
		goto Failer;
	pApAddTxt=(ApAddTxt)GetProcAddress(g_hApW,"ApAddTxt");
	if(pApAddTxt==NULL)
		goto Failer;
	pApAddLine=(ApAddLine)GetProcAddress(g_hApW,"ApAddLine");
	if(pApAddLine==NULL)
		goto Failer;
	pApAddRect=(ApAddRect)GetProcAddress(g_hApW,"ApAddRect");
	if(pApAddRect==NULL)
		goto Failer;
	return TRUE;
Failer:
	FreeApWDll(); 
	return FALSE;

}

void FreeApWDll()
{
	if(g_hApW==NULL)
		return ;
	FreeLibrary(g_hApW);
	g_hApW=NULL;
}



void AddImageData(long id)
{
	int i,j;
	int temp1,temp2;
	int red,green,blue;
	int MemImageWidth=640;
	int MemImageHeight=640;
	int color=24;//can equal 1 and 8 and 24
	char *MemData=malloc(MemImageWidth*MemImageHeight*3);
	for(i=0;i<MemImageHeight - 1;i++){
		for(j=0;j<MemImageWidth - 1;j++){
			temp1=i&8;
			temp2=j&8;
			if(temp1|temp2){
				red=255;
				green = blue = 0;
			}else{
                red = 0;
                green = blue = 255	;		
			}
            MemData[i * MemImageWidth * 3 + j * 3 + 0] = red;
            MemData[i * MemImageWidth * 3 + j * 3 + 1] = green;
            MemData[i * MemImageWidth * 3 + j * 3 + 2] = blue;
		}
	}

	pApAddImageData(id,MemData,MemImageWidth,MemImageHeight,color);

	free(MemData);
	MemData=NULL;
}


void RecompressTruecolorFile(char *szImageFile)
{
	long id;
	char szPDFFile[256];
	memset(szPDFFile,0,256);

	// recompress lzw
	GetModulePath(szPDFFile,"Truecolor_lzw.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApSetFunction(id,Ap_Set_Recompress,3,0,"lzw",NULL);
		pApAddImage(id,szImageFile);
		pApClose(id);
	}

	// recompress zip
	GetModulePath(szPDFFile,"Truecolor_zip.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApSetFunction(id,Ap_Set_Recompress,3,0,"zip",NULL);
		pApAddImage(id,szImageFile);
		pApClose(id);
	}

	// recompress packbits
	GetModulePath(szPDFFile,"Truecolor_packbits.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApSetFunction(id,Ap_Set_Recompress,3,0,"packbits",NULL);
		pApAddImage(id,szImageFile);
		pApClose(id);
	}

	// recompress jpeg
	GetModulePath(szPDFFile,"Truecolor_jpeg.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApSetFunction(id,Ap_Set_Recompress,3,0,"jpeg",NULL);
		pApAddImage(id,szImageFile);
		pApClose(id);
	}

}

void RecompressGrayFile(char *szImageFile)
{
	long id;
	char szPDFFile[256];
	memset(szPDFFile,0,256);

	// recompress lzw
	GetModulePath(szPDFFile,"Gray_lzw.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApSetFunction(id,Ap_Set_Recompress,2,0,"lzw",NULL);
		pApAddImage(id,szImageFile);
		pApClose(id);
	}

	// recompress zip
	GetModulePath(szPDFFile,"Gray_zip.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApSetFunction(id,Ap_Set_Recompress,2,0,"zip",NULL);
		pApAddImage(id,szImageFile);
		pApClose(id);
	}

	// recompress packbits
	GetModulePath(szPDFFile,"Gray_packbits.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApSetFunction(id,Ap_Set_Recompress,2,0,"packbits",NULL);
		pApAddImage(id,szImageFile);
		pApClose(id);
	}

	// recompress jpeg
	GetModulePath(szPDFFile,"Gray_jpeg.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApSetFunction(id,Ap_Set_Recompress,2,0,"jpeg",NULL);
		pApAddImage(id,szImageFile);
		pApClose(id);
	}

}

void RecompressBlackWhiteFile(char *szImageFile)
{

	long id;
	char szPDFFile[256];
	memset(szPDFFile,0,256);

	// recompress lzw
	GetModulePath(szPDFFile,"Black_White_lzw.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApSetFunction(id,Ap_Set_Recompress,1,0,"lzw",NULL);
		pApAddImage(id,szImageFile);
		pApClose(id);
	}

	// recompress zip
	GetModulePath(szPDFFile,"Black_White_zip.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApSetFunction(id,Ap_Set_Recompress,1,0,"zip",NULL);
		pApAddImage(id,szImageFile);
		pApClose(id);
	}

	// recompress CCITT Group 3 fax encoding
	GetModulePath(szPDFFile,"Black_White_g3.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApSetFunction(id,Ap_Set_Recompress,1,0,"g3",NULL);
		pApAddImage(id,szImageFile);
		pApClose(id);
	}

	// recompress CCITT Group 4 fax encoding
	GetModulePath(szPDFFile,"Black_White_g4.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApSetFunction(id,Ap_Set_Recompress,1,0,"g4",NULL);
		pApAddImage(id,szImageFile);
		pApClose(id);
	}

}

void Recompress(char *pImageFile)
{
	long bits;
	bits=pApGetFunction(0,Ap_Get_ImageBits,0,0,pImageFile,0);	
	switch(bits)
	{
	case 1:
		RecompressBlackWhiteFile(pImageFile);
		break;
	case 8:
		RecompressGrayFile(pImageFile);
		break;
	case 24:
		RecompressTruecolorFile(pImageFile);
		break;
	default :
		break;
	}

}

void AddPDFInfo()
{
	long id;
	char szPDFFile[256];
	char szImageFile[256];
	memset(szPDFFile,0,256);
	memset(szImageFile,0,256);

	GetModulePath(szImageFile,"multipage.tif");
	GetModulePath(szPDFFile,"Information.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApAddInfo(id,"Title","Subject","Author","Keywords","Creator");
		pApAddImage(id,szImageFile);
		pApClose(id);
	}
	
}

void PDFsecurity()
{
	long id;
	char szPDFFile[256];
	char szImageFile[256];
	memset(szPDFFile,0,256);
	memset(szImageFile,0,256);

//	GetModulePath(szImageFile,"multipage.tif");
	GetModulePath(szImageFile,"Truecolor.tif");
	GetModulePath(szPDFFile,"Security.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApSetFunction(id,Ap_Set_Encrypt,128,permission_Print+permission_Copy+permission_Modify,"owner","user");
		pApAddImage(id,szImageFile);
		pApClose(id);
	}

}

void AddPDFBookmark()
{
	int beginpage;
	int pagenums;
	int pagecount;
	long id;
	char szPDFFile[256];
	char szImageFile[256];
	char szBookmark[256];
	memset(szPDFFile,0,256);
	memset(szImageFile,0,256);
	memset(szBookmark,0,256);

	GetModulePath(szImageFile,"multipage.tif");
	GetModulePath(szPDFFile,"Bookmark.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		//get multi page tiff page count
		pagecount=pApGetFunction(id,Ap_Get_ImagePageCount,0,0,szImageFile,0);
		for(beginpage=1;beginpage<=pagecount;beginpage++){
			//add bookmark
			sprintf(szBookmark,"bookmark %d",beginpage);
			pApSetFunction(id,Ap_Set_BookMark,0,0,szBookmark,0);
			//Add one page
			pagenums=1;
			pApSetFunction(id,Ap_Set_MultiPage,beginpage,pagenums,0,0);			
			pApAddImage(id,szImageFile);
		}
		pApClose(id);
	}

}

void AppendPDF()
{
	long id;
	char szPDFFile[256];
	char szImageFile[256];
	memset(szPDFFile,0,256);
	memset(szImageFile,0,256);

	GetModulePath(szImageFile,"multipage.tif");
	GetModulePath(szPDFFile,"Append.pdf");
	//Append PDF file
	if( (id=pApOpen(szPDFFile)) >0 )
	{
		pApAddImage(id,szImageFile);
		pApClose(id);
	}else
	//Create new PDF file
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApAddImage(id,szImageFile);
		pApClose(id);
	}
		
}

void Skewcorrect_Clearspot()
{
	long id;
	char szPDFFile[256];
	char szImageFile[256];
	memset(szPDFFile,0,256);
	memset(szImageFile,0,256);

	GetModulePath(szImageFile,"Skewcorrect.tif");
	GetModulePath(szPDFFile,"Skewcorrect.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		pApAddImage(id,szImageFile);

		//set skewcorrect
		pApSetFunction(id,Ap_Set_Skewcorrect,1,0,NULL,NULL);
		//set clearspot
		pApSetFunction(id,Ap_Set_Clearspot,1,0,NULL,NULL);

		pApAddImage(id,szImageFile);		

		pApClose(id);	
	}

}


void Other()
{

	long id,iret,width,height,xdpi,ydpi;
	int beginpage,pagenums,pagecount;
	char szBookmark[256];
	char szPDFFile[256];
	char szImageFile[256];
	char buf[32],buf2[32];
	memset(szPDFFile,0,256);
	memset(szImageFile,0,256);
	memset(szBookmark,0,256);

	GetModulePath(szImageFile,"multipage.tif");
	GetModulePath(szPDFFile,"Other.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		//set info
		pApAddInfo(id,"Title","Subject","Author","Keywords","Creator");

		pApSetFunction(id,Ap_Set_ViewerPreferences,4+4096,2,0,0);

		//set encrypt
		pApSetFunction(id,Ap_Set_Encrypt,128,permission_Print+permission_Copy+permission_Modify,"owner","user");


		//get multi page tiff page count
		pagecount=pApGetFunction(id,Ap_Get_ImagePageCount,0,0,szImageFile,0);
		for(beginpage=1;beginpage<=pagecount;beginpage++){
			//Get image width and height
			iret=pApGetFunction(id,Ap_Get_ImageSizeW,(long)&width,(long)&height,szImageFile,ltoa(beginpage,buf,10));
			//Get image dpi (Resolution)
			iret=pApGetFunction(id,Ap_Get_ImageDpiX,(long)&xdpi,(long)&ydpi,szImageFile,ltoa(beginpage,buf,10));
			if(xdpi>0&&ydpi>0){
 				width  = (long)(width * (72.0/xdpi));
 				height = (long)(height* (72.0/ydpi));
			}
			//new page
			iret=pApSetFunction(id,Ap_Set_NewOrClosePage,width,height,0,0);
			//set image size
			iret=pApSetFunction(id,Ap_Set_ImagePosAndSize,0,0,ltoa(width,buf,10),ltoa(height,buf2,10));
			//add bookmark
			sprintf(szBookmark,"bookmark %d",beginpage);
			pApSetFunction(id,Ap_Set_BookMark,0,0,szBookmark,0);
			//add one 
			pagenums=1;
			pApSetFunction(id,Ap_Set_MultiPage,beginpage,pagenums,0,0);			
			iret=pApAddImage(id,szImageFile);
			//close the page
			iret=pApSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);
		}

		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,"bookmark memory image",0);
		//add image four, the example for bit 24 bmp
		AddImageData(id);

		pApClose(id);
	}

}

void Other2()
{

	long id,iret,width,height,xdpi,ydpi;
	int beginpage,pagenums,pagecount;
	char szBookmark[256];
	char szPDFFile[256];
	char szImageFile[256];
	char buf[32],buf2[32];
	memset(szPDFFile,0,256);
	memset(szImageFile,0,256);
	memset(szBookmark,0,256);

	GetModulePath(szPDFFile,"Other2.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{

		
		//new a page for a3
		pApSetFunction(id,Ap_Set_NewOrClosePage,1,1,0,0);
		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,"bookmark one",0);
		//set system font and size
		pApSetFunction(id,Ap_Set_Font,1,32,"Arial",0);
		//add text
		pApAddTextEx(id,300,300,"this is a text!",RGB(0,255,255));

		//set system font and size
		pApSetFunction(id,Ap_Set_Font,1,32,"Helvetica",0);
		//add text
		pApAddTextEx(id,300,400,"this is a text!",RGB(0,255,255));


			
		//set font and size
		pApSetFunction(id,Ap_Set_Font,203,32,0,0);

		{
		char string[]="this is a text! this is a text! this is a text! this is a text!";
		//width =pApGetFunction(id,Ap_Get_StringWidth,0,0,string,0);
		//height=pApGetFunction(id,Ap_Get_StringHeight,0,0,string,0);
		//add text for rect
		width=200;  
		height=0;
		pApAddText(id,1,1,(long)&width,(long)&height,string,
					 RGB(0,0,255),RGB(255,0,255),Ap_DT_WORDBREAK|Ap_DT_CALCRECT); 
		pApAddText(id,1,1,width,height,string,
					 RGB(0,0,255),RGB(255,0,255),Ap_DT_WORDBREAK|Ap_DT_CENTER); 
		}

		
		//set system font and size
		pApSetFunction(id,Ap_Set_Font,1,32,"Verdana",0);
		//add text
		pApAddTextEx(id,300,500,"this is a text!",RGB(0,255,255));

		
		//new a page for b5
		pApSetFunction(id,Ap_Set_NewOrClosePage,4,4,0,0);
		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,"bookmark two",0);
		//add graphic
		pApAddLine  (id,10,10,100,200,5,RGB(0,0,255));
		pApAddRect(id,20,210,300,400,3,RGB(0,255,0),1,RGB(255,0,255));

		GetModulePath(szImageFile,"test.txt");
		pApSetFunction(id,Ap_Set_Font,200,16,0,0);
		pApAddTxt(id,szImageFile,0,0,0,1,1,64,64,64,64,4);
		

		pApClose(id);

	}
}



void main()
{
	char szImageFile[256];
	memset(szImageFile,0,256); 

	if(!LoadApWDll())
		return ;


	//recompress tiff files to PDFs
	GetModulePath(szImageFile,"Black_White.tif");
	Recompress(szImageFile);
	GetModulePath(szImageFile,"Gray.tif");
	Recompress(szImageFile);
	GetModulePath(szImageFile,"Truecolor.tif");
	Recompress(szImageFile);

	AddPDFInfo();

	PDFsecurity();

	AddPDFBookmark();
	
	AppendPDF();
	AppendPDF();

	Skewcorrect_Clearspot();

	Other();

	Other2();


	FreeApWDll();

	return ;

}