/*********************************************************************
 VERSY SYSTEMS INCORPORATED
 Copyright (C) 2003-2005 Versy Systems Incorporated
 All rights reserved.

 NOTICE: Versy permits you to use, modify, and distribute this file
 in accordance with the terms of the Versy license agreement
 accompanying it. If you have received this file from a source other
 than Versy, then your use, modification, or distribution of it
 requires the prior written permission of Versy.

---------------------------------------------------------------------

VSSignA.h
*********************************************************************/
/*********************************************************************
*********************************************************************/

#ifndef VSSignA_H
#define VSSignA_H

#include "VSTypes.h" 
#include "VSError.h"

#ifdef  __cplusplus
extern "C"{
#endif




    typedef void *PDFPfxHandle, *PDFSigHandle;

    PDFPfxHandle PDFPfxCreate(PDFLibHandle);
    void PDFPfxDispose(PDFPfxHandle);
    PDFPfxHandle PDFPfxLoadFromStream(PDFLibHandle, PDFStreamHandle, const ppUns8 *);
    PDFPfxHandle PDFPfxLoadFromFile(PDFLibHandle, char *, const ppUns8 *);
    PDFPfxHandle PDFPfxLoadFromBuffer(PDFLibHandle, void *, ppInt32, const ppUns8 *);

    PDFSigHandle PDFDocPrepSign(PDFDocHandle);
    void sig_SetSigner(PDFSigHandle, char *);
    void sig_SetReason(PDFSigHandle, char *);
    void sig_SetField(PDFSigHandle, char *);

    void PDFDocSign(PDFDocHandle, PDFPfxHandle);

#ifdef  __cplusplus
}
#endif

#endif /* #ifndef VSSignA_H */

