/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSImageA.h"
#include "VSAnnotA.h"
#include "VSFontA.h"

int main( void )
{
	int HelvIndex, TimesIndex, CourierIndex;      /* Font indexes */
	int Page;                                     /* Page index variable description */
	PBXHandle PB;                                 /* Paint box variable description */ 
	PDFDocHandle doc = NULL;                      /* Document variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocCreate( PDFLibrary );             /* Create new PDF file */
		PDFDocSetAutoLaunch( doc, true );             /* Launch destination PDF file after work */
		Page = PDFDocAppendPage2( doc, psA4,poPagePortrait );  /* Insert new page into document */
		PB = PDFPageCreatePaintBox( doc, Page, 72 );    /* Create paintbox */ 
		HelvIndex = PDFFontAppend14Standard( doc, stdfHelveticaBold, etStandardEncoding );    /* Load Helvetica Bold font */
		TimesIndex = PDFFontAppend14Standard( doc, stdfTimesBoldItalic, etStandardEncoding );    /* Load Times Bold Italic font */
		CourierIndex = PDFFontAppend14Standard( doc, stdfCourierOblique, etStandardEncoding );    /* Load Courier Oblique font */
		PBXSetActiveFont( PB, HelvIndex, 14, false, false );                          /* Set Helvetica Bold as active font */      
		PBXTextOut( PB, 20, 20, 0 , "Standard Helvetica" );                           /* Draw text by current font */
		PBXSetActiveFont( PB, TimesIndex, 14, false, false );                         /* Set Times New Roman Bold Italic as active font */
		PBXTextOut( PB, 20, 40, 0 , "Standard Times New Roman Bold Italic" );         /* Draw text by current font */
		PBXSetActiveFont( PB, CourierIndex, 14, false, false );                       /* Set Standard Courier Oblique as active font */
		PBXTextOut( PB, 20, 60, 0 , "Standard Courier Oblique" );                     /* Draw text by current font */
		PBXClose( PB, true );                                     /* Close paintbox */
		PDFDocSaveToFile( doc, "../Data/out/StandardFontTest.pdf" );      /* Saving the document */ 
	} PDFFINALLY( PDFLibrary ){                                   /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
}