/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
import teamdev.jxcapture.Capture;
import teamdev.jxcapture.events.CaptureAdapter;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

/**
 * The example demonstrates how to capture the specified region on the screen.
 * <p>
 * To select the specified region click the left mouse button, move the mouse pointer and click
 * the left button to complete the operation and to get the screen shot of
 * the selected region.
 * <p>To cancel the operation press the Esc key.
 *
 * @author Ikryanov Vladimir
 */
public class RegionCaptureSample {
    public static void main(String[] args) {
        System.out.println("Please select a specified region and press Enter key in order to " +
                "complete capture operation.");
        Capture.captureRegion(new CaptureAdapter() {
            public void complete(BufferedImage image) {
                try {
                    ImageIO.write(image, "PNG", new File("C:/regionWindow.png"));
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public void cancel() {
                System.out.println("Cancel");
            }
        });
        System.out.println("Done");
    }
}
