/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import teamdev.jxcapture.Capture;
import teamdev.jxcapture.events.CaptureAdapter;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

/**
 * The example demonstrates how to capture the desktop.
 *
 * @author Ikryanov Vladimir
 */
public class DesktopWindowSample {
    public static void main(String[] args) {
        Capture.captureDesktop(new CaptureAdapter() {
            public void complete(BufferedImage image) {
                try {
                    ImageIO.write(image, "PNG", new File("C:/desktopWindow.png"));
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });

        System.out.println("Done");
    }
}
