/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.MnemonicText;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;

public class ApplicationAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(ApplicationAction.class.getName());
    private final ApplicationActionMap appAM;
    private final ResourceMap resourceMap;
    private final String actionName;
    private final Method actionMethod;
    private final String enabledProperty;
    private final Method isEnabledMethod;
    private final Method setEnabledMethod;
    private final String selectedProperty;
    private final Method isSelectedMethod;
    private final Method setSelectedMethod;
    private final Task.BlockingScope block;
    private Action proxy = null;
    private Object proxySource = null;
    private PropertyChangeListener proxyPCL = null;
    private static final String SELECTED_KEY = "SwingSelectedKey";
    private static final String DISPLAYED_MNEMONIC_INDEX_KEY = "SwingDisplayedMnemonicIndexKey";
    private static final String LARGE_ICON_KEY = "SwingLargeIconKey";

    public ApplicationAction(ApplicationActionMap appAM, ResourceMap resourceMap, String baseName, Method actionMethod, String enabledProperty, String selectedProperty, Task.BlockingScope block) {
        if (appAM == null) {
            throw new IllegalArgumentException("null appAM");
        }
        if (baseName == null) {
            throw new IllegalArgumentException("null baseName");
        }
        this.appAM = appAM;
        this.resourceMap = resourceMap;
        this.actionName = baseName;
        this.actionMethod = actionMethod;
        this.enabledProperty = enabledProperty;
        this.selectedProperty = selectedProperty;
        this.block = block;
        if (enabledProperty != null) {
            this.setEnabledMethod = this.propertySetMethod(enabledProperty, Boolean.TYPE);
            this.isEnabledMethod = this.propertyGetMethod(enabledProperty);
            if (this.isEnabledMethod == null) {
                throw this.newNoSuchPropertyException(enabledProperty);
            }
        } else {
            this.isEnabledMethod = null;
            this.setEnabledMethod = null;
        }
        if (selectedProperty != null) {
            this.setSelectedMethod = this.propertySetMethod(selectedProperty, Boolean.TYPE);
            this.isSelectedMethod = this.propertyGetMethod(selectedProperty);
            if (this.isSelectedMethod == null) {
                throw this.newNoSuchPropertyException(selectedProperty);
            }
            super.putValue(SELECTED_KEY, Boolean.FALSE);
        } else {
            this.isSelectedMethod = null;
            this.setSelectedMethod = null;
        }
        if (resourceMap != null) {
            this.initActionProperties(resourceMap, baseName);
        }
    }

    ApplicationAction(ApplicationActionMap appAM, ResourceMap resourceMap, String actionName) {
        this(appAM, resourceMap, actionName, null, null, null, Task.BlockingScope.NONE);
    }

    private IllegalArgumentException newNoSuchPropertyException(String propertyName) {
        String actionsClassName = this.appAM.getActionsClass().getName();
        String msg = String.format("no property named %s in %s", propertyName, actionsClassName);
        return new IllegalArgumentException(msg);
    }

    String getEnabledProperty() {
        return this.enabledProperty;
    }

    String getSelectedProperty() {
        return this.selectedProperty;
    }

    public Action getProxy() {
        return this.proxy;
    }

    public void setProxy(Action proxy) {
        Action oldProxy = this.proxy;
        this.proxy = proxy;
        if (oldProxy != null) {
            oldProxy.removePropertyChangeListener(this.proxyPCL);
            this.proxyPCL = null;
        }
        if (this.proxy != null) {
            this.updateProxyProperties();
            this.proxyPCL = new ProxyPCL();
            proxy.addPropertyChangeListener(this.proxyPCL);
        } else if (oldProxy != null) {
            this.setEnabled(false);
            this.setSelected(false);
        }
        this.firePropertyChange("proxy", oldProxy, this.proxy);
    }

    public Object getProxySource() {
        return this.proxySource;
    }

    public void setProxySource(Object source) {
        Object oldValue = this.proxySource;
        this.proxySource = source;
        this.firePropertyChange("proxySource", oldValue, this.proxySource);
    }

    private void maybePutDescriptionValue(String key, Action proxy) {
        Object s = proxy.getValue(key);
        if (s instanceof String) {
            this.putValue(key, (String)s);
        }
    }

    private void updateProxyProperties() {
        Action proxy = this.getProxy();
        if (proxy != null) {
            this.setEnabled(proxy.isEnabled());
            Object s = proxy.getValue(SELECTED_KEY);
            this.setSelected(s instanceof Boolean && (Boolean)s != false);
            this.maybePutDescriptionValue("ShortDescription", proxy);
            this.maybePutDescriptionValue("LongDescription", proxy);
        }
    }

    private void initActionProperties(ResourceMap resourceMap, String baseName) {
        Icon largeIcon;
        Icon smallIcon;
        Icon icon;
        KeyStroke key;
        Integer index;
        Integer mnemonic;
        boolean iconOrNameSpecified = false;
        Object typedName = null;
        String text = resourceMap.getString(baseName + ".Action.text", new Object[0]);
        if (text != null) {
            MnemonicText.configure(this, text);
            iconOrNameSpecified = true;
        }
        if ((mnemonic = resourceMap.getKeyCode(baseName + ".Action.mnemonic")) != null) {
            this.putValue("MnemonicKey", mnemonic);
        }
        if ((index = resourceMap.getInteger(baseName + ".Action.displayedMnemonicIndex")) != null) {
            this.putValue(DISPLAYED_MNEMONIC_INDEX_KEY, index);
        }
        if ((key = resourceMap.getKeyStroke(baseName + ".Action.accelerator")) != null) {
            this.putValue("AcceleratorKey", key);
        }
        if ((icon = resourceMap.getIcon(baseName + ".Action.icon")) != null) {
            this.putValue("SmallIcon", icon);
            this.putValue(LARGE_ICON_KEY, icon);
            iconOrNameSpecified = true;
        }
        if ((smallIcon = resourceMap.getIcon(baseName + ".Action.smallIcon")) != null) {
            this.putValue("SmallIcon", smallIcon);
            iconOrNameSpecified = true;
        }
        if ((largeIcon = resourceMap.getIcon(baseName + ".Action.largeIcon")) != null) {
            this.putValue(LARGE_ICON_KEY, largeIcon);
            iconOrNameSpecified = true;
        }
        this.putValue("ShortDescription", resourceMap.getString(baseName + ".Action.shortDescription", new Object[0]));
        this.putValue("LongDescription", resourceMap.getString(baseName + ".Action.longDescription", new Object[0]));
        this.putValue("ActionCommandKey", resourceMap.getString(baseName + ".Action.command", new Object[0]));
        if (!iconOrNameSpecified) {
            this.putValue("Name", this.actionName);
        }
    }

    private String propertyMethodName(String prefix, String propertyName) {
        return prefix + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    private Method propertyGetMethod(String propertyName) {
        String[] getMethodNames = new String[]{this.propertyMethodName("is", propertyName), this.propertyMethodName("get", propertyName)};
        Class actionsClass = this.appAM.getActionsClass();
        for (String name : getMethodNames) {
            try {
                return actionsClass.getMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException ignore) {
            }
        }
        return null;
    }

    private Method propertySetMethod(String propertyName, Class type) {
        Class actionsClass = this.appAM.getActionsClass();
        try {
            return actionsClass.getMethod(this.propertyMethodName("set", propertyName), type);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    public String getName() {
        return this.actionName;
    }

    protected Object getActionArgument(Class pType, String pKey, ActionEvent actionEvent) {
        Object argument = null;
        if (pType == ActionEvent.class) {
            argument = actionEvent;
        } else if (pType == Action.class) {
            argument = this;
        } else if (pType == ActionMap.class) {
            argument = this.appAM;
        } else if (pType == ResourceMap.class) {
            argument = this.resourceMap;
        } else if (pType == ApplicationContext.class) {
            argument = this.appAM.getContext();
        } else if (pType == Application.class) {
            argument = this.appAM.getContext().getApplication();
        } else {
            IllegalArgumentException e = new IllegalArgumentException("unrecognized @Action method parameter");
            this.actionFailed(actionEvent, e);
        }
        return argument;
    }

    private Task.InputBlocker createInputBlocker(Task task, ActionEvent event) {
        Object target = event.getSource();
        if (this.block == Task.BlockingScope.ACTION) {
            target = this;
        }
        return new DefaultInputBlocker(task, this.block, target);
    }

    private void noProxyActionPerformed(ActionEvent actionEvent) {
        Object taskObject = null;
        Annotation[][] allPAnnotations = this.actionMethod.getParameterAnnotations();
        Class<?>[] pTypes = this.actionMethod.getParameterTypes();
        Object[] arguments = new Object[pTypes.length];
        for (int i = 0; i < pTypes.length; ++i) {
            String pKey = null;
            for (Annotation pAnnotation : allPAnnotations[i]) {
                if (!(pAnnotation instanceof Action.Parameter)) continue;
                pKey = ((Action.Parameter)pAnnotation).value();
                break;
            }
            arguments[i] = this.getActionArgument(pTypes[i], pKey, actionEvent);
        }
        try {
            Object target = this.appAM.getActionsObject();
            taskObject = this.actionMethod.invoke(target, arguments);
        }
        catch (Exception e) {
            this.actionFailed(actionEvent, e);
        }
        if (taskObject instanceof Task) {
            Task task = (Task)((Object)taskObject);
            if (task.getInputBlocker() == null) {
                task.setInputBlocker(this.createInputBlocker(task, actionEvent));
            }
            ApplicationContext ctx = this.appAM.getContext();
            ctx.getTaskService().execute(task);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Action proxy = this.getProxy();
        if (proxy != null) {
            actionEvent.setSource(this.getProxySource());
            proxy.actionPerformed(actionEvent);
        } else if (this.actionMethod != null) {
            this.noProxyActionPerformed(actionEvent);
        }
    }

    public boolean isEnabled() {
        if (this.getProxy() != null || this.isEnabledMethod == null) {
            return super.isEnabled();
        }
        try {
            Object b = this.isEnabledMethod.invoke(this.appAM.getActionsObject(), new Object[0]);
            return (Boolean)b;
        }
        catch (Exception e) {
            throw this.newInvokeError(this.isEnabledMethod, e, new Object[0]);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.getProxy() != null || this.setEnabledMethod == null) {
            super.setEnabled(enabled);
        } else {
            try {
                this.setEnabledMethod.invoke(this.appAM.getActionsObject(), enabled);
            }
            catch (Exception e) {
                throw this.newInvokeError(this.setEnabledMethod, e, enabled);
            }
        }
    }

    public boolean isSelected() {
        if (this.getProxy() != null || this.isSelectedMethod == null) {
            Object v = this.getValue(SELECTED_KEY);
            return v instanceof Boolean ? (Boolean)v : false;
        }
        try {
            Object b = this.isSelectedMethod.invoke(this.appAM.getActionsObject(), new Object[0]);
            return (Boolean)b;
        }
        catch (Exception e) {
            throw this.newInvokeError(this.isSelectedMethod, e, new Object[0]);
        }
    }

    public void setSelected(boolean selected) {
        if (this.getProxy() != null || this.setSelectedMethod == null) {
            super.putValue(SELECTED_KEY, selected);
        } else {
            try {
                super.putValue(SELECTED_KEY, selected);
                if (selected != this.isSelected()) {
                    this.setSelectedMethod.invoke(this.appAM.getActionsObject(), selected);
                }
            }
            catch (Exception e) {
                throw this.newInvokeError(this.setSelectedMethod, e, selected);
            }
        }
    }

    public void putValue(String key, Object value) {
        if (SELECTED_KEY.equals(key) && value instanceof Boolean) {
            this.setSelected((Boolean)value);
        } else {
            super.putValue(key, value);
        }
    }

    private Error newInvokeError(Method m, Exception e, Object ... args) {
        String argsString = args.length == 0 ? "" : args[0].toString();
        for (int i = 1; i < args.length; ++i) {
            argsString = argsString + ", " + args[i];
        }
        String actionsClassName = this.appAM.getActionsObject().getClass().getName();
        String msg = String.format("%s.%s(%s) failed", actionsClassName, m, argsString);
        return new Error(msg, e);
    }

    void forwardPropertyChangeEvent(PropertyChangeEvent e, String actionPropertyName) {
        if ("selected".equals(actionPropertyName) && e.getNewValue() instanceof Boolean) {
            this.putValue(SELECTED_KEY, (Boolean)e.getNewValue());
        }
        this.firePropertyChange(actionPropertyName, e.getOldValue(), e.getNewValue());
    }

    private void actionFailed(ActionEvent actionEvent, Exception e) {
        throw new Error(e);
    }

    public String toString() {
        Object nameValue;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" ");
        boolean enabled = this.isEnabled();
        if (!enabled) {
            sb.append("(");
        }
        sb.append(this.getName());
        Object selectedValue = this.getValue(SELECTED_KEY);
        if (selectedValue instanceof Boolean && ((Boolean)selectedValue).booleanValue()) {
            sb.append("+");
        }
        if (!enabled) {
            sb.append(")");
        }
        if ((nameValue = this.getValue("Name")) instanceof String) {
            sb.append(" \"");
            sb.append((String)nameValue);
            sb.append("\"");
        }
        this.proxy = this.getProxy();
        if (this.proxy != null) {
            sb.append(" Proxy for: ");
            sb.append(this.proxy.toString());
        }
        return sb.toString();
    }

    private static class DefaultInputBlocker
    extends Task.InputBlocker {
        private JDialog modalDialog = null;

        DefaultInputBlocker(Task task, Task.BlockingScope scope, Object target) {
            super(task, scope, target);
            switch (scope) {
                case ACTION: {
                    if (target instanceof Action) break;
                    throw new IllegalArgumentException("target not an Action");
                }
                case COMPONENT: 
                case WINDOW: {
                    if (target instanceof Component) break;
                    throw new IllegalArgumentException("target not a Component");
                }
            }
        }

        private void setActionTargetBlocked(boolean f) {
            Action action = (Action)this.getTarget();
            action.setEnabled(!f);
        }

        private void setComponentTargetBlocked(boolean f) {
            Component component = (Component)this.getTarget();
            component.setEnabled(!f);
        }

        private JDialog createBlockingDialog() {
            JOptionPane optionPane = new JOptionPane();
            if (this.getTask().getUserCanCancel()) {
                JButton cancelButton = new JButton();
                cancelButton.setName("BlockingDialog.cancelButton");
                ActionListener doCancelTask = new ActionListener(){

                    public void actionPerformed(ActionEvent ignore) {
                        DefaultInputBlocker.this.getTask().cancel(true);
                    }
                };
                cancelButton.addActionListener(doCancelTask);
                optionPane.setOptions(new Object[]{cancelButton});
            }
            Component dialogOwner = (Component)this.getTarget();
            String taskTitle = this.getTask().getTitle();
            String dialogTitle = taskTitle == null ? "BlockingDialog" : taskTitle;
            JDialog dialog = optionPane.createDialog(dialogOwner, dialogTitle);
            dialog.setModal(true);
            dialog.setName("BlockingDialog");
            optionPane.setName("BlockingDialog.optionPane");
            ResourceMap resourceMap = this.getTask().getResourceMap();
            if (resourceMap != null) {
                resourceMap.injectComponents(dialog);
            }
            dialog.pack();
            return dialog;
        }

        private void showBlockingDialog(boolean f) {
            if (f) {
                if (this.modalDialog != null) {
                    String msg = String.format("unexpected InputBlocker state [%s] %s", f, this);
                    logger.warning(msg);
                    this.modalDialog.dispose();
                }
                this.modalDialog = this.createBlockingDialog();
                Runnable doShowDialog = new Runnable(){

                    public void run() {
                        DefaultInputBlocker.this.modalDialog.setVisible(true);
                    }
                };
                EventQueue.invokeLater(doShowDialog);
            } else if (this.modalDialog != null) {
                this.modalDialog.dispose();
                this.modalDialog = null;
            } else {
                String msg = String.format("unexpected InputBlocker state [%s] %s", f, this);
                logger.warning(msg);
            }
        }

        protected void block() {
            switch (this.getScope()) {
                case ACTION: {
                    this.setActionTargetBlocked(true);
                    break;
                }
                case COMPONENT: {
                    this.setComponentTargetBlocked(true);
                    break;
                }
                case WINDOW: 
                case APPLICATION: {
                    this.showBlockingDialog(true);
                }
            }
        }

        protected void unblock() {
            switch (this.getScope()) {
                case ACTION: {
                    this.setActionTargetBlocked(false);
                    break;
                }
                case COMPONENT: {
                    this.setComponentTargetBlocked(false);
                    break;
                }
                case WINDOW: 
                case APPLICATION: {
                    this.showBlockingDialog(false);
                }
            }
        }
    }

    private class ProxyPCL
    implements PropertyChangeListener {
        private ProxyPCL() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName == null || "enabled".equals(propertyName) || "selected".equals(propertyName) || "ShortDescription".equals(propertyName) || "LongDescription".equals(propertyName)) {
                ApplicationAction.this.updateProxyProperties();
            }
        }
    }
}

