/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import teamdev.jxcapture.samples.demo.AboutDialog;
import teamdev.jxcapture.samples.demo.ApplicationSettings;
import teamdev.jxcapture.samples.demo.CaptureOperations;
import teamdev.jxcapture.samples.demo.ImageFileChooser;
import teamdev.jxcapture.samples.demo.ImageViewer;
import teamdev.jxcapture.samples.demo.JxCaptureDemo;
import teamdev.jxcapture.samples.demo.SettingsDialog;

public class TrayPopupMenu
extends JPopupMenu {
    private ResourceBundle resource = ApplicationSettings.getResourceBundle();
    private CaptureOperations operations = CaptureOperations.getInstance();
    private ObjectCaptureAction objectCaptureAction = new ObjectCaptureAction();
    private RegionCaptureAction regionCaptureAction = new RegionCaptureAction();
    private DesktopCaptureAction desktopCaptureAction = new DesktopCaptureAction();
    private ActiveWindowCaptureAction windowCaptureAction = new ActiveWindowCaptureAction();
    private boolean captureOperationEnabled = true;
    private JxCaptureDemo application;
    static /* synthetic */ Class class$teamdev$jxcapture$samples$demo$ImageViewer;

    public TrayPopupMenu(JxCaptureDemo jxCaptureDemo) {
        this.application = jxCaptureDemo;
        this.configCaptureOperations();
        this.createGUI();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("captureOperationEnabled")) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    TrayPopupMenu.this.windowCaptureAction.setEnabled(bl);
                    TrayPopupMenu.this.objectCaptureAction.setEnabled(bl);
                    TrayPopupMenu.this.regionCaptureAction.setEnabled(bl);
                    TrayPopupMenu.this.desktopCaptureAction.setEnabled(bl);
                }
            }
        });
    }

    private void createGUI() {
        JMenuItem jMenuItem = new JMenuItem(this.windowCaptureAction);
        JMenuItem jMenuItem2 = new JMenuItem(this.objectCaptureAction);
        JMenuItem jMenuItem3 = new JMenuItem(this.regionCaptureAction);
        JMenuItem jMenuItem4 = new JMenuItem(this.desktopCaptureAction);
        JMenuItem jMenuItem5 = new JMenuItem(new OpenImageAction());
        JMenuItem jMenuItem6 = new JMenuItem(new SettingsAction());
        JMenuItem jMenuItem7 = new JMenuItem(new AboutAction());
        JMenuItem jMenuItem8 = new JMenuItem(new ExitAction());
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new CaptureToViewerAction());
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(new CaptureToFileAction());
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(new CaptureToClipboardAction());
        ApplicationSettings applicationSettings = ApplicationSettings.getInstance();
        jRadioButtonMenuItem.setSelected(applicationSettings.isCaptureToViewer());
        jRadioButtonMenuItem2.setSelected(applicationSettings.isCaptureToFile());
        jRadioButtonMenuItem3.setSelected(applicationSettings.isCaptureToClipboard());
        JMenu jMenu = new JMenu("Capture To");
        jMenu.setIcon(new ImageIcon((class$teamdev$jxcapture$samples$demo$ImageViewer == null ? (class$teamdev$jxcapture$samples$demo$ImageViewer = TrayPopupMenu.class$("teamdev.jxcapture.samples.demo.ImageViewer")) : class$teamdev$jxcapture$samples$demo$ImageViewer).getResource("resources/images/empty.png")));
        jMenu.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem3);
        jMenu.add(jRadioButtonMenuItem2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem3);
        this.add(jMenuItem);
        this.add(jMenuItem2);
        this.add(jMenuItem3);
        this.add(jMenuItem4);
        this.add(jMenuItem5);
        this.addSeparator();
        this.add(jMenu);
        this.addSeparator();
        this.add(jMenuItem6);
        this.add(jMenuItem7);
        this.addSeparator();
        this.add(jMenuItem8);
    }

    private void configCaptureOperations() {
        this.operations.addCaptureOperationsListener(new CaptureOperations.CaptureOperationsListener(){

            public void operationBegin() {
                TrayPopupMenu.this.setCaptureOperationEnabled(false);
            }

            public void operationComplete(boolean bl) {
                TrayPopupMenu.this.setCaptureOperationEnabled(true);
            }
        });
    }

    public void setCaptureOperationEnabled(boolean bl) {
        boolean bl2 = this.captureOperationEnabled;
        this.captureOperationEnabled = bl;
        this.firePropertyChange("captureOperationEnabled", bl2, this.captureOperationEnabled);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private abstract class FullAction
    extends SimpleAction {
        protected FullAction(String string) {
            super(string);
            String string2 = TrayPopupMenu.this.resource.getString("TrayPopupMenu.Action." + string + ".Accelerator");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(string2));
        }
    }

    private abstract class SimpleAction
    extends BaseAction {
        protected SimpleAction(String string) {
            super(string);
            String string2 = TrayPopupMenu.this.resource.getString("TrayPopupMenu.Action." + string + ".Icon");
            this.putValue("SmallIcon", new ImageIcon((class$teamdev$jxcapture$samples$demo$ImageViewer == null ? (class$teamdev$jxcapture$samples$demo$ImageViewer = TrayPopupMenu.class$("teamdev.jxcapture.samples.demo.ImageViewer")) : class$teamdev$jxcapture$samples$demo$ImageViewer).getResource(string2)));
        }
    }

    private abstract class BaseAction
    extends AbstractAction {
        protected BaseAction(String string) {
            this.putValue("Name", TrayPopupMenu.this.resource.getString("TrayPopupMenu.Action." + string + ".Text"));
        }
    }

    private class CaptureToClipboardAction
    extends BaseAction {
        private CaptureToClipboardAction() {
            super("ToClipboard");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ApplicationSettings.getInstance().setCaptureToClipboard();
        }
    }

    private class CaptureToFileAction
    extends AbstractAction {
        private CaptureToFileAction() {
            super("ToFile");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ApplicationSettings.getInstance().setCaptureToFile();
        }
    }

    private class CaptureToViewerAction
    extends AbstractAction {
        private CaptureToViewerAction() {
            super("ToViewer");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ApplicationSettings.getInstance().setCaptureToViewer();
        }
    }

    private class ExitAction
    extends SimpleAction {
        public ExitAction() {
            super("Exit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TrayPopupMenu.this.application.close();
        }
    }

    private class AboutAction
    extends SimpleAction {
        public AboutAction() {
            super("About");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ AboutAction this$1;
                {
                    this.this$1 = aboutAction;
                }

                public void run() {
                    AboutDialog aboutDialog = AboutDialog.getInstance();
                    aboutDialog.setVisible(true);
                    aboutDialog.toFront();
                }
            });
        }
    }

    private class SettingsAction
    extends SimpleAction {
        public SettingsAction() {
            super("Settings");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ SettingsAction this$1;
                {
                    this.this$1 = settingsAction;
                }

                public void run() {
                    SettingsDialog settingsDialog = SettingsDialog.getInstance();
                    settingsDialog.setVisible(true);
                    settingsDialog.toFront();
                }
            });
        }
    }

    private class OpenImageAction
    extends SimpleAction {
        private OpenImageAction() {
            super("OpenImage");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageViewer imageViewer;
            ImageFileChooser imageFileChooser = new ImageFileChooser();
            File file = imageFileChooser.openImageFile();
            if (file != null && (imageViewer = new ImageViewer()).setImage(file)) {
                imageViewer.setVisible(true);
                imageViewer.toFront();
            }
        }
    }

    private class DesktopCaptureAction
    extends FullAction {
        public DesktopCaptureAction() {
            super("Screen");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TrayPopupMenu.this.operations.desktopCapture();
        }
    }

    private class RegionCaptureAction
    extends FullAction {
        public RegionCaptureAction() {
            super("Region");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TrayPopupMenu.this.operations.regionCapture();
        }
    }

    private class ObjectCaptureAction
    extends FullAction {
        public ObjectCaptureAction() {
            super("Object");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TrayPopupMenu.this.operations.objectCapture();
        }
    }

    private class ActiveWindowCaptureAction
    extends FullAction {
        public ActiveWindowCaptureAction() {
            super("ActiveWindow");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TrayPopupMenu.this.operations.activeWindowCapture();
        }
    }
}

