/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import teamdev.jxcapture.samples.demo.ApplicationSettings;
import teamdev.jxcapture.samples.demo.CaptureOperations;
import teamdev.jxcapture.samples.demo.ImageViewer;
import teamdev.jxcapture.samples.demo.TrayPopupMenu;
import teamdev.jxdesktop.Keyboard;
import teamdev.jxdesktop.PlatformContext;
import teamdev.jxdesktop.win32.gdi.Icon;
import teamdev.jxdesktop.win32.shell.TrayIcon;
import teamdev.jxdesktop.win32.shell.TrayMessage;

public class JxCaptureDemo
implements Runnable {
    private TrayIcon trayIcon;
    private InputStream inputStream;
    private Keyboard keyboard = Keyboard.createKeyboard();
    private KeyListener keyboardListener = new KeyListener();
    private ResourceBundle resource = ApplicationSettings.getResourceBundle();
    static /* synthetic */ Class class$teamdev$jxcapture$samples$demo$JxCaptureDemo;

    public void run() {
        ApplicationSettings.getInstance().loadSettings();
        if (PlatformContext.isWindows()) {
            String string = this.resource.getString("TrayIcon.Message.Title");
            String string2 = this.resource.getString("TrayIcon.Message.Message");
            String string3 = this.resource.getString("TrayIcon.ToolTip.Text");
            TrayPopupMenu trayPopupMenu = new TrayPopupMenu(this);
            this.trayIcon = new TrayIcon(this.getTrayIcon());
            this.trayIcon.setToolTip(string3);
            this.trayIcon.setPopupMenu((JPopupMenu)trayPopupMenu);
            this.trayIcon.setVisible(true);
            this.trayIcon.showMessage((TrayMessage)new TrayMessage.Info(string, string2));
        } else {
            this.showApplicationWindow();
        }
        this.keyboard.addKeyListener((java.awt.event.KeyListener)this.keyboardListener);
    }

    private void showApplicationWindow() {
        throw new UnsupportedOperationException("JxCapture Demo window is not supported yet.");
    }

    private Icon getTrayIcon() {
        URL uRL = (class$teamdev$jxcapture$samples$demo$JxCaptureDemo == null ? (class$teamdev$jxcapture$samples$demo$JxCaptureDemo = JxCaptureDemo.class$("teamdev.jxcapture.samples.demo.JxCaptureDemo")) : class$teamdev$jxcapture$samples$demo$JxCaptureDemo).getResource("resources/images/JxCapture.ico");
        try {
            this.inputStream = uRL.openStream();
            return new Icon(this.inputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void close() {
        if (!this.canExit()) {
            return;
        }
        ApplicationSettings.getInstance().saveSettings();
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.trayIcon.setVisible(false);
        this.trayIcon.dispose();
        this.keyboard.removeKeyListener((java.awt.event.KeyListener)this.keyboardListener);
        this.keyboard.dispose();
        System.exit(0);
    }

    private boolean canExit() {
        List list = CaptureOperations.getInstance().getActiveViewers();
        for (int i = 0; i < list.size(); ++i) {
            ImageViewer imageViewer = (ImageViewer)list.get(i);
            if (imageViewer.close()) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        System.setProperty("javax.swing.adjustPopupLocationToFit", "false");
        SwingUtilities.invokeLater(new JxCaptureDemo());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class KeyListener
    extends KeyAdapter {
        private CaptureOperations operations = CaptureOperations.getInstance();

        private KeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isControlDown() && keyEvent.isShiftDown() && !this.operations.isBusy()) {
                switch (keyEvent.getKeyCode()) {
                    case 65: {
                        this.operations.activeWindowCapture();
                        break;
                    }
                    case 87: {
                        this.operations.objectCapture();
                        break;
                    }
                    case 82: {
                        this.operations.regionCapture();
                        break;
                    }
                    case 70: {
                        this.operations.desktopCapture();
                    }
                }
            }
        }
    }
}

