/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageComponent
extends JPanel {
    private final int[] percents = new int[]{10, 25, 50, 100, 200, 300, 400, 500};
    private final int defaultIndex = 3;
    private int currentIndex = 3;
    private double percentWidth;
    private double percentHeight;
    private BufferedImage originImage;
    private Image fastImage;
    private ImagePanel imagePanel = new ImagePanel();

    public ImageComponent() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(193, 193, 193));
        this.add((Component)this.imagePanel, "Center");
    }

    public void setImage(File file) throws Exception {
        BufferedImage bufferedImage = ImageIO.read(file);
        this.setImage(bufferedImage);
    }

    public void setImage(BufferedImage bufferedImage) {
        this.initialize(bufferedImage);
        this.fastImage = bufferedImage.getScaledInstance(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        this.imagePanel.updateImage(this.fastImage);
    }

    public void saveImage(File file) throws Exception {
        String string = file.getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        ImageIO.write((RenderedImage)this.originImage, string2, file);
    }

    public void zoomIn() {
        if (this.canZoomIn()) {
            this.zoomTo(++this.currentIndex);
        }
    }

    public void zoomOut() {
        if (this.canZoomOut()) {
            this.zoomTo(--this.currentIndex);
        }
    }

    public boolean canZoomIn() {
        return this.currentIndex != this.percents.length - 1;
    }

    public boolean canZoomOut() {
        return this.currentIndex != 0;
    }

    public int[] getPercents() {
        return this.percents;
    }

    public void actualSize() {
        this.imagePanel.updateImage(this.fastImage);
        this.currentIndex = 3;
    }

    public void fitToWindow(Dimension dimension) {
        int n = this.originImage.getWidth();
        int n2 = this.originImage.getHeight();
        Dimension dimension2 = new Dimension(n, n2);
        Dimension dimension3 = ImageComponent.getScaledDimension(dimension2, dimension);
        Image image = this.originImage.getScaledInstance(dimension3.width, dimension3.height, 2);
        this.imagePanel.updateImage(image);
    }

    public void dispose() {
        if (this.imagePanel != null) {
            this.imagePanel.dispose();
            this.imagePanel = null;
        }
        if (this.originImage != null) {
            this.originImage.flush();
            this.originImage = null;
        }
    }

    public void zoomTo(int n) {
        Image image = this.originImage;
        this.currentIndex = n;
        if (this.currentIndex != 3) {
            int n2 = (int)(this.percentWidth * (double)this.percents[n]);
            int n3 = (int)(this.percentHeight * (double)this.percents[n]);
            image = this.originImage.getScaledInstance(n2, n3, 2);
        }
        this.imagePanel.updateImage(image);
    }

    public BufferedImage getImage() {
        return this.originImage;
    }

    private static Dimension getScaledDimension(Dimension dimension, Dimension dimension2) {
        int n;
        int n2;
        double d = (double)dimension.width / (double)dimension.height;
        double d2 = (double)dimension2.width / (double)dimension2.height;
        if (d > d2) {
            n2 = dimension2.width;
            n = (int)((double)n2 / d);
        } else {
            n = dimension2.height;
            n2 = (int)((double)n * d);
        }
        if (n2 == 0 && dimension2.width > 0) {
            n2 = 1;
        }
        if (n == 0 && dimension2.height > 0) {
            n = 1;
        }
        return new Dimension(n2, n);
    }

    private void initialize(BufferedImage bufferedImage) {
        this.percentWidth = (double)bufferedImage.getWidth() / 100.0;
        this.percentHeight = (double)bufferedImage.getHeight() / 100.0;
        this.originImage = bufferedImage;
    }

    public class ImagePanel
    extends JLabel {
        private ImageIcon imageIcon;

        public ImagePanel() {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public void updateImage(Image image) {
            if (this.imageIcon != null) {
                this.dispose();
            }
            this.imageIcon = new ImageIcon(image);
            this.setIcon(this.imageIcon);
        }

        public void dispose() {
            if (this.imageIcon != null) {
                this.imageIcon.getImage().flush();
                this.imageIcon = null;
            }
        }
    }
}

