/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class ApplicationSettings {
    private static final String CAPTURE_TO_FILE = "CAPTURE_TO_FILE";
    private static final String CAPTURE_TO_VIEWER = "CAPTURE_TO_VIEWER";
    private static final String CAPTURE_TO_CLIPBOARD = "CAPTURE_TO_CLIPBOARD";
    private static final String INCLUDE_CURSOR = "INCLUDE_CURSOR";
    private static final String CAPTURE_TRANSPARENT_WINDOWS = "CAPTURE_TRANSPARENT_WINDOWS";
    private static final String DELAY_BEFORE_CAPTURE = "DELAY_BEFORE_CAPTURE";
    private static final String AUTO_SAVE = "AUTO_SAVE";
    private static final String DELAY_TIME = "DELAY_TIME";
    private static final String TEMPLATE_FILE_NAME = "TEMPLATE_FILE_NAME";
    private static final String OUTPUT_FOLDER = "OUTPUT_FOLDER";
    private static final String IMAGE_FORMAT_INDEX = "IMAGE_FORMAT_INDEX";
    private static final String TEMPLATE_NUMBER = "TEMPLATE_NUMBER";
    private static ApplicationSettings instance;
    private static ResourceBundle resource;
    private int maxDelayTime = 60000;
    private String[] imageFormats = new String[]{"png", "jpeg", "bmp", "gif"};
    private Map imageFormatExtensions = new HashMap();
    private String[] formatDescriptions = new String[]{"PNG Graphic (*.png)", "JPEG Graphic (*.jpeg, *.jpg)", "BMP Graphic (*.bmp)", "GIF Graphic (*.gif)"};
    private String configFileName = "appconfig.conf";
    private boolean captureToViewer = true;
    private boolean captureToFile;
    private boolean captureToClipboard;
    private boolean includeCursor;
    private boolean captureTransparentWindows;
    private boolean delayBeforeCapture;
    private boolean autoSave;
    private String templateFileName = "ScreenShot#";
    private String outputFolder = "";
    private int delayTime = 1000;
    private int imageFormatIndex;
    private int templateNumber;

    private ApplicationSettings() {
        this.imageFormatExtensions.put(this.imageFormats[0], new String[]{"png", "PNG"});
        this.imageFormatExtensions.put(this.imageFormats[1], new String[]{"jpeg", "JPEG", "jpg", "JPG"});
        this.imageFormatExtensions.put(this.imageFormats[2], new String[]{"bmp", "BMP"});
        this.imageFormatExtensions.put(this.imageFormats[3], new String[]{"gif", "GIF"});
    }

    public static ApplicationSettings getInstance() {
        return instance == null ? (instance = new ApplicationSettings()) : instance;
    }

    public static ResourceBundle getResourceBundle() {
        if (resource == null) {
            resource = ResourceBundle.getBundle("teamdev.jxcapture.samples.demo.resources.JxCaptureDemo");
        }
        return resource;
    }

    public void saveSettings() {
        Properties properties = new Properties();
        properties.setProperty(CAPTURE_TO_FILE, String.valueOf(this.captureToFile));
        properties.setProperty(CAPTURE_TO_VIEWER, String.valueOf(this.captureToViewer));
        properties.setProperty(CAPTURE_TO_CLIPBOARD, String.valueOf(this.captureToClipboard));
        properties.setProperty(INCLUDE_CURSOR, String.valueOf(this.includeCursor));
        properties.setProperty(CAPTURE_TRANSPARENT_WINDOWS, String.valueOf(this.captureTransparentWindows));
        properties.setProperty(DELAY_BEFORE_CAPTURE, String.valueOf(this.delayBeforeCapture));
        properties.setProperty(AUTO_SAVE, String.valueOf(this.autoSave));
        properties.setProperty(TEMPLATE_FILE_NAME, this.templateFileName);
        properties.setProperty(OUTPUT_FOLDER, this.outputFolder);
        properties.setProperty(DELAY_TIME, String.valueOf(this.delayTime));
        properties.setProperty(IMAGE_FORMAT_INDEX, String.valueOf(this.imageFormatIndex));
        properties.setProperty(TEMPLATE_NUMBER, String.valueOf(this.templateNumber));
        try {
            File file = new File(this.configFileName);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "JxCapture Demo Application Settings");
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadSettings() {
        Properties properties = new Properties();
        try {
            File file = new File(this.configFileName);
            if (!file.exists()) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.captureToFile = Boolean.valueOf(properties.getProperty(CAPTURE_TO_FILE));
        this.captureToViewer = Boolean.valueOf(properties.getProperty(CAPTURE_TO_VIEWER));
        this.captureToClipboard = Boolean.valueOf(properties.getProperty(CAPTURE_TO_CLIPBOARD));
        this.includeCursor = Boolean.valueOf(properties.getProperty(INCLUDE_CURSOR));
        this.captureTransparentWindows = Boolean.valueOf(properties.getProperty(CAPTURE_TRANSPARENT_WINDOWS));
        this.delayBeforeCapture = Boolean.valueOf(properties.getProperty(DELAY_BEFORE_CAPTURE));
        this.autoSave = Boolean.valueOf(properties.getProperty(AUTO_SAVE));
        this.templateFileName = properties.getProperty(TEMPLATE_FILE_NAME);
        this.outputFolder = properties.getProperty(OUTPUT_FOLDER);
        this.delayTime = Integer.valueOf(properties.getProperty(DELAY_TIME));
        this.imageFormatIndex = Integer.valueOf(properties.getProperty(IMAGE_FORMAT_INDEX));
        this.templateNumber = Integer.valueOf(properties.getProperty(TEMPLATE_NUMBER));
    }

    public boolean isIncludeCursor() {
        return this.includeCursor;
    }

    public void setIncludeCursor(boolean bl) {
        this.includeCursor = bl;
    }

    public boolean isCaptureTransparentWindows() {
        return this.captureTransparentWindows;
    }

    public void setCaptureTransparentWindows(boolean bl) {
        this.captureTransparentWindows = bl;
    }

    public boolean isDelayBeforeCapture() {
        return this.delayBeforeCapture;
    }

    public void setDelayBeforeCapture(boolean bl) {
        this.delayBeforeCapture = bl;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean bl) {
        this.autoSave = bl;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int n) {
        this.delayTime = n;
    }

    public int getImageFormatIndex() {
        return this.imageFormatIndex;
    }

    public void setImageFormatIndex(int n) {
        this.imageFormatIndex = n;
    }

    public int getTemplateNumber() {
        return this.templateNumber;
    }

    public void setTemplateNumber(int n) {
        this.templateNumber = n;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String string) {
        this.outputFolder = string;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplateFileName(String string) {
        this.templateFileName = string;
    }

    public boolean isCaptureToViewer() {
        return this.captureToViewer;
    }

    public void setCaptureToViewer() {
        this.resetCaptureToValues();
        this.captureToViewer = true;
    }

    public boolean isCaptureToFile() {
        return this.captureToFile;
    }

    public void setCaptureToFile() {
        this.resetCaptureToValues();
        this.captureToFile = true;
    }

    public boolean isCaptureToClipboard() {
        return this.captureToClipboard;
    }

    public void setCaptureToClipboard() {
        this.resetCaptureToValues();
        this.captureToClipboard = true;
    }

    public String[] getImageFormats() {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.4")) {
            return new String[]{this.imageFormats[0], this.imageFormats[1]};
        }
        if (string.startsWith("1.5")) {
            return new String[]{this.imageFormats[0], this.imageFormats[1], this.imageFormats[2]};
        }
        return this.imageFormats;
    }

    public String[] getFormatDescriptions() {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.4")) {
            return new String[]{this.formatDescriptions[0], this.formatDescriptions[1]};
        }
        if (string.startsWith("1.5")) {
            return new String[]{this.formatDescriptions[0], this.formatDescriptions[1], this.formatDescriptions[2]};
        }
        return this.formatDescriptions;
    }

    public String[] getFormatExtensions(String string) {
        Object v = this.imageFormatExtensions.get(string);
        if (v == null) {
            return new String[0];
        }
        return (String[])v;
    }

    public int getMaxDelayTime() {
        return this.maxDelayTime;
    }

    private void resetCaptureToValues() {
        this.captureToViewer = false;
        this.captureToFile = false;
        this.captureToClipboard = false;
    }
}

