/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.E;
import com.jniwrapper.Function;
import com.jniwrapper.LibraryLoader;
import com.jniwrapper.LibraryNotFoundException;
import com.jniwrapper.NativeResourceCollector;
import com.jniwrapper.NoSuchFunctionException;
import com.jniwrapper.NoSuchVariableException;
import com.jniwrapper.Parameter;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.Pointer;
import com.jniwrapper.g;
import java.io.File;

public class Library {
    public static final String NATIVE_CODE = PlatformContext.isLinux() && PlatformContext.isPPC() ? (PlatformContext.isPPC64() ? "jniwrap_ppc64" : "jniwrap_ppc") : (PlatformContext.isX64() ? "jniwrap64" : "jniwrap");
    private static boolean b = false;
    private String d;
    private E f;
    private static LibraryLoader c = null;
    private LibraryLoader e = null;
    private byte a = (byte)-1;

    public Library(String string, byte by) {
        this(string);
        if (by != 0 && by != 2 && by != 1) {
            throw new IllegalArgumentException();
        }
        this.a = by;
    }

    public Library(String string) {
        this.d = string;
        this.e = Library.getDefaultLibraryLoader();
    }

    public static void loadNativeCode(LibraryLoader libraryLoader) throws SecurityException, UnsatisfiedLinkError {
        if (!b) {
            try {
                libraryLoader.loadLibrary(NATIVE_CODE);
                b = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new UnsatisfiedLinkError("Cannot find JNIWrapper native library in java.library.path.");
            }
        }
    }

    public static void loadNativeCode(String string) throws SecurityException, UnsatisfiedLinkError {
        if (!b) {
            System.load(string);
            b = true;
        }
    }

    public static void loadNativeCode() throws SecurityException, UnsatisfiedLinkError {
        Library.loadNativeCode(Library.getDefaultLibraryLoader());
    }

    public static void ensureNativeCode() {
        if (!b) {
            Library.loadNativeCode();
        }
    }

    public void load() throws LibraryNotFoundException {
        Library.ensureNativeCode();
        if (this.isLoaded()) {
            return;
        }
        File file = Library.getDefaultLibraryLoader().findLibrary(this.d);
        if (file == null || !file.exists()) {
            this.a(this.d);
        } else {
            this.a(file.getAbsolutePath());
        }
    }

    private void a(String string) throws LibraryNotFoundException {
        long l2 = Library.loadLibrary((string + '\u0000').getBytes());
        this.f = new E(l2);
        NativeResourceCollector.getInstance().addNativeResource(this, this.f);
    }

    public void load(File file) throws LibraryNotFoundException {
        Library.ensureNativeCode();
        if (this.isLoaded()) {
            return;
        }
        File file2 = new File(file, this.d);
        this.a(file2.getAbsolutePath());
    }

    public void load(LibraryLoader libraryLoader) throws LibraryNotFoundException {
        Library.ensureNativeCode();
        if (this.isLoaded()) {
            return;
        }
        this.e = libraryLoader;
        File file = libraryLoader.findLibrary(this.d);
        if (file == null) {
            throw new LibraryNotFoundException(this.d);
        }
        this.a(file.getAbsolutePath());
    }

    public void load(ClassLoader classLoader) {
        Library.ensureNativeCode();
        if (this.isLoaded()) {
            return;
        }
        this.e = new DefaultLibraryLoader(classLoader, System.getProperty("java.library.path"), this.d);
        File file = this.e.findLibrary(this.d);
        if (file == null) {
            throw new LibraryNotFoundException(this.d);
        }
        this.a(file.getAbsolutePath());
    }

    protected void unload() {
        this.f.unload();
    }

    public boolean isLoaded() {
        if (this.f != null) {
            return this.f.isLoaded();
        }
        return false;
    }

    public String getName() {
        return this.d;
    }

    long a() {
        return this.f.getLibID();
    }

    public Function getFunction(String string, Class[] classArray) throws NoSuchFunctionException, LibraryNotFoundException {
        if (!this.isLoaded()) {
            this.load();
        }
        Function function = new Function(this, string);
        if (this.a != -1) {
            function.setCallingConvention(this.a);
        }
        return function;
    }

    public Function getFunction(String string) throws NoSuchFunctionException, LibraryNotFoundException {
        return this.getFunction(string, null);
    }

    public void getVariable(String string, Parameter parameter) throws NoSuchVariableException {
        if (!this.isLoaded()) {
            this.load();
        }
        long l2 = Library.getVariableHandle(this.a(), string);
        Pointer pointer = new Pointer(parameter);
        new Pointer.Void(l2).castTo(pointer);
        NativeResourceCollector.getInstance().addNativeResource(parameter, new g(this));
    }

    public LibraryLoader getLibraryLoader() {
        return this.e;
    }

    public static LibraryLoader getDefaultLibraryLoader() {
        if (c == null) {
            c = DefaultLibraryLoader.getInstance();
        }
        return c;
    }

    public static void setDefaultLibraryLoader(LibraryLoader libraryLoader) {
        c = libraryLoader;
    }

    private static native long loadLibrary(byte[] var0) throws LibraryNotFoundException;

    private static native void freeLibrary(long var0);

    private static native long getVariableHandle(long var0, String var2) throws NoSuchVariableException;

    static void a(long l2) {
        Library.freeLibrary(l2);
    }
}

