/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import teamdev.jxcapture.samples.demo.CaptureOperations;
import teamdev.jxcapture.samples.demo.ImageComponent;
import teamdev.jxcapture.samples.demo.ImageFileChooser;

public class ImageViewer
extends JFrame {
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private ImageComponent imageComponent;
    private JButton zoomToButton;
    private boolean zoomInEnabled = true;
    private boolean zoomOutEnabled = true;
    private boolean imageModified = false;
    private JPopupMenu zoomToPopupMenu = new JPopupMenu();

    public ImageViewer() throws HeadlessException {
        ApplicationContext applicationContext = Application.getInstance().getContext();
        this.resourceMap = applicationContext.getResourceMap(ImageViewer.class);
        this.actionMap = applicationContext.getActionMap(ImageViewer.class, (Object)this);
        this.setSize(750, 500);
        this.setName("ImageViewer");
        this.setLocationRelativeTo(null);
        this.setIconImage(this.resourceMap.getImageIcon("icon").getImage());
        this.createMenuBar();
        this.createContentPane();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ImageViewer.this.close();
            }
        });
        this.resourceMap.injectComponents((Component)this);
    }

    private void createMenuBar() {
        String string = this.getSeparatorValue();
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createMenu("FileMenu", new String[]{"open", "save", string, "close"}));
        jMenuBar.add(this.createMenu("ViewMenu", new String[]{"zoomIn", "zoomOut", "zoomTo", string, "actualSize", "fitToWindow"}));
        jMenuBar.add(this.createMenu("EditMenu", new String[]{"copy"}));
        jMenuBar.add(this.createMenu("SettingsMenu", new String[]{"settings"}));
        jMenuBar.add(this.createMenu("HelpMenu", new String[]{"about"}));
        this.setJMenuBar(jMenuBar);
    }

    private JMenu createMenu(String string, String[] stringArray) {
        JMenu jMenu = new JMenu();
        jMenu.setName(string);
        String string2 = this.getSeparatorValue();
        for (String string3 : stringArray) {
            JMenuItem jMenuItem;
            if (string3.equals(string2)) {
                jMenu.add(new JSeparator());
                continue;
            }
            if (string3.equals("zoomTo")) {
                jMenuItem = new JMenu();
                this.configZoomToMenu(string3, (JMenu)jMenuItem);
                jMenu.add(jMenuItem);
                continue;
            }
            jMenuItem = new JMenuItem();
            this.configMenuItem(string3, jMenuItem);
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    private void configMenuItem(String string, JMenuItem jMenuItem) {
        jMenuItem.setName(string);
        jMenuItem.setAction(this.actionMap.get(string));
        jMenuItem.setIcon(this.getIcon(string, "menu"));
    }

    private JToolBar createToolBar() {
        String string = this.getSeparatorValue();
        String[] stringArray = new String[]{"open", "save", string, "copy", string, "zoomIn", "zoomOut", "zoomTo", string, "settings"};
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        for (String string2 : stringArray) {
            if (string2.equals(string)) {
                jToolBar.addSeparator();
                continue;
            }
            if (string2.equals("zoomTo")) {
                jToolBar.add(this.createZoomToButton(string2, emptyBorder));
                continue;
            }
            jToolBar.add(this.createToolBarButton(string2, emptyBorder));
        }
        return jToolBar;
    }

    private ImageComponent getImageComponent() {
        return this.imageComponent == null ? (this.imageComponent = new ImageComponent()) : this.imageComponent;
    }

    private JButton createToolBarButton(String string, Border border) {
        JButton jButton = new JButton();
        jButton.setName(string);
        jButton.setBorder(border);
        jButton.setVerticalTextPosition(3);
        jButton.setHorizontalTextPosition(0);
        jButton.setAction(this.actionMap.get(string));
        jButton.setIcon(this.getIcon(string, "button"));
        jButton.setFocusable(false);
        return jButton;
    }

    private JButton createZoomToButton(String string, Border border) {
        this.zoomToButton = this.createToolBarButton(string, border);
        this.zoomToPopupMenu.add(new JMenuItem(this.actionMap.get("actualSize")));
        this.zoomToPopupMenu.add(new JMenuItem(this.actionMap.get("fitToWindow")));
        this.zoomToPopupMenu.addSeparator();
        List<PercentAction> list = this.getZoomToActions();
        for (PercentAction percentAction : list) {
            this.zoomToPopupMenu.add(new JMenuItem(percentAction));
        }
        this.zoomToPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                ImageViewer.this.zoomToButton.setSelected(true);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                ImageViewer.this.zoomToButton.setSelected(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        return this.zoomToButton;
    }

    private void configZoomToMenu(String string, JMenu jMenu) {
        this.configMenuItem(string, jMenu);
        List<PercentAction> list = this.getZoomToActions();
        for (PercentAction percentAction : list) {
            jMenu.add(new JMenuItem(percentAction));
        }
    }

    private List<PercentAction> getZoomToActions() {
        LinkedList<PercentAction> linkedList = new LinkedList<PercentAction>();
        int[] nArray = this.getImageComponent().getPercents();
        for (int i = 0; i < nArray.length; ++i) {
            linkedList.add(new PercentAction(nArray[i], i));
        }
        return linkedList;
    }

    private void createContentPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createToolBar(), "North");
        jPanel.add((Component)new JScrollPane(this.getImageComponent()), "Center");
        this.setContentPane(jPanel);
    }

    private Icon getIcon(String string, String string2) {
        return this.resourceMap.getIcon(string + "." + string2 + ".icon");
    }

    private String getSeparatorValue() {
        return this.resourceMap.getString("separator", new Object[0]);
    }

    private void updateZoomActionState() {
        this.setZoomInEnabled(this.getImageComponent().canZoomIn());
        this.setZoomOutEnabled(this.getImageComponent().canZoomOut());
    }

    private boolean isImageModified() {
        return this.imageModified;
    }

    private void setImageModified(boolean bl) {
        this.imageModified = bl;
    }

    private boolean confirmSaveImage() {
        String string = this.resourceMap.getString("confirmSaveImageDialog.Title", new Object[0]);
        String string2 = this.resourceMap.getString("confirmSaveImageDialog.Message", new Object[0]);
        int n = JOptionPane.showConfirmDialog(this, string2, string, 1);
        switch (n) {
            case 0: {
                return this.save();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.getImageComponent().setImage(bufferedImage);
        this.setImageModified(true);
    }

    public boolean setImage(File file) {
        try {
            this.getImageComponent().setImage(file);
        }
        catch (Exception exception) {
            String string = this.resourceMap.getString("openImageErrorDialog.Title", new Object[0]);
            String string2 = this.resourceMap.getString("openImageErrorDialog.Message", new Object[0]);
            string2 = String.format(string2, file.getAbsolutePath());
            JOptionPane.showMessageDialog(this, string2, string, 0);
            return false;
        }
        this.setImageModified(false);
        return true;
    }

    public boolean isZoomInEnabled() {
        return this.zoomInEnabled;
    }

    public boolean isZoomOutEnabled() {
        return this.zoomOutEnabled;
    }

    public void setZoomInEnabled(boolean bl) {
        boolean bl2 = this.zoomInEnabled;
        this.zoomInEnabled = bl;
        this.firePropertyChange("zoomInEnabled", bl2, this.zoomInEnabled);
    }

    public void setZoomOutEnabled(boolean bl) {
        boolean bl2 = this.zoomOutEnabled;
        this.zoomOutEnabled = bl;
        this.firePropertyChange("zoomOutEnabled", bl2, this.zoomOutEnabled);
    }

    @Action
    public boolean close() {
        if (this.isImageModified() && !this.confirmSaveImage()) {
            return false;
        }
        this.getImageComponent().dispose();
        this.setVisible(false);
        this.dispose();
        return true;
    }

    @Action
    public void open() {
        if (this.isImageModified() && !this.confirmSaveImage()) {
            return;
        }
        ImageFileChooser imageFileChooser = new ImageFileChooser(this);
        File file = imageFileChooser.openImageFile();
        if (file != null) {
            this.setImage(file);
        }
    }

    @Action
    public boolean save() {
        ImageFileChooser imageFileChooser = new ImageFileChooser(this);
        File file = imageFileChooser.saveImageFile();
        if (file != null) {
            try {
                this.getImageComponent().saveImage(file);
                this.setImageModified(false);
                return true;
            }
            catch (Exception exception) {
                String string = this.resourceMap.getString("saveImageErrorDialog.Title", new Object[0]);
                String string2 = this.resourceMap.getString("saveImageErrorDialog.Message", new Object[0]);
                string2 = String.format(string2, file.getAbsolutePath());
                JOptionPane.showMessageDialog(this, string2, string, 0);
                return false;
            }
        }
        return false;
    }

    @Action
    public void copy() {
        CaptureOperations.getInstance().copyToClipboard(this.getImageComponent().getImage());
    }

    @Action(enabledProperty="zoomInEnabled")
    public void zoomIn() {
        ImageComponent imageComponent = this.getImageComponent();
        if (imageComponent.canZoomIn()) {
            imageComponent.zoomIn();
        }
        this.updateZoomActionState();
    }

    @Action(enabledProperty="zoomOutEnabled")
    public void zoomOut() {
        ImageComponent imageComponent = this.getImageComponent();
        if (imageComponent.canZoomOut()) {
            imageComponent.zoomOut();
        }
        this.updateZoomActionState();
    }

    @Action
    public void zoomTo() {
        this.zoomToPopupMenu.show(this.zoomToButton, 0, this.zoomToButton.getBounds().height);
    }

    @Action
    public void actualSize() {
        this.getImageComponent().actualSize();
        this.updateZoomActionState();
    }

    @Action
    public void fitToWindow() {
        ImageComponent imageComponent = this.getImageComponent();
        Dimension dimension = imageComponent.getParent().getSize();
        imageComponent.fitToWindow(dimension);
    }

    private class PercentAction
    extends AbstractAction {
        private int index = 0;

        public PercentAction(int n, int n2) {
            this.index = n2;
            this.putValue("Name", n + " %");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(String.valueOf(n2 + 1)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImageViewer.this.getImageComponent().zoomTo(this.index);
            ImageViewer.this.updateZoomActionState();
        }
    }
}

