/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32.ui;

import com.jniwrapper.Bool;
import com.jniwrapper.Callback;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.Int8;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.ShortInt;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.FlagSet;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import teamdev.jxdesktop.win32.FunctionName;
import teamdev.jxdesktop.win32.Handle;
import teamdev.jxdesktop.win32.IntPtr;
import teamdev.jxdesktop.win32.LastError;
import teamdev.jxdesktop.win32.LastErrorException;
import teamdev.jxdesktop.win32.Msg;
import teamdev.jxdesktop.win32.Point;
import teamdev.jxdesktop.win32.Rect;
import teamdev.jxdesktop.win32.Size;
import teamdev.jxdesktop.win32.gdi.ColorRef;
import teamdev.jxdesktop.win32.gdi.DC;
import teamdev.jxdesktop.win32.gdi.Icon;
import teamdev.jxdesktop.win32.gdi.Region;
import teamdev.jxdesktop.win32.ui.FlashInfo;
import teamdev.jxdesktop.win32.ui.PaintStruct;
import teamdev.jxdesktop.win32.ui.User32;
import teamdev.jxdesktop.win32.ui.WindowMessageListener;
import teamdev.jxdesktop.win32.ui.WindowProc;
import teamdev.jxdesktop.win32.ui.WindowTools;
import teamdev.jxdesktop.win32.ui.c;

public class Wnd
extends Handle {
    private WindowProc e;
    private WindowMessageListener c;
    public static final int GW_HWNDFIRST = 0;
    public static final int GW_HWNDLAST = 1;
    public static final int GW_HWNDNEXT = 2;
    public static final int GW_HWNDPREV = 3;
    public static final int GW_OWNER = 4;
    public static final int GW_CHILD = 5;
    private static final FunctionName h = new FunctionName("FindWindow");
    private static final FunctionName a = new FunctionName("FindWindowEx");
    private static final FunctionName b = new FunctionName("CreateWindowEx");
    private static final FunctionName d = new FunctionName("GetClassName");
    private static final FunctionName j = new FunctionName("SetWindowLong");
    private static final FunctionName g = new FunctionName("GetWindowLong");
    private static final FunctionName i = new FunctionName("PeekMessage");
    private static final FunctionName m = new FunctionName("SendMessage");
    private static final FunctionName f = new FunctionName("PostMessage");
    private static final FunctionName l = new FunctionName("CallWindowProc");
    private static final FunctionName k = new FunctionName("GetWindowText");
    public static final String FUNCTION_GET_WINDOW_THREAD_PROCESS_ID = "GetWindowThreadProcessId";
    public static final int WS_OVERLAPPED = 0;
    public static final int WS_POPUP = Integer.MIN_VALUE;
    public static final int WS_CHILD = 0x40000000;
    public static final int WS_MINIMIZE = 0x20000000;
    public static final int WS_VISIBLE = 0x10000000;
    public static final int WS_DISABLED = 0x8000000;
    public static final int WS_CLIPSIBLINGS = 0x4000000;
    public static final int WS_CLIPCHILDREN = 0x2000000;
    public static final int WS_MAXIMIZE = 0x1000000;
    public static final int WS_CAPTION = 0xC00000;
    public static final int WS_BORDER = 0x800000;
    public static final int WS_DLGFRAME = 0x400000;
    public static final int WS_VSCROLL = 0x200000;
    public static final int WS_HSCROLL = 0x100000;
    public static final int WS_SYSMENU = 524288;
    public static final int WS_THICKFRAME = 262144;
    public static final int WS_GROUP = 131072;
    public static final int WS_TABSTOP = 65536;
    public static final int WS_MINIMIZEBOX = 131072;
    public static final int WS_MAXIMIZEBOX = 65536;
    public static final int WS_OVERLAPPEDWINDOW = 0xCF0000;
    public static final int WS_POPUPWINDOW = -2138570752;
    public static final int WS_CHILDWINDOW = 0x40000000;
    public static final int WS_TILED = 0;
    public static final int WS_ICONIC = 0x20000000;
    public static final int WS_SIZEBOX = 262144;
    public static final int WS_TILEDWINDOW = 0xCF0000;
    public static final int WS_EX_DLGMODALFRAME = 1;
    public static final int WS_EX_NOPARENTNOTIFY = 4;
    public static final int WS_EX_TOPMOST = 8;
    public static final int WS_EX_ACCEPTFILES = 16;
    public static final int WS_EX_TRANSPARENT = 32;
    public static final int WS_EX_MDICHILD = 64;
    public static final int WS_EX_TOOLWINDOW = 128;
    public static final int WS_EX_WINDOWEDGE = 256;
    public static final int WS_EX_CLIENTEDGE = 512;
    public static final int WS_EX_CONTEXTHELP = 1024;
    public static final int WS_EX_RIGHT = 4096;
    public static final int WS_EX_LEFT = 0;
    public static final int WS_EX_RTLREADING = 8192;
    public static final int WS_EX_LTRREADING = 0;
    public static final int WS_EX_LEFTSCROLLBAR = 16384;
    public static final int WS_EX_RIGHTSCROLLBAR = 0;
    public static final int WS_EX_CONTROLPARENT = 65536;
    public static final int WS_EX_STATICEDGE = 131072;
    public static final int WS_EX_APPWINDOW = 262144;
    public static final int WS_EX_OVERLAPPEDWINDOW = 768;
    public static final int WS_EX_PALETTEWINDOW = 392;
    public static final int WS_EX_LAYERED = 524288;
    public static final int LWA_COLORKEY = 1;
    public static final int LWA_ALPHA = 2;
    public static final int SWP_NOSIZE = 1;
    public static final int SWP_NOMOVE = 2;
    public static final int SWP_NOZORDER = 4;
    public static final int SWP_NOREDRAW = 8;
    public static final int SWP_NOACTIVATE = 16;
    public static final int SWP_FRAMECHANGED = 32;
    public static final int SWP_SHOWWINDOW = 64;
    public static final int SWP_HIDEWINDOW = 128;
    public static final int SWP_NOCOPYBITS = 256;
    public static final int SWP_NOOWNERZORDER = 512;
    public static final int SWP_NOSENDCHANGING = 1024;
    public static final int SWP_DRAWFRAME = 32;
    public static final int SWP_NOREPOSITION = 512;
    public static final int SWP_DEFERERASE = 8192;
    public static final int SWP_ASYNCWINDOWPOS = 16384;
    public static final int HWND_TOP = 0;
    public static final int HWND_BOTTOM = 1;
    public static final int HWND_TOPMOST = -1;
    public static final int HWND_NOTOPMOST = -2;
    public static final int GWL_WNDPROC = -4;
    public static final int GWL_HINSTANCE = -6;
    public static final int GWL_HWNDPARENT = -8;
    public static final int GWL_STYLE = -16;
    public static final int GWL_EXSTYLE = -20;
    public static final int GWL_USERDATA = -21;
    public static final int GWL_ID = -12;
    public static final int RDW_INVALIDATE = 1;
    public static final int RDW_INTERNALPAINT = 2;
    public static final int RDW_ERASE = 4;
    public static final int RDW_VALIDATE = 8;
    public static final int RDW_NOINTERNALPAINT = 16;
    public static final int RDW_NOERASE = 32;
    public static final int RDW_NOCHILDREN = 64;
    public static final int RDW_ALLCHILDREN = 128;
    public static final int RDW_UPDATENOW = 256;
    public static final int RDW_ERASENOW = 512;
    public static final int RDW_FRAME = 1024;
    public static final int RDW_NOFRAME = 2048;
    public static final int OPAQUE = 255;
    public static final int TRANSPARENT = 0;

    public Wnd() {
    }

    public Wnd(long l2) {
        super(l2);
    }

    public Wnd(Component component) {
        this(WindowTools.getWindowHandle(component));
    }

    static Function a(Object object) {
        return User32.getInstance().getFunction(object.toString());
    }

    public void eventLoop() {
        Wnd.eventLoop(this.getValue());
    }

    public static void eventLoop(long l2) {
        if (l2 == 0L) {
            throw new IllegalArgumentException("Event processing window is not available");
        }
        Function function = Wnd.a(User32.FUNCTION_GET_MESSAGE);
        Function function2 = Wnd.a("TranslateMessage");
        Function function3 = Wnd.a(User32.FUNCTION_DISPATCH_MESSAGE);
        Wnd wnd = new Wnd(l2);
        ShortInt shortInt = new ShortInt(1L);
        Msg msg = new Msg();
        IntPtr intPtr = new IntPtr(0L);
        while (shortInt.getValue() != 0L) {
            Pointer pointer = new Pointer((Parameter)msg);
            function.invoke((Parameter)shortInt, (Parameter)pointer, (Parameter)wnd, (Parameter)intPtr, (Parameter)intPtr);
            if (shortInt.getValue() == -1L) break;
            function2.invoke(null, (Parameter)pointer);
            function3.invoke(null, (Parameter)pointer);
        }
    }

    public static Wnd findWindow(String string, String string2) {
        Function function = Wnd.a(h);
        Wnd wnd = new Wnd();
        Handle handle = string2 == null ? new Handle() : new Str(string2);
        Str str = new Str(string);
        function.invoke((Parameter)wnd, (Parameter)new Pointer((Parameter)str), (Parameter)handle);
        return wnd;
    }

    public static Wnd findWindowEx(Wnd wnd, String string, String string2) {
        Function function = Wnd.a(a);
        Wnd wnd2 = new Wnd();
        Handle handle = string2 == null ? new Handle() : new Str(string2);
        Str str = new Str(string);
        function.invoke((Parameter)wnd2, (Parameter)(wnd != null ? wnd : new Handle()), (Parameter)new Handle(), (Parameter)new Pointer((Parameter)str), (Parameter)new Pointer((Parameter)handle));
        return wnd2;
    }

    public static Wnd findWindow(String string) {
        return Wnd.findWindow(string, null);
    }

    public static Wnd findWindowByName(String string) {
        Function function = Wnd.a(h);
        Wnd wnd = new Wnd();
        function.invoke((Parameter)wnd, (Parameter)new Pointer(null, true), (Parameter)new Str(string));
        return wnd;
    }

    public static Wnd getDesktopWindow() {
        Function function = Wnd.a("GetDesktopWindow");
        Wnd wnd = new Wnd();
        function.invoke((Parameter)wnd);
        return wnd;
    }

    private static Wnd a(Object object, Parameter[] parameterArray) {
        Wnd wnd = new Wnd();
        Function function = Wnd.a(object);
        long l2 = function.invoke((Parameter)wnd, parameterArray);
        if (wnd.getValue() == 0L) {
            throw new LastErrorException(l2, "Cannot create window.");
        }
        return wnd;
    }

    public static Wnd createWindow(String string, String string2, int n2, long l2, long l3, long l4, long l5, Wnd wnd, Handle handle, Handle handle2, Handle handle3) {
        return Wnd.a(b, new Parameter[]{new UInt(0L), new Str(string), new Str(string2), new Int((long)n2), new Int(l2), new Int(l3), new Int(l4), new Int(l5), wnd, handle, handle2, handle3});
    }

    public static Wnd createWindow(int n2, String string, String string2, int n3, long l2, long l3, long l4, long l5, Wnd wnd, Handle handle, Handle handle2, Handle handle3) {
        return Wnd.a(b, new Parameter[]{new Int32(n2), new Str(string), new Str(string2), new Int((long)n3), new Int(l2), new Int(l3), new Int(l4), new Int(l5), wnd, handle, handle2, handle3});
    }

    public static Wnd createWindow(String string) {
        Handle handle = new Handle();
        Wnd wnd = new Wnd();
        return Wnd.createWindow(0, string, string, 0, 0L, 0L, 0L, 0L, wnd, handle, handle, handle);
    }

    public void update() {
        Function function = Wnd.a("UpdateWindow");
        Int intVal = new Int();
        long l2 = function.invoke((Parameter)intVal, (Parameter)this);
        if (intVal.getValue() == 0L) {
            throw new LastErrorException(l2, "Error updating window.");
        }
    }

    public void destroy() {
        Function function = Wnd.a("DestroyWindow");
        Int intVal = new Int();
        long l2 = function.invoke((Parameter)intVal, (Parameter)this);
        if (intVal.getValue() == 0L) {
            throw new LastErrorException(l2, "Error destroying window.");
        }
    }

    public Size getSize() {
        Size size = new Size();
        Rect rect = this.getWindowRect();
        size.setCx(rect.getRightAsInt() - rect.getLeftAsInt());
        size.setCy(rect.getBottomAsInt() - rect.getTopAsInt());
        return size;
    }

    public Size getClientSize() {
        Size size = new Size();
        Rect rect = this.getClientRect();
        size.setCx(rect.getRightAsInt() - rect.getLeftAsInt());
        size.setCy(rect.getBottomAsInt() - rect.getTopAsInt());
        return size;
    }

    public Rect getBounds() {
        Rect rect = new Rect();
        Function function = Wnd.a("GetWindowRect");
        function.invoke(null, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)rect));
        return rect;
    }

    public Rect getWindowRect() {
        Function function = Wnd.a("GetWindowRect");
        Rect rect = new Rect();
        function.invoke(null, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)rect));
        return rect;
    }

    public void centerInDesktop() {
        Rect rect = Wnd.getDesktopWindow().getWindowRect();
        Rect rect2 = this.getWindowRect();
        int n2 = (rect.getWidth() - rect2.getWidth()) / 2;
        int n3 = (rect.getHeight() - rect2.getHeight()) / 2;
        rect2.moveTo(n2, n3);
        this.moveWindow((int)rect2.getLeft(), (int)rect2.getTop(), rect2.getWidth(), rect2.getHeight(), true);
    }

    public Rect getClientRect() {
        Rect rect = new Rect();
        Function function = Wnd.a("GetClientRect");
        function.invoke(null, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)rect));
        return rect;
    }

    public void setRegion(Region region, boolean bl) {
        Function function = Wnd.a("SetWindowRgn");
        function.invoke(null, (Parameter)this, (Parameter)(region == null ? new Handle() : region), (Parameter)new Bool(bl));
    }

    public Region getRegion() {
        Region region = new Region();
        Function function = Wnd.a("GetWindowRgn");
        function.invoke(null, (Parameter)this, (Parameter)region);
        return region;
    }

    public boolean setPosition(Wnd wnd, long l2, long l3, long l4, long l5, long l6) {
        Function function = Wnd.a("SetWindowPos");
        IntBool intBool = new IntBool();
        long l7 = function.invoke((Parameter)intBool, new Parameter[]{this, wnd, new Int(l2), new Int(l3), new Int(l4), new Int(l5), new UInt(l6)});
        if (intBool.getValue() == 0L) {
            throw new LastErrorException(l7, "Failed to show splash.", true);
        }
        return true;
    }

    public DC beginPaint(PaintStruct paintStruct) {
        Function function = Wnd.a("BeginPaint");
        DC dC = new DC();
        long l2 = function.invoke((Parameter)dC, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)paintStruct));
        if (dC.isNull()) {
            throw new LastErrorException(l2, "Failed to get DC.", true);
        }
        return dC;
    }

    public void endPaint(PaintStruct paintStruct) {
        Function function = User32.getInstance().getFunction("EndPaint");
        function.invoke(null, (Parameter)this, (Parameter)new Pointer.Const((Parameter)paintStruct));
    }

    public boolean sendMessage(int n2, long l2, long l3) {
        Function function = Wnd.a(m);
        Bool bool = new Bool();
        function.invoke((Parameter)bool, (Parameter)this, (Parameter)new UInt((long)n2), (Parameter)new IntPtr(l2), (Parameter)new IntPtr(l3));
        return bool.getValue();
    }

    public long sendMessageEx(int n2, long l2, long l3) {
        Function function = Wnd.a(m);
        IntPtr intPtr = new IntPtr();
        function.invoke((Parameter)intPtr, (Parameter)this, (Parameter)new UInt((long)n2), (Parameter)new IntPtr(l2), (Parameter)new IntPtr(l3));
        return intPtr.getValue();
    }

    public boolean peekMessage(long l2, boolean bl) {
        return this.peekMessage(new Msg(), l2, l2, bl);
    }

    public boolean peekMessage(Msg msg, long l2, long l3, boolean bl) {
        Function function = Wnd.a(i);
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{new Pointer((Parameter)msg), this, new UInt(l2), new UInt(l3), new UInt(bl ? 1L : 0L)});
        return bool.getValue();
    }

    public boolean postMessage(int n2, long l2, long l3) {
        Function function = Wnd.a(f);
        IntBool intBool = new IntBool();
        function.invoke((Parameter)intBool, (Parameter)this, (Parameter)new UInt((long)n2), (Parameter)new IntPtr(l2), (Parameter)new IntPtr(l3));
        return intBool.getBooleanValue();
    }

    public void show(ShowWindowCommand showWindowCommand) {
        Function function = Wnd.a("ShowWindow");
        function.invoke(null, (Parameter)this, (Parameter)new Int((long)showWindowCommand.getValue()));
    }

    public void setWindowLong(int n2, long l2) {
        this.setWindowLong(n2, (Parameter)new IntPtr(l2));
    }

    public long setWindowLong(int n2, Parameter parameter) {
        UInt uInt = new UInt();
        Function function = Wnd.a(j);
        LastError.setValue(0);
        long l2 = function.invoke((Parameter)uInt, (Parameter)this, (Parameter)new Int((long)n2), parameter);
        if (uInt.getValue() == 0L && l2 != 0L) {
            throw new LastErrorException(l2);
        }
        return uInt.getValue();
    }

    public long getWindowLong(int n2) {
        IntPtr intPtr = new IntPtr();
        Function function = Wnd.a(g);
        LastError.setValue(0);
        long l2 = function.invoke((Parameter)intPtr, (Parameter)this, (Parameter)new Int((long)n2));
        return intPtr.getValue();
    }

    public void setLayeredWindowAttributes(ColorRef colorRef, byte by, int n2) {
        Function function = Wnd.a("SetLayeredWindowAttributes");
        function.invoke(null, (Parameter)this, (Parameter)(colorRef == null ? new ColorRef(0L) : colorRef), (Parameter)new Int8(by), (Parameter)new UInt32((long)n2));
    }

    public boolean getLayeredWindowAttributes(ColorRef colorRef, Int8 int8, UInt32 uInt32) {
        Function function = Wnd.a("GetLayeredWindowAttributes");
        Int32 int32 = new Int32();
        function.invoke((Parameter)int32, (Parameter)this, (Parameter)(colorRef == null ? new Pointer.Void(0L) : new Pointer.OutOnly((Parameter)colorRef)), (Parameter)(int8 == null ? new Pointer.Void(0L) : new Pointer.OutOnly((Parameter)int8)), (Parameter)(uInt32 == null ? new Pointer.Void(0L) : new Pointer.OutOnly((Parameter)uInt32)));
        return int32.getValue() != 0L;
    }

    public void redraw(Rect rect, Region region, int n2) {
        Function function = Wnd.a("RedrawWindow");
        function.invoke(null, (Parameter)this, (Parameter)new Pointer((Parameter)rect, rect == null), (Parameter)(region == null ? new Region() : region), (Parameter)new UInt((long)n2));
    }

    public void setParent(Wnd wnd) {
        Function function = Wnd.a("SetParent");
        Wnd wnd2 = new Wnd();
        LastError.clearLastErrorCode();
        long l2 = function.invoke((Parameter)wnd2, (Parameter)this, (Parameter)wnd);
        if (wnd2.isNull() && l2 != 0L) {
            throw new LastErrorException(l2);
        }
    }

    public Wnd getParent() {
        Function function = Wnd.a("GetParent");
        Wnd wnd = new Wnd();
        function.invoke((Parameter)wnd, (Parameter)this);
        return wnd;
    }

    public void bringToTop() {
        Function function = Wnd.a("BringWindowToTop");
        function.invoke(null, (Parameter)this);
    }

    public void setForeground() {
        Function function = Wnd.a("SetForegroundWindow");
        function.invoke(null, (Parameter)this);
    }

    public static long callWindowProc(Handle handle, Wnd wnd, UInt uInt, Pointer.Void void_, Pointer.Void void_2) {
        Function function = Wnd.a(l);
        IntPtr intPtr = new IntPtr();
        function.invoke((Parameter)intPtr, new Parameter[]{handle, wnd, uInt, void_, void_2});
        return intPtr.getValue();
    }

    public void moveWindow(int n2, int n3, int n4, int n5, boolean bl) {
        Function function = Wnd.a("MoveWindow");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{this, new Int((long)n2), new Int((long)n3), new Int((long)n4), new Int((long)n5), new Bool(bl)});
    }

    public void moveWindow(int n2, int n3, int n4, int n5) {
        this.moveWindow(n2, n3, n4, n5, false);
    }

    public boolean getUpdateRect(Rect rect, boolean bl) {
        Function function = Wnd.a("GetUpdateRect");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)rect), (Parameter)new Bool(bl));
        return bool.getValue();
    }

    public boolean getUpdateRect(Rect rect) {
        return this.getUpdateRect(rect, false);
    }

    public boolean flashWindow(FlashInfo flashInfo) {
        Function function = Wnd.a("FlashWindowEx");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, (Parameter)new Pointer((Parameter)flashInfo));
        return bool.getValue();
    }

    public String getWindowClassName() {
        Str str = new Str();
        Function function = User32.getInstance().getFunction(d.toString());
        function.invoke(null, (Parameter)this, (Parameter)str, (Parameter)new Int((long)str.getMaxLength()));
        return str.getValue();
    }

    public Wnd getWindow(int n2) {
        Wnd wnd = new Wnd();
        User32.getInstance().getFunction("GetWindow").invoke((Parameter)wnd, (Parameter)this, (Parameter)new UInt((long)n2));
        return wnd;
    }

    public Object clone() {
        return new Wnd(this.getValue());
    }

    public Point screenToClient(Point point) {
        Function function = User32.getInstance().getFunction("ScreenToClient");
        Bool bool = new Bool();
        Point point2 = new Point(point);
        long l2 = function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Pointer((Parameter)point2));
        if (!bool.getValue()) {
            throw new LastErrorException(l2);
        }
        return point2;
    }

    public Point clientToScreen(Point point) {
        Function function = User32.getInstance().getFunction("ClientToScreen");
        Bool bool = new Bool();
        Point point2 = new Point(point);
        long l2 = function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Pointer((Parameter)point2));
        if (!bool.getValue()) {
            throw new LastErrorException(l2);
        }
        return point2;
    }

    public static List getAllWindows() {
        IntBool intBool = new IntBool();
        IntPtr intPtr = new IntPtr();
        EnumWindowsCallback enumWindowsCallback = new EnumWindowsCallback();
        Function function = User32.getInstance().getFunction("EnumWindows");
        function.invoke((Parameter)intBool, (Parameter)enumWindowsCallback, (Parameter)intPtr);
        enumWindowsCallback.dispose();
        return enumWindowsCallback.getWindows();
    }

    public static List getChildWindows(Wnd wnd) {
        IntBool intBool = new IntBool();
        IntPtr intPtr = new IntPtr();
        EnumWindowsCallback enumWindowsCallback = new EnumWindowsCallback();
        Function function = User32.getInstance().getFunction("EnumChildWindows");
        function.invoke((Parameter)intBool, (Parameter)wnd, (Parameter)enumWindowsCallback, (Parameter)intPtr);
        enumWindowsCallback.dispose();
        return enumWindowsCallback.getWindows();
    }

    public List getChildWindows() {
        return Wnd.getChildWindows(this);
    }

    public static List getThreadWindows(long l2) {
        IntBool intBool = new IntBool();
        IntPtr intPtr = new IntPtr();
        EnumWindowsCallback enumWindowsCallback = new EnumWindowsCallback();
        Function function = User32.getInstance().getFunction("EnumThreadWindows");
        function.invoke((Parameter)intBool, (Parameter)new UInt32(l2), (Parameter)enumWindowsCallback, (Parameter)intPtr);
        enumWindowsCallback.dispose();
        return enumWindowsCallback.getWindows();
    }

    public String getWindowText() {
        Function function = User32.getInstance().getFunction(k.toString());
        Str str = new Str(1024);
        Int intVal = new Int();
        function.invoke((Parameter)intVal, (Parameter)this, (Parameter)new Pointer((Parameter)str), (Parameter)new Int(1024L));
        return str.getValue();
    }

    public void setVisible(boolean bl) {
        long l2 = this.getWindowLong(-16);
        l2 = !bl ? (l2 &= 0xFFFFFFFFEFFFFFFFL) : (l2 |= 0x10000000L);
        this.setWindowLong(-16, l2);
    }

    public boolean isVisible() {
        long l2 = this.getWindowLong(-16);
        return (l2 & 0x10000000L) != 0L;
    }

    public void setWindowStyle(long l2) {
        this.setWindowLong(-16, l2);
        this.setPosition(this, 0L, 0L, 0L, 0L, 39L);
    }

    public long getWindowStyle() {
        return this.getWindowLong(-16);
    }

    public void setWindowExStyle(long l2) {
        this.setWindowLong(-20, l2);
        this.setPosition(this, 0L, 0L, 0L, 0L, 39L);
    }

    public long getWindowExStyle() {
        return this.getWindowLong(-20);
    }

    public boolean isTransparent() {
        long l2 = this.getWindowExStyle();
        return (l2 & 0x80000L) != 0L;
    }

    public void setTransparent(boolean bl) {
        long l2 = this.getWindowExStyle();
        if (bl) {
            long l3 = l2 | 0x80000L;
            this.setWindowExStyle(l3);
            this.setLayeredWindowAttributes(new ColorRef(0L), this.getTransparency(), 2);
        } else {
            long l4 = l2 & 0xFFFFFFFFFFF7FFFFL;
            this.setWindowExStyle(l4);
        }
        this.redraw(null, null, 288);
    }

    public void setTransparent(byte by) {
        long l2 = this.getWindowExStyle();
        if (by != 0) {
            long l3 = l2 | 0x80000L;
            this.setWindowExStyle(l3);
            this.setLayeredWindowAttributes(new ColorRef(0L), by, 2);
        } else {
            long l4 = l2 & 0xFFFFFFFFFFF7FFFFL;
            this.setWindowExStyle(l4);
        }
        this.redraw(null, null, 288);
    }

    public byte getTransparency() {
        Int8 int8 = new Int8();
        this.getLayeredWindowAttributes(null, int8, null);
        return (byte)int8.getValue();
    }

    public void setTransparency(byte by) {
        this.setLayeredWindowAttributes(null, by, 2);
    }

    public boolean isPalleteWindow() {
        long l2 = this.getWindowExStyle();
        return (l2 & 0x188L) != 0L;
    }

    public void setPalleteWindow(boolean bl) {
        long l2 = this.getWindowExStyle();
        long l3 = bl ? l2 | 0x188L : l2 & 0xFFFFFFFFFFFFFE77L;
        this.setWindowExStyle(l3);
        this.redraw(null, null, 1025);
    }

    public void setTopmost(boolean bl) {
        int n2 = -2;
        if (bl) {
            n2 = -1;
        }
        this.setPosition(new Wnd(n2), 0L, 0L, 0L, 0L, 3L);
    }

    public void setRounded(boolean bl, int n2, int n3) {
        Region region = null;
        if (bl) {
            Rect rect = this.getWindowRect();
            rect.moveTo(0L, 0L);
            region = Region.createRoundRectRegion((int)rect.getLeft(), (int)rect.getTop(), (int)rect.getRight(), (int)rect.getBottom(), n2, n3);
        }
        this.setRegion(region, true);
    }

    public void setRounded(boolean bl) {
        this.setRounded(bl, 30, 30);
    }

    public void setWindowIcon(Icon icon, Icon.IconType iconType) {
        this.sendMessageEx(128, iconType.getValue(), icon.getValue());
    }

    public void setCaptionVisible(boolean bl) {
        long l2 = this.getWindowStyle();
        long l3 = bl ? l2 | 0xC00000L : l2 & 0xFFFFFFFFFF3FFFFFL;
        this.setWindowStyle(l3);
        this.redraw(null, null, 6);
    }

    public boolean isCaptionVisible() {
        long l2 = this.getWindowStyle();
        return (l2 & 0xC00000L) != 0L;
    }

    public void setBorderVisible(boolean bl) {
        long l2 = this.getWindowStyle();
        long l3 = bl ? l2 | 0x800000L : l2 & 0xFFFFFFFFFFFBFFFFL;
        this.setWindowStyle(l3);
    }

    public boolean isBorderVisible() {
        long l2 = this.getWindowStyle();
        return (l2 & 0x800000L) != 0L;
    }

    public Region setRegion(Region region) {
        Region region2 = this.getRegion();
        this.setRegion(region, true);
        return region2;
    }

    public void setContinuousRepainting(boolean bl) {
        WindowMessageListener windowMessageListener = this.a();
        WindowProc windowProc = this.b();
        if (bl) {
            windowProc.addMessageListener(windowMessageListener);
            windowProc.substitute();
        } else {
            windowProc.removeMessageListener(windowMessageListener);
            windowProc.restoreNative();
        }
    }

    private WindowProc b() {
        if (this.e == null) {
            this.e = new WindowProc(this);
        }
        return this.e;
    }

    private WindowMessageListener a() {
        if (this.c == null) {
            this.c = new c(this);
        }
        return this.c;
    }

    public Wnd setFocus() {
        Function function = User32.getInstance().getFunction("SetFocus");
        Wnd wnd = new Wnd();
        function.invoke((Parameter)wnd, (Parameter)this);
        return wnd;
    }

    public static Wnd getFocus() {
        Function function = User32.getInstance().getFunction("GetFocus");
        Wnd wnd = new Wnd();
        function.invoke((Parameter)wnd);
        return wnd;
    }

    public int getThreadId() {
        Function function = User32.getInstance().getFunction(FUNCTION_GET_WINDOW_THREAD_PROCESS_ID);
        UInt32 uInt32 = new UInt32();
        function.invoke((Parameter)uInt32, (Parameter)this, (Parameter)new Handle());
        return (int)uInt32.getValue();
    }

    public int getProcessId() {
        Function function = User32.getInstance().getFunction(FUNCTION_GET_WINDOW_THREAD_PROCESS_ID);
        UInt32 uInt32 = new UInt32();
        UInt32 uInt322 = new UInt32();
        function.invoke((Parameter)uInt32, (Parameter)this, (Parameter)new Pointer((Parameter)uInt322));
        return (int)uInt322.getValue();
    }

    public void invalidateRect(Rect rect, boolean bl) {
        Function function = User32.getInstance().getFunction("InvalidateRect");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Pointer((Parameter)rect, rect == null), (Parameter)new Bool(bl));
    }

    public void setHotKey(HotKey hotKey) {
        long l2 = (long)(hotKey.getKeyCode() & 0xFF) | (hotKey.getFlags() & 0xFFL) * 256L;
        long l3 = this.sendMessageEx(50, l2, 0L);
        if (l3 <= 0L) {
            throw new RuntimeException("The window handle or hot key is invalid.");
        }
    }

    public HotKey getHotKey() {
        long l2 = this.sendMessageEx(51, 0L, 0L);
        if (l2 == 0L) {
            return null;
        }
        long l3 = l2 & 0xFFL;
        long l4 = l2 >> 8;
        HotKey hotKey = new HotKey((int)l3);
        hotKey.setupFlag(l4, true);
        return hotKey;
    }

    public boolean isWindow() {
        Function function = User32.getInstance().getFunction("IsWindow");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, (Parameter)this);
        return bool.getValue();
    }

    public static Wnd getForegroundWindow() {
        Wnd wnd = new Wnd();
        Function function = User32.getInstance().getFunction("GetForegroundWindow");
        function.invoke((Parameter)wnd);
        return wnd;
    }

    public static Wnd getWindowFromPoint(int n2, int n3) {
        Wnd wnd = new Wnd();
        Function function = User32.getInstance().getFunction("WindowFromPoint");
        function.invoke((Parameter)wnd, (Parameter)new Point(n2, n3));
        return wnd;
    }

    public boolean isMaximized() {
        Function function = User32.getInstance().getFunction("IsZoomed");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, (Parameter)this);
        return bool.getValue();
    }

    public boolean test() {
        return false;
    }

    public boolean isWindowVisible() {
        Function function = User32.getInstance().getFunction("IsWindowVisible");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, (Parameter)this);
        return bool.getValue();
    }

    public static boolean openClipboard(Wnd wnd) {
        Function function = User32.getInstance().getFunction("OpenClipboard");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, (Parameter)(wnd != null ? wnd : new Pointer.Void()));
        return bool.getValue();
    }

    public static boolean closeClipboard() {
        Function function = User32.getInstance().getFunction("CloseClipboard");
        Bool bool = new Bool();
        function.invoke((Parameter)bool);
        return bool.getValue();
    }

    public static boolean emptyClipboard() {
        Function function = User32.getInstance().getFunction("EmptyClipboard");
        Bool bool = new Bool();
        function.invoke((Parameter)bool);
        return bool.getValue();
    }

    public static Handle setClipboardData(int n2, Handle handle) {
        Function function = User32.getInstance().getFunction("SetClipboardData");
        Handle handle2 = new Handle();
        function.invoke((Parameter)handle2, (Parameter)new UInt((long)n2), (Parameter)handle);
        return handle2;
    }

    public static class HotKey
    extends FlagSet {
        private int a;

        public HotKey(int n2) {
            this.a = n2;
        }

        public void setAlt(boolean bl) {
            this.setupFlag(1L, bl);
        }

        public boolean isAlt() {
            return this.contains(1L);
        }

        public void setControl(boolean bl) {
            this.setupFlag(2L, bl);
        }

        public boolean isControl() {
            return this.contains(2L);
        }

        public void setShift(boolean bl) {
            this.setupFlag(4L, bl);
        }

        public boolean isShift() {
            return this.contains(4L);
        }

        public int getKeyCode() {
            return this.a;
        }
    }

    public static class EnumWindowsCallback
    extends Callback {
        private Wnd b = new Wnd();
        private IntPtr a = new IntPtr();
        private Bool d = new Bool();
        private List c = new LinkedList();

        public EnumWindowsCallback() {
            this.init(new Parameter[]{this.b, this.a}, (Parameter)this.d);
        }

        public void callback() {
            this.c.add(new Wnd(this.b.getValue()));
            this.d.setValue(true);
        }

        public List getWindows() {
            return this.c;
        }
    }

    public static class ShowWindowCommand
    extends EnumItem {
        public static final ShowWindowCommand HIDE = new ShowWindowCommand(0);
        public static final ShowWindowCommand SHOWNORMAL = new ShowWindowCommand(1);
        public static final ShowWindowCommand NORMAL = new ShowWindowCommand(1);
        public static final ShowWindowCommand SHOWMINIMIZED = new ShowWindowCommand(2);
        public static final ShowWindowCommand SHOWMAXIMIZED = new ShowWindowCommand(3);
        public static final ShowWindowCommand MAXIMIZE = new ShowWindowCommand(3);
        public static final ShowWindowCommand SHOWNOACTIVATE = new ShowWindowCommand(4);
        public static final ShowWindowCommand SHOW = new ShowWindowCommand(5);
        public static final ShowWindowCommand MINIMIZE = new ShowWindowCommand(6);
        public static final ShowWindowCommand SHOWMINNOACTIVE = new ShowWindowCommand(7);
        public static final ShowWindowCommand SHOWNA = new ShowWindowCommand(8);
        public static final ShowWindowCommand RESTORE = new ShowWindowCommand(9);
        public static final ShowWindowCommand SHOWDEFAULT = new ShowWindowCommand(10);
        public static final ShowWindowCommand FORCEMINIMIZE = new ShowWindowCommand(11);
        public static final ShowWindowCommand MAX = new ShowWindowCommand(11);

        protected ShowWindowCommand(int n2) {
            super(n2);
        }
    }
}

