/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32.system;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import java.io.File;
import teamdev.jxdesktop.win32.FunctionName;
import teamdev.jxdesktop.win32.Handle;
import teamdev.jxdesktop.win32.LastErrorException;
import teamdev.jxdesktop.win32.WinFunctionCache;
import teamdev.jxdesktop.win32.process.Process;
import teamdev.jxdesktop.win32.system.VersionInfo;

public class Kernel32
extends WinFunctionCache {
    private static final FunctionName e = new FunctionName("GetWindowsDirectory");
    private static final FunctionName g = new FunctionName("GetSystemDirectory");
    private static final FunctionName h = new FunctionName("GlobalAddAtom");
    private static final FunctionName d = new FunctionName("GetCurrentDirectory");
    private static final FunctionName f = new FunctionName("SetCurrentDirectory");
    private boolean c;
    private static Kernel32 a;

    private Kernel32() {
        super("kernel32");
    }

    protected void setupEncoding() {
    }

    public boolean isUnicode() {
        if (!this.c) {
            VersionInfo versionInfo = new VersionInfo();
            this.setUnicode(versionInfo.isNT());
            this.c = true;
        }
        return super.isUnicode();
    }

    public void setUnicode(boolean bl) {
        this.c = true;
        super.setUnicode(bl);
    }

    public static Kernel32 getInstance() {
        if (a == null) {
            a = new Kernel32();
        }
        return a;
    }

    public static int multiByteToWideChar(int n2, int n3, Pointer.Void void_, int n4, Pointer.Void void_2, int n5) {
        Function function = Kernel32.getInstance().getFunction("MultiByteToWideChar");
        Int intVal = new Int();
        function.invoke((Parameter)intVal, new Parameter[]{new UInt((long)n2), new UInt32((long)n3), void_, new Int((long)n4), void_2, new Int((long)n5)});
        return (int)intVal.getValue();
    }

    public static int lstrlen(Pointer.Void void_) {
        Function function = Kernel32.getInstance().getFunction("lstrlen");
        Int intVal = new Int();
        function.invoke((Parameter)intVal, (Parameter)void_);
        return (int)intVal.getValue();
    }

    public static int mulDiv(int n2, int n3, int n4) {
        Function function = Kernel32.getInstance().getFunction("MulDiv");
        Int intVal = new Int();
        function.invoke((Parameter)intVal, (Parameter)new Int((long)n2), (Parameter)new Int((long)n3), (Parameter)new Int((long)n4));
        return (int)intVal.getValue();
    }

    public static int getCurrentThreadId() {
        UInt32 uInt32 = new UInt32();
        Function function = Kernel32.getInstance().getFunction("GetCurrentThreadId");
        function.invoke((Parameter)uInt32);
        return (int)uInt32.getValue();
    }

    public static int getCurrentProcessId() {
        UInt32 uInt32 = new UInt32();
        Function function = Kernel32.getInstance().getFunction("GetCurrentProcessId");
        function.invoke((Parameter)uInt32);
        return (int)uInt32.getValue();
    }

    public static String getWindowsDirectory() {
        Str str = new Str();
        UInt32 uInt32 = new UInt32((long)str.getMaxLength());
        UInt32 uInt322 = new UInt32();
        Function function = Kernel32.getInstance().getFunction(e.toString());
        function.invoke((Parameter)uInt322, (Parameter)new Pointer((Parameter)str), (Parameter)uInt32);
        if (uInt322.getValue() != 0L && uInt322.getValue() <= 256L) {
            return str.getValue().endsWith("\\") ? str.getValue() : str.getValue() + "\\";
        }
        return null;
    }

    public static String getSystemDirectory() {
        Str str = new Str();
        UInt32 uInt32 = new UInt32((long)str.getMaxLength());
        UInt32 uInt322 = new UInt32();
        Function function = Kernel32.getInstance().getFunction(g.toString());
        function.invoke((Parameter)uInt322, (Parameter)new Pointer((Parameter)str), (Parameter)uInt32);
        if (uInt322.getValue() != 0L && uInt322.getValue() <= 256L) {
            return str.getValue().endsWith("\\") ? str.getValue() : str.getValue() + "\\";
        }
        return null;
    }

    public static int globalAddAtom(String string) {
        if (string == null) {
            throw new IllegalArgumentException("value cannot be null.");
        }
        Function function = Kernel32.getInstance().getFunction(h.toString());
        UInt16 uInt16 = new UInt16();
        long l2 = function.invoke((Parameter)uInt16, (Parameter)new Str(string));
        if (uInt16.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
        return (int)uInt16.getValue();
    }

    public static String getCurrentDirectory() {
        Function function = Kernel32.getInstance().getFunction(d.toString());
        Str str = new Str(255);
        UInt32 uInt32 = new UInt32();
        function.invoke((Parameter)uInt32, (Parameter)new UInt32((long)str.getLength()), (Parameter)new Pointer((Parameter)str));
        if (uInt32.getValue() == 0L) {
            str.setValue("");
        } else if (uInt32.getValue() >= 255L) {
            str = new Str((int)uInt32.getValue());
            function.invoke((Parameter)uInt32, (Parameter)new UInt32((long)str.getLength()), (Parameter)new Pointer((Parameter)str));
            if (uInt32.getValue() == 0L) {
                str.setValue("");
            }
        }
        return str.getValue();
    }

    public static void setCurrentDirectory(String string) {
        if (string == null || !new File(string).isDirectory()) {
            throw new IllegalArgumentException("The specified directory is invalid.");
        }
        Function function = Kernel32.getInstance().getFunction(f.toString());
        function.invoke((Parameter)new IntBool(), (Parameter)new Str(string));
    }

    public static long getProcessId(Process process) {
        UInt32 uInt32 = new UInt32();
        Function function = Kernel32.getInstance().getFunction("GetProcessId");
        long l2 = function.invoke((Parameter)uInt32, (Parameter)process);
        if (uInt32.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
        return uInt32.getValue();
    }

    public static long processIdToSessionId(UInt32 uInt32) {
        Handle handle = new Handle();
        UInt32 uInt322 = new UInt32();
        Function function = Kernel32.getInstance().getFunction("ProcessIdToSessionId");
        long l2 = function.invoke((Parameter)handle, (Parameter)uInt32, (Parameter)new Pointer((Parameter)uInt322));
        if (handle.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
        return uInt322.getValue();
    }
}

