/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.ComplexArray;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.Logger;
import com.jniwrapper.util.StreamUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import teamdev.jxdesktop.win32.FunctionName;
import teamdev.jxdesktop.win32.Handle;
import teamdev.jxdesktop.win32.LastErrorException;
import teamdev.jxdesktop.win32.Size;
import teamdev.jxdesktop.win32.gdi.Bitmap;
import teamdev.jxdesktop.win32.gdi.BitmapInfo;
import teamdev.jxdesktop.win32.gdi.BitmapInfoHeader;
import teamdev.jxdesktop.win32.gdi.BitmapStructure;
import teamdev.jxdesktop.win32.gdi.DC;
import teamdev.jxdesktop.win32.gdi.DDBitmap;
import teamdev.jxdesktop.win32.gdi.GdiObject;
import teamdev.jxdesktop.win32.gdi.IconDir;
import teamdev.jxdesktop.win32.gdi.IconDirEntry;
import teamdev.jxdesktop.win32.gdi.IconInfo;
import teamdev.jxdesktop.win32.gdi.RGBQuad;
import teamdev.jxdesktop.win32.gdi.WindowDC;
import teamdev.jxdesktop.win32.ui.User32;

public class Icon
extends GdiObject {
    private static final Logger b = Logger.getInstance((Class)(c == null ? (c = Icon.a("teamdev.jxdesktop.win32.gdi.Icon")) : c));
    private static final FunctionName g = new FunctionName("LoadIcon");
    private static final FunctionName i = new FunctionName("LoadImage");
    private Dimension d = new Dimension(IconType.SMALL.getSize());
    private int h;
    static Class c;
    static Class e;
    static Class f;

    static Function a(Object object) {
        return User32.getInstance().getFunction(object.toString());
    }

    protected void update() {
        IconInfo iconInfo;
        Bitmap bitmap;
        if (!this.isNull() && !(bitmap = (iconInfo = this.getIconInfo()).getColorBitmap()).isNull()) {
            Size size = bitmap.getSize();
            this.d.width = size.getCx();
            this.d.height = size.getCy();
            this.h = bitmap.getBitCount();
        }
    }

    public Icon() {
    }

    public Icon(long l2) {
        super(l2);
    }

    public Icon(Dimension dimension) {
        this.d.setSize(dimension);
    }

    public Icon(String string) {
        this(new Handle(), string);
    }

    public Icon(Handle handle, String string) {
        Function function = Icon.a(g);
        long l2 = function.invoke((Parameter)this, (Parameter)handle, (Parameter)new Str(string));
        if (this.isNull()) {
            throw new LastErrorException(l2, "Failed to load icon.", true);
        }
        this.update();
    }

    public Icon(File file) {
        this.load(file);
    }

    public Icon(File file, Dimension dimension) {
        this.load(file, dimension);
    }

    public Icon(Handle handle, File file) {
        this.load(handle, file, this.getSize());
    }

    public void load(File file) {
        this.load(file, this.getSize());
    }

    public void load(File file, Dimension dimension) {
        this.load(new Handle(), file, dimension);
    }

    public void load(Handle handle, File file, Dimension dimension) {
        if (file == null) {
            throw new IllegalArgumentException("File is null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exsist.");
        }
        if (dimension == null) {
            throw new IllegalArgumentException("Invalid size parameter.");
        }
        Function function = Icon.a((Object)i.toString());
        long l2 = function.invoke((Parameter)this, new Parameter[]{handle, new Str(file.getAbsolutePath()), new UInt((long)GdiObject.ImageType.ICON.getValue()), new Int((long)dimension.width), new Int((long)dimension.height), new UInt(32784L)});
        if (this.isNull()) {
            throw new LastErrorException(l2, "Failed to load icon.", true);
        }
        this.update();
    }

    public Icon(InputStream inputStream) throws IOException {
        this.load(inputStream, this.getSize());
    }

    public Icon(InputStream inputStream, Dimension dimension) throws IOException {
        this.load(inputStream, dimension);
    }

    public Icon(Component component, javax.swing.Icon icon) {
        this();
        this.a(component, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Component component, javax.swing.Icon icon) {
        int n2 = icon.getIconWidth();
        int n3 = icon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 1);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                if (bufferedImage.getRGB(i2, i3) == 0) {
                    bufferedImage2.setRGB(i2, i3, 0xFFFFFF);
                    continue;
                }
                bufferedImage2.setRGB(i2, i3, 0);
            }
        }
        DDBitmap dDBitmap = new DDBitmap(bufferedImage);
        DDBitmap dDBitmap2 = new DDBitmap(bufferedImage2);
        IconInfo iconInfo = new IconInfo(dDBitmap2, dDBitmap);
        Function function = Icon.a((Object)"CreateIconIndirect");
        try {
            long l2 = function.invoke((Parameter)this, (Parameter)new Pointer((Parameter)iconInfo));
            if (this.isNull()) {
                throw new LastErrorException(l2, "Failed to create icon from the resource.");
            }
        }
        finally {
            dDBitmap.deleteObject();
            dDBitmap2.deleteObject();
        }
    }

    public void load(InputStream inputStream, Dimension dimension) throws IOException {
        this.a(inputStream, dimension, -1);
    }

    public void load(InputStream inputStream, int n2) throws IOException {
        this.a(inputStream, null, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(InputStream inputStream, Dimension dimension, int n2) {
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            byte[] byArray = StreamUtils.readBytes((InputStream)inputStream);
            if (byArray.length == 0) {
                throw new IllegalArgumentException("Input Stream is empty.");
            }
            IconDir iconDir = new IconDir();
            iconDir.read(byArray, 0);
            int n3 = iconDir.getCount();
            iconDir.getEntries().setElementCount(n3);
            ComplexArray complexArray = iconDir.getEntries();
            boolean bl = false;
            for (int i2 = 0; i2 < n3; ++i2) {
                WindowDC windowDC;
                int n4;
                List list;
                int n5;
                IconDirEntry iconDirEntry = (IconDirEntry)complexArray.getElement(i2);
                int n6 = iconDir.getLength() + i2 * iconDirEntry.getLength();
                iconDirEntry.read(byArray, n6);
                int n7 = iconDirEntry.getWidth();
                int n8 = iconDirEntry.getHeight();
                if (dimension == null) {
                    if (i2 != n2) {
                        continue;
                    }
                } else {
                    int n9 = n5 = n7 == dimension.width && n8 == dimension.height ? 1 : 0;
                    if (n5 == 0) continue;
                }
                bl = true;
                n5 = iconDirEntry.getImageOffset();
                int n10 = iconDirEntry.getBytesInRes();
                byte[] byArray2 = new byte[n10];
                System.arraycopy(byArray, n5, byArray2, 0, n10);
                n6 = 0;
                BitmapInfo bitmapInfo = new BitmapInfo();
                bitmapInfo.read(byArray2, n6);
                BitmapInfoHeader bitmapInfoHeader = bitmapInfo.getBitmapInfoHeader();
                n6 += bitmapInfoHeader.getLength();
                int n11 = (int)bitmapInfoHeader.getClrUsed();
                long l2 = bitmapInfoHeader.getBitCount();
                if (n11 == 0 && l2 == 8L) {
                    n11 = 256;
                }
                if (n11 == 0 && l2 == 4L) {
                    n11 = 16;
                }
                List list2 = list = n11 > 0 ? new ArrayList(n11) : Collections.EMPTY_LIST;
                if (n11 > 0) {
                    for (n4 = 0; n4 < n11; ++n4) {
                        RGBQuad rGBQuad = new RGBQuad();
                        rGBQuad.read(byArray2, n6);
                        list.add(rGBQuad);
                        n6 += rGBQuad.getLength();
                    }
                }
                n4 = (int)bitmapInfoHeader.getHeight();
                int n12 = n4 / 2;
                int n13 = (int)bitmapInfoHeader.getWidth();
                int n14 = (int)((long)n13 * l2 / 8L);
                int n15 = n14 * n12;
                byte[] byArray3 = new byte[n15];
                System.arraycopy(byArray2, n6, byArray3, 0, n15);
                n6 += n15;
                BitmapInfo bitmapInfo2 = new BitmapInfo(n11);
                BitmapInfoHeader bitmapInfoHeader2 = bitmapInfo2.getBitmapInfoHeader();
                bitmapInfoHeader2.setWidth(n13);
                bitmapInfoHeader2.setHeight(n12);
                bitmapInfoHeader2.setPlanes(1L);
                bitmapInfoHeader2.setBitCount(l2);
                bitmapInfoHeader2.setCompression(Bitmap.Compression.RGB);
                bitmapInfoHeader2.setSizeImage(0L);
                if (n11 > 0) {
                    bitmapInfoHeader2.setClrUsed(n11);
                    bitmapInfoHeader2.setClrImportant(n11);
                    windowDC = bitmapInfo2.getColors();
                    for (int i3 = 0; i3 < n11; ++i3) {
                        windowDC.setElement(i3, (Parameter)list.get(i3));
                    }
                }
                windowDC = new WindowDC(null);
                DC dC = DC.createCompatibleDC(windowDC);
                DDBitmap dDBitmap = new DDBitmap(windowDC, n7, n12);
                PrimitiveArray primitiveArray = new PrimitiveArray(byArray3, e == null ? (e = Icon.a("com.jniwrapper.Int8")) : e);
                dDBitmap.setDIBits(dC, 0, n12, new Pointer((Parameter)primitiveArray), bitmapInfo2, 0);
                n14 = (n13 + 31) / 32 * 4;
                int n16 = n12 * n14;
                byte[] byArray4 = new byte[n16];
                System.arraycopy(byArray2, n6, byArray4, 0, n16);
                BitmapInfo bitmapInfo3 = new BitmapInfo(2);
                BitmapInfoHeader bitmapInfoHeader3 = bitmapInfo3.getBitmapInfoHeader();
                bitmapInfoHeader3.setWidth(n7);
                bitmapInfoHeader3.setHeight(n12);
                bitmapInfoHeader3.setPlanes(1L);
                bitmapInfoHeader3.setBitCount(1L);
                bitmapInfoHeader3.setCompression(Bitmap.Compression.RGB);
                bitmapInfoHeader3.setSizeImage(0L);
                bitmapInfoHeader3.setClrUsed(2L);
                bitmapInfoHeader3.setClrImportant(2L);
                PrimitiveArray primitiveArray2 = bitmapInfo3.getColors();
                primitiveArray2.setElement(0, (Parameter)new RGBQuad(0, 0, 0));
                primitiveArray2.setElement(1, (Parameter)new RGBQuad(255, 255, 255));
                PrimitiveArray primitiveArray3 = new PrimitiveArray(byArray4, f == null ? (f = Icon.a("com.jniwrapper.UInt8")) : f);
                DDBitmap dDBitmap2 = new DDBitmap(windowDC, n7, n12);
                dDBitmap2.setDIBits(dC, 0, n12, new Pointer((Parameter)primitiveArray3), bitmapInfo3, 0);
                dC.release();
                ((DC)windowDC).release();
                IconInfo iconInfo = new IconInfo(dDBitmap2, dDBitmap);
                Function function = Icon.a((Object)"CreateIconIndirect");
                try {
                    long l3 = function.invoke((Parameter)this, (Parameter)new Pointer((Parameter)iconInfo));
                    if (this.isNull()) {
                        throw new LastErrorException(l3, "Failed to create icon from the resource.");
                    }
                    break;
                }
                finally {
                    dDBitmap.deleteObject();
                    dDBitmap2.deleteObject();
                }
            }
            if (!bl) {
                throw new RuntimeException("Resource not found.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.update();
    }

    public IconInfo getIconInfo() {
        IconInfo iconInfo = new IconInfo();
        Function function = Icon.a((Object)"GetIconInfo");
        Bool bool = new Bool();
        long l2 = function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Pointer((Parameter)iconInfo));
        if (!bool.getValue()) {
            throw new LastErrorException(l2, "Failed to retrieve IconInfo for this icon.");
        }
        return iconInfo;
    }

    public Dimension getSize() {
        return this.d;
    }

    public int getBitCount() {
        return this.h;
    }

    public BufferedImage toImage() {
        IconInfo iconInfo = this.getIconInfo();
        Bitmap bitmap = iconInfo.getMaskBitmap();
        Bitmap bitmap2 = iconInfo.getColorBitmap();
        WindowDC windowDC = new WindowDC(null);
        BitmapStructure bitmapStructure = new BitmapStructure();
        this.getObject(bitmap2, (Parameter)bitmapStructure);
        int n2 = (int)bitmapStructure.getBitsPixel();
        BitmapInfo bitmapInfo = n2 >= 16 ? new BitmapInfo() : new BitmapInfo(n2);
        BitmapInfoHeader bitmapInfoHeader = bitmapInfo.getBitmapInfoHeader();
        int n3 = (int)bitmapStructure.getBitmapWidth();
        int n4 = (int)bitmapStructure.getBitmapHeight();
        bitmapInfoHeader.setWidth(n3);
        bitmapInfoHeader.setHeight(n4);
        bitmapInfoHeader.setPlanes(1L);
        bitmapInfoHeader.setBitCount(n2);
        bitmapInfoHeader.setCompression(Bitmap.Compression.RGB);
        if (n2 == 4 || n2 == 8) {
            int n5 = 1 << n2;
            bitmapInfoHeader.setClrUsed(n5);
            bitmapInfoHeader.setClrImportant(n5);
        }
        Pointer pointer = new Pointer(null, true);
        bitmap2.getDIBits((DC)windowDC, 0, n4, pointer, bitmapInfo, 0);
        int n6 = (int)bitmapInfoHeader.getSizeImage();
        PrimitiveArray primitiveArray = new PrimitiveArray(f == null ? (f = Icon.a("com.jniwrapper.UInt8")) : f, n6);
        bitmap2.getDIBits((DC)windowDC, 0, n4, new Pointer((Parameter)primitiveArray), bitmapInfo, 0);
        PrimitiveArray primitiveArray2 = new PrimitiveArray(f == null ? (f = Icon.a("com.jniwrapper.UInt8")) : f, n6);
        bitmap.getDIBits((DC)windowDC, 0, n4, new Pointer((Parameter)primitiveArray2), bitmapInfo, 0);
        windowDC.release();
        PrimitiveArray primitiveArray3 = bitmapInfo.getColors();
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        int n7 = 0;
        int n8 = 0;
        for (int i2 = n4 - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                int n9 = 0;
                int n10 = 0;
                switch (n2) {
                    case 8: {
                        RGBQuad rGBQuad = (RGBQuad)primitiveArray3.getElement(n7++);
                        int n11 = (int)rGBQuad.getRed();
                        int n12 = (int)rGBQuad.getGreen();
                        int n13 = (int)rGBQuad.getBlue();
                        n9 = 0xFF000000 | n13 | n12 | n11;
                        RGBQuad rGBQuad2 = (RGBQuad)primitiveArray3.getElement(n8++);
                        int n14 = (int)rGBQuad2.getRed();
                        int n15 = (int)rGBQuad2.getGreen();
                        int n16 = (int)rGBQuad2.getBlue();
                        n10 = n16 | n15 | n14;
                        break;
                    }
                    case 16: {
                        int n17 = Icon.a(primitiveArray, n7++);
                        int n11 = Icon.a(primitiveArray, n7++);
                        int n12 = n11 << 8 | n17;
                        int n13 = (n12 & 0x1F) << 3;
                        int n18 = (n12 & 0x3E0) << 6;
                        int n14 = (n12 & 0x7C00) << 9;
                        n9 = 0xFF000000 | n13 | n18 | n14;
                        n17 = Icon.a(primitiveArray2, n8++);
                        n11 = Icon.a(primitiveArray2, n8++);
                        n12 = n11 << 8 | n17;
                        int n15 = (n12 & 0x1F) << 3;
                        int n16 = (n12 & 0x3E0) << 6;
                        int n19 = (n12 & 0x7C00) << 9;
                        n10 = n15 | n16 | n19;
                        break;
                    }
                    case 24: 
                    case 32: {
                        int n13;
                        int n20 = Icon.a(primitiveArray, n7++);
                        int n11 = Icon.a(primitiveArray, n7++);
                        int n12 = Icon.a(primitiveArray, n7++);
                        n9 = n20 | n11 << 8 | n12 << 16;
                        if (n2 == 32) {
                            if ((n13 = Icon.a(primitiveArray, n7++)) == 0) {
                                n13 = 255;
                            }
                            n9 |= n13 << 24;
                        } else {
                            n9 |= 0xFF000000;
                        }
                        n13 = Icon.a(primitiveArray2, n8++);
                        int n21 = Icon.a(primitiveArray2, n8++);
                        int n14 = Icon.a(primitiveArray2, n8++);
                        n10 = n13 | n21 << 8 | n14 << 16;
                        if (n2 != 32) break;
                        ++n8;
                    }
                }
                if (n10 != 0) {
                    bufferedImage.setRGB(i3, i2, n10);
                    continue;
                }
                bufferedImage.setRGB(i3, i2, n9);
            }
        }
        return bufferedImage;
    }

    private static int a(PrimitiveArray primitiveArray, int n2) {
        UInt8 uInt8 = (UInt8)primitiveArray.getElement(n2);
        return (int)uInt8.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List loadFromStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        LinkedList<Icon> linkedList = new LinkedList<Icon>();
        try {
            Function function = User32.getInstance().getFunction("CreateIconIndirect");
            byte[] byArray = StreamUtils.readBytes((InputStream)inputStream);
            if (byArray.length == 0) {
                throw new IllegalArgumentException("Input Stream is empty.");
            }
            IconDir iconDir = new IconDir();
            iconDir.read(byArray, 0);
            int n2 = iconDir.getCount();
            iconDir.getEntries().setElementCount(n2);
            ComplexArray complexArray = iconDir.getEntries();
            for (int i2 = 0; i2 < n2; ++i2) {
                WindowDC windowDC;
                int n3;
                List list;
                IconDirEntry iconDirEntry = (IconDirEntry)complexArray.getElement(i2);
                int n4 = iconDir.getLength() + i2 * iconDirEntry.getLength();
                iconDirEntry.read(byArray, n4);
                int n5 = iconDirEntry.getWidth();
                int n6 = iconDirEntry.getHeight();
                if (n5 == 0 && n6 == 0) continue;
                int n7 = iconDirEntry.getImageOffset();
                int n8 = iconDirEntry.getBytesInRes();
                byte[] byArray2 = new byte[n8];
                System.arraycopy(byArray, n7, byArray2, 0, n8);
                n4 = 0;
                BitmapInfo bitmapInfo = new BitmapInfo();
                bitmapInfo.read(byArray2, n4);
                BitmapInfoHeader bitmapInfoHeader = bitmapInfo.getBitmapInfoHeader();
                n4 += bitmapInfoHeader.getLength();
                int n9 = (int)bitmapInfoHeader.getClrUsed();
                long l2 = bitmapInfoHeader.getBitCount();
                if (n9 == 0 && l2 == 8L) {
                    n9 = 256;
                }
                if (n9 == 0 && l2 == 4L) {
                    n9 = 16;
                }
                List list2 = list = n9 > 0 ? new ArrayList(n9) : Collections.EMPTY_LIST;
                if (n9 > 0) {
                    for (n3 = 0; n3 < n9; ++n3) {
                        RGBQuad rGBQuad = new RGBQuad();
                        rGBQuad.read(byArray2, n4);
                        list.add(rGBQuad);
                        n4 += rGBQuad.getLength();
                    }
                }
                n3 = (int)bitmapInfoHeader.getHeight();
                int n10 = n3 / 2;
                int n11 = (int)bitmapInfoHeader.getWidth();
                int n12 = (int)((long)n11 * l2 / 8L);
                int n13 = n12 * n10;
                byte[] byArray3 = new byte[n13];
                System.arraycopy(byArray2, n4, byArray3, 0, n13);
                n4 += n13;
                BitmapInfo bitmapInfo2 = new BitmapInfo(n9);
                BitmapInfoHeader bitmapInfoHeader2 = bitmapInfo2.getBitmapInfoHeader();
                bitmapInfoHeader2.setWidth(n11);
                bitmapInfoHeader2.setHeight(n10);
                bitmapInfoHeader2.setPlanes(1L);
                bitmapInfoHeader2.setBitCount(l2);
                bitmapInfoHeader2.setCompression(Bitmap.Compression.RGB);
                bitmapInfoHeader2.setSizeImage(0L);
                if (n9 > 0) {
                    bitmapInfoHeader2.setClrUsed(n9);
                    bitmapInfoHeader2.setClrImportant(n9);
                    windowDC = bitmapInfo2.getColors();
                    for (int i3 = 0; i3 < n9; ++i3) {
                        windowDC.setElement(i3, (Parameter)list.get(i3));
                    }
                }
                windowDC = new WindowDC(null);
                DC dC = DC.createCompatibleDC(windowDC);
                DDBitmap dDBitmap = new DDBitmap(windowDC, n5, n10);
                PrimitiveArray primitiveArray = new PrimitiveArray(byArray3, e == null ? Icon.a("com.jniwrapper.Int8") : e);
                dDBitmap.setDIBits(dC, 0, n10, new Pointer((Parameter)primitiveArray), bitmapInfo2, 0);
                n12 = (n11 + 31) / 32 * 4;
                int n14 = n10 * n12;
                byte[] byArray4 = new byte[n14];
                System.arraycopy(byArray2, n4, byArray4, 0, n14);
                BitmapInfo bitmapInfo3 = new BitmapInfo(2);
                BitmapInfoHeader bitmapInfoHeader3 = bitmapInfo3.getBitmapInfoHeader();
                bitmapInfoHeader3.setWidth(n5);
                bitmapInfoHeader3.setHeight(n10);
                bitmapInfoHeader3.setPlanes(1L);
                bitmapInfoHeader3.setBitCount(1L);
                bitmapInfoHeader3.setCompression(Bitmap.Compression.RGB);
                bitmapInfoHeader3.setSizeImage(0L);
                bitmapInfoHeader3.setClrUsed(2L);
                bitmapInfoHeader3.setClrImportant(2L);
                PrimitiveArray primitiveArray2 = bitmapInfo3.getColors();
                primitiveArray2.setElement(0, (Parameter)new RGBQuad(0, 0, 0));
                primitiveArray2.setElement(1, (Parameter)new RGBQuad(255, 255, 255));
                PrimitiveArray primitiveArray3 = new PrimitiveArray(byArray4, f == null ? Icon.a("com.jniwrapper.UInt8") : f);
                DDBitmap dDBitmap2 = new DDBitmap(windowDC, n5, n10);
                dDBitmap2.setDIBits(dC, 0, n10, new Pointer((Parameter)primitiveArray3), bitmapInfo3, 0);
                dC.release();
                ((DC)windowDC).release();
                IconInfo iconInfo = new IconInfo(dDBitmap2, dDBitmap);
                try {
                    Icon icon = new Icon();
                    long l3 = function.invoke((Parameter)icon, (Parameter)new Pointer((Parameter)iconInfo));
                    if (icon.isNull()) {
                        throw new LastErrorException(l3, "Failed to create icon from the resource.");
                    }
                    icon.d.setSize(n5, n6);
                    icon.h = (int)l2;
                    linkedList.add(icon);
                    continue;
                }
                finally {
                    dDBitmap.deleteObject();
                    dDBitmap2.deleteObject();
                }
            }
        }
        catch (Exception exception) {
            b.error((Object)"", (Throwable)exception);
        }
        return linkedList;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static FunctionName a() {
        return i;
    }

    public static class IconType
    extends EnumItem {
        public static final IconType SMALL = new IconType(0, new Dimension(16, 16));
        public static final IconType BIG = new IconType(1, new Dimension(32, 32));
        private Dimension a;

        private IconType(int n2, Dimension dimension) {
            super(n2);
            this.a = dimension;
        }

        public Dimension getSize() {
            return this.a;
        }
    }

    public static class SystemIcon
    extends EnumItem {
        public static final SystemIcon SAMPLE = new SystemIcon(32512);
        public static final SystemIcon HAND = new SystemIcon(32513);
        public static final SystemIcon QUES = new SystemIcon(32514);
        public static final SystemIcon BANG = new SystemIcon(32515);
        public static final SystemIcon NOTE = new SystemIcon(32516);
        public static final SystemIcon WINLOGO = new SystemIcon(32517);
        private Icon b;
        private Icon a;

        private SystemIcon(int n2) {
            super(n2);
        }

        public static Icon loadSystemIcon(int n2, Dimension dimension) {
            Icon icon = new Icon();
            Function function = Icon.a(Icon.a());
            long l2 = function.invoke((Parameter)icon, new Parameter[]{new Handle(), new Int32(n2), new UInt32((long)GdiObject.ImageType.ICON.getValue()), new Int((long)dimension.width), new Int((long)dimension.height), new UInt32(32768L)});
            if (icon.isNull()) {
                throw new LastErrorException(l2, "Failed to load icon for " + n2);
            }
            return icon;
        }

        public Icon getIcon(IconType iconType) {
            Icon icon = null;
            if (iconType.equals((Object)IconType.SMALL)) {
                if (this.b == null) {
                    this.b = SystemIcon.loadSystemIcon(this.getValue(), iconType.getSize());
                }
                icon = this.b;
            } else if (iconType.equals((Object)IconType.BIG)) {
                if (this.a == null) {
                    this.a = SystemIcon.loadSystemIcon(this.getValue(), iconType.getSize());
                }
                icon = this.a;
            }
            return icon;
        }

        public Icon getSmall() {
            return this.getIcon(IconType.SMALL);
        }

        public Icon getBig() {
            return this.getIcon(IconType.BIG);
        }
    }
}

